<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use Modules\ACL\Entities\Permission;
use Modules\Order\Entities\Order;
use Modules\Order\Policies\OrderPolicy;
use Modules\Project\Entities\Project;
use Modules\Project\Policies\ProjectPolicy;
use Modules\Ticket\Entities\Ticket;
use Modules\Ticket\Policies\TicketPolicy;
use Modules\User\Entities\User;
use Modules\User\Policies\UserPolicy;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array
     */
    protected $policies = [
        // 'App\Models\Model' => 'App\Policies\ModelPolicy',
        User::class => UserPolicy::class,
        Ticket::class => TicketPolicy::class,
        Project::class => ProjectPolicy::class,
        Order::class => OrderPolicy::class,
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();

        foreach (Permission::all() as $permission){
            Gate::define($permission->name , function ($user) use ($permission){
                return $user->hasPermission($permission);
            });
        }

    }
}
