<?php

namespace App\Jobs;

use Carbon\Carbon;
use Hekmatinasser\Verta\Verta;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\Course\Entities\Course;
use Modules\Project\Entities\Project;
use Modules\Project\Notifications\ExpirationClientNotify;
use Modules\User\Entities\User;

class CheckProjectExpiration implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $projects = Project::all();
        foreach ($projects as $project) {
            $date = Carbon::parse($project->renew_date);
            if (!$date->isPast()){
                //6 days before renewal date
                if ($date->diffInDays() == 6){
                    //create order invoice for project
                     $project->orders()->create([
                        'tracking_id' => rand(100000 , 20000),
                        'status' => 'unpaid',
                        'price' => $project->price / 2,
                        'product_type' => Project::class,
                        'user_id' => $project->user_id,
                        'product_id' => $project->id,
                         'type' => 'renewal'
                    ]);
                     //send sms to user
                    $this->getNotify($project, $date);
                }

                //3 days before renewal date
                if ($date->diffInDays() == 3) {
                    //send sms to user
                    $this->getNotify($project, $date);
                }

                //1 day before renewal date
                if ($date->diffInDays() == 1) {
                    //send sms to user
                    $this->getNotify($project, $date);
                }

                //renewal day
                if ($date->diffInDays() == 0) {
                    //send sms to user
                    $this->getNotify($project, $date);
                }
            }
        }
    }
    /**
     * @param Project $project
     * @param Carbon $date
     */
    public function getNotify(Project $project, Carbon $date)
    {
        $project->notify(new ExpirationClientNotify(
            $project->domain,
            Verta::instance($date)->formatJalaliDate(),
            $project->title,
            Verta::instance($project->start_date)->formatJalaliDate(),
            $project->user->phone
        ));
    }
}
