<?php


//check user role in users edit page
use Hekmatinasser\Verta\Verta;

if (! function_exists('whatIsUserRole')){
    function whatIsUserRole($role , $user){
        foreach ($role->users as $value){
            if ($value->pivot->user_id == $user->id){
                return 'selected';
            }
        }
    }
}

//check active menu in admin page
if(! function_exists('isMenuActive')){
    function isMenuActive($route){
        if (\Illuminate\Support\Facades\Route::currentRouteName() == $route){
            return 'active';
        }
    }
}


if(! function_exists('whatIsCategories')){
    function whatIsCategories($category , $post){
        foreach ($post->categories as $val){

            if ($category->id == $val->pivot->category_id){
                return 'selected';
            }
        }
    }
}

if (!function_exists('notificationsCount')) {
    function notificationsCount($searchKey){
        $data = \Illuminate\Notifications\DatabaseNotification::where('data','LIKE',"%{$searchKey}%")->whereNull('read_at')->get();
        if (count($data)>0){
            return count($data);
        }
        return '';
    }
}
if (!function_exists('markAsReadNotifications')) {
    function markAsReadNotifications($searchKey){
        $data = \Illuminate\Notifications\DatabaseNotification::where('data','LIKE',"%{$searchKey}%")->whereNull('read_at')->get();
        if (count($data)>0){
            foreach ($data as $notification) {
                $notification->markAsRead();
            }
        }
        return '';
    }
}
if (!function_exists('persianToEngNum')){
    function persianToEngNum($string) {
        $persian = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
        $arabic = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
        $num = range(0, 9);
        $convertedPersianNums = str_replace($persian, $num, $string);
        $englishNumbersOnly = str_replace($arabic, $num, $convertedPersianNums);
        return $englishNumbersOnly;
    }
}

if (! function_exists('storeDate')) {
    function storeDate($date) {
        $string = explode('/', $date) ;
        $year = persianToEngNum($string[0]);
        $month = persianToEngNum($string[1]);
        $day = persianToEngNum($string[2]);
        $date_gregorian = Verta::getGregorian($year,$month,$day);
        return implode('-',$date_gregorian) . ' ' . '14:40:47';
    }
}
if (!function_exists('uploader')) {
    function uploader($request,$input){
        if ($file = $request->file($input)) {
            $name = time() . $file->getClientOriginalName();
            $file->move('images/' , $name);
            return $name;
        }
    }
}

