@extends('user::frontend.layout')
@section('profile-active-page')
    <div class="container">
        <div class="row justify-content-between align-items-center p-4">
            <div class="section-head">
                <div id="nav-icon3">
                    <span></span>
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
                <div class="section-title">
                    <div class="title-icon">
                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M4.375 6.125H7V4.375L8.75 2.625H11.375L13.125 4.375V6.125H15.75C16.4462 6.125 17.1139 6.40156 17.6062 6.89384C18.0984 7.38613 18.375 8.05381 18.375 8.75V15.75C18.375 16.4462 18.0984 17.1139 17.6062 17.6062C17.1139 18.0984 16.4462 18.375 15.75 18.375H4.375C3.67881 18.375 3.01113 18.0984 2.51884 17.6062C2.02656 17.1139 1.75 16.4462 1.75 15.75V8.75C1.75 8.05381 2.02656 7.38613 2.51884 6.89384C3.01113 6.40156 3.67881 6.125 4.375 6.125V6.125ZM9.11225 3.5L7.875 4.73725V6.125H12.25V4.73725L11.0128 3.5H9.11225ZM4.375 7C3.91087 7 3.46575 7.18437 3.13756 7.51256C2.80937 7.84075 2.625 8.28587 2.625 8.75V15.75C2.625 16.2141 2.80937 16.6592 3.13756 16.9874C3.46575 17.3156 3.91087 17.5 4.375 17.5H15.75C16.2141 17.5 16.6592 17.3156 16.9874 16.9874C17.3156 16.6592 17.5 16.2141 17.5 15.75V8.75C17.5 8.28587 17.3156 7.84075 16.9874 7.51256C16.6592 7.18437 16.2141 7 15.75 7H4.375Z"
                                fill="black"></path>
                        </svg>
                    </div>
                    <div class="title-box">
                        <h3 class="title">
                            پروژه شماره {{$project->tracking_id}}#
                        </h3>
                    </div>
                </div>
            </div>
            <div>
                <a href="{{route('profile.projects')}}" class="kw-btn-green">همه پروژه ها</a>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4">
                <div class="kw-wrapper kw-wrapper-br p-4">
                    <h5 class="pb-4">جزئیات پروژه</h5>
                    <ul class="kw-list1">
                        <li>نام پروژه: {{$project->title}}
                            <hr>
                        </li>
                        <li>هزینه پروژه: {{number_format($project->price)}} تومان
                            <hr>
                        </li>
                        <li>
                            وضعیت پروژه:
                            @switch($project->status)
                                @case('preparation')
                                <span class="badge badge-info badge-pill">در حال آماده سازی</span>
                                @break
                                @case('done')
                                <span class="badge badge-success badge-pill">تحویل داده شده</span>
                                @break
                                @case('canceled')
                                <span class="badge badge-danger badge-pill">لغو شده</span>
                                @break
                            @endswitch
                            <hr>
                        </li>
                        <li>
                            تاریخ شروع
                            پروژه: {{\Hekmatinasser\Verta\Verta::instance($project->start_date)->format('%d %B, %Y')}}
                            <hr>
                        </li>
                        <li>
                            تاریخ تمدید:
                            @if(\Illuminate\Support\Carbon::parse($project->renew_date)->isPast())
                                <span class="badge badge-pill badge-danger">
                                    {{\Hekmatinasser\Verta\Verta::instance($project->renew_date)->formatDifference()}}
                                </span>
                                <span class="badge badge-pill badge-warning">تاریخ تمدید گذشته است</span>
                            @else
                                {{\Hekmatinasser\Verta\Verta::instance($project->renew_date)->formatJalaliDate()}}
                                <span class="badge badge-pill badge-success">
                                    {{\Hekmatinasser\Verta\Verta::instance($project->renew_date)->formatDifference()}}
                                </span>
                            @endif
                        </li>
                    </ul>
                </div>
            </div>
            <div class="col-md-8 kw-mt-1rem">
                <div class="kw-wrapper kw-wrapper-br p-4 table-responsive">
                    <h5 class="pb-4">تاریخچه پرداخت و فاکتور ها</h5>
                    <table class="table table-hover">
                        <thead>
                        <tr>
                            <th scope="col">شماره</th>
                            <th scope="col">مبلغ</th>
                            <th scope="col">وضعیت</th>
                            <th scope="col">تاریخ ایجاد</th>
                            <th scope="col">عملیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($project->orders as $order)
                            <tr>
                                <th scope="row">{{$order->tracking_id}}</th>
                                <td>{{number_format($order->price)}} تومان</td>
                                <td>
                                    @switch($order->status)
                                        @case('unpaid')
                                        <span class="badge badge-warning badge-pill">پرداخت نشده</span>
                                        @break
                                        @case('full_paid')
                                        <span class="badge badge-success badge-pill">پرداخت شده</span>
                                        @break
                                        @case('canceled')
                                        <span class="badge badge-danger badge-pill">لغو شده</span>
                                        @break

                                    @endswitch
                                        @switch($order->type)
                                            @case('renewal')
                                            <span class="badge badge-pill badge-primary light">فاکتور تمدید</span>
                                            @break
                                            @case('first')
                                            <span class="badge badge-pill badge-primary light">قسط اول</span>
                                            @break
                                            @case('second')
                                            <span class="badge badge-pill badge-primary light">قسط دوم</span>
                                            @break
                                        @endswitch
                                </td>
                                <td>
                                    {{\Hekmatinasser\Verta\Verta::instance($order->created_at)->format('%d %B, %Y')}}
                                </td>
                                <td>
                                    @switch($order->status)
                                        @case('full_paid')
                                        <span type="button" class="kw-btn-green mt-0">
                                        پرداخت شده
                                    </span>
                                        @break
                                        @case('unpaid')
                                        <a href="{{route('profile.projects.payment' , $order)}}"
                                           class="kw-btn-orange mt-0"> پرداخت </a>
                                        @break
                                        @case('canceled')
                                        <span class="badge badge-danger badge-pill">لغو شده</span>
                                        @break
                                    @endswitch
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="row mt-5">
            <div class="col-md-12 kw-mt-1rem">
                <div class="kw-wrapper kw-wrapper-br p-4 ">
                    <h5 class="pb-4">اصلاحیه های پروژه</h5>
                    <div class="alert alert-info fade show" role="alert">
                        <strong>شما تا 2 مرحله قادر به ارسال اصلاحیه های پروژه خود در زمان اجرای قرارداد
                            میباشید</strong>
                    </div>
                    <form action="{{route('profile.projects.edit-levels' , $project)}}" method="post" id="edit-levels" class="p-0">
                        @csrf
                        @method('patch')
                    </form>
                    @if(!$project->edit_level1)
                        <div class="pb-1">
                            <h6 class="pb-1 pt-4">اصلاحیه مرحله اول</h6>
                                <div class="row">
                                    <div class="col-md-12">
                                        <label for="edit_level1">متن اصلاحیه</label>
                                        <textarea name="edit_level1" id="edit_level1" cols="30" rows="10"
                                                  class="form-control" form="edit-levels"
                                        ></textarea>
                                    </div>
                                </div>
                                <a onclick="event.preventDefault(); document.getElementById('edit-levels').submit()"
                                    class="kw-btn-green">ارسال</a>
                            <script>
                                ClassicEditor
                                    .create(document.querySelector('#edit_level1'), {
                                        language: 'fa',
                                    })
                                    .catch(error => {
                                        console.error(error);
                                    });
                            </script>
                        </div>
                    @else
                        <div class="alert alert-success fade show" role="alert">
                            <strong>اصلاحات مرحله اول ارسال شده است.</strong>
                        </div>
                    @endif
                    @if(!$project->edit_level2)
                        @if($project->edit_level1)
                            <div class="pb-1">
                                <h6 class="pb-1 pt-4">اصلاحیه مرحله دوم</h6>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <label for="edit_level2">متن اصلاحیه</label>
                                            <textarea name="edit_level2" id="edit_level2" cols="30" rows="10"
                                                      class="form-control" form="edit-levels"
                                            ></textarea>
                                        </div>
                                    </div>
                                    <a
                                        onclick="event.preventDefault(); document.getElementById('edit-levels').submit()"
                                        class="kw-btn-green">ارسال</a>
                                <script>
                                    ClassicEditor
                                        .create(document.querySelector('#edit_level2'), {
                                            language: 'fa',
                                        })
                                        .catch(error => {
                                            console.error(error);
                                        });
                                </script>
                            </div>
                        @endif
                    @else
                        <div class="alert alert-success fade show" role="alert">
                            <strong>اصلاحات مرحله دوم ارسال شده است.</strong>
                        </div>
                    @endif


                </div>
            </div>
        </div>
    </div>
    <style>
        .ck-editor__editable {
            min-height: 300px;
        }
    </style>
@stop
@section('head')
    <script src="https://cdn.ckeditor.com/ckeditor5/27.1.0/classic/ckeditor.js"></script>
@endsection
