@extends('user::frontend.layout')
@section('profile-active-page')
    <div class="container">
        <div class="row justify-content-between align-items-center p-4">
            <div class="section-head">
                <div id="nav-icon3">
                    <span></span>
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
                <div class="section-title">
                    <div class="title-icon">
                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M4.375 6.125H7V4.375L8.75 2.625H11.375L13.125 4.375V6.125H15.75C16.4462 6.125 17.1139 6.40156 17.6062 6.89384C18.0984 7.38613 18.375 8.05381 18.375 8.75V15.75C18.375 16.4462 18.0984 17.1139 17.6062 17.6062C17.1139 18.0984 16.4462 18.375 15.75 18.375H4.375C3.67881 18.375 3.01113 18.0984 2.51884 17.6062C2.02656 17.1139 1.75 16.4462 1.75 15.75V8.75C1.75 8.05381 2.02656 7.38613 2.51884 6.89384C3.01113 6.40156 3.67881 6.125 4.375 6.125V6.125ZM9.11225 3.5L7.875 4.73725V6.125H12.25V4.73725L11.0128 3.5H9.11225ZM4.375 7C3.91087 7 3.46575 7.18437 3.13756 7.51256C2.80937 7.84075 2.625 8.28587 2.625 8.75V15.75C2.625 16.2141 2.80937 16.6592 3.13756 16.9874C3.46575 17.3156 3.91087 17.5 4.375 17.5H15.75C16.2141 17.5 16.6592 17.3156 16.9874 16.9874C17.3156 16.6592 17.5 16.2141 17.5 15.75V8.75C17.5 8.28587 17.3156 7.84075 16.9874 7.51256C16.6592 7.18437 16.2141 7 15.75 7H4.375Z"
                                fill="black"></path>
                        </svg>
                    </div>
                    <div class="title-box">
                        <h3 class="title">
                            پروژه ها
                        </h3>
                    </div>
                </div>
            </div>
        </div>
        <div>
            <table class="table table-hover">
                <thead>
                <tr>
                    <th scope="col">شماره</th>
                    <th scope="col">عنوان</th>
                    <th scope="col">وضعیت</th>
                    <th scope="col">دامنه</th>
                    <th scope="col">تاریخ شروع</th>
                    <th scope="col">تاریخ تمدید</th>
                    <th scope="col">عملیات</th>
                </tr>
                </thead>
                <tbody>
                @foreach(auth()->user()->projects as $project)
                    <tr>
                        <th scope="row">#{{$project->tracking_id}}</th>
                        <td>{{$project->title}}</td>
                        <td>
                            @switch($project->status)
                                @case('preparation')
                                <span class="badge badge-info badge-pill">در حال آماده سازی</span>
                                @break
                                @case('done')
                                <span class="badge badge-success badge-pill">تحویل داده شده</span>
                                @break
                                @case('canceled')
                                <span class="badge badge-danger badge-pill">لغو شده</span>
                                @break
                            @endswitch
                        </td>
                        <td>{{$project->domain}}</td>
                        <td>
                            {{\Hekmatinasser\Verta\Verta::instance($project->start_date)->format('%d %B, %Y')}}
                        </td>
                        <td>
                            @if(\Illuminate\Support\Carbon::parse($project->renew_date)->isPast())
                                <span class="badge badge-pill badge-danger">
                                    {{\Hekmatinasser\Verta\Verta::instance($project->renew_date)->formatDifference()}}
                                </span>
                                <span class="badge badge-pill badge-warning">تاریخ تمدید گذشته است</span>
                            @else
                                {{\Hekmatinasser\Verta\Verta::instance($project->renew_date)->formatJalaliDate()}}
                                <span class="badge badge-pill badge-success">
                                    {{\Hekmatinasser\Verta\Verta::instance($project->renew_date)->formatDifference()}}
                                </span>
                            @endif
                        </td>
                        <td>
                            <a href="{{route('profile.projects.show' , $project)}}" class="kw-btn-blue-sm mt-0">جزئیات</a>
                            @if($project->course_file)
                                <a
                                    href="{{\Illuminate\Support\Facades\URL::temporarySignedRoute(
                                    'get.projects.url' , now()->addMinutes(60) , ['path' => $project->course_file]
                                    )}}"
                                   class="kw-btn-blue-sm mt-0">ویدئو آموزش پنل
                                </a>
                            @endif
                            @if($project->login_info)
                                <a   href="{{\Illuminate\Support\Facades\URL::temporarySignedRoute(
                                    'get.projects.url' , now()->addMinutes(60) , ['path' => $project->login_info]
                                    )}}"  class="kw-btn-blue-sm mt-0">اطلاعات ورود</a>
                            @endif
                        </td>
                    </tr>
                @endforeach

                </tbody>
            </table>
        </div>
    </div>
@stop
