@extends('user::frontend.layout')
@section('profile-active-page')
    <div class="container">
        <div class="row justify-content-between align-items-center p-4">
            <div class="section-head">
                <div id="nav-icon3">
                    <span></span>
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
                <div class="section-title">
                    <div class="title-icon">
                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M4.7251 4.19995C4.0289 4.19995 3.36123 4.47651 2.86894 4.9688C2.37666 5.46108 2.1001 6.12876 2.1001 6.82495V14.175C2.1001 14.8711 2.37666 15.5388 2.86894 16.0311C3.36123 16.5234 4.0289 16.8 4.7251 16.8H12.0751C12.7713 16.8 13.439 16.5234 13.9313 16.0311C14.4235 15.5388 14.7001 14.8711 14.7001 14.175V13.125L17.2201 15.015C17.3761 15.132 17.5616 15.2032 17.7558 15.2207C17.95 15.2382 18.1453 15.2013 18.3197 15.1141C18.4941 15.0269 18.6408 14.8928 18.7433 14.727C18.8458 14.5611 18.9001 14.3699 18.9001 14.175V6.82495C18.9001 6.62995 18.8458 6.43881 18.7433 6.27293C18.6408 6.10706 18.4941 5.97301 18.3197 5.8858C18.1453 5.7986 17.95 5.76168 17.7558 5.77919C17.5616 5.79671 17.3761 5.86795 17.2201 5.98495L14.7001 7.87495V6.82495C14.7001 6.12876 14.4235 5.46108 13.9313 4.9688C13.439 4.47651 12.7713 4.19995 12.0751 4.19995H4.7251ZM14.7001 9.18745L17.8501 6.82495V14.175L14.7001 11.8125V9.18745ZM13.6501 6.82495V14.175C13.6501 14.5927 13.4842 14.9933 13.1888 15.2886C12.8934 15.584 12.4928 15.75 12.0751 15.75H4.7251C4.30738 15.75 3.90677 15.584 3.6114 15.2886C3.31603 14.9933 3.1501 14.5927 3.1501 14.175V6.82495C3.1501 6.40724 3.31603 6.00663 3.6114 5.71126C3.90677 5.41589 4.30738 5.24995 4.7251 5.24995H12.0751C12.4928 5.24995 12.8934 5.41589 13.1888 5.71126C13.4842 6.00663 13.6501 6.40724 13.6501 6.82495Z" fill="black"></path>
                        </svg>
                    </div>
                    <div class="title-box">
                        <h3 class="title">
                            دوره های آموزشی
                        </h3>
                    </div>
                </div>
            </div>
        </div>
        <div>
            <table class="table table-hover">
                <thead>
                <tr>
                    <th scope="col">تصویر</th>
                    <th scope="col">عنوان</th>
                    <th scope="col">عملیات</th>
                </tr>
                </thead>
                <tbody>
                @foreach(auth()->user()->courses as $course)
                    <tr>
                        <th scope="row">
                            <img src="{{$course->image}}" alt="" width="100px" height="auto" class="kw-wrapper-br">
                        </th>
                        <td>
                            {{$course->title}}
                            <br>
                            <p class="subtitle">
                                مدت زمان دوره:
                                {{$course->time}}
                            </p>
                            <br>
                            <p class="subtitle">
                                تعداد قسمت ها
                                {{$course->episodes->count()}}
                            </p>
                        </td>
                        <td>
                            <a href="{{asset('series/' . $course->slug)}}" class="kw-btn-blue mt-0">مشاهده دوره</a>
                        </td>
                    </tr>

                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@stop
