<?php

namespace Modules\User\Http\Controllers\Front;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Validation\Rule;
use Modules\Course\Entities\Course;
use Modules\Project\Entities\Project;
use Modules\Ticket\Entities\Ticket;
use Modules\User\Entities\User;
use function GuzzleHttp\Promise\all;

class UserController extends Controller
{
    use SEOTools;
    public function dashboard()
    {
        $this->seo()
            ->settitle('داشبورد کاربری');
        $courses = Course::simplePaginate(3);
        return view('user::frontend.dashboard', compact(['courses']));
    }

    public function edit()
    {
        $this->seo()
            ->settitle('ویرایش حساب کاربری');
        return view('user::frontend.edit');
    }

    public function update(Request $request, User $user)
    {
//        dd($request->all());
        $validData = $request->validate([
            'name' => 'min:3|required',
            'identity_number' => [
                'nullable',
                Rule::unique('users')->ignore($user->id)
            ],
            'birthday' => 'nullable',
            'h_phone' => 'nullable',
            'address' => 'nullable'
        ]);
        if ($validData['birthday']) {
            $birthday = storeDate($validData['birthday']);
            $user->update([
                'birthday' => $birthday
            ]);
        }
        $user->update([
            'name' => $validData['name'],
            'identity_number' => $validData['identity_number'],
            'h_phone' => $validData['h_phone'],
            'address' => $validData['address'],
        ]);
        if ($file = $request->file('avatar')) {
            $name = time() . $file->getClientOriginalName();
            $file->move('images/users/' , $name);
            $user->update([
                'avatar' => asset("/images/users/$name"),
            ]);
        }
        alert()->success('ویرایش با موفقیت انجام شد');
        return back();
    }
}
