<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Route;

Route::middleware(['auth' , 'can:edit-profile'])->prefix('profile')->group(function () {
    Route::get('tickets' , 'Front\TicketController@index')->name('profile.tickets');
    Route::get('tickets/newTicket' , 'Front\TicketController@create')->name('profile.tickets.create');
    Route::post('tickets/newTicket/{user}' , 'Front\TicketController@store')->name('profile.tickets.store');
    Route::get('tickets/{ticket:tracking_id}' , 'Front\TicketController@show')->name('profile.tickets.show');
    Route::post('tickets/reply/{ticket:tracking_id}' , 'Front\TicketController@reply')->name('profile.tickets.reply');
});

