<?php

namespace Modules\Ticket\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Modules\Ticket\Notifications\channels\TicketSmsChannel;

class TicketClientNotify extends Notification
{
    use Queueable;

    public $phone;
    public $pattern;
    public $tracking_id;


    public function __construct($phone , $pattern , $tracking_id)
    {
        $this->phone = $phone;
        $this->pattern = $pattern;
        $this->tracking_id = $tracking_id;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return [TicketSmsChannel::class];
    }

    public function toTicketSmsChannel($notifiable)
    {
        return [
            'phone' => $this->phone,
            'pattern' => $this->pattern,
            'tracking_id' => $this->tracking_id,
        ];
    }
}
