<?php

namespace Modules\Ticket\Http\Controllers\Admin;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Ticket\Entities\Ticket;
use Modules\Ticket\Notifications\TicketAdminNotify;
use Modules\Ticket\Notifications\TicketClientNotify;

class TicketController extends Controller
{
    use SEOTools;
    public function index()
    {
        $this->seo()->setTitle('همه تیکت ها');

        $tickets = Ticket::query();
        if ($key = \request('search')) {
            $tickets = $tickets->where('tracking_id', $key);
        }
        markAsReadNotifications('newTicket');

        $tickets = $tickets->latest()->simplePaginate(15);
        return view('ticket::backend.all', compact('tickets'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('ticket::create');
    }


    public function store(Request $request)
    {
        //
    }

    public function reply(Request $request, Ticket $ticket)
    {
        $validData = $request->validate([
            'message' => 'required|min:10'
        ]);
        $ticket->replies()->create([
            'message' => $validData['message'],
            'for' => 'admin'
        ]);
        $ticket->update(['status' => 'answered']);
        $ticket->user->notify(new TicketClientNotify($ticket->user->phone , 'ej7pddpdjj' , $ticket->tracking_id));
        alert()->success('پاسخ شما با موفقیت ارسال شد');
        return back();
    }

    public function closeOpen(Ticket $ticket)
    {
        switch ($ticket->status) {
            case 'closed':
                $ticket->update(['status' => 'waiting']);
            break;
            case 'waiting':
                $ticket->update(['status' => 'closed']);
            break;
            case 'answered':
                $ticket->update(['status' => 'closed']);
            break;
        }

        alert()->success('وضعیت تیکت با موفقیت تغییر یافت.');
        return back();
    }

    public function show(Ticket $ticket)
    {

        return view('ticket::show', compact('ticket'));
    }


    public function edit(Ticket $ticket)
    {
        $this->seo()->setTitle("تیکت شماره $ticket->tracking_id");
        return view('ticket::backend.edit', compact('ticket'));
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
    }

    public function destroy(Ticket $ticket)
    {
        $ticket->delete();
        alert()->success('تیکیت با موفقیت حذف گردید.');
        return back();
    }
}
