@component('backend.layouts.components.main',['title' => 'ویرایش پروژه','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">ویرایش پروژه</li>
    @endslot
    {{-- Section Start --}}

    <div class="col-md-8">
        <div class="sidebar-admin">
            <div class="card-header">
                <h4 class="card-title">جزئیات پروژه</h4>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <input name="title" type="text"
                           class="form-control input-rounded @error('title') is-invalid @enderror" placeholder="عنوان"
                           form="store" required value="{{old('title') ? old('title') : $project->title}}">
                    @error('title')
                    <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                    @enderror
                </div>
                <div class="">
                    <form action="{{route('admin.projects.update' , $project)}}" method="post" id="store">
                        @csrf
                        @method('patch')
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">تاریخ شروع</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control input-rounded"
                                       value="{{old('start_date') ? old('start_date') : $project->start_date}}"
                                       name="start_date" id="start_date"/>
                                <script type="text/javascript">
                                    $('#start_date').persianDatepicker({
                                        format: 'L',
                                        initialValue: 'georgian'
                                    });
                                </script>
                                @error('start_date')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">تاریخ تمدید</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control input-rounded"
                                       value="{{old('renew_date') ? old('renew_date') : $project->renew_date}}"
                                       name="renew_date" id="renew_date"/>
                                <script type="text/javascript">
                                    $('#renew_date').persianDatepicker({
                                        format: 'L',
                                        initialValue: 'georgian'
                                    });
                                </script>
                                @error('start_date')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">کارفرما</label>
                            <div class="col-sm-9">
                                <select class="form-control default-select" name="user_id">
                                    <option value="">انتخاب کنید</option>
                                    @foreach($users as $user)
                                        <option value="{{$user->id}}"
                                                @if($user->id == $project->user_id) selected @endif>تلفن
                                            همراه: {{$user->phone}} | نام: {{$user->name}}  </option>
                                    @endforeach
                                </select>
                                @error('user_id')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">وضعیت</label>
                            <div class="col-sm-9">
                                <select class="form-control default-select" name="status">
                                    <option value="">انتخاب کنید</option>
                                    <option value="preparation" @if($project->status == 'preparation') selected @endif>
                                        در حال انجام
                                    </option>
                                    <option value="done" @if($project->status == 'done') selected @endif>انجام شده
                                    </option>
                                    <option value="canceled" @if($project->status == 'canceled') selected @endif>لغو
                                        شده
                                    </option>
                                </select>
                                @error('status')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">اصلاحات مرحله اول</label>
                            <div class="col-sm-9">
                            <textarea name="edit_level1" class="form-control" id="editor1" cols="30" rows="10">{!! old('edit_level1') ? old('edit_level1') : $project->edit_level1 !!}</textarea>
                                @error('edit_level1')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">اصلاحات مرحله دوم</label>
                            <div class="col-sm-9">
                                <textarea name="edit_level2" class="form-control" id="editor2" cols="30" rows="10">{!! old('edit_level2') ? old('edit_level2') : $project->edit_level2 !!}</textarea>
                                @error('edit_level2')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">دامنه پروژه</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control input-rounded" name="domain"
                                       value="{{old('domain') ? old('domain') : $project->domain}}"
                                />
                                @error('domain')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">نام کاربری</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control input-rounded" name="username"
                                       value="{{old('username') ? old('username') : $project->username}}"
                                />
                                @error('username')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">رمز عبور</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control input-rounded" name="password"
                                value="{{old('password') ? old('password') : $project->password}}"
                                />
                                @error('password')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">قیمت</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control input-rounded" name="price"
                                       value="{{old('price') ? old('price') : $project->price}}"
                                />
                                @error('price')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">فایل آموزشی</label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <input type="text" id="course_file" class="form-control" name="course_file"
                                           aria-label="Image" aria-describedby="button-image"
                                           value="{{old('course_file') ? old('course_file') : $project->course_file}}"
                                           style="direction: ltr;border-radius: 0 50px 50px 0">
                                    <div class="input-group-append">
                                        <button class="btn btn-outline-info" type="button"
                                                id="button-image">
                                            انتخاب
                                        </button>
                                    </div>
                                </div>
                                @error('course_file')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">اطلاعات ورود</label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <input type="text" id="login_info" class="form-control" name="login_info"
                                           aria-label="Image" aria-describedby="button-image"
                                           value="{{old('login_info') ? old('login_info') : $project->login_info}}"
                                           style="direction: ltr;border-radius: 0 50px 50px 0">
                                    <div class="input-group-append">
                                        <button class="btn btn-outline-info" type="button"
                                                id="button-image2">
                                            انتخاب
                                        </button>
                                    </div>
                                </div>
                                @error('login_info')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}

    <div class="col-md-4">
        @if($errors->any())
            <div class="alert alert-danger left-icon-big alert-dismissible fade show">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span><i
                            class="mdi mdi-close"></i></span>
                </button>
                <div class="media">
                    <div class="alert-left-icon-big">
                        <span><i class="mdi mdi-alert"></i></span>
                    </div>
                    <div class="media-body">
                        <h5 class="mt-1 mb-2">خطا!</h5>
                        @foreach($errors->all() as $error)
                            <p class="mb-0">{{$error}}</p>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif
        <div class="sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.projects.index')}}" role="button" class="btn btn-xs btn-info light" title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای اعمال ویرایش ها، روی دکمه "به روز رسانی" کلیک کنید.
                </p>
                <div class="row">
                    <button class="btn btn-success btn-sm btn-block light"
                            onclick="document.getElementById('store').submit()">
                        <i class="fa fa-refresh"></i>
                        به روز رسانی
                    </button>
                </div>
            </div>
        </div>
    </div>

    {{-- Sidebar End --}}

    {{-- Scripts --}}
@section('script')
    <script src="/backend/vendor/nestable2/js/jquery.nestable.min.js"></script>
    <script src="{{asset('/backend/js/file-editor.js')}}"></script>
    <script src="{{asset('/backend/js/file-editor2.js')}}"></script>
    <script>
        document.addEventListener("DOMContentLoaded", function() {

            document.getElementById('button-image').addEventListener('click', (event) => {
                event.preventDefault();

                inputId = 'course_file';

                window.open('/file-manager/fm-button', 'fm', 'width=1400,height=800');
            });

            // second button
            document.getElementById('button-image2').addEventListener('click', (event) => {
                event.preventDefault();

                inputId = 'login_info';

                window.open('/file-manager/fm-button', 'fm', 'width=1400,height=800');
            });
        });

        // input
        let inputId = '';

        // set file link
        function fmSetLink($url) {
            document.getElementById(inputId).value = $url;
        }
    </script>
@stop

@section('head')
    <link rel="stylesheet" href="https://unpkg.com/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.js" integrity="sha256-H+K7U5CnXl1h5ywQfKtSj8PCmoN9aaq30gDh27Xc0jk=" crossorigin="anonymous"></script>
    <script src="https://unpkg.com/persian-date@1.1.0/dist/persian-date.min.js"></script>
    <script src="https://unpkg.com/persian-datepicker@1.2.0/dist/js/persian-datepicker.min.js"></script>
    <script src="https://cdn.tiny.cloud/1/piqrm2bib3zv8de8a26kklh89gvqb0bhm9a14mjb88jwos8r/tinymce/5/tinymce.min.js" referrerpolicy="origin"></script>

    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.0/css/all.css">
    <link rel="stylesheet" href="{{ asset('/vendor/file-manager/css/file-manager.css') }}">
    <link rel="stylesheet" href="{{ asset('/backend/vendor/nestable2/css/jquery.nestable.min.css') }}">
@stop
@endcomponent
