@component('backend.layouts.components.main',['title' => 'مدیریت پروژه ها', 'titleBar'=>true , 'button' => 'افزودن پروژه' , 'route' => 'admin.projects.create'])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">پروژه ها</li>
    @endslot

    {{-- Table Start --}}
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست پروژه ها</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>کد</th>
                            <th>نام</th>
                            <th>دامنه</th>
                            <th>کارفرما</th>
                            <th>تاریخ شروع</th>
                            <th>تاریخ تمدید</th>
                            <th>وضعیت</th>
                            <th>فایل آموزشی</th>
                            <th>اطلاعات ورود</th>
                            @can('manage-projects')
                                <th>عملیات</th>
                            @endcan
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($projects as $project)
                            <tr>
                                <td>{{$project->tracking_id}}</td>
                                <td>{{$project->title}}</td>
                                <td><a href="{{$project->domain}}" target="_blank">{{$project->domain}}</a></td>
                                <td>
                                    <a href="{{route('admin.users.edit' , $project->user->id)}}">{{$project->user->name}}</a>
                                </td>
                                <td>
                                    {{\Hekmatinasser\Verta\Verta::instance($project->start_date)->formatJalaliDate()}}
                                </td>
                                <td>
                                    @if(\Illuminate\Support\Carbon::parse($project->renew_date)->isPast())
                                        <span class="badge badge-pill badge-danger light">
                                            {{\Hekmatinasser\Verta\Verta::instance($project->renew_date)->formatDifference()}}
                                        </span>
                                    @else
                                        {{\Hekmatinasser\Verta\Verta::instance($project->renew_date)->formatJalaliDate()}}
                                        <span class="badge badge-pill badge-success light">
                                            {{\Hekmatinasser\Verta\Verta::instance($project->renew_date)->formatDifference()}}
                                        </span>
                                    @endif
                                </td>
                                <td>
                                    @switch($project->status)
                                        @case('preparation')
                                        <span class="badge badge-pill badge-info light">در حال انجام</span>
                                        @break
                                        @case('canceled')
                                        <span class="badge badge-pill badge-danger light">لغو شده یا عدم تمدید</span>
                                        @break
                                        @case('done')
                                        <span class="badge badge-pill badge-success light">تحویل داده شده</span>
                                        @break
                                    @endswitch
                                </td>
                                <td>
                                    @if($project->course_file)
                                        <span class="badge badge-pill badge-primary light">ارسال شده</span>
                                    @else
                                        <span class="badge badge-pill badge-warning light">ارسال نشده</span>
                                    @endif

                                </td>
                                <td>
                                    @if($project->login_info)
                                        <span class="badge badge-pill badge-primary light">ارسال شده</span>
                                    @else
                                        <span class="badge badge-pill badge-warning light">ارسال نشده</span>
                                    @endif
                                </td>
                                <td>
                                    <form action="{{route('admin.projects.destroy', $project->id)}}" method="post"
                                          id="delete-{{$project->id}}">
                                        @method('delete')
                                        @csrf
                                    </form>
                                    @can('manage-users')
                                        <a href="{{route('admin.projects.edit', $project->id)}}" role="button"
                                           class="btn btn-success light sharp" title="ویرایش">
                                            <i class="fa fa-pencil"
                                               onclick="document.getElementById('edit-{{$project->id}}').submit()"></i>
                                        </a>
                                        <button onclick="document.getElementById('delete-{{$project->id}}').submit()"
                                                role="button" class="btn btn-danger light sharp" title="حذف">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>

                </div>
                {{$projects->links()}}
            </div>
        </div>
    </div>
    {{-- Table End --}}
@section('script')
    <script src="{{asset('/backend/js/search.js')}}"></script>
@stop
@endcomponent
