<?php

namespace Modules\Project\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Modules\Project\Notifications\channels\AdminSmsChannel;
use Modules\Project\Notifications\channels\ClientSmsChannel;

class ExpirationAdminNotify extends Notification
{
    use Queueable;


    public $domain_name;
    public $renew_date;
    public $start_date;
    public $phone;
    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($domain_name , $renew_date , $phone)
    {
        $this->phone = $phone;
        $this->domain_name = $domain_name;
        $this->renew_date = $renew_date;
    }

    public function via($notifiable)
    {
        return [AdminSmsChannel::class];
    }

    public function toAdminSmsChannel()
    {
        return [
            'phone' => $this->phone,
            'domain_name' => $this->domain_name,
            'renew_date' => $this->renew_date,
        ];
    }
}
