<?php

namespace Modules\Project\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Modules\Project\Notifications\channels\EditProjectSmsChannel;

class EditProjectNotify extends Notification
{
    use Queueable;

    public $phone;
    public $pattern;
    public $tracking_id;
    public $domain;

    public function __construct($phone , $domain , $tracking_id , $pattern)
    {
        $this->phone = $phone;
        $this->domain = $domain;
        $this->tracking_id = $tracking_id;
        $this->pattern = $pattern;
    }


    public function via($notifiable)
    {
        return [EditProjectSmsChannel::class , 'database'];
    }


    public function toEditProjectSmsChannel()
    {
        return [
          'phone' => $this->phone,
          'domain' => $this->domain,
          'tracking_id' => $this->tracking_id,
          'pattern' => $this->pattern
        ];
    }


    public function toArray($notifiable)
    {
        return [
            'data' => 'newProjectEdit'
        ];
    }
}
