<?php

namespace Modules\Project\Http\Controllers\Admin;

use Artesaos\SEOTools\Traits\SEOTools;
use Hekmatinasser\Verta\Verta;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Project\Entities\Project;
use Modules\User\Entities\User;

class ProjectController extends Controller
{
    use SEOTools;
    public function index()
    {
        $this->seo()->setTitle('همه پروژه ها');

        $projects = Project::query();
        if ($key = \request('search')) {
            $projects = $projects->where('tracking_id', $key);
        }
        $projects = $projects->latest()->simplePaginate(15);
        return view('project::backend.all', compact('projects'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $this->seo()->setTitle('ایجاد پروژه جدید');

        $users = User::all();
        return view('project::backend.create', compact('users'));
    }

    public function store(Request $request)
    {
        $validData = $request->validate([
            'title' => 'required',
            'start_date' => 'required',
            'renew_date' => 'required',
            'status' => 'required',
            'user_id' => 'required',
            'edit_level1' => 'nullable',
            'edit_level2' => 'nullable',
            'domain' => 'required',
            'username' => 'nullable',
            'password' => 'nullable',
            'course_file' => 'nullable',
            'login_info' => 'nullable',
            'price' => 'required',
        ]);
        $start_date = storeDate($validData['start_date']);
        $renew_date = storeDate($validData['renew_date']);
        $project = Project::create([
            'tracking_id' => rand(10000, 50000),
            'title' => $validData['title'],
            'start_date' => $start_date,
            'renew_date' => $renew_date,
            'status' => $validData['status'],
            'edit_level1' => $validData['edit_level1'],
            'edit_level2' => $validData['edit_level2'],
            'user_id' => $validData['user_id'],
            'domain' => $validData['domain'],
            'username' => $validData['username'],
            'password' => $validData['password'],
            'course_file' => $validData['course_file'],
            'login_info' => $validData['login_info'],
            'price' => $validData['price'],
        ]);
        $project->save();
        alert()->success('پروژه با موفقیت ایجاد شد');
        return back();
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('project::show');
    }


    public function edit(Project $project)
    {
        $this->seo()->setTitle("ویرایش پروژه $project->domain");

        $users = User::all();
        return view('project::backend.edit', compact(['users', 'project']));
    }


    public function update(Request $request, Project $project)
    {
        $validData = $request->validate([
            'title' => 'required',
            'start_date' => 'required',
            'renew_date' => 'required',
            'status' => 'required',
            'user_id' => 'required',
            'edit_level1' => 'nullable',
            'edit_level2' => 'nullable',
            'domain' => 'required',
            'username' => 'nullable',
            'password' => 'nullable',
            'course_file' => 'nullable',
            'login_info' => 'nullable',
            'price' => 'required',
        ]);
        $start_date = storeDate($validData['start_date']);
        $renew_date = storeDate($validData['renew_date']);
        $project->update([
            'title' => $validData['title'],
            'start_date' => $start_date,
            'renew_date' => $renew_date,
            'status' => $validData['status'],
            'edit_level1' => $validData['edit_level1'],
            'edit_level2' => $validData['edit_level2'],
            'user_id' => $validData['user_id'],
            'domain' => $validData['domain'],
            'username' => $validData['username'],
            'password' => $validData['password'],
            'course_file' => $validData['course_file'],
            'login_info' => $validData['login_info'],
            'price' => $validData['price'],
        ]);
        alert()->success('پروژه با موفقیت به روز رسانی شد');
        return back();
    }


    public function destroy(Project $project)
    {
        $project->delete();
        alert()->success('عملیات با موفقیت انجام شد');
        return back();
    }
}
