<?php

namespace Modules\Post\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Str;

class CreatePost extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */

    public function prepareForValidation()
    {

        if($this->input('slug')!=null){
            $this->merge(['slug',Str::slug($this->input('slug'),'-')]);
        }else{

            $this->merge(['slug',Str::slug($this->input('title'),'-')]);
        }
    }

    public function rules()
    {
        return [
            'title' => 'required',
            'slug' => 'unique:posts|nullable',
            'body' => 'required',
            'category' => 'nullable',
            'meta_title' => 'nullable',
            'meta_keywords' => 'nullable',
            'meta_description' => 'nullable',
            'meta_type' => 'nullable',
            'status' => 'nullable',
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
}
