@component('frontend.layouts.content' , ['title' => $portfolio->title , 'subtitle' => 'خلاقیت، زیبایی، کیفیت...'])

    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="{{route('main')}}">خانه</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{$portfolio->title}}</li>
    @endslot
    <div class="float-sidebar">
        <a id="details">جزئیات</a>
    </div>
    <section>
        <div class="container">
            <div class="row mt-5">
                <div class="col-md-12 col-lg-9">
                    <!--details-->
                    <div class="kw-wrapper kw-wrapper-br p-4">
                        <div class="section-head">
                            <div class="section-title">
                                <div class="title-icon">
                                    <svg width="25" height="31" viewBox="0 0 25 31" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M4.875 0H19.5C20.7929 0 22.0329 0.513615 22.9471 1.42785C23.8614 2.34209 24.375 3.58207 24.375 4.875V26C24.375 27.2929 23.8614 28.5329 22.9471 29.4471C22.0329 30.3614 20.7929 30.875 19.5 30.875H4.875C3.58207 30.875 2.34209 30.3614 1.42785 29.4471C0.513615 28.5329 0 27.2929 0 26V4.875C0 3.58207 0.513615 2.34209 1.42785 1.42785C2.34209 0.513615 3.58207 0 4.875 0ZM4.875 1.625C4.01305 1.625 3.1864 1.96741 2.5769 2.5769C1.96741 3.1864 1.625 4.01305 1.625 4.875V26C1.625 26.862 1.96741 27.6886 2.5769 28.2981C3.1864 28.9076 4.01305 29.25 4.875 29.25H19.5C20.362 29.25 21.1886 28.9076 21.7981 28.2981C22.4076 27.6886 22.75 26.862 22.75 26V4.875C22.75 4.01305 22.4076 3.1864 21.7981 2.5769C21.1886 1.96741 20.362 1.625 19.5 1.625H14.625V12.5125L9.75 9.1L4.875 12.5125V1.625ZM13 1.625H6.5V9.3925L9.75 7.11588L13 9.39088V1.625Z"
                                            fill="#288ED9"></path>
                                    </svg>
                                </div>
                                <div class="title-box">
                                    <h3 class="title">
                                        توضیحات پروژه
                                    </h3>
                                    <p>مختصر توضیحی درباره این پروژه</p>
                                    <div class="blue-line"></div>
                                </div>
                            </div>
                        </div>
                        <div class="blog-content">
                            {!! $portfolio->desc !!}
                        </div>
                    </div>
                     @auth
                    <!--send comment-->
                        <div class="kw-wrapper kw-wrapper-br mt-3" id="addcomment">
                            <div class="section-head p-3">
                                <div class="section-title">
                                    <div class="title-icon">
                                        <svg width="39" height="39" viewBox="0 0 39 39" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M4.875 33.4523L10.7023 27.625H29.25C30.112 27.625 30.9386 27.2826 31.5481 26.6731C32.1576 26.0636 32.5 25.237 32.5 24.375V9.75C32.5 8.88805 32.1576 8.0614 31.5481 7.4519C30.9386 6.84241 30.112 6.5 29.25 6.5H8.125C7.26305 6.5 6.4364 6.84241 5.8269 7.4519C5.21741 8.0614 4.875 8.88805 4.875 9.75V33.4523ZM4.875 35.75H3.25V9.75C3.25 8.45707 3.76361 7.21709 4.67785 6.30285C5.59209 5.38861 6.83207 4.875 8.125 4.875H29.25C30.5429 4.875 31.7829 5.38861 32.6971 6.30285C33.6114 7.21709 34.125 8.45707 34.125 9.75V24.375C34.125 25.6679 33.6114 26.9079 32.6971 27.8221C31.7829 28.7364 30.5429 29.25 29.25 29.25H11.375L4.875 35.75ZM9.75 11.375H27.625V13H9.75V11.375ZM9.75 16.25H27.625V17.875H9.75V16.25ZM9.75 21.125H22.75V22.75H9.75V21.125Z"
                                                fill="#288ED9"></path>
                                        </svg>

                                    </div>
                                    <div class="title-box">
                                        <h2 class="title">
                                            ثبت نظر برای این مقاله
                                        </h2>
                                        <p>ثبت نظر جدید...</p>
                                        <div class="blue-line"></div>
                                    </div>

                                </div>

                            </div>

                            <form action="" class="mt-0" id="comment-store" method="post">
                                @csrf
                                @method('post')
                                <input type="hidden" id="commentable_id" value="{{$portfolio->id}}">
                                <input type="hidden" id="commentable_type" value="{{get_class($portfolio)}}">
                                <label for="body">نظر شما</label>
                                <textarea name="message" id="body" cols="30" rows="10" class="form-control"></textarea>
                                <a class="kw-btn-green" onclick="sendComment()">ارسال نظر</a>
                            </form>
                        </div>
                    @endauth
                    @guest
                        <div class="alert alert-info mt-3 kw-wrapper-br" role="alert">
                            برای ثبت نظر ابتدا باید ثبت نام کنید.
                        </div>
                     @endguest
                <!--comments-->
                    <div class="comments mt-3 kw-wrapper kw-wrapper-br p-3">
                        <div class="section-head p-3">
                            <div class="section-title">
                                <div class="title-icon">
                                    <svg width="39" height="39" viewBox="0 0 39 39" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M4.875 33.4523L10.7023 27.625H29.25C30.112 27.625 30.9386 27.2826 31.5481 26.6731C32.1576 26.0636 32.5 25.237 32.5 24.375V9.75C32.5 8.88805 32.1576 8.0614 31.5481 7.4519C30.9386 6.84241 30.112 6.5 29.25 6.5H8.125C7.26305 6.5 6.4364 6.84241 5.8269 7.4519C5.21741 8.0614 4.875 8.88805 4.875 9.75V33.4523ZM4.875 35.75H3.25V9.75C3.25 8.45707 3.76361 7.21709 4.67785 6.30285C5.59209 5.38861 6.83207 4.875 8.125 4.875H29.25C30.5429 4.875 31.7829 5.38861 32.6971 6.30285C33.6114 7.21709 34.125 8.45707 34.125 9.75V24.375C34.125 25.6679 33.6114 26.9079 32.6971 27.8221C31.7829 28.7364 30.5429 29.25 29.25 29.25H11.375L4.875 35.75ZM9.75 11.375H27.625V13H9.75V11.375ZM9.75 16.25H27.625V17.875H9.75V16.25ZM9.75 21.125H22.75V22.75H9.75V21.125Z"
                                            fill="#288ED9"></path>
                                    </svg>

                                </div>
                                <div class="title-box">
                                    <h3 class="title">
                                        نظرات
                                    </h3>
                                    <div class="blue-line"></div>
                                </div>
                                @if(!$portfolio->comments->where('status' , 1)->count())
                                    <p class="subtitle">
                                        هنوز نظری برای این پست ثبت نشده است
                                    </p>
                                @endif
                            </div>

                        </div>
                        @include('comment::frontend.show' , [
                        'comments' => $portfolio->comments->whereNull('parent_id')->where('status' , 1) ,
                        'comment_reply' => false
                        ])
                    </div>
                </div>
                <div class="col-md-4 col-lg-3 kw-p-single-sidebar">
                    <div class="kw-wrapper kw-wrapper-br p-3 kw-mt-1rem">
                        <div class="section-head">
                            <div class="section-title">
                                <div class="title-icon">
                                    <svg width="28" height="18" viewBox="0 0 28 18" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M0 1.625V0H27.625V1.625H0ZM27.625 8.125V9.75H0V8.125H27.625ZM0 16.25H27.625V17.875H0V16.25Z"
                                            fill="#288ED9"></path>
                                    </svg>
                                </div>
                                <div class="title-box">
                                    <h6 class="title">جزئیات پروژه</h6>
                                    <div class="blue-line"></div>
                                </div>
                            </div>
                        </div>
                        <div class="kw-p-single-details p-3">
                            <ul class="kw-list1">
                                <li>
                                    نام پروژه: {{$portfolio->title }}
                                    <hr>
                                </li>
                                <li>
                                    تاریخ راه اندازی: {{$portfolio->project_running_date}}
                                    <hr>
                                </li>
                                <li>
                                    وضعیت پروژه:
                                    @switch($portfolio->status)
                                        @case(1)
                                        فعال
                                        @break
                                        @case(0)
                                        غیر فعال
                                        @break
                                    @endswitch
                                </li>
                            </ul>
                        </div>

                    </div>
                    <!--website link-->
                    <div class="kw-wrapper kw-wrapper-br p-3 kw-mt-1rem mt-3">
                        <div class="section-head">
                            <div class="section-title">
                                <div class="title-icon">
                                    <svg width="31" height="18" viewBox="0 0 31 18" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M9.75 9.75V8.125H21.125V9.75H9.75ZM21.9375 0C24.3079 0 26.5812 0.941626 28.2573 2.61773C29.9334 4.29384 30.875 6.56713 30.875 8.9375C30.875 11.3079 29.9334 13.5812 28.2573 15.2573C26.5812 16.9334 24.3079 17.875 21.9375 17.875H17.875V16.25H21.9375C23.8769 16.25 25.7369 15.4796 27.1082 14.1082C28.4796 12.7369 29.25 10.8769 29.25 8.9375C29.25 6.9981 28.4796 5.13814 27.1082 3.76678C25.7369 2.39542 23.8769 1.625 21.9375 1.625H17.875V0H21.9375ZM8.9375 17.875C6.56713 17.875 4.29384 16.9334 2.61773 15.2573C0.941627 13.5812 0 11.3079 0 8.9375C0 6.56713 0.941627 4.29384 2.61773 2.61773C4.29384 0.941626 6.56713 0 8.9375 0H13V1.625H8.9375C6.9981 1.625 5.13814 2.39542 3.76678 3.76678C2.39542 5.13814 1.625 6.9981 1.625 8.9375C1.625 10.8769 2.39542 12.7369 3.76678 14.1082C5.13814 15.4796 6.9981 16.25 8.9375 16.25H13V17.875H8.9375Z"
                                            fill="#288ED9"></path>
                                    </svg>

                                </div>
                                <div class="title-box">
                                    <h6 class="title">لینک پروژه</h6>
                                    <div class="blue-line"></div>
                                </div>
                            </div>
                        </div>
                        <div class="kw-p-single-link p-3">
                            <a href="{{$portfolio->link}}" rel="nofollow">{{$portfolio->link}}</a>
                        </div>

                    </div>
                    <div class="kw-wrapper kw-wrapper-br p-3 kw-mt-1rem mt-3">
                        <div class="section-head">
                            <div class="section-title">
                                <div class="title-icon">
                                    <svg width="32" height="28" viewBox="0 0 32 28" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M7.97062 27.625L0 13.8222L7.982 0H23.92L31.8955 13.8125L23.92 27.625H7.97062ZM22.9808 1.625H8.91963L1.87687 13.8222L8.90825 26H22.9808L30.017 13.8125L22.9808 1.625Z"
                                            fill="#288ED9"></path>
                                    </svg>
                                </div>
                                <div class="title-box">
                                    <h6 class="title">لوگوی وب سایت</h6>
                                    <div class="blue-line"></div>
                                </div>
                            </div>
                        </div>
                        <div class="kw-p-single-logo p-3">
                            <img src="{{asset($portfolio->logo)}}" alt="">
                        </div>

                    </div>
                    <div class="kw-wrapper kw-wrapper-br p-3 kw-mt-1rem mt-3">
                        <div class="section-head">
                            <div class="section-title">
                                <div class="title-icon">
                                    <svg width="28" height="28" viewBox="0 0 28 28" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M8.125 24.375C6.83207 24.375 5.59209 23.8614 4.67785 22.9471C3.76361 22.0329 3.25 20.7929 3.25 19.5V17.875H0V16.25H3.25V11.375H0V9.75H3.25V8.125C3.25 6.83207 3.76361 5.59209 4.67785 4.67785C5.59209 3.76361 6.83207 3.25 8.125 3.25H9.75V0H11.375V3.25H16.25V0H17.875V3.25H19.5C20.7929 3.25 22.0329 3.76361 22.9471 4.67785C23.8614 5.59209 24.375 6.83207 24.375 8.125V9.75H27.625V11.375H24.375V16.25H27.625V17.875H24.375V19.5C24.375 20.7929 23.8614 22.0329 22.9471 22.9471C22.0329 23.8614 20.7929 24.375 19.5 24.375H17.875V27.625H16.25V24.375H11.375V27.625H9.75V24.375H8.125ZM8.125 4.875C7.26305 4.875 6.4364 5.21741 5.8269 5.8269C5.21741 6.4364 4.875 7.26305 4.875 8.125V19.5C4.875 20.362 5.21741 21.1886 5.8269 21.7981C6.4364 22.4076 7.26305 22.75 8.125 22.75H19.5C20.362 22.75 21.1886 22.4076 21.7981 21.7981C22.4076 21.1886 22.75 20.362 22.75 19.5V8.125C22.75 7.26305 22.4076 6.4364 21.7981 5.8269C21.1886 5.21741 20.362 4.875 19.5 4.875H8.125ZM9.75 17.875V9.75H17.875V17.875H9.75ZM11.375 11.375V16.25H16.25V11.375H11.375Z"
                                            fill="#288ED9"></path>
                                    </svg>
                                </div>
                                <div class="title-box">
                                    <h6 class="title">تکنولوژی ها، نرم افزار ها، و زبان برنامه نویسی</h6>
                                    <div class="blue-line"></div>
                                </div>
                            </div>
                        </div>
                        <div class="kw-p-single-tech p-3">
                            @php
                                $techs = unserialize($portfolio->techs);
                            @endphp
                            <ul class="horizontal-list">
                                @foreach($techs as $tech)
                                    @switch($tech)
                                        @case('php')
                                        <li>
                                            <img src="/images/icons/php.png" alt="">
                                        </li>
                                        @break
                                        @case('figma')
                                        <li>
                                            <img src="/images/icons/figma.png" alt="">
                                        </li>
                                        @break
                                        @case('wordpress')
                                        <li>
                                            <img src="/images/icons/WordPress.png" alt="">
                                        </li>
                                        @break

                                        @case('woocommerce')
                                        <li>
                                            <img src="/images/icons/woocommerce.png" alt="">
                                        </li>
                                        @break

                                        @case('html')
                                        <li>
                                            <img src="/images/icons/Html.png" alt="">
                                        </li>
                                        @break

                                        @case('javascript')
                                        <li>
                                            <img src="/images/icons/JavaScript.png" alt="">
                                        </li>
                                        @break

                                        @case('css')
                                        <li>
                                            <img src="/images/icons/CSS3.png" alt="">
                                        </li>
                                        @break

                                        @case('laravel')
                                        <li>
                                            <img src="/images/icons/Laravel.png" alt="">
                                        </li>
                                        @break

                                    @endswitch
                                @endforeach
                            </ul>
                        </div>

                    </div>
                    <div class="kw-wrapper kw-wrapper-br p-3 kw-mt-1rem mt-3">
                        <div class="section-head">
                            <div class="section-title">
                                <div class="title-icon">
                                    <svg width="26" height="7" viewBox="0 0 26 7" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M19.5 3.25C19.5 2.38805 19.8424 1.5614 20.4519 0.951904C21.0614 0.34241 21.888 0 22.75 0C23.612 0 24.4386 0.34241 25.0481 0.951904C25.6576 1.5614 26 2.38805 26 3.25C26 4.11195 25.6576 4.9386 25.0481 5.5481C24.4386 6.15759 23.612 6.5 22.75 6.5C21.888 6.5 21.0614 6.15759 20.4519 5.5481C19.8424 4.9386 19.5 4.11195 19.5 3.25ZM9.75 3.25C9.75 2.38805 10.0924 1.5614 10.7019 0.951904C11.3114 0.34241 12.138 0 13 0C13.862 0 14.6886 0.34241 15.2981 0.951904C15.9076 1.5614 16.25 2.38805 16.25 3.25C16.25 4.11195 15.9076 4.9386 15.2981 5.5481C14.6886 6.15759 13.862 6.5 13 6.5C12.138 6.5 11.3114 6.15759 10.7019 5.5481C10.0924 4.9386 9.75 4.11195 9.75 3.25ZM0 3.25C0 2.38805 0.34241 1.5614 0.951903 0.951904C1.5614 0.34241 2.38805 0 3.25 0C4.11195 0 4.9386 0.34241 5.5481 0.951904C6.15759 1.5614 6.5 2.38805 6.5 3.25C6.5 4.11195 6.15759 4.9386 5.5481 5.5481C4.9386 6.15759 4.11195 6.5 3.25 6.5C2.38805 6.5 1.5614 6.15759 0.951903 5.5481C0.34241 4.9386 0 4.11195 0 3.25ZM3.25 1.625C2.81902 1.625 2.4057 1.79621 2.10095 2.10095C1.79621 2.4057 1.625 2.81902 1.625 3.25C1.625 3.68098 1.79621 4.0943 2.10095 4.39905C2.4057 4.70379 2.81902 4.875 3.25 4.875C3.68098 4.875 4.0943 4.70379 4.39905 4.39905C4.70379 4.0943 4.875 3.68098 4.875 3.25C4.875 2.81902 4.70379 2.4057 4.39905 2.10095C4.0943 1.79621 3.68098 1.625 3.25 1.625ZM13 1.625C12.569 1.625 12.1557 1.79621 11.851 2.10095C11.5462 2.4057 11.375 2.81902 11.375 3.25C11.375 3.68098 11.5462 4.0943 11.851 4.39905C12.1557 4.70379 12.569 4.875 13 4.875C13.431 4.875 13.8443 4.70379 14.149 4.39905C14.4538 4.0943 14.625 3.68098 14.625 3.25C14.625 2.81902 14.4538 2.4057 14.149 2.10095C13.8443 1.79621 13.431 1.625 13 1.625ZM22.75 1.625C22.319 1.625 21.9057 1.79621 21.601 2.10095C21.2962 2.4057 21.125 2.81902 21.125 3.25C21.125 3.68098 21.2962 4.0943 21.601 4.39905C21.9057 4.70379 22.319 4.875 22.75 4.875C23.181 4.875 23.5943 4.70379 23.899 4.39905C24.2038 4.0943 24.375 3.68098 24.375 3.25C24.375 2.81902 24.2038 2.4057 23.899 2.10095C23.5943 1.79621 23.181 1.625 22.75 1.625Z"
                                            fill="#288ED9"></path>
                                    </svg>
                                </div>
                                <div class="title-box">
                                    <h6 class="title">پالت رنگی</h6>
                                    <div class="blue-line"></div>
                                </div>
                            </div>
                        </div>
                        <div class="kw-p-single-pallet p-3">
                            @php
                                $colors = explode(',' , $portfolio->colors);
                            @endphp
                            @foreach($colors as $color)
                                <svg width="36" height="36" viewBox="0 0 36 36" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <circle cx="18" cy="18" r="18" fill="{{$color}}"></circle>
                                </svg>
                            @endforeach
                        </div>

                    </div>

                    <div class="kw-wrapper kw-wrapper-br p-3 kw-mt-1rem mt-3">
                        <div class="section-head">
                            <div class="section-title">
                                <div class="title-icon">
                                    <svg width="28" height="31" viewBox="0 0 28 31" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M16.2511 4.875H17.8761V3.25C17.8761 2.81902 17.7049 2.4057 17.4002 2.10095C17.0954 1.79621 16.6821 1.625 16.2511 1.625H11.3761C10.9451 1.625 10.5318 1.79621 10.2271 2.10095C9.92233 2.4057 9.75113 2.81902 9.75113 3.25V4.875H11.3761V8.242L2.08925 24.3262C1.79293 24.8195 1.63286 25.3825 1.62539 25.9578C1.61792 26.5331 1.76333 27.1001 2.04675 27.6009C2.33016 28.1016 2.74143 28.5181 3.23854 28.8079C3.73564 29.0976 4.30075 29.2502 4.87613 29.25H22.7511C23.3265 29.2502 23.8916 29.0976 24.3887 28.8079C24.8858 28.5181 25.2971 28.1016 25.5805 27.6009C25.8639 27.1001 26.0093 26.5331 26.0019 25.9578C25.9944 25.3825 25.8343 24.8195 25.538 24.3262L16.2511 8.242V4.875ZM4.87613 30.875C3.99846 30.8752 3.13702 30.6385 2.38272 30.1898C1.62842 29.7411 1.00924 29.0971 0.590535 28.3257C0.171827 27.5544 -0.0308794 26.6843 0.00381014 25.8073C0.0384997 24.9303 0.309298 24.079 0.787625 23.3431L9.75113 7.81787V6.5C9.32015 6.5 8.90682 6.32879 8.60208 6.02405C8.29733 5.7193 8.12613 5.30598 8.12613 4.875V3.25C8.12613 2.38805 8.46854 1.5614 9.07803 0.951903C9.68752 0.34241 10.5142 0 11.3761 0H16.2511C17.1131 0 17.9397 0.34241 18.5492 0.951903C19.1587 1.5614 19.5011 2.38805 19.5011 3.25V4.875C19.5011 5.30598 19.3299 5.7193 19.0252 6.02405C18.7204 6.32879 18.3071 6.5 17.8761 6.5V7.81787L26.8396 23.3431C27.318 24.079 27.5888 24.9303 27.6234 25.8073C27.6581 26.6843 27.4554 27.5544 27.0367 28.3257C26.618 29.0971 25.9988 29.7411 25.2445 30.1898C24.4902 30.6385 23.6288 30.8752 22.7511 30.875H4.87613ZM15.1039 19.9745L17.7461 17.3323L22.7511 26H4.87613L10.8236 15.6975L15.1039 19.9745ZM15.1039 22.2722L11.173 18.343L7.69062 24.375H19.9366L17.3984 19.9777L15.1039 22.2722ZM14.6261 11.375C15.0571 11.375 15.4704 11.5462 15.7752 11.851C16.0799 12.1557 16.2511 12.569 16.2511 13C16.2511 13.431 16.0799 13.8443 15.7752 14.149C15.4704 14.4538 15.0571 14.625 14.6261 14.625C14.1951 14.625 13.7818 14.4538 13.4771 14.149C13.1723 13.8443 13.0011 13.431 13.0011 13C13.0011 12.569 13.1723 12.1557 13.4771 11.851C13.7818 11.5462 14.1951 11.375 14.6261 11.375Z"
                                            fill="#4B3DA7"></path>
                                    </svg>
                                </div>
                                <div class="title-box">
                                    <h6 class="title">درصد پیشرفت</h6>
                                    <div class="blue-line"></div>
                                </div>
                            </div>
                        </div>
                        <div class="p-3">
                            <div class="progress">
                                <div class="progress-bar progress-bar-striped bg-success" role="progressbar"
                                     style="width: {{$portfolio->project_progress}}%"
                                     aria-valuenow="{{$portfolio->project_progress}}" aria-valuemin="0"
                                     aria-valuemax="{{$portfolio->project_progress}}">{{$portfolio->project_progress}}%
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="kw-wrapper kw-wrapper-br bg-red p-3 kw-mt-1rem mt-3">
                        <div class="section-head kw-copyright-section">
                            <div class="section-title">
                                <div class="title-icon">
                                    <svg class="kw-copyright-svg" width="31" height="31" viewBox="0 0 31 31" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M15.4375 0C19.5318 0 23.4584 1.62645 26.3535 4.52154C29.2486 7.41663 30.875 11.3432 30.875 15.4375C30.875 19.5318 29.2486 23.4584 26.3535 26.3535C23.4584 29.2486 19.5318 30.875 15.4375 30.875C11.3432 30.875 7.41663 29.2486 4.52154 26.3535C1.62645 23.4584 0 19.5318 0 15.4375C0 11.3432 1.62645 7.41663 4.52154 4.52154C7.41663 1.62645 11.3432 0 15.4375 0ZM15.4375 1.625C11.7742 1.625 8.26093 3.08024 5.67059 5.67059C3.08024 8.26093 1.625 11.7742 1.625 15.4375C1.625 19.1008 3.08024 22.6141 5.67059 25.2044C8.26093 27.7948 11.7742 29.25 15.4375 29.25C19.1008 29.25 22.6141 27.7948 25.2044 25.2044C27.7948 22.6141 29.25 19.1008 29.25 15.4375C29.25 11.7742 27.7948 8.26093 25.2044 5.67059C22.6141 3.08024 19.1008 1.625 15.4375 1.625ZM14.625 22.75V19.5H16.25V22.75H14.625ZM14.625 16.25V8.125H16.25V16.25H14.625Z"
                                            fill="white"></path>
                                    </svg>
                                </div>
                                <div class="title-box">
                                    <p class="subtitle text-white">هرگونه کپی برداری از این محصول پیگرد قانونی به همراه
                                        دارد.</p>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>

@section('scripts')
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script src="{{asset('/js/responsive-sidebar.js')}}"></script>
    <script src="{{asset('/assets/js/comments.js')}}"></script>
@stop
@endcomponent
