@component('backend.layouts.components.main',['title' => 'مدیریت نمونه کار ها', 'titleBar'=>true , 'button' => 'افزودن نمونه کار' , 'route' => 'admin.portfolios.create'])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">نمونه کار ها</li>


    @endslot

    {{-- Table Start --}}
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست نمونه کار ها</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>لوگو</th>
                            <th>نام</th>
                            <th>دسته بندی</th>
                            <th>تاریخ ثبت</th>
                            @can('manage-portfolios')
                                <th>عملیات</th>
                            @endcan
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($portfolios as $portfolio)
                            <tr>
                                <td>
                                    <img src="{{$portfolio->logo}}" alt="" style="width: 55px; height: auto;">
                                </td>
                                <td>{{$portfolio->title}}</td>
                                <td>
                                    @foreach($portfolio->categories as $category)
                                        @if(count($portfolio->categories)>1)
                                            {{$category->name . ','}}
                                        @else
                                            {{$category->name}}
                                        @endif
                                    @endforeach
                                </td>
                                <td>{{\Hekmatinasser\Verta\Verta::instance($portfolio->created_at)->formatJalaliDate()}}</td>

                                <td>
                                    <form action="{{route('admin.portfolios.destroy', $portfolio->id)}}" method="post"
                                          id="delete-{{$portfolio->id}}">
                                        @method('delete')
                                        @csrf
                                    </form>
                                    @can('manage-users')
                                        <a href="{{route('admin.portfolios.edit', $portfolio->id)}}" role="button"
                                           class="btn btn-success light sharp" title="ویرایش">
                                            <i class="fa fa-pencil"
                                               onclick="document.getElementById('edit-{{$portfolio->id}}').submit()"></i>
                                        </a>
                                        <button onclick="document.getElementById('delete-{{$portfolio->id}}').submit()"
                                                role="button" class="btn btn-danger light sharp" title="حذف">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    @endcan
                                    <a href="{{asset('portfolios/'.$portfolio->slug)}}" role="button"
                                       class="btn btn-primary light sharp" title="نمایش" target="_blank">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                </td>

                            </tr>

                        @endforeach
                        </tbody>
                    </table>

                </div>
                {{$portfolios->links()}}
            </div>
        </div>
    </div>
    {{-- Table End --}}
@section('script')
    <script src="{{asset('/backend/js/search.js')}}"></script>
@stop
@endcomponent
