<?php

namespace Modules\Payment\Http\Controllers\Front;

use Carbon\Carbon;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Str;
use Modules\Cart\Http\Helpers\Cart;
use Modules\Course\Entities\Course;
use Modules\Course\Notifications\SuccessfulCoursePurchase;
use Modules\Course\Notifications\SuccessfulCoursePurchaseAdminNotify;
use Modules\Order\Entities\Order;
use Modules\Payment\Entities\Payment;
use Modules\Project\Entities\Project;
use Modules\Project\Notifications\SuccessfulProjectPurchase;
use Modules\User\Entities\User;

class PaymentController extends Controller
{
    public function payment()
    {
        $cart = Cart::instance('cart');
        $cartItems = $cart->all();
        if ($cartItems->count()) {
            $price = $cartItems->sum(function ($cart){
                return $cart['discount_percent'] == 0 ?  $cart['price']
                    : $cart['price'] - ($cart['price'] * $cart['discount_percent']);
            });
            $productId = $cartItems->flatMap(function ($cart){
                return [$cart['course']->id ];
            });
            $order = auth()->user()->orders()->create([
                'tracking_id' => rand(100000 , 20000),
                'status' => 'unpaid',
                'price' => $price,
                'product_type' => Course::class,
                'product_id' => serialize($productId->toArray())
            ]);

            $order->courses()->attach($productId);

            $token = config('services.payping.token');
            $res_number = Str::random();
            $args = [
                'amount' => $price,
                'payerName' => \auth()->user()->name,
                'returnUrl' =>route('payment.callback'),
                'clientRefId' => $res_number
            ];
            $payment = new \PayPing\Payment($token);
            try {
                $payment->pay($args);
            } catch (\Exception $e) {
                $errors = collect(json_decode($e->getMessage(),true));
                alert()->error($errors->first());
                return redirect('/cart');
            }
            $order->payments()->create([
                'res_number' => $res_number,
                'price' => $price
            ]);

            $cart->flush();
            return redirect($payment->getPayUrl());
        }

        alert()->warning('سبد خرید شما خالی است');
        return back();
    }

    public function coursesCallBack(Request $request)
    {
        $payment = Payment::where('res_number',$request->clientrefid)->firstOrFail();

        $token = config('services.payping.token');

        $payping = new \PayPing\Payment($token);

        try {
            if($payping->verify($request->refid, $payment->order->price)){
                $payment->update([
                    'status' => 1,
                ]);
                $payment->order()->update([
                    'status'=>'full_paid'
                ]);
                auth()->user()
                    ->courses()
                    ->attach(unserialize($payment->order->product_id));
                auth()->user()->notify(new SuccessfulCoursePurchase(auth()->user()->phone , auth()->user()->name , '8obsnhgjaq'));
                $staff = User::where('phone' , '09058775382')->first();
                $staff->notify(new SuccessfulCoursePurchase($staff->phone , $staff->name , 'wn50vthrj2' ));
                alert()->success('پرداخت شما موفق بود');
                return redirect(route('profile.courses'));
            }else{
                alert()->error('پرداخت شما موفق نبود');
                return redirect(route('profile.dashboard'));
            }
        } catch (\Exception $e) {
            $errors = collect(json_decode($e->getMessage(),true));
            alert()->error($errors->first());
            return redirect(route('profile.dashboard'));

        }
    }

    public function projectsCallBack(Request $request)
    {
        $payment = Payment::where('res_number',$request->clientrefid)->firstOrFail();
        $project = Project::whereId($payment->order->product_id)->firstOrFail();

        $token = config('services.payping.token');

        $payping = new \PayPing\Payment($token);
        try {
            if($payping->verify($request->refid, $payment->order->price)){
                $payment->update([
                    'status' => 1,
                ]);
                $payment->order()->update([
                    'status'=>'full_paid'
                ]);
//                $renewal_date = Carbon::parse($project->renew_date);
//                $project->update([
//                    'renew_date' => $renewal_date->addYear()
//                ]);
                $staff = User::where('phone' , '09058775382')->first();
                auth()->user()->notify(new SuccessfulProjectPurchase(auth()->user()->phone , $project->domain , 'bewx2ntu1u'));
                $staff->notify(new SuccessfulProjectPurchase($staff->phone , $project->domain , '2m14abqwiy'));
                alert()->success('پرداخت شما موفق بود');
                return redirect(route('profile.projects'));
            }else{
                alert()->error('پرداخت شما موفق نبود');
                return redirect(route('profile.projects'));
            }
        } catch (\Exception $e) {
            $errors = collect(json_decode($e->getMessage(),true));
            alert()->error($errors->first());
            return redirect(route('profile.dashboard'));

        }
    }

}
