@component('backend.layouts.components.main',['title' => 'ویرایش سوال','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">ویرایش سوال</li>
    @endslot
    {{-- Section Start --}}
    <div class="col-md-8">
        <div class="sidebar-admin">
            <div class="card-header">
                <h4 class="card-title">جزئیات سوال</h4>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <input name="question" type="text"
                           class="form-control input-rounded @error('question') is-invalid @enderror" placeholder="سوال"
                           form="store" required value="{{old('question' , $faq->question)}}">
                    @error('question')
                    <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                    @enderror
                </div>
                <div class="">
                    <form action="{{route('admin.faqs.update',$faq)}}" method="post" id="store">
                        @csrf
                        @method('patch')
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">پاسخ</label>
                            <div class="col-sm-9">
                                <textarea name="answer" class="form-control" id="answer" cols="30" rows="10">{{old('answer' , $faq->answer)}}</textarea>
                                @error('answer')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">برگه مربوطه</label>
                            <div class="col-sm-9">
                                <select class="form-control default-select" name="page_id">
                                    <option value="">انتخاب کنید</option>
                                    @foreach($pages as $page)
                                        <option value="{{$page->id}}" @if($faq->page_id == $page->id) selected @endif> {{$page->title}} </option>
                                    @endforeach
                                </select>
                                @error('page_id')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}
    <div class="col-md-4">
        @if($errors->any())
            <div class="alert alert-danger left-icon-big alert-dismissible fade show">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span><i
                            class="mdi mdi-close"></i></span>
                </button>
                <div class="media">
                    <div class="alert-left-icon-big">
                        <span><i class="mdi mdi-alert"></i></span>
                    </div>
                    <div class="media-body">
                        <h5 class="mt-1 mb-2">خطا!</h5>
                        @foreach($errors->all() as $error)
                            <p class="mb-0">{{$error}}</p>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif


        <div class=" sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.faqs.index')}}" role="button" class="btn btn-xs btn-info light" title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای ایجاد سوال جدید، روی دکمه "ساختن" کلیک کنید.
                </p>

                <div class="row">
                    <button class="btn btn-success btn-sm btn-block light"
                            onclick="document.getElementById('store').submit()">
                        <i class="fa fa-save"></i>
                        ساختن
                    </button>
                </div>
            </div>
        </div>
    </div>
    {{-- Sidebar End --}}



    {{-- Scripts --}}
@section('script')
    <script src="/backend/vendor/nestable2/js/jquery.nestable.min.js"></script>

@stop

@section('head')
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.0/css/all.css">
    <link rel="stylesheet" href="{{ asset('/vendor/file-manager/css/file-manager.css') }}">
    <link rel="stylesheet" href="{{ asset('/backend/vendor/nestable2/css/jquery.nestable.min.css') }}">
@stop
@endcomponent
