<?php

namespace Modules\Page\Http\Controllers\Front;

use Artesaos\SEOTools\Facades\JsonLd;
use Artesaos\SEOTools\Facades\OpenGraph;
use Artesaos\SEOTools\Facades\SEOMeta;
use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Page\Entities\Page;

class PageController extends Controller
{
    use SEOTools;

    public function show(Page $page)
    {
        $this->seo()
            ->settitle($page->meta_title)
            ->setDescription($page->meta_description);
        $this->seo()->jsonLd()->setType('WebPage');
        $this->seo()->jsonLd()->setImages(asset($page->image));
        $this->seo()->jsonLd()->setUrl(asset($page->slug));
        JsonLd::addValue('primaryImageOfPage',asset($page->image));
        SEOMeta::addKeyword($page->meta_keywords)
            ->setCanonical(asset($page->slug));
        OpenGraph::setTitle($page->title)
            ->setDescription($page->meta_description)
            ->setUrl(asset($page->slug))
            ->addProperty('locale', 'fa_IR')
            ->setSiteName('کاراوب')
            ->setType('Article')
            ->addImage(asset($page->image));
        return view('page::frontend.show',compact('page'));
    }

    public function faqShow(Page $page)
    {
        return $page->faqs;
    }
}
