<?php

namespace Modules\Page\Http\Controllers\Admin;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;
use Modules\Page\Entities\Page;

class PageController extends Controller
{
    use SEOTools;
    public function index()
    {
        $this->seo()->setTitle('همه برگه ها');

        $pages = Page::query();
        if ($key = \request('search')) {
            $pages = $pages->where('title', 'like', "%$key%");
        }
        $pages = $pages->latest()->simplePaginate(15);
        return view('page::backend.all' , compact('pages'));
    }


    public function show(Page $page)
    {
        $this->seo()->setTitle("ویرایش برگه $page->title");
        return view('page::backend.online-editor' , compact('page'));
    }


    public function edit(Page $page)
    {
        $this->seo()->setTitle("ویرایش برگه $page->title");
        return view('page::backend.edit' , compact('page'));
    }

    public function update(Request $request, Page $page)
    {
        $page->update([
            'body' => $request->body
        ]);
        return response()->json([
           'status' => 'موفق'
        ]);
    }

    public function destroy(Page $page)
    {
        $page->delete();
        alert()->success('عملیات موفق بود');
        return back();
    }

    public function updatePageInfo(Request $request,Page $page)
    {
        $validData = $request->validate([
            'title' => 'required',
            'slug' => ['nullable', Rule::unique('pages')->ignore($page)],
            'meta_title' => 'nullable',
            'meta_keywords' => 'nullable',
            'meta_description' => 'nullable',
            'meta_type' => 'nullable',
            'status' => 'nullable',
            'is_indexable' => 'nullable',
            'rating_count' => 'nullable'
        ]);
        //if status exists
        if (array_key_exists('status', $validData)) {
            $validData['status'] = 1;
            $page->update([
                'title' => $validData['title'],
                'meta_title' => $validData['meta_title'],
                'slug' => Str::slug($validData['slug'],'-'),
                'meta_keywords' => $validData['meta_keywords'],
                'meta_description' => $validData['meta_description'],
                'meta_type' => $validData['meta_type'],
                'status' => $validData['status'],
                'is_indexable' => $validData['is_indexable'],
                'image' => $request->image,
                'rating_count' => $validData['rating_count'],
            ]);
        }else{
            //if status does not exists
            $page->update([
                'title' => $validData['title'],
                'meta_title' => $validData['meta_title'],
                'slug' => Str::slug($validData['slug'],'-'),
                'meta_keywords' => $validData['meta_keywords'],
                'meta_description' => $validData['meta_description'],
                'meta_type' => $validData['meta_type'],
                'status' => 0,
                'is_indexable' => $validData['is_indexable'],
                'image' => $request->image,
                'rating_count' => $validData['rating_count'],
            ]);
        }
        alert()->success('برگه با موفقیت ویرایش شد', 'موفق');
        return back();
    }
}
