@component('backend.layouts.components.main',['title' => 'ویرایش سفارش','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">ویرایش سفارش</li>
    @endslot
    {{-- Section Start --}}

    <div class="col-md-8">
        <div class="sidebar-admin">
            <div class="card-header">
                <h4 class="card-title">جزئیات سفارش</h4>
            </div>
            <div class="card-body">
                <form action="{{route('admin.orders.update' , $order)}}" method="post" id="store">
                    @csrf
                    @method('patch')
                    <div class="form-group row">
                        <label class="col-sm-3 col-form-label">کاربر</label>
                        <div class="col-sm-9">
                            <select class="form-control default-select" name="user_id">
                                <option value="">انتخاب کنید</option>
                                @foreach($users as $user)
                                    <option value="{{$user->id}}"
                                            @if($order->user_id == $user->id) selected @endif>تلفن همراه:
                                        {{$user->phone}} | نام: {{$user->name}}
                                    </option>
                                @endforeach
                            </select>
                            @error('user_id')
                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                            @enderror
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-3 col-form-label">وضعیت</label>
                        <div class="col-sm-9">
                            <select class="form-control default-select" name="status">
                                <option value="">انتخاب کنید</option>
                                <option value="full_paid" @if($order->status == 'full_paid') selected @endif>پرداخت شده</option>
                                <option value="unpaid" @if($order->status == 'unpaid') selected @endif>پرداخت نشده</option>
                                <option value="half_paid" @if($order->status == 'half_paid') selected @endif>پیش پرداخت</option>
                                <option value="canceled" @if($order->status == 'canceled') selected @endif>لفو شده</option>
                            </select>
                            @error('status')
                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                            @enderror
                        </div>
                    </div>
                    @if($order->product_type == \Modules\Course\Entities\Course::class)
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">دوره آموزشی</label>
                            <div class="col-sm-9">
                                <select class="form-control default-select" name="course_id">
                                    <option value="">انتخاب کنید</option>
                                    @foreach($courses as $course)
                                        <option value="{{$course->id}}"
                                                @if($order->product_id == $course->id) selected @endif
                                        >{{$course->title}}</option>
                                    @endforeach
                                </select>
                                @error('course_id')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                    @endif
                    @if($order->product_type == \Modules\Project\Entities\Project::class)
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">پروژه</label>
                            <div class="col-sm-9">
                                <select class="form-control default-select" name="project_id">
                                    <option value="">انتخاب کنید</option>
                                    @foreach($projects as $project)
                                        <option value="{{$project->id}}"
                                                @if($order->product_id == $project->id) selected @endif
                                        >کد: {{$project->tracking_id}} | دامنه: {{$project->domain}} </option>
                                    @endforeach
                                </select>
                                @error('project_id')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                    @endif
                    <div class="form-group row">
                        <label class="col-sm-3 col-form-label">قیمت</label>
                        <div class="col-sm-9">
                            <input type="text" name="price" class="form-control input-rounded"
                                   value="{{old('price') ? old('price') : $order->price}}">
                            @error('price')
                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                            @enderror
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-3 col-form-label">نوع سفارش</label>
                        <div class="col-sm-9">
                            <select class="form-control default-select" name="type">
                                <option value="">انتخاب کنید</option>
                                <option value="normal" @if($order->type == 'normal') selected @endif>عادی</option>
                                <option value="renewal" @if($order->type == 'renewal') selected @endif>برای تمدید</option>
                                <option value="first" @if($order->type == 'first') selected @endif>قسط اول</option>
                                <option value="second" @if($order->type == 'second') selected @endif>قسط دوم</option>
                            </select>
                            @error('type')
                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                            @enderror
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}

    <div class="col-md-4">
        @if($errors->any())
            <div class="alert alert-danger left-icon-big alert-dismissible fade show">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span><i
                            class="mdi mdi-close"></i></span>
                </button>
                <div class="media">
                    <div class="alert-left-icon-big">
                        <span><i class="mdi mdi-alert"></i></span>
                    </div>
                    <div class="media-body">
                        <h5 class="mt-1 mb-2">خطا!</h5>
                        @foreach($errors->all() as $error)
                            <p class="mb-0">{{$error}}</p>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif
        <div class="sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.orders.index')}}" role="button" class="btn btn-xs btn-info light" title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای اعمال ویرایش ها، روی دکمه "به روز رسانی" کلیک کنید.
                </p>
                <div class="row">
                    <button class="btn btn-success btn-sm btn-block light"
                            onclick="document.getElementById('store').submit()">
                        <i class="fa fa-refresh"></i>
                        به روز رسانی
                    </button>
                </div>
            </div>
        </div>
    </div>

    {{-- Sidebar End --}}

    {{-- Scripts --}}
@section('script')
    <script src="/backend/vendor/nestable2/js/jquery.nestable.min.js"></script>
    <script src="{{asset('/backend/js/file-button.js')}}"></script>
@stop

@section('head')
    <link rel="stylesheet" href="https://unpkg.com/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.js" integrity="sha256-H+K7U5CnXl1h5ywQfKtSj8PCmoN9aaq30gDh27Xc0jk=" crossorigin="anonymous"></script>
    <script src="https://unpkg.com/persian-date@1.1.0/dist/persian-date.min.js"></script>
    <script src="https://unpkg.com/persian-datepicker@1.2.0/dist/js/persian-datepicker.min.js"></script>
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.0/css/all.css">
    <link rel="stylesheet" href="{{ asset('/vendor/file-manager/css/file-manager.css') }}">
    <link rel="stylesheet" href="{{ asset('/backend/vendor/nestable2/css/jquery.nestable.min.css') }}">
@stop
@endcomponent
