@component('backend.layouts.components.main',['title' => 'مدیریت سفارشات', 'titleBar'=>true , 'button' => 'افزودن سفارش' , 'route' => 'admin.orders.create'])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">سفارشات</li>
    @endslot

    {{-- Table Start --}}
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست سفارشات</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>کد سفارش</th>
                            <th>کاربر</th>
                            <th>مبلغ</th>
                            <th>وضعیت</th>
                            <th>تاریخ ایجاد</th>
                            @can('manage-all')
                                <th>عملیات</th>
                            @endcan
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($orders as $order)

                            <tr>
                                <td>{{$order->tracking_id}}</td>
                                <td>
                                    <a href="{{route('admin.users.edit' , $order->user->name)}}">{{$order->user->name}}</a>
                                </td>
                                <td>{{number_format($order->price)}}</td>
                                <td>
                                    @switch($order->status)
                                        @case('half_paid')
                                        <span class="badge badge-pill badge-info light">پیش پرداخت</span>
                                        @break
                                        @case('full_paid')
                                        <span class="badge badge-pill badge-success light">پرداخت شده</span>
                                        @break
                                        @case('unpaid')
                                        <span class="badge badge-pill badge-warning light">پرداخت نشده</span>
                                        @break
                                        @case('half_paid')
                                        <span class="badge badge-pill badge-danger light">لغو شده</span>
                                        @break
                                    @endswitch
                                    @switch($order->type)
                                        @case('normal')
                                        <span class="badge badge-pill badge-primary light">عادی</span>
                                        @break
                                        @case('renewal')
                                        <span class="badge badge-pill badge-primary light">برای تمدید</span>
                                        @break
                                        @case('first')
                                        <span class="badge badge-pill badge-primary light">قسط اول</span>
                                        @break
                                        @case('second')
                                        <span class="badge badge-pill badge-primary light">قسط دوم</span>
                                        @break
                                    @endswitch
                                </td>
                                <td>
                                    {{\Hekmatinasser\Verta\Verta::instance($order->created_at)->formatJalaliDate()}}
                                </td>
                                <td>
                                    <form action="{{route('admin.orders.destroy', $order->id)}}" method="post"
                                          id="delete-{{$order->id}}">
                                        @method('delete')
                                        @csrf
                                    </form>
                                    @can('manage-users')
                                        <a href="{{route('admin.orders.edit', $order->id)}}" role="button"
                                           class="btn btn-success light sharp" title="ویرایش">
                                            <i class="fa fa-pencil"
                                               onclick="document.getElementById('edit-{{$order->id}}').submit()"></i>
                                        </a>
                                        <button onclick="document.getElementById('delete-{{$order->id}}').submit()"
                                                role="button" class="btn btn-danger light sharp" title="حذف">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>

                </div>
                {{$orders->links()}}
            </div>
        </div>
    </div>
    {{-- Table End --}}
@section('script')
    <script src="{{asset('/backend/js/search.js')}}"></script>
@stop
@endcomponent
