@component('backend.layouts.components.main',['title' => 'مدیریت منو','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">ویرایش منو</li>
        <li class="breadcrumb-item">{{$menu->name}}</li>
    @endslot
    {{-- Section Start --}}
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">جزئیات منو</h4>
            </div>
            <div class="card-body">
                <div class="basic-form">
                    <form action="{{route('admin.menus.update' , $menu->id)}}" method="post" id="update">
                        @csrf
                        @method('patch')
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">نام</label>
                            <div class="col-sm-9">
                                <input name="title" type="text"
                                       class="form-control input-rounded @error('title') is-invalid @enderror"
                                       placeholder="نام" value="{{old('title' , $menu->title)}}">
                                @error('title')
                                <span class="invalid-feedback">
                                        <strong>
                                            {{$message}}
                                        </strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">لینک</label>
                            <div class="col-sm-9">
                                <input name="link" type="text"
                                       class="form-control input-rounded @error('link') is-invalid @enderror"
                                       placeholder="لینک" value="{{old('link' , $menu->link)}}" style="direction: ltr">
                                @error('link')
                                <span class="invalid-feedback">
                                        <strong>
                                            {{$message}}
                                        </strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">ترتیب</label>
                            <div class="col-sm-9">
                                <input name="order" type="text"
                                       class="form-control input-rounded @error('order') is-invalid @enderror"
                                       placeholder="ترتیب" value="{{old('order' , $menu->order)}}">
                                @error('order')
                                <span class="invalid-feedback">
                                        <strong>
                                            {{$message}}
                                        </strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">منوی مادر</label>
                            <div class="col-sm-9">
                                <div class="dropdown bootstrap-select form-control default-select dropup">
                                    <select name="parent_id"
                                            class="form-control default-select input-rounded @error('parent_id') is-invalid @enderror" id="sel1" tabindex="-98">
                                        <option value="">ندارد</option>
                                        @include('menu::backend.partials.menu-dropdown-edit' ,
                                        [
                                            'menus' => $menus ,
                                            'level' => 0,
                                            'menu_id' => $menu
                                            ])
                                    </select>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}
    <div class="col-md-4">
        <div class=" sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.menus.index')}}" role="button" class="btn btn-xs btn-info light" title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای اعمال تغییرات روی دکمه ی به روز رسانی کلیک کنید.
                </p>
                <p class="text-justify">
                    <i class="fa fa-circle text-warning ml-1"></i>
                    در صورت حذف، آیتم مورد نظر برای همیشه حذف شده و راهی برای بازگشت آن وجود ندارد.
                </p>
                <div class="row">
                    <form action="{{route('admin.menus.destroy', $menu->id)}}" method="post" id="delete-{{$menu->id}}">
                        @method('delete')
                        @csrf
                    </form>
                    <div class="col-md-6">
                        <button class="btn btn-danger btn-sm btn-block light" onclick="document.getElementById('delete-{{$menu->id}}').submit()">
                            <i class="fa fa-trash"></i>
                            حذف
                        </button>
                    </div>
                    <div class="col-md-6">
                        <button class="btn btn-success btn-sm btn-block light"
                                onclick="document.getElementById('update').submit()">
                            <i class="fa fa-refresh"></i>
                            به روز رسانی
                        </button>
                    </div>
                </div>

            </div>
        </div>
    </div>
    {{-- Sidebar End --}}

@endcomponent
