@component('backend.layouts.components.main', ['title' => 'مدیریت پلاگین ها' , 'titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item active">پلاگین ها</li>
    @endslot

    {{-- Table Start --}}
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست پلاگین ها</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr class="text-center">
                            <th>نام</th>
                            <th>توضیحات</th>
                            <th>وضعیت</th>
                            <th>عملیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($modules as $module)
                            @php

                                $moduleData = new \Nwidart\Modules\Json($module->getPath() . '\module.json');

                            @endphp
                            @if($moduleData->get('display'))
                                <tr>
                                    <td style="font-weight: bold">
                                        {{$moduleData->get('alias')}}
                                    </td>
                                    <td>
                                        {{$moduleData->get('description')}}
                                    </td>

                                    <td class="text-center">
                                        @if(\Nwidart\Modules\Module::isEnable($module->getName()))

                                            <span class="badge badge-success">فعال</span>

                                        @else
                                            <span class="badge badge-warning">غیرفعال</span>
                                        @endif

                                    </td>

                                    <td class="text-center">
                                        @if(\Nwidart\Modules\Module::isEnable($module->getName()))
                                            <form action="{{route('admin.module.disable',$module)}}" method="post" id="module-{{$module->getName()}}">
                                                @csrf
                                                @method('patch')
                                            </form>
                                            <a type="button" onclick="document.getElementById('module-{{$module->getName()}}').submit()" class="btn light btn-danger btn-xs" id="module-{{$module->getName()}}">غیر فعالسازی</a>
                                        @else
                                            <form action="{{route('admin.module.enable',$module)}}" method="post" id="module-{{$module->getName()}}">
                                                @csrf
                                                @method('patch')
                                            </form>
                                            <a type="button" onclick="document.getElementById('module-{{$module->getName()}}').submit()" class="btn light btn-success btn-xs" id="module-{{$module->getName()}}">فعالسازی</a>

                                        @endif


                                    </td>
                                </tr>
                            @endif

                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    {{-- Table End --}}
@endcomponent
