<?php

namespace Modules\LoginWithCode\Http\Controllers\Auth;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\LoginWithCode\Entities\Code;
use Modules\User\Entities\User;

class TokenController extends Controller
{
    use SEOTools;
    public function showToken(Request $request)
    {
        $this->seo()
            ->settitle('کد تایید موبایل');
        if(! $request->session()->has('auth')) {
            return view('loginwithcode::auth.login');
        }
        $request->session()->reflash();
        return view('loginwithcode::auth.token');
    }

    public function token(Request $request)
    {
        $user = User::findOrFail($request->session()->get('auth.user_id'));
        $status = Code::verifyCode($request->token , $user);
        $request->validate([
            'token' => 'required'
        ]);

        if(! $request->session()->has('auth')) {
            return view('loginwithcode::auth.login');
        }

        if (! $status){
            alert()->error('کد وارد شده صحیح نیست');
            return view('loginwithcode::auth.login');
        }else{
            auth()->loginUsingId($user->id);
            $user->activeCode()->delete();
            if ($request->user()->isAdmin()){
                return redirect(route('admin.index'));
            }
            return redirect('/login');
        }
    }
}
