<?php

namespace Modules\LoginWithCode\Http\Controllers\Auth;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\LoginWithCode\Entities\Code;
use Modules\LoginWithCode\Notifications\ActiveCodeNotification;
use Modules\User\Entities\User;

class RegisterController extends Controller
{
    use SEOTools;
    public function showRegister()
    {
        $this->seo()
            ->settitle('ثبت نام')
            ->setDescription('صفحه ثبت نام کاراوب');
        return view('loginwithcode::auth.register');

    }

    public function register(Request $request)
    {

        $validData = $request->validate([
            'name' => ['required' , 'string' , 'max:255' , 'min:3'],
            'phone' => ['required' , 'regex:/^(?:98|\+98|0098|0)?9[0-9]{9}$/','unique:users,phone']
        ]);
        $user = User::create($validData);
        $code = Code::generateCode($user);
        $request->session()->flash('auth',[
            'user_id' => $user->id,
        ]);
        $user->roles()->attach(5);
        $user->notify(new ActiveCodeNotification($code ,  $user->phone ));
        return redirect(route('token'));
    }
}
