@component('frontend.layouts.content' , ['title' => $post->title , 'subtitle' => 'خلاقیت، زیبایی، کیفیت...'])

    @slot('breadcrumb')
        <li class="breadcrumb-item"><a href="{{route('main')}}">خانه</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{$post->title}}</li>
    @endslot
    @section('head')
        <script type="application/ld+json">
            [{
            "@context": "https://schema.org/",
            "@type": "CreativeWorkSeason",
            "name": "{{$post->title}}",
        "aggregateRating": {
        "@type": "AggregateRating",
        "ratingValue": "5",
        "ratingCount": "{{$post->rating_count}}",
        "bestRating": "5",
        "worstRating": "1"
        }}]

        </script>
    @stop


    <div class="container py-4">

        <div class="row">
            <div class="col-lg-3">
                <aside class="sidebar mb-5 mb-lg-0 pb-2 pb-lg-0">
                    <div class="post-image ml-0"  style="border: solid 1px #f5f5f5 !important;
    padding: 1rem;
    border-radius: 10px">
                        <img src="{{asset($post->image)}}"
                             class="img-fluid img-thumbnail img-thumbnail-no-borders rounded-10" alt="">
                    </div>
                    <div class="mt-3" style="border: solid 1px #f5f5f5 !important;
    padding: 1rem;
    border-radius: 10px">
                        <h3 class="font-weight-bold text-3 mb-3 ">مطالب اخیر</h3>

                        <ul class="simple-post-list">
                            @foreach($posts as $post)
                                <li>
                                    <div class="post-image">
                                        <div class="img-thumbnail img-thumbnail-no-borders d-block">
                                            <a href="{{route('post.show' , $post)}}">
                                                <img src="{{asset($post->image)}}" class="border-radius-0" width="50"
                                                     height="50" alt="Main Reasons To Stop Texting And Driving">
                                            </a>
                                        </div>
                                    </div>
                                    <div class="post-info">
                                        <h4 class="font-weight-normal text-3 line-height-8 mb-0 primary-font"><a
                                                    href="{{route('post.show' , $post)}}" class="text-dark">
                                                {{$post->title}}</a></h4>
                                        <div class="post-meta">
                                            {{\Hekmatinasser\Verta\Verta::instance($post->created_at)->formatJalaliDate()}}
                                        </div>
                                    </div>
                                </li>
                            @endforeach


                        </ul>
                    </div>


                </aside>
            </div>
            <div class="col-lg-9">
                <div class="blog-posts single-post">

                    <article class="post post-large blog-single-post border-0 m-0 p-0">


                        <div class="d-flex gap-2 align-items-center ">
                            <div class="post-date ml-0">
                                <span class="day">{{\Hekmatinasser\Verta\Verta::instance($post->created_at)->format('%d')}}</span>
                                <span class="month">{{\Hekmatinasser\Verta\Verta::instance($post->created_at)->format('%B')}}</span>
                            </div>
                            <div class="post-meta m-0" style="margin-right: 1rem !important;">
                                @if($post->categories)
                                    @foreach($post->categories as $category)
                                        <span><i class="far fa-folder"></i>
                                            {{$category->name}},
                                        </span>
                                    @endforeach

                                @endif


                                <span><i class="far fa-comments"></i> <a href="#">
                                        {{$post->comments->count()}}
                                        دیدگاه
                                    </a></span>
                            </div>
                        </div>
                        <div class="post-content ml-0">



                            {!! $post->body !!}


                        </div>
                    </article>

                </div>
            </div>
        </div>

    </div>

    @section('scripts')
        <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
        <script src="{{asset('/js/responsive-sidebar.js')}}"></script>
        <script src="{{asset('/assets/js/comments.js')}}"></script>
    @stop
@endcomponent
