@component('backend.layouts.components.main',['title' => 'ویرایش پست','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">ویرایش پست</li>
    @endslot
    {{-- Section Start --}}

    <div class="col-md-8">
        <div class="sidebar-admin">
            <div class="card-header">
                <h4 class="card-title">جزئیات پست</h4>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <input name="title" type="text"
                           class="form-control input-rounded @error('title') is-invalid @enderror" placeholder="عنوان"
                           form="store" required value="{{old('title') ? old('title') : $file->title}}">
                    @error('title')
                    <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                    @enderror
                </div>
                <div class="custom-tab-1">
                    <div class="form-group row">
                        <label class="col-sm-3 col-form-label">فایل</label>
                        <div class="col-sm-9">
                            <div class="input-group">
                                <input type="text" id="image_label" class="form-control" name="file"
                                       aria-label="Image" aria-describedby="button-image"
                                       form="store"
                                       value="{{old('file') ? old('file') : $file->file}}"
                                       style="direction: ltr;border-radius: 0 50px 50px 0">
                                <div class="input-group-append">
                                    <button class="btn btn-outline-info" type="button"
                                            id="button-image">
                                        انتخاب
                                    </button>
                                </div>
                            </div>
                            @error('image')
                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                            @enderror
                        </div>
                    </div>
                    <form action="{{route('admin.files.update' ,$file)}}" method="post" id="store">
                        @csrf
                        @method('patch')
                        <div class="tab-content">
                            <div class="tab-pane fade" id="detail">
                                <div class="pt-4">
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">لینک</label>
                                        <div class="col-sm-9">
                                            <input type="text" name="slug"
                                                   class="form-control input-rounded @error('slug') is-invalid @enderror"
                                                   placeholder="لینک" value="{{old('slug')}}">
                                            @error('slug')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>


                                </div>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}

    <div class="col-md-4">
        @if($errors->any())
            <div class="alert alert-danger left-icon-big alert-dismissible fade show">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span><i
                            class="mdi mdi-close"></i></span>
                </button>
                <div class="media">
                    <div class="alert-left-icon-big">
                        <span><i class="mdi mdi-alert"></i></span>
                    </div>
                    <div class="media-body">
                        <h5 class="mt-1 mb-2">خطا!</h5>
                        @foreach($errors->all() as $error)
                            <p class="mb-0">{{$error}}</p>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif
        <div class="sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.files.index')}}" role="button" class="btn btn-xs btn-info light" title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای اعمال ویرایش ها، روی دکمه "به روز رسانی" کلیک کنید.
                </p>
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    در صورتی که میخواهید پست منتشر شده اما در سایت نمایش داده نشود وضعیت را در حالت خاموش قرار دهید.
                </p>

                <div class="row">
                    <div class="col-md-6">
                        <div class="custom-control custom-switch toggle-switch text-right mr-4 mb-2">
                            <input type="checkbox" class="custom-control-input" id="customSwitch12" form="store"
                                   name="status" @if($file->status) checked @endif>
                            <label class="custom-control-label fs-14 text-black pr-2" for="customSwitch12">وضعیت</label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <button class="btn btn-success btn-sm btn-block light"
                                onclick="document.getElementById('store').submit()">
                            <i class="fa fa-refresh"></i>
                            به روز رسانی
                        </button>
                    </div>

                </div>

            </div>
        </div>
    </div>

    {{-- Sidebar End --}}

    {{-- Scripts --}}
@section('script')
    <script src="{{ asset('/vendor/file-manager/js/file-manager.js') }}"></script>
    <script src="{{asset('/backend/js/file-editor.js')}}"></script>
    <script src="{{asset('/backend/js/file-button.js')}}"></script>
    <script>
        let meta_title = document.getElementById('meta-title');
        let meta_desc = document.getElementById('meta-desc');
        let g_link = document.getElementById('g-link');
        let g_desc = document.getElementById('g-desc');
        meta_title.addEventListener('change', function () {
            g_link.innerText = meta_title.value;
        })
        meta_desc.addEventListener('change', function () {
            g_desc.innerText = meta_desc.value;
        })
    </script>

@stop

@section('head')
    <script src="https://cdn.tiny.cloud/1/piqrm2bib3zv8de8a26kklh89gvqb0bhm9a14mjb88jwos8r/tinymce/5/tinymce.min.js" referrerpolicy="origin"></script>

    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.0/css/all.css">
    <link rel="stylesheet" href="{{ asset('/vendor/file-manager/css/file-manager.css') }}">
@stop
@endcomponent
