@component('backend.layouts.components.main',['title' => 'مدیریت فایل ها', 'titleBar'=>true , 'button' => 'افزودن فایل' , 'route' => 'admin.files.create'])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">فایل ها</li>
    @endslot

    {{-- Table Start --}}
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست فایل ها</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>نام</th>
                            <th>فایل</th>
                            <th>تاریخ ایجاد</th>
                            @can('manage-posts')
                                <th>عملیات</th>
                            @endcan
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($files as $file)

                            <tr>
                                <td>{{$file->title}}</td>
                                <td>
                                    <a href="{{$file->file}}" download>دانلود فایل</a>
                                </td>
                                <td>{{\Hekmatinasser\Verta\Verta::instance($file->created_at)->formatJalaliDate()}}</td>

                                <td>
                                    <form action="{{route('admin.files.destroy', $file->id)}}" method="post"
                                          id="delete-{{$file->id}}">
                                        @method('delete')
                                        @csrf
                                    </form>
                                    @can('manage-users')
                                        <a href="{{route('admin.files.edit', $file->id)}}" role="button"
                                           class="btn btn-success light sharp" title="ویرایش">
                                            <i class="fa fa-pencil"
                                               onclick="document.getElementById('edit-{{$file->id}}').submit()"></i>
                                        </a>
                                        <button onclick="document.getElementById('delete-{{$file->id}}').submit()"
                                                role="button" class="btn btn-danger light sharp" title="حذف">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    @endcan
                                </td>

                            </tr>

                        @endforeach
                        </tbody>
                    </table>

                </div>
                {{$files->links()}}
            </div>
        </div>
    </div>
    {{-- Table End --}}
@section('script')
    <script src="{{asset('/backend/js/search.js')}}"></script>
@stop
@endcomponent
