@component('backend.layouts.components.main',['title' => 'ویرایش کد تخفیف','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">ویرایش کد تخفیف</li>
    @endslot
    {{-- Section Start --}}
    <div class="col-md-8">
        <div class="sidebar-admin">
            <div class="card-header">
                <h4 class="card-title">جزئیات کد تخفیف</h4>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <input name="code" type="text"
                           class="form-control input-rounded @error('code') is-invalid @enderror" placeholder="عنوان"
                           form="store" required value="{{old('code') ? old('old') : $discount->code}}">
                    @error('code')
                    <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                    @enderror
                </div>

                <form action="{{route('admin.discounts.update' , $discount)}}" method="post" id="store">
                    @csrf
                    @method('patch')
                    <div class="pt-4">

                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">درصد تخفیف</label>
                            <div class="col-sm-9">
                                <input type="text" name="percent"
                                       class="form-control input-rounded @error('percent') is-invalid @enderror"
                                       placeholder="درصد تخفیف" value="{{old('percent') ? old('percent') : $discount->percent}}">
                                @error('percent')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">برای دوره آموزشی خاص</label>
                            <div class="col-sm-9">
                                <select class="form-control default-select" id="sel1" name="course_id">
                                    <option value="">انتخاب کنید</option>
                                    @foreach($courses as $course)
                                        <option value="{{$course->id}}"
                                        @if($course->id == $discount->course_id) selected @endif>
                                            {{$course->title}}
                                        </option>
                                    @endforeach
                                </select>
                                @error('course_id')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">برای کاربر خاص</label>
                            <div class="col-sm-9">
                                <select class="form-control default-select" name="user_id">
                                    <option value="">انتخاب کنید</option>
                                    @foreach($users as $user)
                                        <option value="{{$user->id}}"
                                                @if($user->id == $discount->user_id) selected @endif>
                                            {{$user->phone}}
                                        </option>
                                    @endforeach
                                </select>
                                @error('course_id')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">انقضا</label>
                            <div class="col-sm-9">
                                <span class="badge badge-info badge-pill">تاریخ انقضای فعلی {{\Hekmatinasser\Verta\Verta::instance($discount->expires_at)->formatJalaliDate()}}</span>
                                <input type="text" class="example1 form-control input-rounded mt-3" name="expires_at"/>
                                <script type="text/javascript">
                                    $('.example1').persianDatepicker({
                                        format: 'L',
                                        initialValue: 'georgian'
                                    });
                                </script>
                                @error('expires_at')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}
    <div class="col-md-4">
        @if($errors->any())
            <div class="alert alert-danger left-icon-big alert-dismissible fade show">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span><i
                            class="mdi mdi-close"></i></span>
                </button>
                <div class="media">
                    <div class="alert-left-icon-big">
                        <span><i class="mdi mdi-alert"></i></span>
                    </div>
                    <div class="media-body">
                        <h5 class="mt-1 mb-2">خطا!</h5>
                        @foreach($errors->all() as $error)
                            <p class="mb-0">{{$error}}</p>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif


        <div class=" sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.discounts.index')}}" role="button" class="btn btn-xs btn-info light" title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای ایجاد کد جدید، روی دکمه "ساختن" کلیک کنید.
                </p>
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    در صورتی که میخواهید پست منتشر شده اما در سایت نمایش داده نشود وضعیت را در حالت خاموش قرار دهید.
                </p>

                <div class="row">
                    <div class="col-md-6">
                        <div class="custom-control custom-switch toggle-switch text-right mr-4 mb-2">
                            <input type="checkbox" class="custom-control-input" id="customSwitch12" form="store"
                                   name="status" @if($discount->status) checked @endif>
                            <label class="custom-control-label fs-14 text-black pr-2" for="customSwitch12">وضعیت</label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <button class="btn btn-success btn-sm btn-block light"
                                onclick="document.getElementById('store').submit()">
                            <i class="fa fa-save"></i>
                            به روز رسانی
                        </button>
                    </div>

                </div>

            </div>
        </div>
    </div>
    {{-- Sidebar End --}}



    {{-- Scripts --}}
@section('script')
    <script src="/backend/vendor/nestable2/js/jquery.nestable.min.js"></script>

@stop

@section('head')
    <link rel="stylesheet" href="https://unpkg.com/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.js" integrity="sha256-H+K7U5CnXl1h5ywQfKtSj8PCmoN9aaq30gDh27Xc0jk=" crossorigin="anonymous"></script>
    <script src="https://unpkg.com/persian-date@1.1.0/dist/persian-date.min.js"></script>
    <script src="https://unpkg.com/persian-datepicker@1.2.0/dist/js/persian-datepicker.min.js"></script>
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.0/css/all.css">
    <link rel="stylesheet" href="{{ asset('/vendor/file-manager/css/file-manager.css') }}">
    <link rel="stylesheet" href="{{ asset('/backend/vendor/nestable2/css/jquery.nestable.min.css') }}">
@stop
@endcomponent
