@component('backend.layouts.components.main',['title' => 'مدیریت کد های تخفیف', 'titleBar'=>true , 'button' => 'افزودن کد تخفیف جدید' , 'route' => 'admin.discounts.create'])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">کدهای تخفیف </li>
    @endslot

    {{-- Table Start --}}
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست کد ها</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>کد</th>
                            <th>درصد تخفیف</th>
                            <th>برای کاربر خاص</th>
                            <th>دوره آموزشی مربوطه</th>
                            <th>وضعیت</th>
                            <th>تاریخ انقضا</th>
                        @can('manage-discounts')
                                <th>عملیات</th>
                            @endcan
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($discounts as $discount)

                            <tr>
                                <td>{{$discount->code}}</td>
                                <td>
                                    <span class="badge badge-success badge-pill">%{{$discount->percent}}</span>
                                </td>
                                <td>
                                    @if($discount->user_id)
                                        <a href="{{route('admin.users.edit' , $discount->user->id)}}">
                                            {{$discount->user->phone}}
                                        </a>
                                    @else
                                        برای همه
                                    @endif
                                </td>
                                <td>
                                    @if($discount->course_id)
                                        <a href="{{route('admin.courses.edit' , $discount->course->id)}}">
                                            {{$discount->course->title}}
                                        </a>
                                    @else
                                        برای همه دوره ها
                                    @endif
                                </td>
                                <td>
                                    @switch($discount->status)
                                        @case(1)
                                        <span class="badge-pill badge badge-success">فعال</span>
                                        @break
                                        @case(0)
                                        <span class="badge-pill badge badge-danger">غیر فعال</span>
                                        @break
                                    @endswitch
                                </td>
                                <td>
                                    @if(\Illuminate\Support\Carbon::parse($discount->expires_at)->isPast())
                                        <span class="badge-danger badge-pill badge">
                                            {{\Hekmatinasser\Verta\Verta::instance($discount->expires_at)->formatJalaliDate()}}
                                            منقضی شده
                                        </span>
                                        @else
                                        <span class="badge-success badge-pill badge">
                                            {{\Hekmatinasser\Verta\Verta::instance($discount->expires_at)->formatJalaliDate()}}
                                        </span>
                                    @endif
                                </td>
                                <td>
                                    <form action="{{route('admin.discounts.destroy', $discount->id)}}" method="post"
                                          id="delete-{{$discount->id}}">
                                        @method('delete')
                                        @csrf
                                    </form>
                                    @can('manage-users')
                                        <a href="{{route('admin.discounts.edit', $discount->id)}}" role="button"
                                           class="btn btn-success light sharp" title="ویرایش">
                                            <i class="fa fa-pencil"
                                               onclick="document.getElementById('edit-{{$discount->id}}').submit()"></i>
                                        </a>
                                        <button onclick="document.getElementById('delete-{{$discount->id}}').submit()"
                                                role="button" class="btn btn-danger light sharp" title="حذف">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    @endcan
                                </td>

                            </tr>

                        @endforeach
                        </tbody>
                    </table>

                </div>
                {{$discounts->links()}}
            </div>
        </div>
    </div>
    {{-- Table End --}}
@section('script')
    <script src="{{asset('/backend/js/search.js')}}"></script>
@stop
@endcomponent
