<div class="container p-4">
    <div class="section-head">
        <div class="section-title">
            <div class="title-icon">
                <svg width="50" height="50" viewBox="0 0 50 50" fill="none"
                     xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M28.6458 9.375C30.4415 9.375 32.1637 10.0884 33.4335 11.3581C34.7033 12.6279 35.4166 14.3501 35.4166 16.1458V16.5062L43.4666 11.6771C43.7037 11.5348 43.9743 11.4579 44.2508 11.4544C44.5273 11.4508 44.7998 11.5208 45.0405 11.657C45.2811 11.7932 45.4813 11.9908 45.6206 12.2297C45.7599 12.4686 45.8333 12.7401 45.8333 13.0167V36.9792C45.8333 37.2557 45.7599 37.5273 45.6206 37.7661C45.4813 38.005 45.2811 38.2027 45.0405 38.3389C44.7998 38.4751 44.5273 38.545 44.2508 38.5414C43.9743 38.5379 43.7037 38.4611 43.4666 38.3187L35.4166 33.4896V33.8542C35.4166 35.6499 34.7033 37.3721 33.4335 38.6419C32.1637 39.9116 30.4415 40.625 28.6458 40.625H10.9375C9.14172 40.625 7.41953 39.9116 6.14976 38.6419C4.87998 37.3721 4.16663 35.6499 4.16663 33.8542V16.1458C4.16663 14.3501 4.87998 12.6279 6.14976 11.3581C7.41953 10.0884 9.14172 9.375 10.9375 9.375H28.6458ZM28.6458 12.5H10.9375C9.97052 12.5 9.04319 12.8841 8.35947 13.5678C7.67574 14.2516 7.29163 15.1789 7.29163 16.1458V33.8542C7.29163 35.8667 8.92496 37.5 10.9375 37.5H28.6458C29.6127 37.5 30.5401 37.1159 31.2238 36.4322C31.9075 35.7484 32.2916 34.8211 32.2916 33.8542V16.1458C32.2916 15.1789 31.9075 14.2516 31.2238 13.5678C30.5401 12.8841 29.6127 12.5 28.6458 12.5V12.5ZM42.7083 15.7771L35.4166 20.1542V29.8437L42.7083 34.2187V15.7771Z"
                        fill="#288ED9"/>
                </svg>

            </div>
            <div class="title-box">
                <h3 class="title">
                    قسمت های دوره
                    <a href="{{asset('series/' . $course->slug)}}">
                        {{$course->title}}
                    </a>
                </h3>
                <p>قسمت های آموزشی</p>
                <div class="blue-line"></div>
            </div>
        </div>
    </div>
</div>
<div class="kw-wrapper kw-wrapper-br p-4 mt-3">
    @foreach($course->episodes as $index => $episode)
        <div class="episode-item">
            <div class="right-item">
                @auth
                    @if(!$course->users->where('id' , auth()->user()->id)->count())
                        @if($episode->is_free)
                            <span class="number-free">{{$index+1}}</span>
                        @else
                            <span class="number-not-free">
                                            <svg width="39" height="39" viewBox="0 0 39 39" fill="none"
                                                 xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M26 13C27.2929 13 28.5329 13.5136 29.4471 14.4279C30.3614 15.3421 30.875 16.5821 30.875 17.875V30.875C30.875 32.1679 30.3614 33.4079 29.4471 34.3221C28.5329 35.2364 27.2929 35.75 26 35.75H11.375C10.0821 35.75 8.84209 35.2364 7.92785 34.3221C7.01361 33.4079 6.5 32.1679 6.5 30.875V17.875C6.5 16.5821 7.01361 15.3421 7.92785 14.4279C8.84209 13.5136 10.0821 13 11.375 13V10.5625C11.375 8.6231 12.1454 6.76314 13.5168 5.39178C14.8881 4.02042 16.7481 3.25 18.6875 3.25C20.6269 3.25 22.4869 4.02042 23.8582 5.39178C25.2296 6.76314 26 8.6231 26 10.5625V13ZM11.375 14.625C10.513 14.625 9.6864 14.9674 9.0769 15.5769C8.46741 16.1864 8.125 17.013 8.125 17.875V30.875C8.125 31.737 8.46741 32.5636 9.0769 33.1731C9.6864 33.7826 10.513 34.125 11.375 34.125H26C26.862 34.125 27.6886 33.7826 28.2981 33.1731C28.9076 32.5636 29.25 31.737 29.25 30.875V17.875C29.25 17.013 28.9076 16.1864 28.2981 15.5769C27.6886 14.9674 26.862 14.625 26 14.625H11.375ZM24.375 13V10.5625C24.375 9.05408 23.7758 7.60744 22.7092 6.54083C21.6426 5.47422 20.1959 4.875 18.6875 4.875C17.1791 4.875 15.7324 5.47422 14.6658 6.54083C13.5992 7.60744 13 9.05408 13 10.5625V13H24.375ZM18.6875 22.75C18.041 22.75 17.421 23.0068 16.9639 23.4639C16.5068 23.921 16.25 24.541 16.25 25.1875C16.25 25.834 16.5068 26.454 16.9639 26.9111C17.421 27.3682 18.041 27.625 18.6875 27.625C19.334 27.625 19.954 27.3682 20.4111 26.9111C20.8682 26.454 21.125 25.834 21.125 25.1875C21.125 24.541 20.8682 23.921 20.4111 23.4639C19.954 23.0068 19.334 22.75 18.6875 22.75ZM18.6875 21.125C19.7649 21.125 20.7983 21.553 21.5601 22.3149C22.322 23.0767 22.75 24.1101 22.75 25.1875C22.75 26.2649 22.322 27.2983 21.5601 28.0601C20.7983 28.822 19.7649 29.25 18.6875 29.25C17.6101 29.25 16.5767 28.822 15.8149 28.0601C15.053 27.2983 14.625 26.2649 14.625 25.1875C14.625 24.1101 15.053 23.0767 15.8149 22.3149C16.5767 21.553 17.6101 21.125 18.6875 21.125Z"
                                                fill="white" fill-opacity="0.886"></path>
                                            </svg>
                                         </span>
                        @endif
                    @else
                        <span class="number-free">{{$index+1}}</span>
                    @endif
                @endauth
                @guest
                    @if($episode->is_free)
                        <span class="number-free">{{$index+1}}</span>
                    @else
                        <span class="number-not-free">
                                            <svg width="39" height="39" viewBox="0 0 39 39" fill="none"
                                                 xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M26 13C27.2929 13 28.5329 13.5136 29.4471 14.4279C30.3614 15.3421 30.875 16.5821 30.875 17.875V30.875C30.875 32.1679 30.3614 33.4079 29.4471 34.3221C28.5329 35.2364 27.2929 35.75 26 35.75H11.375C10.0821 35.75 8.84209 35.2364 7.92785 34.3221C7.01361 33.4079 6.5 32.1679 6.5 30.875V17.875C6.5 16.5821 7.01361 15.3421 7.92785 14.4279C8.84209 13.5136 10.0821 13 11.375 13V10.5625C11.375 8.6231 12.1454 6.76314 13.5168 5.39178C14.8881 4.02042 16.7481 3.25 18.6875 3.25C20.6269 3.25 22.4869 4.02042 23.8582 5.39178C25.2296 6.76314 26 8.6231 26 10.5625V13ZM11.375 14.625C10.513 14.625 9.6864 14.9674 9.0769 15.5769C8.46741 16.1864 8.125 17.013 8.125 17.875V30.875C8.125 31.737 8.46741 32.5636 9.0769 33.1731C9.6864 33.7826 10.513 34.125 11.375 34.125H26C26.862 34.125 27.6886 33.7826 28.2981 33.1731C28.9076 32.5636 29.25 31.737 29.25 30.875V17.875C29.25 17.013 28.9076 16.1864 28.2981 15.5769C27.6886 14.9674 26.862 14.625 26 14.625H11.375ZM24.375 13V10.5625C24.375 9.05408 23.7758 7.60744 22.7092 6.54083C21.6426 5.47422 20.1959 4.875 18.6875 4.875C17.1791 4.875 15.7324 5.47422 14.6658 6.54083C13.5992 7.60744 13 9.05408 13 10.5625V13H24.375ZM18.6875 22.75C18.041 22.75 17.421 23.0068 16.9639 23.4639C16.5068 23.921 16.25 24.541 16.25 25.1875C16.25 25.834 16.5068 26.454 16.9639 26.9111C17.421 27.3682 18.041 27.625 18.6875 27.625C19.334 27.625 19.954 27.3682 20.4111 26.9111C20.8682 26.454 21.125 25.834 21.125 25.1875C21.125 24.541 20.8682 23.921 20.4111 23.4639C19.954 23.0068 19.334 22.75 18.6875 22.75ZM18.6875 21.125C19.7649 21.125 20.7983 21.553 21.5601 22.3149C22.322 23.0767 22.75 24.1101 22.75 25.1875C22.75 26.2649 22.322 27.2983 21.5601 28.0601C20.7983 28.822 19.7649 29.25 18.6875 29.25C17.6101 29.25 16.5767 28.822 15.8149 28.0601C15.053 27.2983 14.625 26.2649 14.625 25.1875C14.625 24.1101 15.053 23.0767 15.8149 22.3149C16.5767 21.553 17.6101 21.125 18.6875 21.125Z"
                                                fill="white" fill-opacity="0.886"></path>
                                            </svg>
                                         </span>
                    @endif
                @endguest

                <div class="title">
                    <h4>{{$episode->title}}</h4>
                    <p class="subtitle">
                        {{strip_tags(\Illuminate\Support\Str::limit($episode->body,100))}}
                    </p>
                </div>
            </div>

            <div class="show-episode">
                @auth
                    @if(!$course->users->where('id' , auth()->user()->id)->count())
                        @if($episode->is_free)
                            <a href="{{route('episode.show' ,[$course , $episode])}}"
                               class="kw-btn-blue">مشاهده</a>
                        @else
                            @if($course->price != 0)
                                <span
                                    class="kw-btn-orange">نقدی</span>
                            @else
                                <span
                                    class="kw-btn-orange">ثبت نام در دوره</span>
                            @endif
                        @endif
                    @else
                        <a href="{{route('episode.show' ,[$course , $episode])}}"
                           class="kw-btn-blue">مشاهده</a>
                    @endif
                @endauth
                @guest
                    @if($episode->is_free)
                        <a href="{{route('episode.show' ,[$course , $episode])}}"
                           class="kw-btn-blue">مشاهده</a>
                    @else
                        @if($course->price != 0)
                            <span
                                class="kw-btn-orange">نقدی</span>
                        @else
                            <span
                                class="kw-btn-orange">ثبت نام در دوره</span>
                        @endif
                    @endif
                @endguest
            </div>
        </div>
        <hr>
    @endforeach
</div>
