@component('backend.layouts.components.main',['title' => 'مدیریت دوره ها', 'titleBar'=>true , 'button' => 'افزودن دوره' , 'route' => 'admin.courses.create'])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">دوره ها</li>
    @endslot

    {{-- Table Start --}}
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست دوره ها</h4>
                <a href="{{route('admin.episodes.create')}}" class="btn light btn-success btn-sm">افزودن قسمت جدید</a>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>نام</th>
                            <th>دسته بندی</th>
                            <th>تاریخ ایجاد</th>
                            @can('manage-courses')
                                <th>عملیات</th>
                            @endcan
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($courses as $course)
                            <tr>
                                <td>
                                    {{$course->title}}
                                    <span class="badge light badge-success">{{$course->episodes->count() . ' قسمت '}}</span>
                                    <span class="badge light badge-info">{{$course->users->count()}} دانشجو </span>
                                    <a href="{{route('admin.episodes.index' , ['search' => $course->id])}}" class="badge light badge-primary">مشاهده قسمت ها</a>
                                </td>
                                <td>
                                    @foreach($course->categories as $category)
                                        @if(count($course->categories)>1)
                                            {{$category->name . ','}}
                                        @else
                                            {{$category->name}}
                                        @endif
                                    @endforeach
                                </td>
                                <td>{{\Hekmatinasser\Verta\Verta::instance($course->created_at)->formatJalaliDate()}}</td>

                                <td>
                                    <form action="{{route('admin.courses.destroy', $course->id)}}" method="post"
                                          id="delete-{{$course->id}}">
                                        @method('delete')
                                        @csrf
                                    </form>
                                    @can('manage-users')
                                        <a href="{{route('admin.courses.edit', $course->id)}}" role="button"
                                           class="btn btn-success light sharp" title="ویرایش">
                                            <i class="fa fa-pencil"
                                               onclick="document.getElementById('edit-{{$course->id}}').submit()"></i>
                                        </a>
                                        <button onclick="document.getElementById('delete-{{$course->id}}').submit()"
                                                role="button" class="btn btn-danger light sharp" title="حذف">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    @endcan
                                    <a href="{{asset('series/'.$course->slug)}}" role="button"
                                       class="btn btn-primary light sharp" title="نمایش" target="_blank">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                </td>

                            </tr>

                        @endforeach
                        </tbody>
                    </table>

                </div>
                {{$courses->links()}}
            </div>
        </div>
    </div>
    {{-- Table End --}}
@section('script')
    <script src="{{asset('/backend/js/search.js')}}"></script>
@stop
@endcomponent
