<?php

namespace Modules\Course\Http\Controllers\Admin;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Str;
use Modules\Course\Entities\Course;
use Modules\Course\Entities\Episode;

class EpisodeController extends Controller
{

    use SEOTools;
    public function index()
    {
        $this->seo()->setTitle('همه قسمت های آموزشی');

        $episodes = Episode::query();
        if ($key = \request('search')) {
            $episodes = $episodes
                ->where('title' , 'like' , "%$key%")
                ->orWhere('course_id' , $key);
        }
        $episodes = $episodes->simplePaginate(15);
        return view('course::backend.episodes.all' , compact('episodes'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $this->seo()->setTitle('ایجاد قسمت جدید');

        $courses = Course::all();
        return view('course::backend.episodes.create' , compact('courses'));
    }


    public function store(Request $request)
    {
        $validData = $request->validate([
            'title' => 'required',
            'slug' => 'nullable',
            'body' => 'required',
            'course_id' => 'required',
            'meta_title' => 'nullable',
            'meta_keywords' => 'nullable',
            'meta_desc' => 'nullable',
            'status' => 'nullable',
            'video' => 'required',
            'is_free' => 'required',
            'rating_count' => 'rating_count'
        ]);
        $episode = new Episode();
        $episode->title = $validData['title'];
        $episode->body = $validData['body'];
        $episode->course_id = $validData['course_id'];
        $episode->meta_title = $validData['meta_title'];
        $episode->meta_keywords = $validData['meta_keywords'];
        $episode->meta_desc = $validData['meta_desc'];
        $episode->video = $validData['video'];
        $episode->is_free = $validData['is_free'];
        $episode->rating_count = $validData['rating_count'];
        if ($request->input('slug') != "") {
            $episode->slug = Str::slug($request->input('slug'), '-');
        } else {
            $episode->slug = Str::slug($request->input('title'), '-');
        }
        if (array_key_exists('status', $validData)) {
            $validData['status'] = 1;
            $episode->status = $validData['status'];
        } else {
            $episode->status = 0;
        }
        $episode->save();
        alert()->success('قسمت با موفقیت ایجاد شد', 'موفق');
        return redirect(route('admin.episodes.index'));
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('course::show');
    }

    public function edit(Episode $episode)
    {
        $this->seo()->setTitle("ویرایش قسمت $episode->title");

        $courses = Course::all();
        return view('course::backend.episodes.edit' , compact(['courses' , 'episode']));
    }

    public function update(Request $request, Episode $episode)
    {
        $validData = $request->validate([
            'title' => 'required',
            'slug' => 'nullable',
            'body' => 'required',
            'course_id' => 'required',
            'meta_title' => 'nullable',
            'meta_keywords' => 'nullable',
            'meta_desc' => 'nullable',
            'status' => 'nullable',
            'video' => 'required',
            'is_free' => 'required',
            'rating_count' => 'nullable',
        ]);
        if (array_key_exists('status', $validData)) {
            $validData['status'] = 1;
            $episode->update([
                'title' => $validData['title'],
                'body' => $validData['body'],
                'slug' => Str::slug($validData['slug'],'-'),
                'meta_title' => $validData['meta_title'],
                'meta_keywords' => $validData['meta_keywords'],
                'meta_desc' => $validData['meta_desc'],
                'status' => $validData['status'],
                'course_id' => $validData['course_id'],
                'is_free' => $validData['is_free'],
                'rating_count' => $validData['rating_count'],
                'video' => $request->video,

            ]);
        }else{
            //if status does not exists
            $episode->update([
                'title' => $validData['title'],
                'body' => $validData['body'],
                'slug' => Str::slug($validData['slug'],'-'),
                'meta_title' => $validData['meta_title'],
                'meta_keywords' => $validData['meta_keywords'],
                'meta_desc' => $validData['meta_desc'],
                'status' => 0,
                'course_id' => $validData['course_id'],
                'is_free' => $validData['is_free'],
                'rating_count' => $validData['rating_count'],
                'video' => $request->video
            ]);
        }
        alert()->success('قسمت آموزشی با موفقیت ویرایش شد', 'موفق');
        return back();
    }

    public function destroy(Episode $episode)
    {
        $episode->delete();
        alert()->success(" قسمت  $episode->title با موفقیت حذف شد." , 'موفق');
        return redirect(route('admin.courses.index'));
    }
}
