<?php

namespace Modules\Comment\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Modules\Post\Entities\Post;
use Modules\User\Entities\User;

class Comment extends Model
{
    use HasFactory;
    use Notifiable;
    protected $fillable = ['body' , 'full_name' , 'status' , 'parent_id'];

    public function commentable()
    {
        return $this->morphTo();
    }

    public function children()
    {
        return $this->hasMany(Comment::class , 'parent_id' , 'id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
