@component('backend.layouts.components.main',['title' => 'مدیریت دسته بندی','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">ویرایش دسته بندی</li>
        <li class="breadcrumb-item">{{$categories_portfolio->name}}</li>
    @endslot
    {{-- Section Start --}}
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">جزئیات دسته بندی</h4>
            </div>
            <div class="card-body">
                <div class="basic-form">
                    <form action="{{route('admin.categories-portfolios.update' , $categories_portfolio->id)}}" method="post" id="update">
                        @csrf
                        @method('patch')
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">نام</label>
                            <div class="col-sm-9">
                                <input name="name" type="text"
                                       class="form-control input-rounded @error('name') is-invalid @enderror"
                                       placeholder="نام"
                                       value="{{$categories_portfolio->name}}">
                                @error('name')
                                <span class="invalid-feedback">
                                        <strong>
                                            {{$message}}
                                        </strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">دسته بندی مادر</label>
                            <div class="col-sm-9">
                                <div class="dropdown bootstrap-select form-control default-select dropup">
                                    <select name="parent_id"
                                            class="form-control default-select input-rounded @error('parent_id') is-invalid @enderror" id="sel1" tabindex="-98">
                                        <option value="">ندارد</option>
                                                @include('category::backend.portfolios.partials.category-dropdown-edit' ,
                                                [
                                                    'categories' => $categories ,
                                                    'level' => 0,
                                                    'categories_post' => $categories_portfolio
                                                    ])
                                    </select>
                                </div>

                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}
    <div class="col-md-4">
        <div class=" sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.categories-portfolios.index')}}" role="button" class="btn btn-xs btn-info light" title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای اعمال تغییرات روی دکمه ی به روز رسانی کلیک کنید.
                </p>
                <p class="text-justify">
                    <i class="fa fa-circle text-warning ml-1"></i>
                    در صورت حذف، آیتم مورد نظر برای همیشه حذف شده و راهی برای بازگشت آن وجود ندارد.
                </p>
                <div class="row">
                    <form action="{{route('admin.categories-portfolios.destroy', $categories_portfolio->id)}}" method="post" id="delete-{{$categories_portfolio->id}}">
                        @method('delete')
                        @csrf
                    </form>
                    <div class="col-md-6">
                        <button class="btn btn-danger btn-sm btn-block light" onclick="document.getElementById('delete-{{$categories_portfolio->id}}').submit()">
                            <i class="fa fa-trash"></i>
                            حذف
                        </button>
                    </div>
                    <div class="col-md-6">
                        <button class="btn btn-success btn-sm btn-block light"
                                onclick="document.getElementById('update').submit()">
                            <i class="fa fa-refresh"></i>
                            به روز رسانی
                        </button>
                    </div>
                </div>

            </div>
        </div>
    </div>
    {{-- Sidebar End --}}

@endcomponent
