<?php

namespace Modules\Category\Http\Controllers\Admin;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Category\Entities\Category;
use Modules\Post\Entities\Post;

class PostCategoryController extends Controller
{
    use SEOTools;
    public function index()
    {
        $this->seo()->setTitle('همه دسته بندی ها');
        $categories = Category::with('children')
            ->whereNull('parent_id')
            ->where('category_type'  , Post::class)
            ->simplePaginate(15);
        return view('category::backend.posts.all', compact('categories'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $this->seo()->setTitle('ایجاد دسته بندی جدید');

        $categories = Category::with('children')->whereNull('parent_id')->get();
        return view('category::backend.posts.create' , compact('categories'));
    }

    public function store(Request $request)
    {
        $validData = $request->validate([
            'name' => 'required',
            'parent_id' => 'nullable'
        ]);

        $category = new Category();
        $category->name = $validData['name'];
        $category->parent_id = $validData['parent_id'];
        $category->category_type = Post::class;
        $category->save();
        alert()->success('دسته بندی با موفقیت ساخته شد.' , 'موفق');
        return back();
    }

    public function show($id)
    {
        return view('category::show');
    }

    public function edit(Category $categories_post)
    {
        $this->seo()->setTitle("ویرایش دسته بندی $categories_post->name");

        $categories = Category::with('children')
            ->whereNull('parent_id')
            ->get();

        return view('category::backend.posts.edit' , compact(['categories_post','categories']));
    }


    public function update(Request $request, Category $categories_post)
    {


        $validData = $request->validate([
           'name' => 'required',
           'parent_id' => 'nullable'
        ]);
        $selected_cat = Category::find($validData['parent_id']);

        if ($validData['parent_id'] == $categories_post->id){
            alert()->error('دسته بندی نمیتواند زیر دسته ی خودش باشد' , 'خطا');
            return back();
        }
        foreach ($categories_post->children as $val){
            if ($validData['parent_id'] == $val->id){
                alert()->error('دسته بندی نمیتواند زیر دسته ی خودش باشد' , 'خطا');
                return back();
            }
        }
        $categories_post->update($validData);
        alert()->success('دسته بندی با موفقیت ویرایش شد.' , 'موفق');
        return back();
    }

    public function destroy(Category $categories_post)
    {
        if ($categories_post->children()->count()){
            alert()->error('این دسته بندی دارای زیر دسته است و نمیتواند حذف شود' , 'خطا');
            return back();
        }
        $categories_post->delete();
        alert()->success('دسته بندی با موفقیت حذف شد.' , 'موفق');
        return redirect(route('admin.categories-posts.index'));
    }
}
