<?php


namespace Modules\Cart\Http\Helpers;


use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Str;
use Modules\Discount\Entities\Discount;

class CartService
{
    protected $cart;

    protected $name = 'default';

    public function __construct()
    {
//        $this->cart = session()->get($this->name) ?? collect([]);
        $cart = collect(json_decode(request()->cookie($this->name) , true));
        $this->cart = $cart->count() ? $cart : collect([
            'items' => [],
            'discount' => null
        ]);
    }


    /**
     * @param array $value
     * @param null $obj
     * @return \App\Helpers\Cart\CartService
     */
    public function put(array $value , $obj = null)
    {
        if(! is_null($obj) && $obj instanceof Model) {
            $value = array_merge($value , [
                'id' => Str::random(10),
                'subject_id' => $obj->id,
                'subject_type' => get_class($obj),
                'discount_percent' => 0
            ]);
        } elseif(! isset($value['id'])) {
            $value = array_merge($value , [
                'id' => Str::random(10)
            ]);
        }

        $this->cart['items'] = collect($this->cart['items'])->put($value['id'] , $value);
//        session()->put($this->name , $this->cart);
        $this->storeCookie();


        return $this;
    }

    public function update($key , $options)
    {
        $item = collect($this->get($key, false));

        if(is_numeric($options)) {
            $item = $item->merge([
                'quantity' => $item['quantity'] + $options
            ]);
        }

        if(is_array($options)) {
            $item = $item->merge($options);
        }

        $this->put($item->toArray());

        return $this;
    }

    public function count($key)
    {
        if(! $this->has($key) ) return 0;

        return $this->get($key)['quantity'];
    }

    public function has($key)
    {
        if($key instanceof Model) {
            return ! is_null(
                collect($this->cart['items'])->where('subject_id' , $key->id)->where('subject_type' , get_class($key))->first()
            );
        }

        return ! is_null(
            collect($this->cart['items'])->firstWhere('id' , $key)
        );
    }

    public function get($key , $withRelationShip = true)
    {
        $item = $key instanceof Model
            ? collect($this->cart['items'])->where('subject_id' , $key->id)->where('subject_type' , get_class($key))->first()
            : collect($this->cart['items'])->firstWhere('id' , $key);

        return $withRelationShip ? $this->withRelationshipIfExist($item) : $item;
    }

    public function delete($key)
    {
        if( $this->has($key) ) {
            $this->cart['items'] = collect($this->cart['items'])->filter(function ($item) use ($key) {
                if($key instanceof Model) {
                    return ( $item['subject_id'] != $key->id ) && ( $item['subject_type'] != get_class($key) );
                }
                return $key != $item['id'];
            });
            $this->storeCookie();

            return true;
        }

        return false;
    }

    public function all()
    {
        $cart = $this->cart;
        $cart = collect($this->cart['items'])->map(function($item) use ($cart) {
            $item = $this->withRelationshipIfExist($item);
            $item = $this->checkDiscountValidate($item , $cart['discount']);
            return $item;
        });
//        dd($cart);
        return $cart;
    }

    public function flush()
    {
        $this->cart = collect([
            'items' => [],
            'discount' => null
        ]);
        $this->storeCookie();

        return $this;
    }

    protected function withRelationshipIfExist($item)
    {
        if(isset( $item['subject_id'] ) && isset($item['subject_type']) ) {
            $class = $item['subject_type'];
            $subject = (new $class())->find( $item['subject_id'] );

            $item[strtolower(class_basename($class))] = $subject;

            unset($item['subject_id']);
            unset($item['subject_type']);

            return $item;
        }


        return $item;
    }

    public function instance(string $name)
    {
        $cart = collect(json_decode(request()->cookie($name) , true));
        $this->cart = $cart->count() ? $cart : collect([
            'items' => [],
            'discount' => null
        ]);
        $this->name = $name;
        return $this;
    }

    public function addDiscount($discount)
    {
        $this->cart['discount'] = $discount;
        $this->storeCookie();
    }

    public function getDiscount()
    {
        return Discount::where('id' , $this->cart['discount'])->first();
    }

    protected function storeCookie(): void
    {
        Cookie::queue($this->name, $this->cart->toJson(), 60 * 24 * 7);
    }

    protected function checkDiscountValidate($item, $discount)
    {
        $discount = Discount::where('id' , $discount)->first();
        if($discount && $discount->expires_at > now() ) {
            if($item['course']->id == $discount->course_id ) {
                $item['discount_percent'] = $discount->percent / 100;
            }
            if (!$discount->course_id) {
                $item['discount_percent'] = $discount->percent / 100;
            }
        }

        return $item;
    }
}
