<?php

namespace Modules\Admin\Http\Controllers;

use Artesaos\SEOTools\Traits\SEOTools;
use Modules\User\Entities\User;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;

class AdminController extends Controller
{
    use SEOTools;
    public function index()
    {
        $this->seo()->setTitle('پنل مدیریت سایت');
        return view('admin::index');
    }

    public function showlogin()
    {
        $this->seo()->setTitle('ورود');

        if (auth()->user()){
            return redirect('/');
        }
        return view('admin::login');

    }

    public function login(Request $request)
    {
        $validData = $request->validate([
           'phone' => 'required|exists:users',
           'password' => 'required'
        ]);
        if (Auth::attempt($validData)){
            $user = User::with('roles')->where('phone' , $validData['phone'])->first();
            if ($user->isAdmin()){
                auth()->loginUsingId($user->id);
                return redirect(route('admin.index'));
            }
        }
        return back();
    }

}
