/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.11.15-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: yektamentor_karawebs
-- ------------------------------------------------------
-- Server version	10.11.15-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `yektamentor_karawebs`
--


--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `category_type` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` (`id`, `name`, `parent_id`, `created_at`, `updated_at`, `category_type`) VALUES (1,'بازاریابی',NULL,'2024-10-26 21:36:43','2024-10-26 21:36:43','Modules\\Post\\Entities\\Post'),
(2,'کسب و کار',NULL,'2024-10-26 21:37:40','2024-10-26 21:37:40','Modules\\Post\\Entities\\Post');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorizables`
--

DROP TABLE IF EXISTS `categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categorizables` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) unsigned NOT NULL,
  `categorizable_type` varchar(255) NOT NULL,
  `categorizable_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categorizables_category_id_foreign` (`category_id`),
  KEY `categorizables_categorizable_type_categorizable_id_index` (`categorizable_type`,`categorizable_id`),
  CONSTRAINT `categorizables_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorizables`
--

LOCK TABLES `categorizables` WRITE;
/*!40000 ALTER TABLE `categorizables` DISABLE KEYS */;
INSERT INTO `categorizables` (`id`, `category_id`, `categorizable_type`, `categorizable_id`, `created_at`, `updated_at`) VALUES (1,1,'Modules\\Post\\Entities\\Post',19,NULL,NULL);
/*!40000 ALTER TABLE `categorizables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `codes`
--

DROP TABLE IF EXISTS `codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `codes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `code` int(11) NOT NULL,
  `expired_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `codes_user_id_code_unique` (`user_id`,`code`),
  CONSTRAINT `codes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `codes`
--

LOCK TABLES `codes` WRITE;
/*!40000 ALTER TABLE `codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `codes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `comments`
--

DROP TABLE IF EXISTS `comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `comments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `body` text NOT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `commentable_type` varchar(255) NOT NULL,
  `commentable_id` bigint(20) unsigned NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `comments_commentable_type_commentable_id_index` (`commentable_type`,`commentable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `comments`
--

LOCK TABLES `comments` WRITE;
/*!40000 ALTER TABLE `comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `course_order`
--

DROP TABLE IF EXISTS `course_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `course_order` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `course_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `course_order_order_id_foreign` (`order_id`),
  KEY `course_order_course_id_foreign` (`course_id`),
  CONSTRAINT `course_order_course_id_foreign` FOREIGN KEY (`course_id`) REFERENCES `courses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `course_order_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `course_order`
--

LOCK TABLES `course_order` WRITE;
/*!40000 ALTER TABLE `course_order` DISABLE KEYS */;
/*!40000 ALTER TABLE `course_order` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `course_user`
--

DROP TABLE IF EXISTS `course_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `course_user` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `course_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `course_user_user_id_foreign` (`user_id`),
  KEY `course_user_course_id_foreign` (`course_id`),
  CONSTRAINT `course_user_course_id_foreign` FOREIGN KEY (`course_id`) REFERENCES `courses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `course_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `course_user`
--

LOCK TABLES `course_user` WRITE;
/*!40000 ALTER TABLE `course_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `course_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `courses`
--

DROP TABLE IF EXISTS `courses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `courses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `body` longtext DEFAULT NULL,
  `slug` varchar(255) NOT NULL,
  `time` varchar(255) DEFAULT NULL,
  `teacher` varchar(255) DEFAULT NULL,
  `price` varchar(255) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `meta_title` varchar(255) DEFAULT NULL,
  `meta_desc` varchar(255) DEFAULT NULL,
  `meta_keywords` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `video_cover` varchar(255) DEFAULT NULL,
  `rating_count` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `course_slug_unique` (`slug`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `courses`
--

LOCK TABLES `courses` WRITE;
/*!40000 ALTER TABLE `courses` DISABLE KEYS */;
/*!40000 ALTER TABLE `courses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `discounts`
--

DROP TABLE IF EXISTS `discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `discounts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `percent` int(11) NOT NULL,
  `course_id` bigint(20) unsigned DEFAULT NULL,
  `expires_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `discounts_course_id_foreign` (`course_id`),
  KEY `discounts_user_id_foreign` (`user_id`),
  CONSTRAINT `discounts_course_id_foreign` FOREIGN KEY (`course_id`) REFERENCES `courses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discounts_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `discounts`
--

LOCK TABLES `discounts` WRITE;
/*!40000 ALTER TABLE `discounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `discounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `question` text NOT NULL,
  `answer` text NOT NULL,
  `page_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `faqs_page_id_foreign` (`page_id`),
  CONSTRAINT `faqs_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `pages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` (`id`, `question`, `answer`, `page_id`, `created_at`, `updated_at`) VALUES (13,'آیا طراحی سایت فروشگاهی دارای اتصال امن (https) میباشد؟','در صورت سفارش ssl این گواهینامه برای شما نصب و فعال میشود',12,'2021-04-03 13:59:03','2021-04-03 13:59:03'),
(14,'آیا درگاه پرداخت در طراحی سایت فروشگاهی اعمال میشود؟','بله، بعد از انجام مراحل و روال دریافت درگاه، این درگاه بر روی وب سایت شما ست شده و قابلیت پرداخت برای شما فعال میگردد.',12,'2021-04-03 13:59:25','2021-04-03 13:59:25'),
(15,'آیا دریافت نماد اعتماد الکترونیکی در پیکیج های طراحی سایت فروشگاهی وجود دارد؟','بله، نماد اعتماد الکترونیکی در صورتی که واجد شرایط آن باشید برای شما دریافت خواهد شد.',12,'2021-04-03 13:59:39','2021-04-03 13:59:39'),
(16,'آیا سیستم مدیریت سفارش در طراحی فروشگاه اینترنتی وجود دارد؟','بله، سیستم مدیریت بسیار حرفه ای برای مدیریت سفارشات شما در پنل مدیریت وجود دارد که به راحتی میتوانید سفارش های خود را مدیریت کنید',12,'2021-04-03 13:59:54','2021-04-03 13:59:54'),
(17,'دسته بندی طراحی سایت فروشگاهی به چه صورت است؟','به راحتی میتوانید از طریق پنل مدیریت هر دسته بندی ای که لازم دارید را اضافه، حذف و ویرایش کنید.',12,'2021-04-03 14:00:08','2021-04-03 14:00:08'),
(18,'آیا کار با پنل مدیریت طراحی سایت فروشگاهی آموزش داده میشود؟','بله، بعد از تکمیل کار طراحی وب سایت فروشگاهی، فایلی حاوی اطلاعات ورود و فایل ویدیویی آموزش پنل مدیریت برای شما ارسال میگردد.',12,'2021-04-03 14:00:21','2021-04-03 14:00:21'),
(19,'قالب طراحی سایت فروشگاهی به چه صورت است؟','قالب طراحی سایت فروشگاهی بر اساس نیاز و سلیقه شما طراحی میشود.',12,'2021-04-03 14:00:34','2021-04-03 14:00:34'),
(20,'آیا کاراوب بعد از طراحی سایت شخصی، پشتیبانی وب سایت را هم به عهده دارد؟','بله، پشتیبانی یکساله رایگان برای تمامی طراحی سایت هایی که در کاراوب انجام میشود لحاظ میگردد',10,'2021-04-03 14:06:07','2021-04-03 14:06:07'),
(21,'آیا دامین و هاست هم جزو پکیج طراحی وب سایت شخصی میباشد؟','بله، تهیه دامین و هاست به عهده کاراوب میباشد. بسته به نوع پکیج انتخابی این دامین میتواند com یا ir یا هردو باشد',10,'2021-04-03 14:06:20','2021-04-03 14:06:20'),
(22,'آیا امکان ارتقاء طراحی سایت شخصی وجود دارد؟','بله، هر زمان که نیاز به ارتقاء وب سایت شخصی داشته باشید میتوانید با پرداخت ماب التفاوت هزینه، وب سایت خود را ارتقاء دهید.',10,'2021-04-03 14:06:31','2021-04-03 14:06:31'),
(23,'آیا کار با پنل مدیریت طراحی سایت شخصی به من آموزش داده میشود؟','بله، در مرحله ی آخر طراحی سایت شخصی، فیلم آموزشی کار با پنل مدیریت به صورت اختصاصی برای شما گرفته شده و ارسال میگردد.',10,'2021-04-03 14:06:41','2021-04-03 14:06:41'),
(24,'طراحی سایت شخصی چقدر زمان میبرد؟','بسته به نوع طراحی و امکانات مورد نظر شما زمان طراحی وب سایت شخصی متغیر است بین 10 تا 15 روز کاری',10,'2021-04-03 14:06:53','2021-04-03 14:06:53'),
(25,'آیا تغییر ظاهر سایت بعد از تغییر سایت امکان پذیر است؟','خیر، تغییر ظاهر کلی سایت بعد از تحویل سایت امکان پذیر نمیباشد.',1,'2021-04-03 14:07:05','2021-04-03 14:07:05'),
(26,'آیا طراحی سایت فروشگاهی دارای اتصال امن (https) میباشد؟','در صورت سفارش ssl این گواهینامه برای شما نصب و فعال میشود',1,'2021-04-03 14:08:25','2021-04-03 14:08:25'),
(27,'آیا درگاه پرداخت در طراحی سایت فروشگاهی اعمال میشود؟','بله، بعد از انجام مراحل و روال دریافت درگاه، این درگاه بر روی وب سایت شما ست شده و قابلیت پرداخت برای شما فعال میگردد.',1,'2021-04-03 14:08:37','2021-04-03 14:08:37'),
(28,'آیا دریافت نماد اعتماد الکترونیکی در پیکیج های طراحی سایت فروشگاهی وجود دارد؟','بله، نماد اعتماد الکترونیکی در صورتی که واجد شرایط آن باشید برای شما دریافت خواهد شد.',1,'2021-04-03 14:08:50','2021-04-03 14:08:50'),
(29,'آیا سیستم مدیریت سفارش در طراحی فروشگاه اینترنتی وجود دارد؟','بله، سیستم مدیریت بسیار حرفه ای برای مدیریت سفارشات شما در پنل مدیریت وجود دارد که به راحتی میتوانید سفارش های خود را مدیریت کنید',1,'2021-04-03 14:09:00','2021-04-03 14:09:00'),
(30,'دسته بندی طراحی سایت فروشگاهی به چه صورت است؟','به راحتی میتوانید از طریق پنل مدیریت هر دسته بندی ای که لازم دارید را اضافه، حذف و ویرایش کنید',1,'2021-04-03 14:09:12','2021-04-03 14:09:12'),
(31,'آیا کار با پنل مدیریت طراحی سایت فروشگاهی آموزش داده میشود؟','بله، بعد از تکمیل کار طراحی وب سایت فروشگاهی، فایلی حاوی اطلاعات ورود و فایل ویدیویی آموزش پنل مدیریت برای شما ارسال میگردد.',1,'2021-04-03 14:09:22','2021-04-03 14:09:22'),
(32,'قالب طراحی سایت فروشگاهی به چه صورت است؟','قالب طراحی سایت فروشگاهی بر اساس نیاز و سلیقه شما طراحی میشود.',1,'2021-04-03 14:09:34','2021-04-03 14:09:34');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `files`
--

DROP TABLE IF EXISTS `files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `file` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `files`
--

LOCK TABLES `files` WRITE;
/*!40000 ALTER TABLE `files` DISABLE KEYS */;
INSERT INTO `files` (`id`, `title`, `file`, `created_at`, `updated_at`) VALUES (1,'فایل تستی','/images/woo.png','2024-10-21 18:38:09','2024-10-21 18:38:09'),
(6,'بازاریابی لحظه ای به سبک گوگل','/uploads/micromoments-guide-to-winning-shift-to-mobile-download.pdf','2024-10-26 21:53:40','2024-10-26 21:53:40');
/*!40000 ALTER TABLE `files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) NOT NULL,
  `payload` longtext NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `link` varchar(255) NOT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `order` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` (`id`, `title`, `link`, `parent_id`, `order`, `created_at`, `updated_at`, `icon`, `subtitle`) VALUES (5,'خانه','/',NULL,0,'2021-04-10 06:53:48','2021-11-02 15:06:55','',NULL),
(43,'وبلاگ','/blog/index',NULL,NULL,'2024-10-21 18:47:07','2024-10-21 18:47:07',NULL,NULL),
(44,'فایل ها','/files',NULL,NULL,'2024-10-21 18:47:23','2024-10-21 18:47:23',NULL,NULL);
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES (1,'2014_10_12_000000_create_users_table',1),
(2,'2014_10_12_100000_create_password_resets_table',1),
(3,'2019_08_19_000000_create_failed_jobs_table',1),
(4,'2021_01_12_132246_create_permissions_and_rules_tables',1),
(5,'2021_01_12_133337_roles_users_table',1),
(6,'2021_01_12_142228_permission_role',1),
(7,'2021_01_14_121616_alter_table_users',1),
(8,'2021_01_16_103040_create_posts_table',1),
(9,'2021_01_16_112409_add_image_field_to_posts_table',1),
(10,'2021_01_16_133632_add_slug_field_to_posts_table',1),
(11,'2021_01_17_173803_categories_and_categorizable_table_create',1),
(12,'2021_01_19_085910_add_type_filed_to_categories_create',2),
(13,'2021_04_07_102729_create_pages_table',3),
(14,'2021_04_10_090736_create_menu_table',4),
(15,'2021_04_12_102506_create_comments_table',5),
(16,'2021_04_12_103102_create_comments_table',6),
(17,'2021_04_12_103255_create_comments_table',7),
(18,'2021_04_16_143928_add_main_page_field_to_pages_table',8),
(19,'2021_06_04_132846_alter_portfolios_table',9),
(20,'2021_06_05_123044_add_user_id_field_to_comments_table',10),
(21,'2021_06_05_125528_create_notifications_table',11),
(22,'2021_06_06_072357_create_codes_table',12),
(23,'2021_06_06_073340_alter_user_table',13),
(24,'2021_06_06_114025_create_course_table',14),
(25,'2021_06_06_114631_edit_episodes_table',15),
(26,'2021_06_06_125751_edit_course_table',16),
(27,'2021_06_06_133716_edit_episodes_table_add_status_field',17),
(28,'2021_06_06_155033_create_course_user_table',18),
(29,'2021_06_07_071914_create_discounts_table',19),
(30,'2021_06_07_073617_create_discounts_table',20),
(31,'2021_06_07_084818_alter_discounts_table_add_user_id_field',21),
(32,'2021_06_07_152043_edit_discounts_table',22),
(33,'2021_06_08_072703_create_orders_table',23),
(34,'2021_06_08_073955_create_orders_table',24),
(35,'2021_06_08_082434_create_orders_table',25),
(36,'2021_06_08_082531_course_order_table',25),
(37,'2021_06_08_080130_create_payments_table',26),
(38,'2021_06_08_100218_table_orders_add_order_type_field',27),
(39,'2021_06_08_131626_add_order_id_field_to_orders_table',28),
(40,'2021_06_08_140422_add_is_free_field_to_episodes_table',29),
(41,'2021_06_09_174456_add_video_cover_field_to_courses_table',30),
(42,'2021_06_10_100353_create_projects_table',31),
(43,'2021_06_10_100439_create_order_project_table',32),
(44,'2021_06_10_113746_edit_projects_table',33),
(45,'2021_06_10_120353_add_extras_field_projects_table',34),
(46,'2021_06_10_135544_create_jobs_table',35),
(47,'2021_06_11_081927_add_some_fields_to_projects_table',36),
(48,'2021_06_12_112753_add_amoozesh_field_to_projects_table',37),
(49,'2021_06_13_064227_add_price_field_to_projects_table',38),
(50,'2021_06_13_081833_create_tickets_table',39),
(51,'2021_06_13_084020_add_users_field_to_tickets_table',40),
(52,'2021_06_13_095509_add_ticketble_field_to_tickets_table',41),
(53,'2021_06_13_150221_add_tracking_id_field_to_tickets_table',42),
(54,'2021_06_14_085223_create_ticket_replies_table',43),
(55,'2021_06_17_052433_add_type_field_to_orders_table',44),
(56,'2021_06_17_061329_add_fields_to_projects_table',45),
(57,'2021_06_17_090736_add_rating_count_to_pages_table',46),
(58,'2021_06_19_120146_add_rating_count_field_posts_table',47),
(59,'2021_06_19_120157_add_rating_count_field_courses_table',48),
(60,'2021_06_19_120206_add_rating_count_field_episodes_table',48),
(61,'2024_10_21_213921_create_files_table',49);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notifications`
--

DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `notifications` (
  `id` char(36) NOT NULL,
  `type` varchar(255) NOT NULL,
  `notifiable_type` varchar(255) NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notifications`
--

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
INSERT INTO `notifications` (`id`, `type`, `notifiable_type`, `notifiable_id`, `data`, `read_at`, `created_at`, `updated_at`) VALUES ('11cfea52-8e7d-4431-be08-08a90cbe1e25','Modules\\Comment\\Notifications\\NotifyAdminOfNewComment','Modules\\User\\Entities\\User',137,'{\"data\":\"newComment\"}','2021-12-12 02:05:35','2021-12-10 04:04:06','2021-12-12 02:05:35'),
('1760e66d-6d14-43b1-9df2-75498a181352','Modules\\Comment\\Notifications\\NotifyAdminOfNewComment','Modules\\User\\Entities\\User',137,'{\"data\":\"newComment\"}','2021-11-23 15:29:25','2021-11-21 16:50:41','2021-11-23 15:29:25'),
('204a5ab3-0a3f-42b7-a65a-0278459a0892','Modules\\Ticket\\Notifications\\TicketAdminNotify','Modules\\User\\Entities\\User',52,'{\"data\":\"newTicket\"}','2021-07-13 16:15:44','2021-07-13 14:26:41','2021-07-13 16:15:44'),
('21ef0807-2627-4c0e-90f2-8da7dad065da','Modules\\Ticket\\Notifications\\TicketAdminNotify','Modules\\User\\Entities\\User',194,'{\"data\":\"newTicket\"}','2023-05-31 15:29:13','2023-05-30 18:55:13','2023-05-31 15:29:13'),
('26663fb9-562a-4ded-abf7-f147fecfc523','Modules\\Comment\\Notifications\\NotifyAdminOfNewComment','Modules\\User\\Entities\\User',204,'{\"data\":\"newComment\"}','2023-11-04 19:41:10','2023-10-28 21:54:25','2023-11-04 19:41:10'),
('388cc599-d95d-43a3-991c-5b62cdb6afce','Modules\\Ticket\\Notifications\\TicketAdminNotify','Modules\\User\\Entities\\User',52,'{\"data\":\"newTicket\"}','2021-08-20 12:51:12','2021-08-19 19:05:43','2021-08-20 12:51:12'),
('41f3b777-40fe-4e5f-810d-67799172a2b6','Modules\\Ticket\\Notifications\\TicketAdminNotify','Modules\\User\\Entities\\User',194,'{\"data\":\"newTicket\"}','2023-07-25 19:33:36','2023-07-01 08:11:14','2023-07-25 19:33:36'),
('48767f14-cc26-4cd7-b758-dee422d4e85e','Modules\\Comment\\Notifications\\NotifyAdminOfNewComment','Modules\\User\\Entities\\User',1,'{\"data\":\"newComment\"}','2021-11-02 22:02:25','2021-11-02 14:59:43','2021-11-02 22:02:25'),
('4a3c4de3-63a5-4862-a9df-416271c69556','Modules\\Comment\\Notifications\\NotifyAdminOfNewComment','Modules\\User\\Entities\\User',1,'{\"data\":\"newComment\"}','2021-12-13 12:06:51','2021-12-13 11:33:51','2021-12-13 12:06:51'),
('5042680b-f7d8-4d11-b31a-98d884909433','Modules\\Comment\\Notifications\\NotifyAdminOfNewComment','Modules\\User\\Entities\\User',193,'{\"data\":\"newComment\"}','2023-05-15 14:16:07','2023-05-13 04:42:17','2023-05-15 14:16:07'),
('5306f4a2-470f-4283-8f68-0cc77052e850','Modules\\Comment\\Notifications\\NotifyAdminOfNewComment','Modules\\User\\Entities\\User',204,'{\"data\":\"newComment\"}','2023-10-02 14:12:49','2023-09-27 22:57:09','2023-10-02 14:12:49'),
('53eb8cbd-a021-4d69-9343-7a4f9db01217','Modules\\Ticket\\Notifications\\TicketAdminNotify','Modules\\User\\Entities\\User',194,'{\"data\":\"newTicket\"}','2023-06-02 18:01:12','2023-05-31 15:33:37','2023-06-02 18:01:12'),
('551e8be2-3965-4039-834d-d75763b2a3b9','Modules\\Comment\\Notifications\\NotifyAdminOfNewComment','Modules\\User\\Entities\\User',1,'{\"data\":\"newComment\"}','2021-11-23 21:10:30','2021-11-23 21:08:31','2021-11-23 21:10:30'),
('6391ffc0-c216-460c-9e5b-9f11cccab0fd','Modules\\Ticket\\Notifications\\TicketAdminNotify','Modules\\User\\Entities\\User',194,'{\"data\":\"newTicket\"}','2023-06-25 09:01:20','2023-06-18 14:29:14','2023-06-25 09:01:20'),
('78183f59-5fa6-4172-866c-390499327372','Modules\\Ticket\\Notifications\\TicketAdminNotify','Modules\\User\\Entities\\User',1,'{\"data\":\"newTicket\"}','2022-11-26 09:23:49','2022-11-26 09:23:24','2022-11-26 09:23:49'),
('8cd77dab-ddfe-47b0-8a96-7e93dc179483','Modules\\Comment\\Notifications\\NotifyAdminOfNewComment','Modules\\User\\Entities\\User',193,'{\"data\":\"newComment\"}','2023-09-26 13:26:49','2023-09-24 20:16:10','2023-09-26 13:26:49'),
('adeaf4f5-7026-49ca-b99d-e1432f37986d','Modules\\Ticket\\Notifications\\TicketAdminNotify','Modules\\User\\Entities\\User',194,'{\"data\":\"newTicket\"}','2023-06-12 11:52:46','2023-06-11 08:21:17','2023-06-12 11:52:46'),
('dcb24782-5abb-452d-8e34-0fb2c1417034','Modules\\Ticket\\Notifications\\TicketAdminNotify','Modules\\User\\Entities\\User',52,'{\"data\":\"newTicket\"}','2022-07-27 16:40:00','2022-07-17 06:18:38','2022-07-27 16:40:00'),
('f5008611-e878-400c-85a3-0de0e31b5395','Modules\\Comment\\Notifications\\NotifyAdminOfNewComment','Modules\\User\\Entities\\User',193,'{\"data\":\"newComment\"}','2023-10-11 12:41:33','2023-10-10 18:43:13','2023-10-11 12:41:33'),
('f5cb0c24-4665-4dbc-8738-a559fc564c1c','Modules\\Comment\\Notifications\\NotifyAdminOfNewComment','Modules\\User\\Entities\\User',131,'{\"data\":\"newComment\"}','2021-11-02 14:57:54','2021-11-01 21:47:11','2021-11-02 14:57:54'),
('f848ca73-353e-4bcc-b9e5-63e6991630b8','Modules\\Comment\\Notifications\\NotifyAdminOfNewComment','Modules\\User\\Entities\\User',1,'{\"data\":\"newComment\"}','2023-05-24 20:35:31','2023-05-24 20:35:21','2023-05-24 20:35:31'),
('fc15bb70-d472-4701-8579-e3c2282a0b7b','Modules\\Ticket\\Notifications\\TicketAdminNotify','Modules\\User\\Entities\\User',194,'{\"data\":\"newTicket\"}','2023-06-11 08:17:06','2023-06-09 18:01:20','2023-06-11 08:17:06');
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_project`
--

DROP TABLE IF EXISTS `order_project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_project` (
  `project_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  KEY `order_project_project_id_foreign` (`project_id`),
  KEY `order_project_order_id_foreign` (`order_id`),
  CONSTRAINT `order_project_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `order_project_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_project`
--

LOCK TABLES `order_project` WRITE;
/*!40000 ALTER TABLE `order_project` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tracking_id` varchar(255) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `price` bigint(20) NOT NULL,
  `status` enum('half_paid','full_paid','unpaid','canceled') NOT NULL,
  `project_status` enum('ui_design','ux_design','coding','correction','delivered') DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `product_type` varchar(255) NOT NULL,
  `product_id` varchar(255) NOT NULL,
  `type` enum('normal','renewal','first','second') NOT NULL DEFAULT 'normal',
  PRIMARY KEY (`id`),
  KEY `orders_user_id_foreign` (`user_id`),
  CONSTRAINT `orders_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `body` longtext NOT NULL,
  `meta_title` varchar(255) DEFAULT NULL,
  `meta_description` text DEFAULT NULL,
  `meta_keywords` varchar(255) DEFAULT NULL,
  `meta_type` varchar(255) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `is_indexable` tinyint(1) NOT NULL DEFAULT 1,
  `image` varchar(255) DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_main_page` tinyint(1) NOT NULL DEFAULT 0,
  `rating_count` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pages_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` (`id`, `title`, `body`, `meta_title`, `meta_description`, `meta_keywords`, `meta_type`, `slug`, `is_indexable`, `image`, `status`, `created_at`, `updated_at`, `is_main_page`, `rating_count`) VALUES (1,'طراحی سایت فروشگاهی','<section><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><div id=\"ij0qi\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><g clip-path=\"url(#clip0)\"><path d=\"M9.28125 4.21875C9.57465 3.87573 9.93887 3.60035 10.3489 3.41153C10.7588 3.22272 11.2049 3.12497 11.6563 3.125H38.3438C38.7951 3.12497 39.2412 3.22272 39.6511 3.41153C40.0611 3.60035 40.4254 3.87573 40.7187 4.21875L48.8719 13.7313C49.5998 14.5807 50 15.6625 50 16.7812V17.5781C50.0002 19.1249 49.5171 20.6331 48.6182 21.8919C47.7193 23.1508 46.4496 24.0973 44.9865 24.5992C43.5234 25.1011 41.94 25.1334 40.4577 24.6915C38.9754 24.2495 37.6682 23.3555 36.7188 22.1344C36.0254 23.0274 35.137 23.7499 34.1214 24.2466C33.1057 24.7433 31.9899 25.001 30.8594 25C29.7288 25.0013 28.6129 24.7437 27.5972 24.2469C26.5816 23.7502 25.6932 23.0276 25 22.1344C24.3068 23.0276 23.4184 23.7502 22.4028 24.2469C21.3871 24.7437 20.2712 25.0013 19.1406 25C18.01 25.0013 16.8941 24.7437 15.8785 24.2469C14.8628 23.7502 13.9744 23.0276 13.2812 22.1344C12.3318 23.3555 11.0246 24.2495 9.5423 24.6915C8.05998 25.1334 6.47661 25.1011 5.01351 24.5992C3.55041 24.0973 2.2807 23.1508 1.38182 21.8919C0.482943 20.6331 -0.000170621 19.1249 4.52017e-08 17.5781V16.7812C3.93986e-05 15.6625 0.400177 14.5807 1.12813 13.7313L9.28437 4.21562L9.28125 4.21875ZM14.8438 17.5781C14.8438 18.7177 15.2965 19.8107 16.1023 20.6165C16.9081 21.4223 18.001 21.875 19.1406 21.875C20.2802 21.875 21.3732 21.4223 22.179 20.6165C22.9848 19.8107 23.4375 18.7177 23.4375 17.5781C23.4375 17.1637 23.6021 16.7663 23.8951 16.4733C24.1882 16.1802 24.5856 16.0156 25 16.0156C25.4144 16.0156 25.8118 16.1802 26.1049 16.4733C26.3979 16.7663 26.5625 17.1637 26.5625 17.5781C26.5625 18.7177 27.0152 19.8107 27.821 20.6165C28.6268 21.4223 29.7198 21.875 30.8594 21.875C31.999 21.875 33.0919 21.4223 33.8977 20.6165C34.7035 19.8107 35.1562 18.7177 35.1562 17.5781C35.1562 17.1637 35.3209 16.7663 35.6139 16.4733C35.9069 16.1802 36.3043 16.0156 36.7188 16.0156C37.1332 16.0156 37.5306 16.1802 37.8236 16.4733C38.1166 16.7663 38.2812 17.1637 38.2812 17.5781C38.2813 18.7177 38.734 19.8107 39.5398 20.6165C40.3456 21.4223 41.4385 21.875 42.5781 21.875C43.7177 21.875 44.8107 21.4223 45.6165 20.6165C46.4223 19.8107 46.875 18.7177 46.875 17.5781V16.7812C46.875 16.4088 46.742 16.0487 46.5 15.7656L38.3438 6.25H11.6563L3.5 15.7656C3.25796 16.0487 3.12497 16.4088 3.125 16.7812V17.5781C3.125 18.7177 3.57771 19.8107 4.38353 20.6165C5.18935 21.4223 6.28227 21.875 7.42188 21.875C8.56148 21.875 9.6544 21.4223 10.4602 20.6165C11.266 19.8107 11.7188 18.7177 11.7188 17.5781C11.7187 17.1637 11.8834 16.7663 12.1764 16.4733C12.4694 16.1802 12.8668 16.0156 13.2812 16.0156C13.6957 16.0156 14.0931 16.1802 14.3861 16.4733C14.6791 16.7663 14.8438 17.1637 14.8438 17.5781V17.5781ZM4.6875 26.5625C5.1019 26.5625 5.49933 26.7271 5.79235 27.0201C6.08538 27.3132 6.25 27.7106 6.25 28.125V46.875H9.375V31.25C9.375 30.4212 9.70424 29.6263 10.2903 29.0403C10.8763 28.4542 11.6712 28.125 12.5 28.125H21.875C22.7038 28.125 23.4987 28.4542 24.0847 29.0403C24.6708 29.6263 25 30.4212 25 31.25V46.875H43.75V28.125C43.75 27.7106 43.9146 27.3132 44.2076 27.0201C44.5007 26.7271 44.8981 26.5625 45.3125 26.5625C45.7269 26.5625 46.1243 26.7271 46.4174 27.0201C46.7104 27.3132 46.875 27.7106 46.875 28.125V46.875H48.4375C48.8519 46.875 49.2493 47.0396 49.5424 47.3326C49.8354 47.6257 50 48.0231 50 48.4375C50 48.8519 49.8354 49.2493 49.5424 49.5424C49.2493 49.8354 48.8519 50 48.4375 50H1.5625C1.1481 50 0.750671 49.8354 0.457646 49.5424C0.16462 49.2493 4.52017e-08 48.8519 4.52017e-08 48.4375C4.52017e-08 48.0231 0.16462 47.6257 0.457646 47.3326C0.750671 47.0396 1.1481 46.875 1.5625 46.875H3.125V28.125C3.125 27.7106 3.28962 27.3132 3.58265 27.0201C3.87567 26.7271 4.2731 26.5625 4.6875 26.5625V26.5625ZM12.5 46.875H21.875V31.25H12.5V46.875ZM28.125 31.25C28.125 30.4212 28.4542 29.6263 29.0403 29.0403C29.6263 28.4542 30.4212 28.125 31.25 28.125H37.5C38.3288 28.125 39.1237 28.4542 39.7097 29.0403C40.2958 29.6263 40.625 30.4212 40.625 31.25V40.625C40.625 41.4538 40.2958 42.2487 39.7097 42.8347C39.1237 43.4208 38.3288 43.75 37.5 43.75H31.25C30.4212 43.75 29.6263 43.4208 29.0403 42.8347C28.4542 42.2487 28.125 41.4538 28.125 40.625V31.25ZM37.5 31.25H31.25V40.625H37.5V31.25Z\" fill=\"#288ED9\"></path></g><defs><clippath id=\"clip0\"><rect width=\"50\" height=\"50\" fill=\"white\"></rect></clippath></defs></svg></div></div><div class=\"title-box\"><h2 class=\"title\"> طراحی سایت فروشگاهی در کاراوب</h2><p id=\"i7s6l\"> <strong>بررسی این نوع وب سایت</strong></p><div class=\"blue-line\"></div></div></div></div><p id=\"ivq9j\">طراحی سایت فروشگاهی از انواع دیگر <a data-cke-saved-href=\"https://karawebs.com\" href=\"https://karawebs.com\">طراحی سایت </a>میباشد که گروه ما به صورت بسیار حرفه ای به انجام آن میپردازد. امروزه همه کسب و کار ها به سمت آنلاین شدن میروند! اگر میخواهید از رقبای خود عقب نمانید، از همین امروز به فکر باشید. در این مطلب سعی داریم تا به بررسی مزایا و معایب <strong>طراحی سایت فروشگاهی</strong> بپردازیم. <strong>طراحی فروشگاه اینترنتی</strong> بحث داغ این روز هاست! فروش در اینستاگرام بهتر است یا اینکه باید به فکر <strong>طراحی فروشگاه اینترنتی</strong> باشید؟ کدام بیشتر شما را به سود میرساند؟<br/>با ما باشید تا به بررسی این موضوع بپردازیم.</p><ul class=\"kw-list1\"><li>پشتیبانی 24 ساعته</li><li id=\"ijvip\">امنیت فوق العاده</li><li id=\"ibx5j\">سئوی استاندارد</li><li id=\"i9yzf\">امکان ارتقاء به سایت چند فروشندگی</li><li id=\"ih8pa\">پنل مدیریت حرفه ای</li></ul><a href=\"#faqs\" class=\"kw-btn-blue\">سوالات متداول</a><a href=\"https://karawebs.com/online-store-prices\" class=\"kw-btn-blue\">تعرفه و امکانات</a></div><div class=\"col-md-6\"><img src=\"/backend/images/grapesjs/1624019759-online-store.png\" alt=\"طراحی سایت فروشگاهی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section><section class=\"kw-p\"><div class=\"container\"><div id=\"iithp4\" class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 28 31\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" id=\"ip30j\"><path d=\"M16.2511 4.875H17.8761V3.25C17.8761 2.81902 17.7049 2.4057 17.4002 2.10095C17.0954 1.79621 16.6821 1.625 16.2511 1.625H11.3761C10.9451 1.625 10.5318 1.79621 10.2271 2.10095C9.92233 2.4057 9.75113 2.81902 9.75113 3.25V4.875H11.3761V8.242L2.08925 24.3262C1.79293 24.8195 1.63286 25.3825 1.62539 25.9578C1.61792 26.5331 1.76333 27.1001 2.04675 27.6009C2.33016 28.1016 2.74143 28.5181 3.23854 28.8079C3.73564 29.0976 4.30075 29.2502 4.87613 29.25H22.7511C23.3265 29.2502 23.8916 29.0976 24.3887 28.8079C24.8858 28.5181 25.2971 28.1016 25.5805 27.6009C25.8639 27.1001 26.0093 26.5331 26.0019 25.9578C25.9944 25.3825 25.8343 24.8195 25.538 24.3262L16.2511 8.242V4.875ZM4.87613 30.875C3.99846 30.8752 3.13702 30.6385 2.38272 30.1898C1.62842 29.7411 1.00924 29.0971 0.590535 28.3257C0.171827 27.5544 -0.0308794 26.6843 0.00381014 25.8073C0.0384997 24.9303 0.309298 24.079 0.787625 23.3431L9.75113 7.81787V6.5C9.32015 6.5 8.90682 6.32879 8.60208 6.02405C8.29733 5.7193 8.12613 5.30598 8.12613 4.875V3.25C8.12613 2.38805 8.46854 1.5614 9.07803 0.951903C9.68752 0.34241 10.5142 0 11.3761 0H16.2511C17.1131 0 17.9397 0.34241 18.5492 0.951903C19.1587 1.5614 19.5011 2.38805 19.5011 3.25V4.875C19.5011 5.30598 19.3299 5.7193 19.0252 6.02405C18.7204 6.32879 18.3071 6.5 17.8761 6.5V7.81787L26.8396 23.3431C27.318 24.079 27.5888 24.9303 27.6234 25.8073C27.6581 26.6843 27.4554 27.5544 27.0367 28.3257C26.618 29.0971 25.9988 29.7411 25.2445 30.1898C24.4902 30.6385 23.6288 30.8752 22.7511 30.875H4.87613ZM15.1039 19.9745L17.7461 17.3323L22.7511 26H4.87613L10.8236 15.6975L15.1039 19.9745ZM15.1039 22.2722L11.173 18.343L7.69062 24.375H19.9366L17.3984 19.9777L15.1039 22.2722ZM14.6261 11.375C15.0571 11.375 15.4704 11.5462 15.7752 11.851C16.0799 12.1557 16.2511 12.569 16.2511 13C16.2511 13.431 16.0799 13.8443 15.7752 14.149C15.4704 14.4538 15.0571 14.625 14.6261 14.625C14.1951 14.625 13.7818 14.4538 13.4771 14.149C13.1723 13.8443 13.0011 13.431 13.0011 13C13.0011 12.569 13.1723 12.1557 13.4771 11.851C13.7818 11.5462 14.1951 11.375 14.6261 11.375V11.375Z\" fill=\"#288ED9\"></path></svg></div></div><div class=\"title-box\"><h3 class=\"title\"> برخی نمونه کار ها</h3><p id=\"i6kfnf\">خلاقیت، کیفیت، زیبایی</p><div class=\"blue-line\"></div></div></div></div><div id=\"i0uqh\" class=\"row\"><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1619518884moshtaqi.jpg\" alt=\"\" id=\"ivo4b\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">داروخانه دکتر مشتاقی</h3><p class=\"subtitle\">طراحی سایت فروشگاهی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/moahtaqi-online\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1611133098screencapture-choobiranshop-2021-01-20-12_27_03.jpg\" alt=\"\" id=\"ive1u\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">فروشگاه چوب ایران</h3><p class=\"subtitle\">طراحی سایت فروشگاهی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/choobiranshop\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1611135044screencapture-elisa-shop-ir-2021-01-20-12_59_30.jpg\" alt=\"\" id=\"iafqy\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">الیسا شاپ</h3><p class=\"subtitle\">طراحی سایت فروشگاهی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/elisa-shop\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1614420323mira.jpg\" alt=\"\" id=\"ig75id\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">فروشگاه میراکالا</h3><p class=\"subtitle\">طراحی سایت فروشگاهی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/mirakala\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div></div></div></section><section id=\"iz6v0x\"><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><img src=\"/backend/images/grapesjs/1624030974-panel.png\" alt=\"طراحی وب سایت فروشگاهی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h2 class=\"title\"> پنل مدیریت اختصاصی طراحی سایت فروشگاهی</h2><p id=\"ieficj\">بررسی امکانات</p><div class=\"blue-line\"></div></div></div></div><p id=\"i6qmdu\">گروه کاراوب با استفاده از کد نویسی اختصاصی، پنل مدیریت حرفه ای را برای وب سایت فروشگاهی شما طراحی خواهد کرد و بعد از اتمام کار طراحی سایت فروشگاهی تمام جزئیات آن را در قالب یک ویدیوی آموزشی به شما آموزش خواهد داد.</p><ul class=\"kw-list1\"><li id=\"i25uh8\">هاست حرفه ای</li><li id=\"ia6iuw\">امنیت پنل مدیریت</li><li id=\"ixmdnh\">سهولت کار با پنل</li></ul></div></div></div></section><section class=\"what-we-do pt-5 pb-5\"><div class=\"container\"><div class=\"row\"><div class=\"col-md-12\"><div class=\"section-head justify-content-center\"><div class=\"section-title\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M40.625 45.8333C42.3479 45.8333 43.75 44.4313 43.75 42.7083V35.4167C43.75 33.6938 42.3479 32.2917 40.625 32.2917C38.1875 32.2917 35.7916 31.9083 33.5 31.1521C32.9522 30.9791 32.3677 30.9581 31.8089 31.0913C31.2501 31.2245 30.7379 31.5069 30.327 31.9083L27.327 34.9083C22.1419 32.0934 17.8834 27.8363 15.0666 22.6521L18.0416 19.6583C18.9 18.8625 19.2083 17.6521 18.8416 16.4875C18.0869 14.1923 17.7043 11.7911 17.7083 9.375C17.7083 7.65208 16.3062 6.25 14.5833 6.25H7.29163C5.56871 6.25 4.16663 7.65208 4.16663 9.375C4.16663 29.4792 20.5208 45.8333 40.625 45.8333ZM7.29163 8.33333H14.5833C14.8596 8.33333 15.1245 8.44308 15.3199 8.63843C15.5152 8.83378 15.625 9.09873 15.625 9.375C15.625 12.0354 16.0416 14.6479 16.8604 17.125C16.9205 17.3048 16.9276 17.498 16.8806 17.6817C16.8337 17.8653 16.7348 18.0316 16.5958 18.1604L12.5208 22.2563C15.9312 28.9813 20.9687 34.0188 27.725 37.4583L31.7854 33.3958C31.9239 33.2587 32.0971 33.1619 32.2865 33.1156C32.4759 33.0694 32.6742 33.0755 32.8604 33.1333C35.352 33.9583 37.9645 34.375 40.625 34.375C41.1979 34.375 41.6666 34.8438 41.6666 35.4167V42.7083C41.6666 43.2813 41.1979 43.75 40.625 43.75C21.6708 43.75 6.24996 28.3292 6.24996 9.375C6.24996 9.09873 6.35971 8.83378 6.55506 8.63843C6.75041 8.44308 7.01536 8.33333 7.29163 8.33333Z\" fill=\"#288ED9\"></path></svg></div><div class=\"title-box\"><h2 class=\"title\">\n                                تماس با گروه کاراوب\n                            </h2><p>مشاوره رایگان جهت راه اندازی وب سایت...</p><div class=\"blue-line\"></div></div></div></div></div><div class=\"col-md-12\"><div class=\"d-flex justify-content-center\"><div class=\"contact-us\"><p class=\"contact-phone\">021-77200630</p></div></div></div></div></div></section><section><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/sherkati/products.png\" alt=\"طراحی فروشگاه اینترنتی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h2 class=\"title\">اهمیت طراحی سایت فروشگاه اینترنتی</h2><p id=\"i19j5a\">چرا طراحی سایت فروشگاهی مهم است؟</p><div class=\"blue-line\"></div></div></div></div><p id=\"iextrd\">با توجه به تغییر تمایل مشتری از خرید فیزیکی به خرید مجازی و اینترنتی اهمیت داشتن یک سایت فروشگاهی مشخص میشود. با داشتن یک سایت خوب، کار آمد و البته بهینه شده برای موتور های جستجو از جمله گوگل میتوانید از فرش به عرش برسید!</p><p id=\"i9e2ju\">اما برخی هنوز هم نمیخواهند بپذیرند که سایت فروشگاهی تبدیل به یک الزام شده! اگر شما مغازه دارید، اگر با تلفن در خانه کار میکنید، اگر صاحب کارخانه هستید و… میتوانید به راحتی محصولات خود را در دنیایی پر از کاربر به نمایش و فروش بگذارید!</p><p id=\"ikz0qj\"><strong>طراحی سایت فروشگاهی</strong> ویترین آنلاین شماست! ویترینی مدرن که به سلیقه ی شما چیده میشود. بر اساس نیاز شما و مشتریانتان ساخته میشود و میتواند شما را به قله ی موفقیت برساند. به سایت های بزرگ نگاه کنید! آمازون، <a data-cke-saved-href=\"http://digikala.com\" href=\"http://digikala.com\">دیجیکالا </a>و سایت های بزرگی که با فروش آنلاین هم زندگی خود را تغییر دادند هم خرید را برای کاربرانشان راحت تر کردند!</p></div></div></div></section><section id=\"inzibp\"><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div id=\"i5l95y\" class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h3 class=\"title\">چت آنلاین طراحی وب سایت فروشگاهی</h3><p id=\"iv9c94\">معرفی امکانات</p><div class=\"blue-line\"></div></div></div></div><p id=\"iq1y3l\">این امکان بسیار جذاب در <strong>طراحی سایت فروشگاهی </strong>شما استفاده خواهد شد! به این صورت که شما عزیزان میتوانید اپلیکیشن چت را روی گوشی موبایل خود نصب کنید و با مشتریانتان در ارتباط باشید! یک سایت فروشگاهی خوب نیازمند امکانات خوب نیز هست، با استفاده از سیستم چت آنلاین شما میتوانید به مشتریانتان مشاوره دهید و به راحتی با آنها در ارتباط باشید.</p><ul class=\"kw-list1\"><li id=\"iwth8k\">ااپلیکیشن موبایل برای چت آنلاین</li><li id=\"iep7mr\">دسترسی به گفتگو ها از طریق پنل مدیریت</li><li id=\"i9wgyp\">امکان نمایش کاربران آنلاین در وب سایت شما</li></ul><a href=\"https://karawebs.com/portfolios\" title=\"نمونه کارها\" class=\"kw-btn-blue\">نمونه کارها</a></div><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/sherkati/chat.png\" alt=\"طراحی سایت فروشگاهی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section><section id=\"iujubi\"><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/sherkati/res-1.png\" alt=\"طراحی وب سایت فروشگاهی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h3 class=\"title\">طراحی ریسپانسیو فروشگاه اینترنتی</h3><p id=\"io5agx\">مناسب برای تمامی نمایشگر ها</p><div class=\"blue-line\"></div></div></div></div><p id=\"ieyzrg\">به اطراف خود نگاه کنید، صفحه نمایش های بزرگ جی خود را به موبایل های خوش دستی داده اند که همیشه کاربران را به دنیای اینترنت متصل میکند! بر اساس الگوریتم Mobile First Index گوگل، وب سایت هایی به کاربران موبایل نمایش داده میشوند که دارای طراحی رسپانسیو باشند. برای اطلاعات بیشتر درباره ریسپانسیو میتوانید این مقاله را مطالعه کنید. اما به طور خلاصه وب سایتی ریسپانسیو است که بدون به هم ریختگی در صفحه نمایش های مختلف به کاربر نمایش داده شود. طراحی فروشگاه اینترنتی در کاراوب به صورت کاملا ریسپانسیو انجام میشود</p><p id=\"itcdti\">امروزه سبک طراحی سایت تغییرات بسیاری کرده و اصطلاحا به Mobile First Design تغییر کرده! یعنی اول طراحی موبایل و بعد باقی صفحه نمایش ها! اهمیت طراحی فروشگاه اینترنتی به صورت ریسپانسیو به حدی بالاست که گوگل را مجبور به استفاده از الگوریتم Mobile First Index برای تمامی سایت ها کرد</p></div></div></div></section><section><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h2 class=\"title\">روش های تخفیف دهی در طراحی سایت فروشگاهی</h2><p id=\"iug9mk\">سیستم تخفیف دهی حرفه ای</p><div class=\"blue-line\"></div></div></div></div><p id=\"iktdwi\"> طراحی سایت فروشگاهی این امکان را به کسب و کار شما میدهد که با ایجاد سیستم های تخفیف مختلف برای مشتریانتان انگیزه ی خرید ایجاد کنید. شما میتوانید به سادگی تخفیف هایی مخصوص یک محصول، یک دسته بندی، یک یا چند کاربر و... داشته باشید.</p><p id=\"iyofyv\">امکان ایجاد کوپن تخفیف به سادگی از طریق پنل مدیریت قالب انجام است و همچنین این موضوع در کلیپ آموزشی پنل مدیریت به شما آموزش داده میشود.</p><ul class=\"kw-list1\"><li id=\"ihv4fm\">تخفیف بر اساس محصول</li><li id=\"ianzfm\">تخفیف بر اساس دسته بندی</li><li id=\"i21ae8\">تخفیف بر اساس کاربر یا کاربران</li></ul></div><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/pages/takhfif.png\" alt=\"طراحی سایت فروشگاهی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section><section id=\"i8bp4x\"><div class=\"container\"><div data-aos=\"fade-up\" class=\"contact aos-init aos-animate\"><div class=\"wrapper\"><div class=\"icon\"></div><div class=\"description\"><strong>به مشاوره نیاز دارید؟ همین حالا با ما تماس بگیرید</strong><p>مشاوره رایگان در رابطه با راه اندازی وب سایت شما</p></div></div><div class=\"call-btn\"><a href=\"\" class=\"kw-btn-blue\">تماس با کاراوب</a></div><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#4B3DA7\" fill-opacity=\"0.07\"></path></svg></div></div></section><section id=\"ijoi3e\"><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/pages/dargah.png\" alt=\"طراحی سایت فروشگاهی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h3 class=\"title\"> پرداخت آنلاین و درگاه های پرداخت</h3><p id=\"iuwqmf\">سیستم پرداخت آنلاین در طراحی سایت فروشگاهی</p><div class=\"blue-line\"></div></div></div></div><p id=\"i60pjk\">یکی از نکات بسیار مهم در طراحی وب سایت فروشگاهی، امنیت آن میباشد. اگر وب سایت از امنیت کافی برخوردار نباشد، پس درگاه های پرداخت نیز به خوبی عمل نخواهند کرد و این مساله وب سایت شما را با مشکل جدی مواجه میکند. کاراوب سعی کرده تا وب سایت فروشگاهی را با بهترین کیفیت ممکن طراحی و با بالاترین امنیت به شما تحویل دهد.</p></div></div></div></section><section><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h3 class=\"title\">نمایش چند مرحله ای موقعیت محصول</h3><p id=\"iv7pao\">وضعیت سفارش محصول مشتری</p><div class=\"blue-line\"></div></div></div></div><p id=\"i0dy6e\">یکی از امکانات جذاب دیگری که کاراوب در طراحی سایت فروشگاهی خود اعمال میکند، امکان مشاهده وضعیت فعلی محصول از طریق پنل کاربری میباشد. این امکان جذاب به مشتری حس اعتماد بیشتری را القاء میکند</p><ul class=\"kw-list1\"><li id=\"ij03xj\">نمایش وضعیت فعلی سفارش</li><li id=\"iilqvr\">تغییر وضعیت از طریق پنل مدیریت</li></ul></div><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/pages/marhale.png\" alt=\"طراحی وب سایت فروشگاهی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section>','طراحی سایت فروشگاهی | طراحی فروشگاه اینترنتی','طراحی سایت فروشگاهی از انواع دیگر طراحی سایت میباشد که گروه ما به صورت بسیار حرفه ای به انجام آن میپردازد. امروزه همه کسب و کار ها به سمت آنلاین شدن میروند! اگر میخواهید از رقبای خود عقب نمانید، از همین امروز به فکر باشید','طراحی سایت فروشگاهی , طراحی فروشگاه اینترنتی , ساخت سایت فروشگاهی , طراحی وب سایت فروشگاهی , طراحی سایت فروش اینترنتی','Article','online-store-web-design',1,'https://karawebs.com/backend/images/grapesjs/1624019759-online-store.png',1,'2020-08-05 07:08:35','2021-11-16 13:39:36',0,'945'),
(2,'طراحی سایت شرکتی','<section><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><div id=\"ij0qi\"></div><div id=\"iqy3l9\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M32.4175 9.2C32.5368 8.89036 32.5283 8.54599 32.3937 8.24265C32.2592 7.93931 32.0096 7.70185 31.7 7.5825C31.3904 7.46315 31.046 7.4717 30.7427 7.60626C30.4393 7.74081 30.2018 7.99036 30.0825 8.3L17.5825 40.8C17.5234 40.9533 17.4951 41.1168 17.4992 41.281C17.5032 41.4453 17.5396 41.6072 17.6063 41.7574C17.6729 41.9076 17.7684 42.0432 17.8875 42.1564C18.0065 42.2697 18.1467 42.3584 18.3 42.4175C18.4533 42.4766 18.6168 42.5049 18.781 42.5008C18.9453 42.4968 19.1072 42.4604 19.2573 42.3937C19.4075 42.3271 19.5432 42.2316 19.6564 42.1125C19.7697 41.9935 19.8584 41.8533 19.9175 41.7L32.4175 9.2V9.2Z\" fill=\"black\"></path><path d=\"M14.5626 15.3C14.6877 15.4067 14.7905 15.5371 14.8652 15.6836C14.9399 15.8302 14.9849 15.99 14.9976 16.154C15.0104 16.3179 14.9907 16.4828 14.9396 16.6391C14.8886 16.7955 14.8072 16.9402 14.7001 17.065L7.89758 25L14.6976 32.9375C14.8985 33.1908 14.9935 33.5122 14.9624 33.8341C14.9314 34.156 14.7769 34.4533 14.5313 34.6636C14.2857 34.874 13.9681 34.981 13.6453 34.9621C13.3225 34.9432 13.0195 34.8 12.8001 34.5625L5.30008 25.8125C5.10642 25.5861 5 25.2979 5 25C5 24.702 5.10642 24.4139 5.30008 24.1875L12.8001 15.4375C13.0159 15.1859 13.3228 15.0303 13.6534 15.005C13.9839 14.9797 14.3109 15.0867 14.5626 15.3025V15.3Z\" fill=\"black\"></path><path d=\"M35.4375 35.95C35.3128 35.8433 35.2102 35.7131 35.1358 35.5668C35.0614 35.4204 35.0165 35.2609 35.0037 35.0972C34.991 34.9336 35.0105 34.769 35.0614 34.6129C35.1122 34.4568 35.1933 34.3123 35.3 34.1875L42.105 26.25L35.3 18.315C35.1932 18.1903 35.1119 18.0457 35.0609 17.8895C35.0099 17.7334 34.9902 17.5687 35.0029 17.4049C35.0155 17.2411 35.0603 17.0815 35.1347 16.935C35.209 16.7885 35.3115 16.6581 35.4363 16.5513C35.561 16.4444 35.7056 16.3631 35.8618 16.3122C36.0179 16.2612 36.1826 16.2414 36.3464 16.2541C36.5101 16.2667 36.6698 16.3115 36.8163 16.3859C36.9628 16.4603 37.0932 16.5628 37.2 16.6875L44.7 25.4375C44.8937 25.6639 45.0001 25.9521 45.0001 26.25C45.0001 26.5479 44.8937 26.8361 44.7 27.0625L37.2 35.8125C37.0933 35.9373 36.9631 36.0398 36.8168 36.1142C36.6705 36.1887 36.5109 36.2335 36.3473 36.2463C36.1836 36.2591 36.019 36.2395 35.8629 36.1886C35.7068 36.1378 35.5623 36.0567 35.4375 35.95V35.95Z\" fill=\"black\"></path></svg></div></div><div class=\"title-box\"><h2 class=\"title\"> طراحی سایت شرکتی در کاراوب</h2><p id=\"i7s6l\"> <strong>بررسی این نوع وب سایت</strong></p><div class=\"blue-line\"></div></div></div></div><p id=\"ivq9j\">در دنیای امروز، آنلاین بودن تمام یا بخشی از کسب و کار به امری ضروری تبدیل شده است. شرکت ها و برند های معروف یا کسانی که تازه کار خود را شروع کرده اند برای ایجاد تعامل بیشتر با مشتری و نمایش ویترین کالا های خود در دنیای اینترنت نیاز به <a data-cke-saved-href=\"https://karawebs.com\" href=\"https://karawebs.com\">طراحی یک سایت حرفه ای</a> و شیک دارند. اما طراحی سایت شرکتی کدام نیاز برند یا شرکت شما را تامین میکند؟</p><p id=\"ifxr5a\">گروه <a data-cke-saved-href=\"https://karawebs.com\" href=\"https://karawebs.com\">طراحی سایت</a> کاراوب با طراحی یک وب سایت بسیار شیک و درخور برند شما، خدمات و محصولات شما را به بهترین شکل ممکن برای مشتریانتان به نمایش میگذارد.  برای مثال شما یک شرکت فروش عطر دارید، کاربری که وارد وب سایت میشود باید به خوبی بتواند با سایت ارتباط برقرار کرده و وب سایت شما را تکر نکند.</p><ul class=\"kw-list1\"><li>پشتیبانی 24 ساعته</li><li id=\"ijvip\">امنیت فوق العاده</li><li id=\"ibx5j\">سئوی استاندارد</li><li id=\"i9yzf\">امکان ارتقاء به سایت فروشگاهی</li><li id=\"ih8pa\">پنل مدیریت حرفه ای</li></ul><a href=\"#faqs\" class=\"kw-btn-blue\">سوالات متداول</a><a href=\"https://karawebs.com/company-webdesign-price\" class=\"kw-btn-blue\">تعرفه و امکانات</a></div><div class=\"col-md-6\"><img src=\"/backend/images/grapesjs/1624019759-online-store.png\" alt=\"طراحی سایت شرکتی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section><section class=\"kw-p\"><div class=\"container\"><div id=\"iithp4\" class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 28 31\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" id=\"ip30j\"><path d=\"M16.2511 4.875H17.8761V3.25C17.8761 2.81902 17.7049 2.4057 17.4002 2.10095C17.0954 1.79621 16.6821 1.625 16.2511 1.625H11.3761C10.9451 1.625 10.5318 1.79621 10.2271 2.10095C9.92233 2.4057 9.75113 2.81902 9.75113 3.25V4.875H11.3761V8.242L2.08925 24.3262C1.79293 24.8195 1.63286 25.3825 1.62539 25.9578C1.61792 26.5331 1.76333 27.1001 2.04675 27.6009C2.33016 28.1016 2.74143 28.5181 3.23854 28.8079C3.73564 29.0976 4.30075 29.2502 4.87613 29.25H22.7511C23.3265 29.2502 23.8916 29.0976 24.3887 28.8079C24.8858 28.5181 25.2971 28.1016 25.5805 27.6009C25.8639 27.1001 26.0093 26.5331 26.0019 25.9578C25.9944 25.3825 25.8343 24.8195 25.538 24.3262L16.2511 8.242V4.875ZM4.87613 30.875C3.99846 30.8752 3.13702 30.6385 2.38272 30.1898C1.62842 29.7411 1.00924 29.0971 0.590535 28.3257C0.171827 27.5544 -0.0308794 26.6843 0.00381014 25.8073C0.0384997 24.9303 0.309298 24.079 0.787625 23.3431L9.75113 7.81787V6.5C9.32015 6.5 8.90682 6.32879 8.60208 6.02405C8.29733 5.7193 8.12613 5.30598 8.12613 4.875V3.25C8.12613 2.38805 8.46854 1.5614 9.07803 0.951903C9.68752 0.34241 10.5142 0 11.3761 0H16.2511C17.1131 0 17.9397 0.34241 18.5492 0.951903C19.1587 1.5614 19.5011 2.38805 19.5011 3.25V4.875C19.5011 5.30598 19.3299 5.7193 19.0252 6.02405C18.7204 6.32879 18.3071 6.5 17.8761 6.5V7.81787L26.8396 23.3431C27.318 24.079 27.5888 24.9303 27.6234 25.8073C27.6581 26.6843 27.4554 27.5544 27.0367 28.3257C26.618 29.0971 25.9988 29.7411 25.2445 30.1898C24.4902 30.6385 23.6288 30.8752 22.7511 30.875H4.87613ZM15.1039 19.9745L17.7461 17.3323L22.7511 26H4.87613L10.8236 15.6975L15.1039 19.9745ZM15.1039 22.2722L11.173 18.343L7.69062 24.375H19.9366L17.3984 19.9777L15.1039 22.2722ZM14.6261 11.375C15.0571 11.375 15.4704 11.5462 15.7752 11.851C16.0799 12.1557 16.2511 12.569 16.2511 13C16.2511 13.431 16.0799 13.8443 15.7752 14.149C15.4704 14.4538 15.0571 14.625 14.6261 14.625C14.1951 14.625 13.7818 14.4538 13.4771 14.149C13.1723 13.8443 13.0011 13.431 13.0011 13C13.0011 12.569 13.1723 12.1557 13.4771 11.851C13.7818 11.5462 14.1951 11.375 14.6261 11.375V11.375Z\" fill=\"#288ED9\"></path></svg></div></div><div class=\"title-box\"><h3 class=\"title\"> برخی نمونه کار ها</h3><p id=\"i6kfnf\">خلاقیت، کیفیت، زیبایی</p><div class=\"blue-line\"></div></div></div></div><div id=\"i0uqh\" class=\"row\"><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1611133274screencapture-faraneng-2021-01-20-12_30_01.jpg\" alt=\"\" id=\"ivo4b\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">وب سایت شرکت فاران</h3><p class=\"subtitle\">طراحی سایت شرکتی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/faran\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1611133658screencapture-zhavandish-2021-01-20-12_36_42.jpg\" alt=\"\" id=\"ive1u\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">شرکت ژاواندیش</h3><p class=\"subtitle\">طراحی سایت شرکتی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/zhavandish\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1611134790screencapture-tsi-piping-2021-01-20-12_55_38.jpg\" alt=\"\" id=\"iafqy\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">شرکت TSI</h3><p class=\"subtitle\">طراحی سایت شرکتی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/tsi\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1611134628screencapture-pnspouya-2021-01-20-12_52_54.jpg\" alt=\"\" id=\"ig75id\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">شرکت PNS</h3><p class=\"subtitle\">طراحی سایت شرکتی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/pns\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div></div></div></section><section id=\"iz6v0x\"><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><img src=\"/backend/images/grapesjs/1624030974-panel.png\" alt=\"طراحی وب سایت شرکتی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h3 class=\"title\">پنل مدیریت اختصاصی سایت شرکتی</h3><p id=\"i0bxlb\">پنل مدیریتی حرفه ای...</p><div class=\"blue-line\"></div></div></div></div><p id=\"i6qmdu\">گروه کاراوب با استفاده از کد نویسی اختصاصی، پنل مدیریت حرفه ای را برای وب سایت شرکتی شما طراحی خواهد کرد و بعد از اتمام کار طراحی سایت شرکتی تمام جزئیات آن را در قالب یک ویدیوی آموزشی به شما آموزش خواهد داد.</p><ul class=\"kw-list1\"><li id=\"i25uh8\">هاست حرفه ای</li><li id=\"ia6iuw\">امنیت پنل مدیریت</li><li id=\"ixmdnh\">سهولت کار با پنل</li></ul></div></div></div></section><section class=\"what-we-do pt-5 pb-5\"><div class=\"container\"><div class=\"row\"><div class=\"col-md-12\"><div class=\"section-head justify-content-center\"><div class=\"section-title\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M40.625 45.8333C42.3479 45.8333 43.75 44.4313 43.75 42.7083V35.4167C43.75 33.6938 42.3479 32.2917 40.625 32.2917C38.1875 32.2917 35.7916 31.9083 33.5 31.1521C32.9522 30.9791 32.3677 30.9581 31.8089 31.0913C31.2501 31.2245 30.7379 31.5069 30.327 31.9083L27.327 34.9083C22.1419 32.0934 17.8834 27.8363 15.0666 22.6521L18.0416 19.6583C18.9 18.8625 19.2083 17.6521 18.8416 16.4875C18.0869 14.1923 17.7043 11.7911 17.7083 9.375C17.7083 7.65208 16.3062 6.25 14.5833 6.25H7.29163C5.56871 6.25 4.16663 7.65208 4.16663 9.375C4.16663 29.4792 20.5208 45.8333 40.625 45.8333ZM7.29163 8.33333H14.5833C14.8596 8.33333 15.1245 8.44308 15.3199 8.63843C15.5152 8.83378 15.625 9.09873 15.625 9.375C15.625 12.0354 16.0416 14.6479 16.8604 17.125C16.9205 17.3048 16.9276 17.498 16.8806 17.6817C16.8337 17.8653 16.7348 18.0316 16.5958 18.1604L12.5208 22.2563C15.9312 28.9813 20.9687 34.0188 27.725 37.4583L31.7854 33.3958C31.9239 33.2587 32.0971 33.1619 32.2865 33.1156C32.4759 33.0694 32.6742 33.0755 32.8604 33.1333C35.352 33.9583 37.9645 34.375 40.625 34.375C41.1979 34.375 41.6666 34.8438 41.6666 35.4167V42.7083C41.6666 43.2813 41.1979 43.75 40.625 43.75C21.6708 43.75 6.24996 28.3292 6.24996 9.375C6.24996 9.09873 6.35971 8.83378 6.55506 8.63843C6.75041 8.44308 7.01536 8.33333 7.29163 8.33333Z\" fill=\"#288ED9\"></path></svg></div><div class=\"title-box\"><h2 class=\"title\">\n                                تماس با گروه کاراوب\n                            </h2><p>مشاوره رایگان جهت راه اندازی وب سایت...</p><div class=\"blue-line\"></div></div></div></div></div><div class=\"col-md-12\"><div class=\"d-flex justify-content-center\"><div class=\"contact-us\"><p class=\"contact-phone\">021-77200630</p></div></div></div></div></div></section><section id=\"iujubi\"><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/sherkati/res-1.png\" alt=\"طراحی سایت شرکتی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h3 class=\"title\">طراحی ریسپانسیو سایت شرکتی</h3><p id=\"io5agx\">مناسب برای تمامی نمایشگر ها</p><div class=\"blue-line\"></div></div></div></div><p id=\"ieyzrg\">با افزایش استفاده مردم از تلفن های همراه و تبلت ها طراحی ریسپانسیو سایت به یک الزام تبدیل شده، تقریبا تمامی وب سایت های طراحی شده توسط گروه طراحی سایت کاراوب به صورت ریسپانسیو یا واکنشگرا طراحی میشوند. طراحی ریسپانسیو سایت شرکتی باعث افزایش رتبه سئو نیز خواهد شد. زیرا گوگل به کاربران موبایل اهمیت بسیار زیادی میدهد. طراحی سایت شرکتی شما با آخرین متد های جهانی انجام خواهد شد.</p></div></div></div></section><section id=\"inzibp\"><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div id=\"i5l95y\" class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h3 class=\"title\">سیستم چت آنلاین و پشتیبانی</h3><p id=\"iv9c94\">معرفی امکانات</p><div class=\"blue-line\"></div></div></div></div><p id=\"iq1y3l\">این امکان بسیار جذاب در طراحی سایت شرکتی شما استفاده خواهد شد! به این صورت که شما عزیزان میتوانید اپلیکیشن چت را روی گوشی موبایل خود نصب کنید و با مشتریانتان در ارتباط باشید! یک سایت شرکتی خوب نیازمند امکانات خوب نیز هست، با استفاده از سیستم چت آنلاین شما میتوانید به مشتریانتان مشاوره دهید و به راحتی با آنها در ارتباط باشید.</p><ul class=\"kw-list1\"><li id=\"iwth8k\">ااپلیکیشن موبایل برای چت آنلاین</li><li id=\"iep7mr\">دسترسی به گفتگو ها از طریق پنل مدیریت</li><li id=\"i9wgyp\">امکان نمایش کاربران آنلاین در وب سایت شما</li></ul><a href=\"https://karawebs.com/portfolios\" title=\"نمونه کارها\" class=\"kw-btn-blue\">نمونه کارها</a></div><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/sherkati/chat.png\" alt=\"طراحی وبسایت شرکتی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section><section id=\"i8bp4x\"><div class=\"container\"><div data-aos=\"fade-up\" class=\"contact aos-init aos-animate\"><div class=\"wrapper\"><div class=\"icon\"></div><div class=\"description\"><strong>به مشاوره نیاز دارید؟ همین حالا با ما تماس بگیرید</strong><p>مشاوره رایگان در رابطه با راه اندازی وب سایت شما</p></div></div><div class=\"call-btn\"><a href=\"\" class=\"kw-btn-blue\">تماس با کاراوب</a></div><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#4B3DA7\" fill-opacity=\"0.07\"></path></svg></div></div></section><section id=\"ijoi3e\"><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/sherkati/support-2.png\" alt=\"طراحی وب سایت شرکتی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h3 class=\"title\">پشتیبانی 24 ساعته</h3><p id=\"iuwqmf\">کاراوب همیشه آماده ی حل مشکلات شماست!</p><div class=\"blue-line\"></div></div></div></div><p id=\"i60pjk\">یکی از مهمترین مسائل در انتخاب طراح سایت، مساله ی پشتیبانی وب سایت است، همانطور که خودروی شما بعد از چندین کیلومتر کارکرد نیاز به سرویس شدن توسط مکانیک دارد، طراحی سایت شرکتی هم نیاز به به روز رسانی و پشتیبانی دارد! پشتیبانی طراحی وب سایت شرکتی در گروه کاراوب از 6 ماه تا یکسال رایگان است و پس از آن با پرداخت 30 درصد مبلغ کل قرارداد این پشتیبانی برای یکسال تمدید میشود.</p></div></div></div></section><section><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h3 class=\"title\"> نمایش محصولات در طراحی سایت شرکتی</h3><p id=\"iv7pao\">نمایش محصولات و نمونه کار های شما</p><div class=\"blue-line\"></div></div></div></div><p id=\"i0dy6e\">به زیبایی هرجه تمام تر میتوانید محصولات مورد نظر شرکت خود را در سایت قرار داده و برای هرکدام از محصولات جزئیات و دسته بندی تعریف کنید</p></div><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/sherkati/products.png\" alt=\"طراحی سایت شرکتی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section>','طراحی سایت شرکتی | طراحی وب سایت شرکتی | طراحی سایت شرکتی حرفه ای','راه اندازی یک سایت شخصیت کاری شما را شکل خواهد داد، اما طراحی سایت شرکتی چه امکاناتی باید داشته باشد؟ امکانات عالی کاراوب را مطالعه کنید...','طراحی سایت شرکتی , طراحی وب سایت شرکتی , طراحی سایت شرکتی حرفه ای','Article','company-webdesign',1,'https://karawebs.com/backend/images/grapesjs/1624030974-panel.png',1,'2020-08-05 07:28:06','2021-11-16 13:39:47',0,'920'),
(3,'طراحی لوگو حرفه ای','<p>&nbsp;</p>\r\n<!-- Start Header Content -->\r\n<div class=\"head-content\">\r\n<div class=\"container\">\r\n<div class=\"row row-aligns\">\r\n<div class=\"col-md-6 order-2 order-md-1\">\r\n<div class=\"head-txt\">\r\n<h2 style=\"box-sizing: border-box; margin: 0px; padding: 0px 0px 10px; border: 0px; outline: 0px; font-size: 26px; text-size-adjust: 100%; vertical-align: baseline; background: #ffffff; color: #333333; line-height: 1em; font-weight: 500; font-family: iranyekanwebregular_FaNum; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; letter-spacing: normal; orphans: 2; text-align: right; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial;\"><span style=\"font-family: IRY;\">طراحی لوگو در کاراوب، حرفه ای و به صرفه!</span></h2>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; text-size-adjust: 100%; vertical-align: baseline; background: #ffffff; font-family: iranyekanwebregular_FaNum; color: #666666; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 300; letter-spacing: normal; orphans: 2; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial; text-align: justify; line-height: 2;\"><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: large; text-size-adjust: 100%; vertical-align: baseline; background: transparent; font-family: IRY;\">ساخت لوگو یکی از اساسی ترین مباحثی است که باید برای کسب و کار خود به آن بپردازید. از ارکان مهم برند سازی در دنیای امروز داشتن یک لوگوی متناسب با کسب و کار شماست! طراحی آرم خوب از دکوراسیون تا سبک کاری و کلاس کاری شما را به مخاطبانتان میرساند. طراحی لوگو در گروه کاراوب به چند روش انجام میشود. شما عزیزان میتوانید همین حالا از طریق فرم سفارش سریع و حرفه ای <a style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 18px; text-size-adjust: 100%; vertical-align: baseline; background: transparent; color: #ff1158; text-decoration: none; font-family: iranyekanwebregular_FaNum !important;\" href=\"../../../logodesign/\" aria-invalid=\"true\">طراحی لوگو احتصاصی</a> خود را سفارش دهید.</span></p>\r\n<div class=\"head-buttons\" style=\"text-align: center;\"><a class=\"bttn btn-purple\" href=\"../../../products?search=%D8%B7%D8%B1%D8%A7%D8%AD%DB%8C+%D9%84%D9%88%DA%AF%D9%88\">سفارش آنلاین</a> <a class=\"bttn btn-purple\" href=\"#h_6251962896021600176826123\">تعرفه ها</a></div>\r\n</div>\r\n</div>\r\n<div class=\"col-md-6 order-1 order-md-2\">\r\n<div class=\"head-img\" style=\"text-align: center;\"><img class=\"img-fluid fr-fic fr-dii img-responsive\" style=\"max-width: 100%; height: auto;\" src=\"../../../images/2020/Main/undraw_interaction_design_odgc (1).png\" alt=\"طراحی لوگو\" width=\"540\" height=\"402\" /></div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<!-- End Header Content --><!-- Background Shape-->\r\n<div class=\"background-shapes\">\r\n<div class=\"box1\">&nbsp;</div>\r\n<div class=\"box2\">&nbsp;</div>\r\n<div class=\"box3\">&nbsp;</div>\r\n<div class=\"dot1\">&nbsp;</div>\r\n<div class=\"dot2\">&nbsp;</div>\r\n<div class=\"heart1\">&nbsp;</div>\r\n<div class=\"heart2\">&nbsp;</div>\r\n<div class=\"circle2\">&nbsp;</div>\r\n</div>\r\n<!-- Start Random Post -->\r\n<section id=\"random-post\" class=\"random-post\">\r\n<div class=\"container\">\r\n<div class=\"first-post\">\r\n<div class=\"row row-aligns\">\r\n<div class=\"col-md-6\">\r\n<div class=\"post-img\"><img class=\"img-fluid fr-fic fr-dii img-responsive\" style=\"max-width: 100%; height: auto;\" src=\"../../../images/2020/Main/undraw_circles_y7s2 (1).png\" alt=\"طراحی آرم\" width=\"540\" height=\"343\" /></div>\r\n</div>\r\n<div class=\"col-md-6\">\r\n<div class=\"post-txt\"><span class=\"label label-purple\" style=\"background-color: #fd7e14;\">مراحل ساخت لوگو</span>\r\n<h2 style=\"box-sizing: border-box; margin: 0px; padding: 0px 0px 10px; border: 0px; outline: 0px; font-size: 26px; text-size-adjust: 100%; vertical-align: baseline; background: #ffffff; color: #333333; line-height: 2; font-weight: 500; font-family: iranyekanwebregular_FaNum; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; letter-spacing: normal; orphans: 2; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial; text-align: justify;\"><span style=\"font-family: IRY;\">مراحل ساخت لوگو در کاراوب</span></h2>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px 0px 1em; border: 0px; outline: 0px; font-size: 14px; text-size-adjust: 100%; vertical-align: baseline; background: #ffffff; font-family: iranyekanwebregular_FaNum; color: #666666; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 300; letter-spacing: normal; orphans: 2; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial; text-align: justify; line-height: 2;\"><span style=\"font-family: IRY; font-size: 18px;\">گروه طراحی<span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; text-size-adjust: 100%; vertical-align: baseline; background: transparent;\">&nbsp;</span><a style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; text-size-adjust: 100%; vertical-align: baseline; background: transparent; color: #ff1158; text-decoration: none; font-family: iranyekanwebregular_FaNum !important;\" href=\"../../../\"><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; text-size-adjust: 100%; vertical-align: baseline; background: transparent;\">کاراوب&nbsp;</span></a>در تلاش است تا در تعامل با مشتری بتواند رضایت او را جلب کند.<span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; text-size-adjust: 100%; vertical-align: baseline; background: transparent;\">&nbsp;طراحی آرم&nbsp;</span>در کاراوب چند مرحله ی ساده اما کارآمد دارد.</span></p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px 0px 1em; border: 0px; outline: 0px; font-size: 14px; text-size-adjust: 100%; vertical-align: baseline; background: #ffffff; font-family: iranyekanwebregular_FaNum; color: #666666; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 300; letter-spacing: normal; orphans: 2; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial; text-align: justify; line-height: 2;\"><span style=\"font-size: 18px;\"><span style=\"font-family: IRY;\">برای گروه ما رضایت شما از همه چیز مهمتر است.</span></span></p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px 0px 1em; border: 0px; outline: 0px; font-size: 14px; text-size-adjust: 100%; vertical-align: baseline; background: #ffffff; font-family: iranyekanwebregular_FaNum; color: #666666; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 300; letter-spacing: normal; orphans: 2; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial; text-align: justify; line-height: 2;\"><span style=\"font-size: 18px;\"><span style=\"font-family: IRY;\">ویرایش های بسیاری انجام میشود تا شما را به طراح مورد نظرتان برسانیم.</span></span></p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px 0px 1em; border: 0px; outline: 0px; font-size: 14px; text-size-adjust: 100%; vertical-align: baseline; background: #ffffff; font-family: iranyekanwebregular_FaNum; color: #666666; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 300; letter-spacing: normal; orphans: 2; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial; text-align: justify; line-height: 2;\"><span style=\"font-family: IRY; font-size: 18px;\">از نمونه کار های کاراوب در ابتدای همین صفحه دیدن کنید</span></p>\r\n<a href=\"#\">&nbsp;</a></div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"second-post\">\r\n<div class=\"row row-aligns\">\r\n<div class=\"col-md-6 order-2 order-md-1\">\r\n<div class=\"post-txt\"><span class=\"label label-purple\" style=\"background-color: #fd7e14;\">ویژگی عالی</span>\r\n<h3 style=\"box-sizing: border-box; margin: 0px; padding: 0px 0px 10px; border: 0px; outline: 0px; font-size: 22px; text-size-adjust: 100%; vertical-align: baseline; background: #ffffff; color: #333333; line-height: 2; font-weight: 500; font-family: iranyekanwebregular_FaNum; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; letter-spacing: normal; orphans: 2; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial; text-align: justify;\"><span style=\"font-family: IRY; font-size: 18px;\">طراحی آرم خود را به تیم حرفه ای کاراوب بسپارید!</span></h3>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; text-size-adjust: 100%; vertical-align: baseline; background: #ffffff; font-family: iranyekanwebregular_FaNum; color: #666666; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 300; letter-spacing: normal; orphans: 2; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial; text-align: justify; line-height: 2;\"><span style=\"font-family: IRY; font-size: 18px;\">به این مراحل جهت درک بهتر مراحل<span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; text-size-adjust: 100%; vertical-align: baseline; background: transparent;\">&nbsp;ساخت لوگو&nbsp;</span>دقت کنید. همچنین شما میتوانید به صورت 24 ساعته با کارشناسان ما در ارتباط باشید. چه از طریق سیستم چت آنلاین چه از طریق سیستم تیکتینگ. فقط کافیست در کاراوب عضو شوید. از اصل مطلب دور نشیم. به مراحل زیر توجه کنید</span>:</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; text-size-adjust: 100%; vertical-align: baseline; background: #ffffff; font-family: iranyekanwebregular_FaNum; color: #666666; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 300; letter-spacing: normal; orphans: 2; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial; text-align: justify; line-height: 2;\">&nbsp;</p>\r\n<span class=\"dots\">&nbsp;</span></div>\r\n</div>\r\n<div class=\"col-md-6 order-1 order-md-2\">\r\n<div class=\"post-img\"><img class=\"img-fluid fr-fic fr-dii img-responsive\" style=\"max-width: 100%; height: auto;\" src=\"../../../images/2020/Main/undraw_pair_programming_njlp (1).png\" alt=\"طراحی آرم\" width=\"540\" height=\"354\" /></div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</section>\r\n<!-- End Try Our Trial --><!-- Start Working -->\r\n<section id=\"start-working\" class=\"start-working\">\r\n<div class=\"overlay\">&nbsp;</div>\r\n<div class=\"container\">\r\n<div class=\"row row-aligns\">\r\n<div class=\"col-lg-3\">&nbsp;</div>\r\n<div class=\"col-lg-6\">\r\n<p>برای ثبت سفارش و مشاوره رایگان با شماره های زیر تماس بگیرید:</p>\r\n<p>تلفن: 778801014-021</p>\r\n<p>موبایل: 09058775382</p>\r\n<p>همچنین میتوانید از طریق چت آنلاین با همکاران ما در ارتباط باشید.</p>\r\n</div>\r\n<div class=\"col-lg-3\">&nbsp;</div>\r\n</div>\r\n<br /><br />\r\n<div class=\"owl-dots disabled\">&nbsp;</div>\r\n</div>\r\n</section>\r\n<!-- End Testimonials --><!-- Start Pricing Table -->\r\n<section id=\"pricing-table\" class=\"pricing-table\">\r\n<div class=\"container\">\r\n<div class=\"section-pricing\">\r\n<div>\r\n<p style=\"text-align: justify;\">امکان ویرایش بعد از طراحی وجود دارد؟</p>\r\n<p style=\"text-align: justify;\">امکان ویرایش طراحی تا 3 بار برای هر لوگو وجود دارد.</p>\r\n<p style=\"text-align: justify;\">تجربه نشان داده بعد از 2 ویرایش طراحی به طرح مد نظر میرسد.</p>\r\n<p style=\"text-align: justify;\">2 طرح لایه باز با هم متفاوت بوده و شما میتوانید بین آنها انتخاب کنید.</p>\r\n<p style=\"text-align: justify;\">هزینه طراحی لوگوی اختصاصی</p>\r\n<p style=\"text-align: justify;\">هزینه به پارامتر های مختلفی بستگی دارد. شما عزیزان میتوانید پکیج به صرفه تر را برای کسب و کار خود انتخاب کنید. هزینه طراحی لوگو در گروه طراحی کاراوب نسبت به دیگر طراحان بسیار مقرون به صرفه تر است.</p>\r\n<p style=\"text-align: justify;\">&nbsp;</p>\r\n<p style=\"text-align: justify;\">&nbsp;</p>\r\n<p style=\"text-align: justify;\">&nbsp;</p>\r\n</div>\r\n<h3 id=\"h_6251962896021600176826123\">تعرفه های طراحی لوگو</h3>\r\n</div>\r\n<div class=\"row\"><!-- Start Price Item -->\r\n<div class=\"col-md-4\">\r\n<div class=\"price-item\">\r\n<div class=\"table-ico\">&nbsp;</div>\r\n<h4>لوگو تایپ</h4>\r\n<div class=\"price-value\">\r\n<h5 style=\"text-align: center;\">780.000 تومان</h5>\r\n</div>\r\n<div class=\"price-details\">\r\n<ul class=\"list-unstyled\" style=\"text-align: center;\">\r\n<li class=\"co-green\">ارائه ی 2 طرح</li>\r\n<li class=\"co-green\">ویرایش تا 2 مرحله</li>\r\n<li class=\"co-green\">زمان 7 روز کاری</li>\r\n</ul>\r\n</div>\r\n<div class=\"price-btn\" style=\"text-align: center;\"><a class=\"bttn btn-purple\" href=\"../../../products/logo-esm\">سفارش آنلاین</a></div>\r\n</div>\r\n</div>\r\n<!-- End Price Item --> <!-- Start Price Item -->\r\n<div class=\"col-md-4\">\r\n<div class=\"price-item active\" style=\"text-align: center;\"><img class=\"fr-fil fr-dib img-responsive\" style=\"max-width: 100%; height: auto;\" src=\"img/blob-shape-1.svg\" alt=\"Hotan Template\" />\r\n<div class=\"table-ico\">&nbsp;</div>\r\n<h4>لوگو تصویر</h4>\r\n<div class=\"price-value\">\r\n<h5 style=\"text-align: center;\">1.500.000 تومان</h5>\r\n</div>\r\n<div class=\"price-details\">\r\n<ul class=\"list-unstyled\" style=\"text-align: center;\">\r\n<li>ارائه ی 2 طرح</li>\r\n<li>ویرایش تا 3 مرحله</li>\r\n<li>زمان 7 روز کاری</li>\r\n</ul>\r\n</div>\r\n<div class=\"price-btn\" style=\"text-align: center;\"><a class=\"bttn btn-purple\" href=\"../../../products/logo-tasvir\">سفارش آنلاین</a></div>\r\n</div>\r\n</div>\r\n<div class=\"col-md-4\">\r\n<div class=\"price-item\">\r\n<h4>لوگو ترکیبی</h4>\r\n<div class=\"price-value\">\r\n<h5 style=\"text-align: center;\">2.000.000 تومان</h5>\r\n</div>\r\n<div class=\"price-details\">\r\n<ul class=\"list-unstyled\" style=\"text-align: center;\">\r\n<li>ارائه ی 2 طرح</li>\r\n<li>ویرایش تا 4 مرحله</li>\r\n<li>زمان 10 روز کاری</li>\r\n</ul>\r\n</div>\r\n<div class=\"price-btn\"><a class=\"bttn btn-purple\" href=\"../../../products/logo-tarkibi\">سفارش آنلاین</a></div>\r\n</div>\r\n</div>\r\n<!-- End Price Item --></div>\r\n</div>\r\n</section>\r\n<!-- End Pricing Table -->\r\n<p>&nbsp;</p>','طراحی لوگو حرفه ای | ساخت لوگو | طراحی آرم | گروه کاراوب','ساخت لوگو ( طراحی لوگو ) یکی از اساسی ترین مباحثی است که باید برای کسب و کار خود به آن بپردازید. طراحی آرم خوب از دکوراسیون تا سبک کاری...','طراحی لوگو , ساخت لوگو , طراحی آرم','Article','logo',1,NULL,1,'2020-08-05 09:05:34','2021-06-19 07:23:03',0,'978'),
(4,'طراحی سایت پزشکی','<section><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><div id=\"ij0qi\"></div><div id=\"i6pw2z\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M32.4175 9.2C32.5368 8.89036 32.5283 8.54599 32.3937 8.24265C32.2592 7.93931 32.0096 7.70185 31.7 7.5825C31.3904 7.46315 31.046 7.4717 30.7427 7.60626C30.4393 7.74081 30.2018 7.99036 30.0825 8.3L17.5825 40.8C17.5234 40.9533 17.4951 41.1168 17.4992 41.281C17.5032 41.4453 17.5396 41.6072 17.6063 41.7574C17.6729 41.9076 17.7684 42.0432 17.8875 42.1564C18.0065 42.2697 18.1467 42.3584 18.3 42.4175C18.4533 42.4766 18.6168 42.5049 18.781 42.5008C18.9453 42.4968 19.1072 42.4604 19.2573 42.3937C19.4075 42.3271 19.5432 42.2316 19.6564 42.1125C19.7697 41.9935 19.8584 41.8533 19.9175 41.7L32.4175 9.2V9.2Z\" fill=\"black\"></path><path d=\"M14.5626 15.3C14.6877 15.4067 14.7905 15.5371 14.8652 15.6836C14.9399 15.8302 14.9849 15.99 14.9976 16.154C15.0104 16.3179 14.9907 16.4828 14.9396 16.6391C14.8886 16.7955 14.8072 16.9402 14.7001 17.065L7.89758 25L14.6976 32.9375C14.8985 33.1908 14.9935 33.5122 14.9624 33.8341C14.9314 34.156 14.7769 34.4533 14.5313 34.6636C14.2857 34.874 13.9681 34.981 13.6453 34.9621C13.3225 34.9432 13.0195 34.8 12.8001 34.5625L5.30008 25.8125C5.10642 25.5861 5 25.2979 5 25C5 24.702 5.10642 24.4139 5.30008 24.1875L12.8001 15.4375C13.0159 15.1859 13.3228 15.0303 13.6534 15.005C13.9839 14.9797 14.3109 15.0867 14.5626 15.3025V15.3Z\" fill=\"black\"></path><path d=\"M35.4375 35.95C35.3128 35.8433 35.2102 35.7131 35.1358 35.5668C35.0614 35.4204 35.0165 35.2609 35.0037 35.0972C34.991 34.9336 35.0105 34.769 35.0614 34.6129C35.1122 34.4568 35.1933 34.3123 35.3 34.1875L42.105 26.25L35.3 18.315C35.1932 18.1903 35.1119 18.0457 35.0609 17.8895C35.0099 17.7334 34.9902 17.5687 35.0029 17.4049C35.0155 17.2411 35.0603 17.0815 35.1347 16.935C35.209 16.7885 35.3115 16.6581 35.4363 16.5513C35.561 16.4444 35.7056 16.3631 35.8618 16.3122C36.0179 16.2612 36.1826 16.2414 36.3464 16.2541C36.5101 16.2667 36.6698 16.3115 36.8163 16.3859C36.9628 16.4603 37.0932 16.5628 37.2 16.6875L44.7 25.4375C44.8937 25.6639 45.0001 25.9521 45.0001 26.25C45.0001 26.5479 44.8937 26.8361 44.7 27.0625L37.2 35.8125C37.0933 35.9373 36.9631 36.0398 36.8168 36.1142C36.6705 36.1887 36.5109 36.2335 36.3473 36.2463C36.1836 36.2591 36.019 36.2395 35.8629 36.1886C35.7068 36.1378 35.5623 36.0567 35.4375 35.95V35.95Z\" fill=\"black\"></path></svg></div></div><div class=\"title-box\"><h2 class=\"title\">طراحی سایت <span id=\"iu4zf\">پزشکی </span>، مطب دوم پزشکان!</h2><p id=\"i7s6l\"> <strong>بررسی این نوع وب سایت</strong></p><div class=\"blue-line\"></div></div></div></div><p id=\"ivq9j\">روز به روز روند زنگی مردم تغییر میکند و به سمت و سوی آنلاین شدن میرود، پزشکان هم از این قاعده مستثنی نیستند، اگر پزشک هستید و به دنبال طراحی سایت پزشکی برای خود و مطب خود میباشید، میتوانید همین حالا وب سایت پزشکی خود را به صورتآنلاین سفارش دهید یا از مشاوره آنلاین بهره ببرید </p><ul class=\"kw-list1\"><li>پشتیبانی 24 ساعته</li><li id=\"ijvip\">امنیت فوق العاده</li><li id=\"ibx5j\">سئوی استاندارد</li><li id=\"i9yzf\">امکان ارتقاء به سایت </li><li id=\"ih8pa\">پنل مدیریت حرفه ای</li></ul><a href=\"#faqs\" class=\"kw-btn-blue\">سوالات متداول</a><a href=\"https://karawebs.com/dr-webdesign-price\" class=\"kw-btn-blue\">تعرفه و امکانات</a></div><div class=\"col-md-6\"><img src=\"/backend/images/grapesjs/1624038352-dr.png\" alt=\"طراحی سایت پزشکی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section><section class=\"kw-p\"><div class=\"container\"><div id=\"iithp4\" class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 28 31\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" id=\"ip30j\"><path d=\"M16.2511 4.875H17.8761V3.25C17.8761 2.81902 17.7049 2.4057 17.4002 2.10095C17.0954 1.79621 16.6821 1.625 16.2511 1.625H11.3761C10.9451 1.625 10.5318 1.79621 10.2271 2.10095C9.92233 2.4057 9.75113 2.81902 9.75113 3.25V4.875H11.3761V8.242L2.08925 24.3262C1.79293 24.8195 1.63286 25.3825 1.62539 25.9578C1.61792 26.5331 1.76333 27.1001 2.04675 27.6009C2.33016 28.1016 2.74143 28.5181 3.23854 28.8079C3.73564 29.0976 4.30075 29.2502 4.87613 29.25H22.7511C23.3265 29.2502 23.8916 29.0976 24.3887 28.8079C24.8858 28.5181 25.2971 28.1016 25.5805 27.6009C25.8639 27.1001 26.0093 26.5331 26.0019 25.9578C25.9944 25.3825 25.8343 24.8195 25.538 24.3262L16.2511 8.242V4.875ZM4.87613 30.875C3.99846 30.8752 3.13702 30.6385 2.38272 30.1898C1.62842 29.7411 1.00924 29.0971 0.590535 28.3257C0.171827 27.5544 -0.0308794 26.6843 0.00381014 25.8073C0.0384997 24.9303 0.309298 24.079 0.787625 23.3431L9.75113 7.81787V6.5C9.32015 6.5 8.90682 6.32879 8.60208 6.02405C8.29733 5.7193 8.12613 5.30598 8.12613 4.875V3.25C8.12613 2.38805 8.46854 1.5614 9.07803 0.951903C9.68752 0.34241 10.5142 0 11.3761 0H16.2511C17.1131 0 17.9397 0.34241 18.5492 0.951903C19.1587 1.5614 19.5011 2.38805 19.5011 3.25V4.875C19.5011 5.30598 19.3299 5.7193 19.0252 6.02405C18.7204 6.32879 18.3071 6.5 17.8761 6.5V7.81787L26.8396 23.3431C27.318 24.079 27.5888 24.9303 27.6234 25.8073C27.6581 26.6843 27.4554 27.5544 27.0367 28.3257C26.618 29.0971 25.9988 29.7411 25.2445 30.1898C24.4902 30.6385 23.6288 30.8752 22.7511 30.875H4.87613ZM15.1039 19.9745L17.7461 17.3323L22.7511 26H4.87613L10.8236 15.6975L15.1039 19.9745ZM15.1039 22.2722L11.173 18.343L7.69062 24.375H19.9366L17.3984 19.9777L15.1039 22.2722ZM14.6261 11.375C15.0571 11.375 15.4704 11.5462 15.7752 11.851C16.0799 12.1557 16.2511 12.569 16.2511 13C16.2511 13.431 16.0799 13.8443 15.7752 14.149C15.4704 14.4538 15.0571 14.625 14.6261 14.625C14.1951 14.625 13.7818 14.4538 13.4771 14.149C13.1723 13.8443 13.0011 13.431 13.0011 13C13.0011 12.569 13.1723 12.1557 13.4771 11.851C13.7818 11.5462 14.1951 11.375 14.6261 11.375V11.375Z\" fill=\"#288ED9\"></path></svg></div></div><div class=\"title-box\"><h3 class=\"title\"> برخی نمونه کار ها</h3><p id=\"i6kfnf\">خلاقیت، کیفیت، زیبایی</p><div class=\"blue-line\"></div></div></div></div><div id=\"i0uqh\" class=\"row\"><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1619518884moshtaqi.jpg\" alt=\"\" id=\"ivo4b\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">داروخانه دکتر مشتاقی</h3><p class=\"subtitle\">طراحی سایت پزشکی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/moahtaqi-online\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1619521205zibajooyan.jpg\" alt=\"\" id=\"ive1u\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">رزرو آنلاین دکتر خشایار احمدی</h3><p class=\"subtitle\">طراحی سایت پزشکی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/dr-ahmadi\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1615448645screencapture-drasgari4clinic-2021-03-11-10_55_45.jpg\" alt=\"\" id=\"iafqy\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">کلینیک دکتر عسگری</h3><p class=\"subtitle\">طراحی سایت پزشکی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/drasgari\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" id=\"ismqxp\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1614420323mira.jpg\" alt=\"\" id=\"ig75id\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">فروشگاه میراکالا</h3><p class=\"subtitle\">طراحی سایت پزشکی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/mirakala\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div></div></div></section><section id=\"iz6v0x\"><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><img src=\"/backend/images/grapesjs/1624030974-panel.png\" alt=\"طراحی وب سایت پزشکی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h2 class=\"title\">امکانات سایت پزشکی چیست؟</h2><p id=\"ieficj\">بررسی امکانات</p><div class=\"blue-line\"></div></div></div></div><p id=\"i6qmdu\">مهمترین ویژگی یک سایت پزشکی، این است که شما میتوانید سیستم نوبت دهی آنلاین داشته باشید! مراجعه کنندگان به راحتی از نوبت دهی آنلاین نوبت دریافت میکنند و شما به راحتی اون رو مدیریت میکنید</p><ul class=\"kw-list1\"><li id=\"i25uh8\">افزایش کیفیت خدمت رسانی به بیماران</li><li id=\"ia6iuw\">ارائه مقالات پزشکی در بخش وبلاگ</li><li id=\"ixmdnh\">نوبت دهی آنلاین</li><li id=\"ib8y98\">پرسش های متداول مراجعه کنندگان</li></ul></div></div></div></section><section class=\"what-we-do pt-5 pb-5\"><div class=\"container\"><div class=\"row\"><div class=\"col-md-12\"><div class=\"section-head justify-content-center\"><div class=\"section-title\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M40.625 45.8333C42.3479 45.8333 43.75 44.4313 43.75 42.7083V35.4167C43.75 33.6938 42.3479 32.2917 40.625 32.2917C38.1875 32.2917 35.7916 31.9083 33.5 31.1521C32.9522 30.9791 32.3677 30.9581 31.8089 31.0913C31.2501 31.2245 30.7379 31.5069 30.327 31.9083L27.327 34.9083C22.1419 32.0934 17.8834 27.8363 15.0666 22.6521L18.0416 19.6583C18.9 18.8625 19.2083 17.6521 18.8416 16.4875C18.0869 14.1923 17.7043 11.7911 17.7083 9.375C17.7083 7.65208 16.3062 6.25 14.5833 6.25H7.29163C5.56871 6.25 4.16663 7.65208 4.16663 9.375C4.16663 29.4792 20.5208 45.8333 40.625 45.8333ZM7.29163 8.33333H14.5833C14.8596 8.33333 15.1245 8.44308 15.3199 8.63843C15.5152 8.83378 15.625 9.09873 15.625 9.375C15.625 12.0354 16.0416 14.6479 16.8604 17.125C16.9205 17.3048 16.9276 17.498 16.8806 17.6817C16.8337 17.8653 16.7348 18.0316 16.5958 18.1604L12.5208 22.2563C15.9312 28.9813 20.9687 34.0188 27.725 37.4583L31.7854 33.3958C31.9239 33.2587 32.0971 33.1619 32.2865 33.1156C32.4759 33.0694 32.6742 33.0755 32.8604 33.1333C35.352 33.9583 37.9645 34.375 40.625 34.375C41.1979 34.375 41.6666 34.8438 41.6666 35.4167V42.7083C41.6666 43.2813 41.1979 43.75 40.625 43.75C21.6708 43.75 6.24996 28.3292 6.24996 9.375C6.24996 9.09873 6.35971 8.83378 6.55506 8.63843C6.75041 8.44308 7.01536 8.33333 7.29163 8.33333Z\" fill=\"#288ED9\"></path></svg></div><div class=\"title-box\"><h2 class=\"title\">\n                                تماس با گروه کاراوب\n                            </h2><p>مشاوره رایگان جهت راه اندازی وب سایت...</p><div class=\"blue-line\"></div></div></div></div></div><div class=\"col-md-12\"><div class=\"d-flex justify-content-center\"><div class=\"contact-us\"><p class=\"contact-phone\">021-77200630</p></div></div></div></div></div></section><section><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/dr/2.jpg\" alt=\"طراحی سایت پزشکی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h3 class=\"title\">اهمیت طراحی سایت پزشکی</h3><p id=\"ixznx3\">چرا طراحی سایت پزشکی مهم است؟</p><div class=\"blue-line\"></div></div></div></div><p id=\"iextrd\">اگر میخواهید مراجعه ی حضوری و تماس های تلفنی را به صفر برسانید، طراحی وب سایت پزشکی را به شما پیشنهاد میکنیم! طراحی سایت میتواند از اتلاف وقت شما جلوگیری کرده و همچنین سیستم کاری شما را به روز کند.</p><p id=\"i9e2ju\">در سایت پزشکی خود میتوانید سوالات متداولی که بیماران و مراجعه کنندگان از شما میپرسند را به راحتی پاسخ دهید تا دیگر نیازی به تماس آنها با مطب شما نباشد</p><p id=\"ikz0qj\"><strong draggable=\"true\" data-highlightable=\"1\" id=\"ipvxel\"></strong>در طراحی سایت پزشکی میتوانید نوبت دهی آنلاین داشته باشید تا نوبت دهی را برای بیماران آسان تر نمایید.</p><p id=\"iqfssk\"><a data-cke-saved-href=\"https://karawebs.com\" href=\"https://karawebs.com\">طراحی وب سایت</a> به شما این امکان را میدهد تا مطب شما در تمام کشور یا حتی در تمام دنیا شعبه داشته باشد و به موقعیت مکانی محدود نباشد</p></div></div></div></section><section id=\"inzibp\"><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div id=\"i5l95y\" class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h3 class=\"title\">چت آنلاین طراحی وب سایت فروشگاهی</h3><p id=\"iv9c94\">معرفی امکانات</p><div class=\"blue-line\"></div></div></div></div><p id=\"iq1y3l\">این امکان بسیار جذاب در طراحی سایت پزشکی شما استفاده خواهد شد! به این صورت که شما عزیزان میتوانید اپلیکیشن چت را روی گوشی موبایل خود نصب کنید و با بیماران در ارتباط باشید! </p><ul class=\"kw-list1\"><li id=\"iwth8k\">ااپلیکیشن موبایل برای چت آنلاین</li><li id=\"iep7mr\">دسترسی به گفتگو ها از طریق پنل مدیریت</li><li id=\"i9wgyp\">امکان نمایش کاربران آنلاین در وب سایت شما</li></ul><a href=\"https://karawebs.com/portfolios\" title=\"نمونه کارها\" class=\"kw-btn-blue\">نمونه کارها</a></div><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/sherkati/chat.png\" alt=\"طراحی سایت پزشکی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section><section id=\"iujubi\"><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/sherkati/res-1.png\" alt=\"طراحی وب سایت پزشکان\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h3 class=\"title\">طراحی ریسپانسیو سایت پزشکان</h3><p id=\"io5agx\">مناسب برای تمامی نمایشگر ها</p><div class=\"blue-line\"></div></div></div></div><p id=\"ieyzrg\">به اطراف خود نگاه کنید، صفحه نمایش های بزرگ جی خود را به موبایل های خوش دستی داده اند که همیشه کاربران را به دنیای اینترنت متصل میکند! بر اساس الگوریتم Mobile First Index گوگل، وب سایت هایی به کاربران موبایل نمایش داده میشوند که دارای طراحی رسپانسیو باشند. برای اطلاعات بیشتر درباره ریسپانسیو میتوانید این مقاله را مطالعه کنید. اما به طور خلاصه وب سایتی ریسپانسیو است که بدون به هم ریختگی در صفحه نمایش های مختلف به کاربر نمایش داده شود. طراحی فروشگاه اینترنتی در کاراوب به صورت کاملا ریسپانسیو انجام میشود</p><p id=\"itcdti\">امروزه سبک طراحی سایت تغییرات بسیاری کرده و اصطلاحا به Mobile First Design تغییر کرده! یعنی اول طراحی موبایل و بعد باقی صفحه نمایش ها! اهمیت طراحی سایت پزشکی به صورت ریسپانسیو به حدی بالاست که گوگل را مجبور به استفاده از الگوریتم Mobile First Index برای تمامی سایت ها کرد</p></div></div></div></section><section id=\"i8bp4x\"><div class=\"container\"><div data-aos=\"fade-up\" class=\"contact aos-init aos-animate\"><div class=\"wrapper\"><div class=\"icon\"></div><div class=\"description\"><strong>به مشاوره نیاز دارید؟ همین حالا با ما تماس بگیرید</strong><p>مشاوره رایگان در رابطه با راه اندازی وب سایت شما</p></div></div><div class=\"call-btn\"><a href=\"\" class=\"kw-btn-blue\">تماس با کاراوب</a></div><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#4B3DA7\" fill-opacity=\"0.07\"></path></svg></div></div></section><section id=\"ijoi3e\"><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/pages/dargah.png\" alt=\"سایت پزشکی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h3 class=\"title\"> پرداخت آنلاین و درگاه های پرداخت</h3><p id=\"iuwqmf\">سیستم پرداخت آنلاین در طراحی سایت پزشکی</p><div class=\"blue-line\"></div></div></div></div><p id=\"i60pjk\">یکی از نکات بسیار مهم در طراحی وب سایت پزشکی، امنیت آن میباشد. اگر وب سایت از امنیت کافی برخوردار نباشد، پس درگاه های پرداخت نیز به خوبی عمل نخواهند کرد و این مساله وب سایت شما را با مشکل جدی مواجه میکند. کاراوب سعی کرده تا وب سایت پزشکیرا با بهترین کیفیت ممکن طراحی و با بالاترین امنیت به شما تحویل دهد.</p></div></div></div></section>','طراحی سایت پزشکی | سایت پزشک','روز به روز روند زنگی مردم تغییر میکند و به سمت و سوی آنلاین شدن میرود، پزشکان هم از این قاعده مستثنی نیستند، اگر پزشک هستید و به دنبال طراحی سایت پزشکی برای خود و مطب خود میباشید، میتوانید همین حالا وب سایت پزشکی خود را به صورتآنلاین سفارش دهید یا از مشاوره آنلاین بهره ببرید','طراحی سایت پزشکی , سایت پزشک , نوبت دهی آنلاین','Article','dr-webdesign',1,'https://karawebs.com/backend/images/grapesjs/1624038352-dr.png',1,'2020-08-31 09:23:37','2021-11-16 13:39:00',0,'976'),
(5,'طراحی سایت املاک','<section><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><div id=\"ij0qi\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" id=\"ic4wy\"><g clip-path=\"url(#clip0)\"><path d=\"M9.28125 4.21875C9.57465 3.87573 9.93887 3.60035 10.3489 3.41153C10.7588 3.22272 11.2049 3.12497 11.6563 3.125H38.3438C38.7951 3.12497 39.2412 3.22272 39.6511 3.41153C40.0611 3.60035 40.4254 3.87573 40.7187 4.21875L48.8719 13.7313C49.5998 14.5807 50 15.6625 50 16.7812V17.5781C50.0002 19.1249 49.5171 20.6331 48.6182 21.8919C47.7193 23.1508 46.4496 24.0973 44.9865 24.5992C43.5234 25.1011 41.94 25.1334 40.4577 24.6915C38.9754 24.2495 37.6682 23.3555 36.7188 22.1344C36.0254 23.0274 35.137 23.7499 34.1214 24.2466C33.1057 24.7433 31.9899 25.001 30.8594 25C29.7288 25.0013 28.6129 24.7437 27.5972 24.2469C26.5816 23.7502 25.6932 23.0276 25 22.1344C24.3068 23.0276 23.4184 23.7502 22.4028 24.2469C21.3871 24.7437 20.2712 25.0013 19.1406 25C18.01 25.0013 16.8941 24.7437 15.8785 24.2469C14.8628 23.7502 13.9744 23.0276 13.2812 22.1344C12.3318 23.3555 11.0246 24.2495 9.5423 24.6915C8.05998 25.1334 6.47661 25.1011 5.01351 24.5992C3.55041 24.0973 2.2807 23.1508 1.38182 21.8919C0.482943 20.6331 -0.000170621 19.1249 4.52017e-08 17.5781V16.7812C3.93986e-05 15.6625 0.400177 14.5807 1.12813 13.7313L9.28437 4.21562L9.28125 4.21875ZM14.8438 17.5781C14.8438 18.7177 15.2965 19.8107 16.1023 20.6165C16.9081 21.4223 18.001 21.875 19.1406 21.875C20.2802 21.875 21.3732 21.4223 22.179 20.6165C22.9848 19.8107 23.4375 18.7177 23.4375 17.5781C23.4375 17.1637 23.6021 16.7663 23.8951 16.4733C24.1882 16.1802 24.5856 16.0156 25 16.0156C25.4144 16.0156 25.8118 16.1802 26.1049 16.4733C26.3979 16.7663 26.5625 17.1637 26.5625 17.5781C26.5625 18.7177 27.0152 19.8107 27.821 20.6165C28.6268 21.4223 29.7198 21.875 30.8594 21.875C31.999 21.875 33.0919 21.4223 33.8977 20.6165C34.7035 19.8107 35.1562 18.7177 35.1562 17.5781C35.1562 17.1637 35.3209 16.7663 35.6139 16.4733C35.9069 16.1802 36.3043 16.0156 36.7188 16.0156C37.1332 16.0156 37.5306 16.1802 37.8236 16.4733C38.1166 16.7663 38.2812 17.1637 38.2812 17.5781C38.2813 18.7177 38.734 19.8107 39.5398 20.6165C40.3456 21.4223 41.4385 21.875 42.5781 21.875C43.7177 21.875 44.8107 21.4223 45.6165 20.6165C46.4223 19.8107 46.875 18.7177 46.875 17.5781V16.7812C46.875 16.4088 46.742 16.0487 46.5 15.7656L38.3438 6.25H11.6563L3.5 15.7656C3.25796 16.0487 3.12497 16.4088 3.125 16.7812V17.5781C3.125 18.7177 3.57771 19.8107 4.38353 20.6165C5.18935 21.4223 6.28227 21.875 7.42188 21.875C8.56148 21.875 9.6544 21.4223 10.4602 20.6165C11.266 19.8107 11.7188 18.7177 11.7188 17.5781C11.7187 17.1637 11.8834 16.7663 12.1764 16.4733C12.4694 16.1802 12.8668 16.0156 13.2812 16.0156C13.6957 16.0156 14.0931 16.1802 14.3861 16.4733C14.6791 16.7663 14.8438 17.1637 14.8438 17.5781V17.5781ZM4.6875 26.5625C5.1019 26.5625 5.49933 26.7271 5.79235 27.0201C6.08538 27.3132 6.25 27.7106 6.25 28.125V46.875H9.375V31.25C9.375 30.4212 9.70424 29.6263 10.2903 29.0403C10.8763 28.4542 11.6712 28.125 12.5 28.125H21.875C22.7038 28.125 23.4987 28.4542 24.0847 29.0403C24.6708 29.6263 25 30.4212 25 31.25V46.875H43.75V28.125C43.75 27.7106 43.9146 27.3132 44.2076 27.0201C44.5007 26.7271 44.8981 26.5625 45.3125 26.5625C45.7269 26.5625 46.1243 26.7271 46.4174 27.0201C46.7104 27.3132 46.875 27.7106 46.875 28.125V46.875H48.4375C48.8519 46.875 49.2493 47.0396 49.5424 47.3326C49.8354 47.6257 50 48.0231 50 48.4375C50 48.8519 49.8354 49.2493 49.5424 49.5424C49.2493 49.8354 48.8519 50 48.4375 50H1.5625C1.1481 50 0.750671 49.8354 0.457646 49.5424C0.16462 49.2493 4.52017e-08 48.8519 4.52017e-08 48.4375C4.52017e-08 48.0231 0.16462 47.6257 0.457646 47.3326C0.750671 47.0396 1.1481 46.875 1.5625 46.875H3.125V28.125C3.125 27.7106 3.28962 27.3132 3.58265 27.0201C3.87567 26.7271 4.2731 26.5625 4.6875 26.5625V26.5625ZM12.5 46.875H21.875V31.25H12.5V46.875ZM28.125 31.25C28.125 30.4212 28.4542 29.6263 29.0403 29.0403C29.6263 28.4542 30.4212 28.125 31.25 28.125H37.5C38.3288 28.125 39.1237 28.4542 39.7097 29.0403C40.2958 29.6263 40.625 30.4212 40.625 31.25V40.625C40.625 41.4538 40.2958 42.2487 39.7097 42.8347C39.1237 43.4208 38.3288 43.75 37.5 43.75H31.25C30.4212 43.75 29.6263 43.4208 29.0403 42.8347C28.4542 42.2487 28.125 41.4538 28.125 40.625V31.25ZM37.5 31.25H31.25V40.625H37.5V31.25Z\" fill=\"#288ED9\"></path></g><defs><clippath id=\"clip0\"><rect width=\"50\" height=\"50\" fill=\"white\"></rect></clippath></defs></svg></div></div><div class=\"title-box\"><h2 class=\"title\">طراحی سایت املاک</h2><p id=\"i7s6l\"> <strong>بررسی این نوع وب سایت</strong></p><div class=\"blue-line\"></div></div></div></div><p id=\"ivq9j\">  در دنیای امروز، همه چیز به سمت آنلاین شدن میرود، از خرید های ساده گرفته تا خرید ملک و خودرو... آژانس املاک نیز میتواند با داشتن یک وب سایت پا به دنیای آنلاین بگذارد، طراحی سایت املاک در <a data-cke-saved-href=\"https://karawebs.com\" href=\"https://karawebs.com\">کاراوب </a>دارای امکانات فوق العاده ای است که در ادامه به بررسی آن میپردازیم</p><ul class=\"kw-list1\"><li>پشتیبانی 24 ساعته</li><li id=\"ijvip\">امنیت فوق العاده</li><li id=\"ibx5j\">سئوی استاندارد</li><li id=\"i9yzf\">امکان ارتقاء به سایت چند فروشندگی</li><li id=\"ih8pa\">پنل مدیریت حرفه ای</li></ul><a href=\"#faqs\" class=\"kw-btn-blue\">سوالات متداول</a></div><div class=\"col-md-6\"><img src=\"/backend/images/grapesjs/1624085112-amlak.png\" alt=\"طراحی سایت املاک\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section><section class=\"kw-p\"><div class=\"container\"><div id=\"iithp4\" class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 28 31\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" id=\"ip30j\"><path d=\"M16.2511 4.875H17.8761V3.25C17.8761 2.81902 17.7049 2.4057 17.4002 2.10095C17.0954 1.79621 16.6821 1.625 16.2511 1.625H11.3761C10.9451 1.625 10.5318 1.79621 10.2271 2.10095C9.92233 2.4057 9.75113 2.81902 9.75113 3.25V4.875H11.3761V8.242L2.08925 24.3262C1.79293 24.8195 1.63286 25.3825 1.62539 25.9578C1.61792 26.5331 1.76333 27.1001 2.04675 27.6009C2.33016 28.1016 2.74143 28.5181 3.23854 28.8079C3.73564 29.0976 4.30075 29.2502 4.87613 29.25H22.7511C23.3265 29.2502 23.8916 29.0976 24.3887 28.8079C24.8858 28.5181 25.2971 28.1016 25.5805 27.6009C25.8639 27.1001 26.0093 26.5331 26.0019 25.9578C25.9944 25.3825 25.8343 24.8195 25.538 24.3262L16.2511 8.242V4.875ZM4.87613 30.875C3.99846 30.8752 3.13702 30.6385 2.38272 30.1898C1.62842 29.7411 1.00924 29.0971 0.590535 28.3257C0.171827 27.5544 -0.0308794 26.6843 0.00381014 25.8073C0.0384997 24.9303 0.309298 24.079 0.787625 23.3431L9.75113 7.81787V6.5C9.32015 6.5 8.90682 6.32879 8.60208 6.02405C8.29733 5.7193 8.12613 5.30598 8.12613 4.875V3.25C8.12613 2.38805 8.46854 1.5614 9.07803 0.951903C9.68752 0.34241 10.5142 0 11.3761 0H16.2511C17.1131 0 17.9397 0.34241 18.5492 0.951903C19.1587 1.5614 19.5011 2.38805 19.5011 3.25V4.875C19.5011 5.30598 19.3299 5.7193 19.0252 6.02405C18.7204 6.32879 18.3071 6.5 17.8761 6.5V7.81787L26.8396 23.3431C27.318 24.079 27.5888 24.9303 27.6234 25.8073C27.6581 26.6843 27.4554 27.5544 27.0367 28.3257C26.618 29.0971 25.9988 29.7411 25.2445 30.1898C24.4902 30.6385 23.6288 30.8752 22.7511 30.875H4.87613ZM15.1039 19.9745L17.7461 17.3323L22.7511 26H4.87613L10.8236 15.6975L15.1039 19.9745ZM15.1039 22.2722L11.173 18.343L7.69062 24.375H19.9366L17.3984 19.9777L15.1039 22.2722ZM14.6261 11.375C15.0571 11.375 15.4704 11.5462 15.7752 11.851C16.0799 12.1557 16.2511 12.569 16.2511 13C16.2511 13.431 16.0799 13.8443 15.7752 14.149C15.4704 14.4538 15.0571 14.625 14.6261 14.625C14.1951 14.625 13.7818 14.4538 13.4771 14.149C13.1723 13.8443 13.0011 13.431 13.0011 13C13.0011 12.569 13.1723 12.1557 13.4771 11.851C13.7818 11.5462 14.1951 11.375 14.6261 11.375V11.375Z\" fill=\"#288ED9\"></path></svg></div></div><div class=\"title-box\"><h3 class=\"title\"> برخی نمونه کار ها</h3><p id=\"i6kfnf\">خلاقیت، کیفیت، زیبایی</p><div class=\"blue-line\"></div></div></div></div><div id=\"i0uqh\" class=\"row\"><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1619518884moshtaqi.jpg\" alt=\"\" id=\"ivo4b\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">داروخانه دکتر مشتاقی</h3><p class=\"subtitle\">طراحی سایت فروشگاهی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/moahtaqi-online\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1611133098screencapture-choobiranshop-2021-01-20-12_27_03.jpg\" alt=\"\" id=\"ive1u\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">فروشگاه چوب ایران</h3><p class=\"subtitle\">طراحی سایت فروشگاهی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/choobiranshop\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1611135044screencapture-elisa-shop-ir-2021-01-20-12_59_30.jpg\" alt=\"\" id=\"iafqy\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">الیسا شاپ</h3><p class=\"subtitle\">طراحی سایت فروشگاهی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/elisa-shop\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1614420323mira.jpg\" alt=\"\" id=\"ig75id\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">فروشگاه میراکالا</h3><p class=\"subtitle\">طراحی سایت فروشگاهی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/mirakala\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div></div></div></section><section id=\"iz6v0x\"><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><img src=\"/backend/images/grapesjs/1624030974-panel.png\" alt=\"طراحی وب سایت املاک\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h2 class=\"title\"><em></em>اهمیت طراحی سایت مشاور املاک</h2><p id=\"ieficj\">بررسی امکانات</p><div class=\"blue-line\"></div></div></div></div><p id=\"i6qmdu\">مشتریان برای خرید یا اجاره ملک، ساعت ها و روز ها به دنبال ملک مورد نظر خود هستند. شما میتوانید با داشتن یک سایت خوب در این زمینه، به مشتریان کمک کنید که ملک مورد نظر خود را به راحتی مشاهده کنند! دیگر نیازی به مراجعه ی حضوری و اتلاف وقت نخواهد بود. <br/>​​​​​​​طراحی سایت املاک میتواند دارای سیستم آنلاین مشاوره باشد به این صورت که شما میتوانید با مشتریان به صورت آنلاین و از طریق وب سایتتان صحبت کنید.<br/></p><ul class=\"kw-list1\"><li id=\"i25uh8\">هاست حرفه ای</li><li id=\"ia6iuw\">امنیت پنل مدیریت</li><li id=\"ixmdnh\">سهولت کار با پنل</li></ul></div></div></div></section><section class=\"what-we-do pt-5 pb-5\"><div class=\"container\"><div class=\"row\"><div class=\"col-md-12\"><div class=\"section-head justify-content-center\"><div class=\"section-title\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M40.625 45.8333C42.3479 45.8333 43.75 44.4313 43.75 42.7083V35.4167C43.75 33.6938 42.3479 32.2917 40.625 32.2917C38.1875 32.2917 35.7916 31.9083 33.5 31.1521C32.9522 30.9791 32.3677 30.9581 31.8089 31.0913C31.2501 31.2245 30.7379 31.5069 30.327 31.9083L27.327 34.9083C22.1419 32.0934 17.8834 27.8363 15.0666 22.6521L18.0416 19.6583C18.9 18.8625 19.2083 17.6521 18.8416 16.4875C18.0869 14.1923 17.7043 11.7911 17.7083 9.375C17.7083 7.65208 16.3062 6.25 14.5833 6.25H7.29163C5.56871 6.25 4.16663 7.65208 4.16663 9.375C4.16663 29.4792 20.5208 45.8333 40.625 45.8333ZM7.29163 8.33333H14.5833C14.8596 8.33333 15.1245 8.44308 15.3199 8.63843C15.5152 8.83378 15.625 9.09873 15.625 9.375C15.625 12.0354 16.0416 14.6479 16.8604 17.125C16.9205 17.3048 16.9276 17.498 16.8806 17.6817C16.8337 17.8653 16.7348 18.0316 16.5958 18.1604L12.5208 22.2563C15.9312 28.9813 20.9687 34.0188 27.725 37.4583L31.7854 33.3958C31.9239 33.2587 32.0971 33.1619 32.2865 33.1156C32.4759 33.0694 32.6742 33.0755 32.8604 33.1333C35.352 33.9583 37.9645 34.375 40.625 34.375C41.1979 34.375 41.6666 34.8438 41.6666 35.4167V42.7083C41.6666 43.2813 41.1979 43.75 40.625 43.75C21.6708 43.75 6.24996 28.3292 6.24996 9.375C6.24996 9.09873 6.35971 8.83378 6.55506 8.63843C6.75041 8.44308 7.01536 8.33333 7.29163 8.33333Z\" fill=\"#288ED9\"></path></svg></div><div class=\"title-box\"><h2 class=\"title\">\n                                تماس با گروه کاراوب\n                            </h2><p>مشاوره رایگان جهت راه اندازی وب سایت...</p><div class=\"blue-line\"></div></div></div></div></div><div class=\"col-md-12\"><div class=\"d-flex justify-content-center\"><div class=\"contact-us\"><p class=\"contact-phone\">021-77200630</p></div></div></div></div></div></section><section><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/pages/undraw_design_notes_8dmv%20(1).png\" alt=\"طراحی سایت املاک\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h4 class=\"title\">سئو سایت املاک</h4><p id=\"irq7ga\"><s>​​​​​​​</s>سئو در این نوع وب سایت</p><div class=\"blue-line\"></div></div></div></div><p id=\"iextrd\"><a data-cke-saved-href=\"https://karawebs.com/\" href=\"https://karawebs.com/\" data-mce-href=\"../../../\" data-mce-selected=\"inline-boundary\"></a><a data-cke-saved-href=\"https://karawebs.com\" href=\"https://karawebs.com\">طراحی سایت</a> در کاراوب، از سئوی اولیه برخوردار است و تمامی وب سایت های طراحی شده توسط گروه ما این قابلیت را دارند که با گذشت زمان در صفحات اول موتور های جستجو گر مثل گوگل جای گیرند</p></div></div></div></section><section id=\"inzibp\"><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div id=\"i5l95y\" class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h3 class=\"title\">ویژگی های مهم سایت املاک</h3><p id=\"iv9c94\">معرفی امکانات</p><div class=\"blue-line\"></div></div></div></div><p id=\"iq1y3l\">وب سایت املاک دارای ویژگی های بسیار مهمی است که شاید در تمامی طراحی سایت ها رعایت نشود!  مشتری باید بتواند در طراحی سایت حرفه ای املاک شما موقعیت مکانی دقیق ملک را روی نقشه مشاهده کند  مشتری باید بتواند با استفاده از سیستم جستجوی حرفه ای ملک را پیدا کند  انتخاب ملک بر اساس ویژگی های ملک از دیگر ویژگی های مهم طراحی سایت مشاور املاک میباشد  ثبت آگهی حرفه ای بر اساس جزئیات ملک، زمین و...</p><a href=\"https://karawebs.com/portfolios\" title=\"نمونه کارها\" class=\"kw-btn-blue\">نمونه کارها</a></div><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/pages/undraw_for_sale_viax%20(2).png\" alt=\"طراحی سایت آژانس املاک\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section><div data-aos=\"fade-up\" class=\"contact aos-init aos-animate\"><div class=\"wrapper\"><div class=\"icon\"></div><div class=\"description\"><strong>به مشاوره نیاز دارید؟ همین حالا با ما تماس بگیرید</strong><p>مشاوره رایگان در رابطه با راه اندازی وب سایت شما</p></div></div><div class=\"call-btn\"><a href=\"\" class=\"kw-btn-blue\">تماس با کاراوب</a></div><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#4B3DA7\" fill-opacity=\"0.07\"></path></svg></div><section id=\"iujubi\"><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/sherkati/res-1.png\" alt=\"طراحی سایت املاک\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h4 class=\"title\">طراحی ریسپانسیو سایت املاک</h4><p id=\"isoahu\">مناسب برای تمامی نمایشگر ها</p><div class=\"blue-line\"></div></div></div></div><p id=\"ieyzrg\">حتما این واژه را قبلا هم شنیده اید، ریسپانسیو بودن وب سایت یعنی طراحی سایت به گونه ای باشید که در تمام صفحه نمایش ها به خوبی ظاهر شود و به هم ریختگی به وچجود نیاید.   همچنین یکی از فاکتور های مهم گوگل ریسپانسیو بودن وب سایت شما است. <a data-cke-saved-href=\"https://karawebs.com/\" href=\"https://karawebs.com/\" data-mce-href=\"../../../\">طراحی سایت </a>شما در کاراوب به صورت کاملا ریسپانسیو و واکنشگراست.</p></div></div></div></section><section id=\"i8bp4x\"><div class=\"container\"></div></section>','طراحی سایت املاک | طراحی سایت آژانس املاک','در دنیای امروز، همه چیز به سمت آنلاین شدن میرود، از خرید های ساده گرفته تا خرید ملک و خودرو... آژانس املاک نیز میتواند با داشتن یک وب سایت پا به دنیای آنلاین بگذارد، طراحی سایت املاک در کاراوب دارای امکانات فوق العاده ای است که در ادامه به بررسی آن میپردازیم','طراحی سایت املاک , طراحی سایت آژانس املاک , طراحی سایت مشاور املاک , طراحی سایت املاک حرفه ای','Article','amlak',1,'https://karawebs.com/backend/images/grapesjs/1624085112-amlak.png',1,'2020-08-31 10:48:55','2021-11-16 13:38:35',0,'998'),
(6,'قیمت طراحی فروشگاه اینترنتی','<body><section id=\"i067\"><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><div id=\"ij0qi\"></div><div id=\"ip7p5v\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 39 39\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M9.75 8.125H30.875C32.1679 8.125 33.4079 8.63861 34.3221 9.55285C35.2364 10.4671 35.75 11.7071 35.75 13V24.375C35.75 25.6679 35.2364 26.9079 34.3221 27.8221C33.4079 28.7364 32.1679 29.25 30.875 29.25H23.5495L24.375 34.125H26V35.75H14.625V34.125H16.25L17.0755 29.25H9.75C8.45707 29.25 7.21709 28.7364 6.30285 27.8221C5.38861 26.9079 4.875 25.6679 4.875 24.375V13C4.875 11.7071 5.38861 10.4671 6.30285 9.55285C7.21709 8.63861 8.45707 8.125 9.75 8.125ZM18.7005 29.25L17.875 34.125H22.75L21.9245 29.25H18.7005ZM9.75 9.75C8.88805 9.75 8.0614 10.0924 7.4519 10.7019C6.84241 11.3114 6.5 12.138 6.5 13V24.375C6.5 25.237 6.84241 26.0636 7.4519 26.6731C8.0614 27.2826 8.88805 27.625 9.75 27.625H30.875C31.737 27.625 32.5636 27.2826 33.1731 26.6731C33.7826 26.0636 34.125 25.237 34.125 24.375V13C34.125 12.138 33.7826 11.3114 33.1731 10.7019C32.5636 10.0924 31.737 9.75 30.875 9.75H9.75ZM1.625 13C1.625 10.8451 2.48102 8.77849 4.00476 7.25476C5.52849 5.73102 7.59512 4.875 9.75 4.875H29.25V6.5H9.75C8.02609 6.5 6.37279 7.18482 5.15381 8.40381C3.93482 9.62279 3.25 11.2761 3.25 13V22.75H1.625V13Z\" fill=\"#4B3DA7\"></path></svg></div></div><div class=\"title-box\"><h2 class=\"title\">تعرفه طراحی سایت فروشگاهی</h2><p id=\"i7s6l\"> <strong id=\"iwwn8\">هزینه طراحی سایت فروشگاهی چقدر است؟</strong></p><div class=\"blue-line\"></div></div></div></div><p id=\"ivq9j\">گروه طراحی سایت کاراوبز سعی در این دارد تا با ارائه پکیج هایی با امکانات عالی، قیمت خوب هم برای مشتریان در نظر گیرد. شما با توجه به نیازتان میتوانید یکی از 3 پکیج <a id=\"ikslp\" draggable=\"true\" data-highlightable=\"1\" data-cke-saved-href=\"https://karawebs.com/online-store-web-design\" href=\"https://karawebs.com/online-store-web-design\">طراحی سایت فروشگاهی </a>زیر را سفارش دهید یا اگر امکانات دلخواه را در این پکیج ها پیدا نمیکنید میتوانید با شماره <strong id=\"iq5vk\" draggable=\"true\">77200630-021</strong> تماس بگیرید.</p><ul class=\"kw-list1\"><li>پشتیبانی 24 ساعته</li><li id=\"ijvip\">امنیت فوق العاده</li><li id=\"ibx5j\">سئوی استاندارد</li><li id=\"i9yzf\">امکان ارتقاء به سایت چند فروشندگی</li><li id=\"ih8pa\">پنل مدیریت حرفه ای</li></ul></div><div class=\"col-md-6\"><img src=\"/backend/images/grapesjs/1624019759-online-store.png\" alt=\"هزینه طراحی سایت فروشگاهی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section><section class=\"kw-pricing-table\"><div class=\"container\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M48.4699 1.01253C48.3248 0.651307 48.0461 0.35991 47.6917 0.198957C47.3373 0.0380044 46.9345 0.019888 46.567 0.148377C46.1996 0.276866 45.8958 0.542067 45.719 0.88881C45.5421 1.23555 45.5057 1.63714 45.6174 2.01003C47.9399 8.68503 43.3299 13.67 39.8149 16.34L38.3949 14.305C37.9174 13.6225 36.8499 13.055 36.0199 13.045L28.0499 13.08C27.0763 13.1094 26.1287 13.4014 25.3074 13.925L1.82238 30.3925C1.27611 30.7769 0.904423 31.3621 0.788689 32.02C0.672954 32.6779 0.822605 33.3548 1.20488 33.9025L11.8774 49.1725C12.6774 50.31 13.9549 50.1725 15.0949 49.3775L38.5799 32.9075C39.2549 32.43 40.0349 31.4 40.3099 30.6125L42.8049 22.75C43.0799 21.965 42.9124 20.7675 42.4349 20.085L41.5699 18.845C46.2899 15.2275 51.1899 8.83503 48.4699 1.01253V1.01253ZM37.5424 24.4075C37.1097 24.7104 36.6216 24.925 36.106 25.0392C35.5904 25.1533 35.0573 25.1648 34.5373 25.0728C34.0172 24.9809 33.5204 24.7874 33.0751 24.5033C32.6299 24.2193 32.245 23.8504 31.9424 23.4175C31.3297 22.5417 31.0896 21.4585 31.2747 20.4058C31.4599 19.353 32.0551 18.4168 32.9299 17.8025C33.6156 17.3221 34.4344 17.0679 35.2717 17.0755C36.109 17.0831 36.923 17.3522 37.5999 17.845C36.9199 18.255 36.4524 18.495 36.3649 18.5325C36.055 18.6803 35.8044 18.9289 35.6544 19.2377C35.5043 19.5465 35.4635 19.8971 35.5387 20.2321C35.614 20.5671 35.8008 20.8665 36.0685 21.0815C36.3363 21.2964 36.6691 21.414 37.0124 21.415C37.2274 21.415 37.4474 21.365 37.6549 21.2675C38.1399 21.0375 38.6599 20.765 39.2024 20.4425C39.3272 21.1927 39.2376 21.9628 38.9439 22.6643C38.6502 23.3658 38.1644 23.97 37.5424 24.4075V24.4075Z\" fill=\"#288ED9\"></path></svg></div><div class=\"title-box\"><h3 class=\"title\">هزینه طراحی سایت فروشگاهی</h3><p id=\"i85zq\">پایینترین هزینه با کیفیت بالا...</p><div class=\"blue-line\"></div></div></div></div><ul><li class=\"active\"><button>پلن پایه</button></li><li><button>پلن حرفه ای</button></li><li><button>پلین ویژه</button></li></ul><table class=\"card-shadow\"><thead class=\"border-bottom\"><tr id=\"ivwel\"><th class=\"font-weight-bold\"><span id=\"ivllx\">طراحی سایت فروشگاهی</span><p id=\"ixoo5u\"><span id=\"iyclf\"></span></p><p id=\"iqofar\"><span id=\"inweh\"><strong>پیش پرداخت 50 درصد و مابقی بعد از تحویل</strong></span><strong></strong></p></th><th class=\"font-weight-bold\"><span id=\"ib64a\">پلن پایه + 12 ماه پشتیبانی رایگان</span></th><th class=\"font-weight-bold\"><span id=\"ii47l\">پلن حرفه ای + 12 ماه پشتیبانی رایگان</span></th><th class=\"font-weight-bold\"><div id=\"iu9flk\"><div id=\"iqpgks\"><span id=\"imm6m\"></span></div></div><div id=\"iaijab\"><p id=\"i9bvv\"></p></div><span id=\"it2mj\">پلن ویژه + اپلیکیشن اندروید + 12 ماه پشتیبانی رایگان</span></th></tr></thead><tbody><tr id=\"ihqnb\" class=\"text-red-imp\"><td class=\"font-weight-bold\"><span>قیمت</span></td><td id=\"i1ubx\"><span class=\"txt-l\"><span id=\"iva4u\">14</span></span><span class=\"txt-top\">میلیون تومان</span></td><td id=\"i2xiv\"><span class=\"txt-l\"><span id=\"ix8v3\">16</span></span><span class=\"txt-top\">میلیون تومان</span></td><td id=\"iu0a3y\" class=\"text-red\"><span class=\"txt-l\"><span id=\"ihudd7\">18</span></span><span class=\"txt-top\">میلیون تومان</span></td><td id=\"inclp\"><span class=\"txt-l\"></span><div id=\"iz3lno\"><span id=\"i06s6h\"></span><span id=\"ifxgiv\"></span></div><div id=\"ihou6t\"><strike id=\"ild22a\" draggable=\"false\" data-highlightable=\"1\"></strike></div><div id=\"i3exrs\"><span id=\"ibbhtj\"><span id=\"ik9ul8\"></span></span></div><div id=\"ib33lr\"><strong id=\"iyfz8g\" draggable=\"false\" data-highlightable=\"1\"><span id=\"iwcptj\"></span></strong></div></td></tr><tr><td colspan=\"5\" class=\"sep\"><span>امکانات وب سایت</span></td></tr><tr id=\"ikddd5\"><td id=\"ic8x1b\"><span id=\"ik8y85\">اجرای سایت با وردپرس</span></td><td><span class=\"tick\">✔</span></td><td><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr id=\"igu2jc\"><td id=\"ilruak\"><span id=\"iavslh\"><span id=\"iyllwo\">فضای هاست</span></span></td><td><span class=\"tick\"><span draggable=\"false\" class=\"gjs-selected\"><span id=\"i7pjw7\">500 مگابایت</span></span></span></td><td><span class=\"tick\"><span id=\"ike2dg\">1 گیگابایت</span></span></td><td class=\"default\"><span class=\"tick\"><span id=\"iya6k1\">2 گیگابایت</span></span></td></tr><tr class=\"border-bottom\"><td id=\"iv6t3u\"><span id=\"igr59p\">دامنه ir</span></td><td id=\"ixi5mw\"><span id=\"il158e\"><span id=\"ijunzy\"><span id=\"i8mixh\"><span id=\"i4uq8k\"><span id=\"iiol4x\">✔</span></span></span></span></span></td><td id=\"idwc8l\"><span class=\"tick\"><span id=\"ifdarh\"><span id=\"i3mgrv\">✔</span></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"irpz2k\"><span id=\"i2c8rd\">دامنه com</span></td><td id=\"i7pgze\"><span id=\"i4f9df\" class=\"text-red\"><span id=\"idu6ic\"><span id=\"ivor1a\"><span id=\"ixsx0h\"><span id=\"iosce5\">✔</span></span></span></span></span></td><td><span class=\"tick\"><span id=\"ilthf9\"><span id=\"i9p49w\"><span id=\"inbusy\"><span id=\"incd8g\">✔</span></span></span></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i20txe\">ظاهر دلخواه سایت</span></td><td><span class=\"tick\"><span id=\"ipf27n\">انتخاب از بین طرح های از قبل طراحی شده</span></span></td><td id=\"i94pu7\"><span class=\"tick\"><span id=\"i8njym\">طراحی template صفحه اصلی</span></span></td><td class=\"default\"><span class=\"tick\"><span id=\"i15u5y\">طراحی اختصاصی 3 صفحه</span></span></td></tr><tr class=\"border-bottom\"><td id=\"ir7cxj\"><span id=\"iwgczn\">پنل مدیریت پیشرفته</span></td><td><span class=\"tick\">✔</span></td><td id=\"it9d2e\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"iouegx\"><span id=\"io4pxi\"><span id=\"ienyxr\">طراحی بنر اختصاصی</span></span></td><td><span class=\"tick\"><span id=\"i9ycb4\">3 بنر</span></span></td><td id=\"iecftm\"><span class=\"tick\"><span id=\"igwgbk\">5 بنر</span></span></td><td class=\"default\"><span class=\"tick\"><span id=\"i90w4s\">10 بنر</span></span></td></tr><tr class=\"border-bottom\"><td id=\"ideaep\"><span>تعریف انواع محصول</span></td><td><span class=\"tick\">✔</span></td><td><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"ig2zyq\"><span id=\"i1cij3\">سیستم مدیریت پیشرفته سفارشات</span></td><td><span class=\"tick\">✔</span></td><td id=\"i9tlqj\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"ia578l\"><span id=\"iaap4z\"><span id=\"ih0ixy\">سیستم مدیریت پیشرفته محصولات</span></span></td><td><span class=\"tick\">✔</span></td><td id=\"ijs203\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"ir9vux\"><span id=\"ivbk9k\"><span id=\"ikgrwp\">سیستم تخفیف دهی حرفه ای</span></span></td><td><span class=\"tick\">✔</span></td><td><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"iiwc5g\"><span id=\"i7cwo3\"><span id=\"icrhgf\">تعریف روش های ارسال محصول</span></span></td><td><span class=\"tick\">✔</span></td><td id=\"i8bkq3\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"i8q2vu\"><span id=\"id15vy\"><span id=\"iuexpa\">اتصال به درگاه بانکی</span></span></td><td><span class=\"tick\">✔</span></td><td><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"ie6o7e\"><span id=\"ivkysf\"><span id=\"i00neh\">پروفایل کاربری پیشرفته</span></span></td><td><span class=\"tick\">✔</span></td><td><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"i0oc3y\"><span id=\"ipwf0y\"><span id=\"id839c\">ورود 10 محصول اولیه توسط کاراوبز</span></span></td><td><span class=\"tick\">✔</span></td><td><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"ioqfdn\">جستجوی پیشرفته و ایجکس</span></td><td id=\"iy9kz7\"><span class=\"tick\"><span id=\"iten58\">x</span></span></td><td id=\"i768wi\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"iwp82p\"><span id=\"i63oxm\">سیستم حرفه ای دسته بندی محصول</span></td><td><span class=\"tick\">✔</span></td><td id=\"ibqm3h\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"ij2x68\"><span id=\"ismb6s\">قیمت بر اساس ویژگی های محصول (مانند رنگ، سایز و...)</span></td><td><span class=\"tick\">✔</span></td><td id=\"i8r05f\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"ik4oqh\"><span id=\"iqt92p\">پیگیری سفارشات</span></td><td><span class=\"tick\"><span class=\"tick\"><span id=\"i7fzt6\"><span id=\"iqe5mq\" draggable=\"false\" class=\"gjs-selected\"><span id=\"i04g7i\">x</span></span></span><br/></span></span></td><td><span class=\"tick\"><span><span id=\"itdxjt\"><span id=\"iqe5mq-2\" draggable=\"false\" class=\"gjs-selected\"><span id=\"ixvpqy\">x</span></span></span></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"iv4nv7\">طراحی ریسپانسیو</span></td><td><span class=\"tick\">✔</span></td><td id=\"iezl15\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"inavwe\"><span id=\"i3lagg-2\">اتصال به درگاه پیامکی</span></td><td id=\"irg9va\"><span class=\"tick\"><span id=\"i4qtda\"></span></span><div id=\"ikg05n\"><span id=\"ie6kzp\"><strong id=\"iqe5mq-3\"><span id=\"i41xh1\">x</span></strong></span></div></td><td id=\"ipkdhh\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"iqk735\"><span id=\"iturbk\">اطلاع رسانی پیامکی بعد از ثبت سفارش</span></td><td><span class=\"tick\"><span></span></span><div><span><strong id=\"i1p8c5\"><span id=\"if85vi\">x</span></strong></span></div></td><td id=\"i5anrh\"><span class=\"tick\"><span id=\"i1p8c5-2\" draggable=\"false\" class=\"gjs-selected\"><span id=\"i04022\">x</span></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"igqqt9\"><span id=\"im9r0n\">مگا منو</span></td><td><span class=\"tick\"><span></span></span><div><span><strong id=\"ioz14o\"><span id=\"id49i3\">x</span></strong></span></div></td><td><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"inn5ro\"><span id=\"ivdu7i\">آموزش ویدیویی پنل مدیریت</span></td><td id=\"ixrfdk\"><span class=\"tick\"><span id=\"ik78pp\" class=\"tick\"><span id=\"iolviz\">✔</span><br/></span></span></td><td id=\"it9y46\"><span class=\"tick\"><span id=\"i3d5nj\"><span id=\"ircsm5\">✔</span></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i2x9g5\">معرفی شبکه های اجتماعی</span></td><td><span class=\"tick\"><span id=\"io1voj\" class=\"tick\"><span id=\"idup3k\">✔</span></span></span></td><td id=\"ice71r\"><span class=\"tick\"><span id=\"ipzh8o\"><span id=\"iwo2hb\">✔</span></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"ijxbdn\"><span id=\"irfv78\"><span id=\"il4c0f\">دریافت اینماد</span></span></td><td id=\"ivjbug\"><span id=\"ia2vmi\"><span id=\"ivetqn\"><span id=\"itysxt\"><span id=\"ie2bnj\">x</span></span></span><br/></span></td><td id=\"izusct\"><span class=\"tick\">✔ </span></td><td class=\"default\"><span class=\"tick\"><span id=\"i5x425\">✔ </span></span></td></tr><tr class=\"border-bottom\"><td id=\"ipqlws\"><span id=\"ixydyu\"><span id=\"imm332\">گزارش گیری پیشرفته فروش</span></span></td><td id=\"i3lfil\"><div id=\"iq2hfa\"><span id=\"i4wfoa\"><strong id=\"ivsav5\"><span id=\"i2kswf\">x</span></strong></span></div><span class=\"tick\"><span id=\"i1cs63\"><span id=\"i5kxzx\"></span></span></span></td><td><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"ickc2t\">سیستم مقایسه محصولات</span></td><td><span class=\"tick\"><span id=\"ivl0ti\"></span></span><div id=\"isu01d\"><span id=\"ii7xse\"><strong id=\"iowk5f\"><span id=\"i3dakl\">x</span></strong></span></div></td><td id=\"i5vnib\"><span class=\"tick\"><span id=\"iagkwp\">x</span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"iixe03\"><span id=\"itbnl1\">تعریف برند محصولات</span></td><td id=\"iuhfhw\"><span class=\"tick\"><span id=\"ilkdu8\"></span></span><div id=\"iaeaxj\"><span id=\"ifeyxm\"><strong id=\"iudgyl\"><span id=\"i38djb\">x</span></strong></span></div></td><td id=\"ix0cwu\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i4j4fg\">عضویت کاربران با شماره موبایل</span></td><td><span class=\"tick\"><span id=\"iinh7i\"></span></span><div id=\"ipmag4\"><span id=\"iymucz\"><strong id=\"ic4n0l\"><span id=\"iu0enh\">x</span></strong></span></div></td><td id=\"i6d5ta\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"ien5ki\">چت آنلاین</span></td><td><div id=\"ig62s1\"><span id=\"iqafmp\"><strong id=\"il3nza\"><span id=\"i5grgn\">x</span></strong></span></div><span class=\"tick\"><span id=\"i1tmcg\"></span></span></td><td id=\"ixkhyu\"><span class=\"tick\"><span id=\"i811o5\"></span></span><div id=\"io0qcn\"><span id=\"iuxp7s\"><strong id=\"isgqi3\"><span id=\"ij22qt\" class=\"tick\">✔</span></strong></span></div></td><td id=\"iwavfy\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i069mk\">چت واتساپ</span></td><td id=\"ie8u0j\"><span class=\"tick\"><span id=\"ijuwqg\"></span></span><div id=\"il132h\"><span id=\"iie92f\"><strong id=\"ik2urk-2\"><span id=\"izw7w1\">x</span></strong></span></div></td><td id=\"iv35v9\"><span class=\"tick\"><span id=\"iu4kbk\"></span></span><div id=\"ihk8co\"><span id=\"ij5p28\"><strong id=\"iuaw21\"><span id=\"i9nd7k\" class=\"tick\">✔</span></strong></span></div></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"ivhkte\">بهینه سازی تصاویر</span></td><td><div id=\"ih9t5k\"><span id=\"ia077w\"><strong id=\"it96kg\"><span id=\"in1pwa\">x</span></strong></span></div><span class=\"tick\"><span id=\"iu9b3i\"></span></span></td><td id=\"iusito\"><span class=\"tick\"><span id=\"i794t7\"><span id=\"ilmm1e\"></span><br/></span></span><div id=\"ice2vl\"><span id=\"i4imch\"><strong id=\"i25vay\"><span id=\"iegnpr\" class=\"tick\">✔</span></strong></span></div></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"ie9yjp\"><span id=\"iqasz1\">پاپ آپ تبلیفاتی</span></td><td id=\"i3w0hc\"><span class=\"tick\"><span id=\"it6s0q\"></span></span><div id=\"ibw5ov\"><span id=\"i6az6e\"><strong id=\"iuys62\"><span id=\"iovj63\">x</span></strong></span></div></td><td id=\"iytieq\"><div id=\"icoqx5\"><span id=\"iuq199\"><strong id=\"iqu2i9\"><span id=\"iflszk\"><span id=\"ifubzj\">x</span></span></strong></span></div><span class=\"tick\"><span id=\"ieetpj\"><span id=\"ic50ih\"></span><br/></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"i77h3s\"><span id=\"ipiyem\">اپلیکیشن اندروید</span></td><td><span class=\"tick\"><span></span></span><div><span><strong id=\"i4mxdg\"><span id=\"i90to6\">x</span></strong></span></div></td><td id=\"i8ut14\"><div><span><strong id=\"if37rk\"><span id=\"i4mxdg-2\" draggable=\"false\" class=\"gjs-selected\"><span id=\"inz40g\">x</span></span><br/></strong></span></div><span class=\"tick\"><span><span></span><br/></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"></tr><tr><td class=\"font-weight-bold\">سفارش پکیج ها</td><td id=\"i7sxxr\"><a href=\"tel:02177200630\" class=\"kw-btn-blue mt-0\">021-77200630</a></td><td id=\"ipwq6w\"><a href=\"tel:02177200630\" class=\"kw-btn-blue mt-0\">021-77200630</a></td><td id=\"iatlfn\"><a href=\"tel:02177200630\" class=\"kw-btn-blue mt-0\">021-77200630</a></td></tr></tbody></table></div></section></body>','قیمت طراحی فروشگاه اینترنتی | هزینه طراحی سایت فروشگاهی',NULL,'تعرفه طراحی سایت فروشگاهی , قیمت طراحی سایت فروشگاهی , هزینه طراحی سایت فروشگاهی','Article','online-store-prices',1,'https://karawebs.com/backend/images/grapesjs/1624019759-online-store.png',1,'2020-09-16 14:17:17','2023-11-27 09:46:03',0,'988'),
(7,'قیمت طراحی سایت شرکتی','<body><section id=\"i067\"><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><div id=\"ij0qi\"></div><div id=\"ip7p5v\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 39 39\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M9.75 8.125H30.875C32.1679 8.125 33.4079 8.63861 34.3221 9.55285C35.2364 10.4671 35.75 11.7071 35.75 13V24.375C35.75 25.6679 35.2364 26.9079 34.3221 27.8221C33.4079 28.7364 32.1679 29.25 30.875 29.25H23.5495L24.375 34.125H26V35.75H14.625V34.125H16.25L17.0755 29.25H9.75C8.45707 29.25 7.21709 28.7364 6.30285 27.8221C5.38861 26.9079 4.875 25.6679 4.875 24.375V13C4.875 11.7071 5.38861 10.4671 6.30285 9.55285C7.21709 8.63861 8.45707 8.125 9.75 8.125ZM18.7005 29.25L17.875 34.125H22.75L21.9245 29.25H18.7005ZM9.75 9.75C8.88805 9.75 8.0614 10.0924 7.4519 10.7019C6.84241 11.3114 6.5 12.138 6.5 13V24.375C6.5 25.237 6.84241 26.0636 7.4519 26.6731C8.0614 27.2826 8.88805 27.625 9.75 27.625H30.875C31.737 27.625 32.5636 27.2826 33.1731 26.6731C33.7826 26.0636 34.125 25.237 34.125 24.375V13C34.125 12.138 33.7826 11.3114 33.1731 10.7019C32.5636 10.0924 31.737 9.75 30.875 9.75H9.75ZM1.625 13C1.625 10.8451 2.48102 8.77849 4.00476 7.25476C5.52849 5.73102 7.59512 4.875 9.75 4.875H29.25V6.5H9.75C8.02609 6.5 6.37279 7.18482 5.15381 8.40381C3.93482 9.62279 3.25 11.2761 3.25 13V22.75H1.625V13Z\" fill=\"#4B3DA7\"></path></svg></div></div><div class=\"title-box\"><h2 class=\"title\">تعرفه طراحی سایت شرکتی</h2><p id=\"i7s6l\"> <strong id=\"iwwn8\">هزینه طراحی سایت شرکتی چقدر است؟</strong></p><div class=\"blue-line\"></div></div></div></div><p id=\"ipaodh\">گروه طراحی سایت کاراوبز سعی در این دارد تا با ارائه پکیج هایی با امکانات عالی، قیمت خوب هم برای مشتریان در نظر گیرد. شما با توجه به نیازتان میتوانید یکی از 3 پکیج طراحی سایت شرکتی زیر را سفارش دهید یا اگر امکانات دلخواه را در این پکیج ها پیدا نمیکنید میتوانید با شماره 77200630-021 تماس بگیرید. هزینه طراحی سایت شرکتی بر اساس امکانات داخل پکیج ها محاسبه شده است.</p><ul class=\"kw-list1\"><li>پشتیبانی 24 ساعته</li><li id=\"ijvip\">امنیت فوق العاده</li><li id=\"ibx5j\">سئوی استاندارد</li><li id=\"i9yzf\">امکان ارتقاء به سایت چند فروشندگی</li><li id=\"ih8pa\">پنل مدیریت حرفه ای</li></ul></div><div class=\"col-md-6\"><img src=\"/backend/images/grapesjs/1624019759-online-store.png\" alt=\"هزینه طراحی سایت شرکتی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section><section class=\"kw-pricing-table\"><div class=\"container\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M48.4699 1.01253C48.3248 0.651307 48.0461 0.35991 47.6917 0.198957C47.3373 0.0380044 46.9345 0.019888 46.567 0.148377C46.1996 0.276866 45.8958 0.542067 45.719 0.88881C45.5421 1.23555 45.5057 1.63714 45.6174 2.01003C47.9399 8.68503 43.3299 13.67 39.8149 16.34L38.3949 14.305C37.9174 13.6225 36.8499 13.055 36.0199 13.045L28.0499 13.08C27.0763 13.1094 26.1287 13.4014 25.3074 13.925L1.82238 30.3925C1.27611 30.7769 0.904423 31.3621 0.788689 32.02C0.672954 32.6779 0.822605 33.3548 1.20488 33.9025L11.8774 49.1725C12.6774 50.31 13.9549 50.1725 15.0949 49.3775L38.5799 32.9075C39.2549 32.43 40.0349 31.4 40.3099 30.6125L42.8049 22.75C43.0799 21.965 42.9124 20.7675 42.4349 20.085L41.5699 18.845C46.2899 15.2275 51.1899 8.83503 48.4699 1.01253V1.01253ZM37.5424 24.4075C37.1097 24.7104 36.6216 24.925 36.106 25.0392C35.5904 25.1533 35.0573 25.1648 34.5373 25.0728C34.0172 24.9809 33.5204 24.7874 33.0751 24.5033C32.6299 24.2193 32.245 23.8504 31.9424 23.4175C31.3297 22.5417 31.0896 21.4585 31.2747 20.4058C31.4599 19.353 32.0551 18.4168 32.9299 17.8025C33.6156 17.3221 34.4344 17.0679 35.2717 17.0755C36.109 17.0831 36.923 17.3522 37.5999 17.845C36.9199 18.255 36.4524 18.495 36.3649 18.5325C36.055 18.6803 35.8044 18.9289 35.6544 19.2377C35.5043 19.5465 35.4635 19.8971 35.5387 20.2321C35.614 20.5671 35.8008 20.8665 36.0685 21.0815C36.3363 21.2964 36.6691 21.414 37.0124 21.415C37.2274 21.415 37.4474 21.365 37.6549 21.2675C38.1399 21.0375 38.6599 20.765 39.2024 20.4425C39.3272 21.1927 39.2376 21.9628 38.9439 22.6643C38.6502 23.3658 38.1644 23.97 37.5424 24.4075V24.4075Z\" fill=\"#288ED9\"></path></svg></div><div class=\"title-box\"><h3 class=\"title\">هزینه طراحی سایت شرکتی</h3><p id=\"i95nl\">پایینترین هزینه با کیفیت بالا...</p><div class=\"blue-line\"></div></div></div></div><ul><li class=\"active\"><button>پلن پایه</button></li><li><button>پلن حرفه ای</button></li><li><button>پلین ویژه</button></li></ul><table class=\"card-shadow\"><thead class=\"border-bottom\"><tr><th class=\"font-weight-bold\"><span id=\"ivllx\">طراحی سایت شرکتی</span><p id=\"iogh1k\"><span id=\"i18ef\"></span></p><p id=\"ivq9j\"><strong><span id=\"ic6i9\">پیش پرداخت 50 درصد مابقی بعد از تحویل</span></strong></p></th><th class=\"font-weight-bold\"><span id=\"i26om\">پلن پایه + 12 ماه پشتیبانی رایگان</span></th><th class=\"font-weight-bold\"><span id=\"i17mj\"><span id=\"i7fsu\">پلن حرفه ای+ 12 ماه پشتیبانی رایگان</span></span></th><th class=\"font-weight-bold\"><span id=\"ixd2d\"><span id=\"izika\">پلن لاکچری+ 12 ماه پشتیبانی رایگان</span></span></th></tr></thead><tbody id=\"ipvcy\"><tr id=\"ie7qx\" class=\"text-red-imp\"><td class=\"font-weight-bold\"><span id=\"ip5iy\">قیمت</span></td><td id=\"i1ubx\"><span class=\"txt-l\"><span id=\"iva4u\">12</span></span><span class=\"txt-top\">میلیون تومان</span></td><td id=\"i4sll\"><span class=\"txt-l\"><span id=\"ix8v3\">14</span></span><span class=\"txt-top\">میلیون تومان</span></td><td id=\"ihfgi\"><span class=\"txt-l\"><span id=\"iptz74\">16</span></span><span class=\"txt-top\">میلیون تومان</span></td></tr><tr><td colspan=\"5\" class=\"sep\"><span>امکانات وب سایت</span></td></tr><tr><td><span id=\"ipqxts\">اجرای سایت با وردپرس</span></td><td><span class=\"tick\">✔</span></td><td><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"ie7ki3\"><span id=\"iwaidi\">فضای هاست</span></td><td><span id=\"i28neu\">500 مگابایت</span></td><td id=\"incn2i\"><span id=\"i0g0fq\">1 گیگابایت</span></td><td class=\"default\"><span id=\"iauqwt\">2 گیگابایت</span></td></tr><tr class=\"border-bottom\"><td id=\"i9voc7\"><span id=\"i069mk\">دامنه ir</span></td><td><span class=\"tick\">✔</span></td><td id=\"iv35v9\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"iv6t3u\"><span id=\"igr59p\">دامنه com</span></td><td><p id=\"ivyz0s\"><span data-cke-bookmark=\"1\" id=\"igmq4a\"> </span><span id=\"igq8gf\"><span style=\"color: rgb(44, 160, 28); font-family: KalamehWebFaNum; font-size: 18px; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; background-color: rgb(255, 255, 255);\">✔</span></span><span data-cke-bookmark=\"1\" id=\"iho7dq\"> </span></p></td><td id=\"idwc8l\"><span class=\"tick\"><span id=\"i5v0ce\"><span id=\"i6rwsf\">✔</span></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i20txe\">ظاهر دلخواه سایت</span></td><td><span id=\"imcn2c\">انتخاب از بین طرح های از قبل طراحی شده</span></td><td id=\"i94pu7\"><span id=\"i864g6\">طراحی template صفحه اصلی</span></td><td class=\"default\"><span id=\"iey0y5\">طراحی اختصاصی 3 صفحه</span></td></tr><tr class=\"border-bottom\"><td id=\"ir7cxj\"><span id=\"iwgczn\">طراحی بنر اختصاصی</span></td><td><span id=\"ijvawi\">3 بنر</span></td><td id=\"it9d2e\"><span id=\"ivl4zo\">5 بنر</span></td><td class=\"default\"><span id=\"isb8ui\">10 بنر</span></td></tr><tr class=\"border-bottom\"><td id=\"inn5ro\"><span id=\"ivdu7i\">نقشه گوگل</span></td><td><p id=\"i75t0a\"></p><div data-cke-filler-webkit=\"start\" data-cke-temp=\"1\" id=\"ieo84b\"><span id=\"i5dd5p\"> </span></div><span data-cke-bookmark=\"1\" id=\"iksu0s\"> </span><span id=\"ipnkf3\">x</span><span data-cke-bookmark=\"1\" id=\"i5xi1i\"> </span><div data-cke-filler-webkit=\"end\" data-cke-temp=\"1\" id=\"i5v4s9\"><span id=\"ipwxu9\"> </span></div><p></p><span class=\"tick\"><span id=\"igerjn\"></span></span></td><td id=\"it9y46\"><span class=\"tick\"><span id=\"igiigi\"><span id=\"ium1ic\">✔</span></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"iukxli\"><span id=\"i03qpf\">ایمیل اختصاصی</span></td><td><span id=\"i2agdc\">3 بنر</span><span class=\"tick\"><span></span></span></td><td id=\"izkdjo\"><span class=\"tick\"><span></span></span><span id=\"ij34xf\"><span id=\"ibv8jz\">3 ایمیل</span></span></td><td class=\"default\"><span class=\"tick\"><span id=\"ib9p76\">نامحدود</span></span></td></tr><tr class=\"border-bottom\"><td><span id=\"io4pxi\">وبلاگ و مقالات</span></td><td id=\"ijzfxr\"><span class=\"tick\">✔</span></td><td id=\"iecftm\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i1cij3\">درباره ما</span></td><td><span class=\"tick\">✔</span></td><td id=\"i9tlqj\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"iaap4z\">فرم تماس</span></td><td><span class=\"tick\">✔</span></td><td id=\"ijs203\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"indguk\"><span id=\"ien5ki\">چت آنلاین</span></td><td id=\"in4gnu\"><span class=\"tick\"><span id=\"izggfn\"></span></span><p id=\"iale2k\"></p><div data-cke-filler-webkit=\"start\" data-cke-temp=\"1\" id=\"inhlrj\"><span id=\"ic7nyi\"> </span></div><span data-cke-bookmark=\"1\" id=\"iiecwa\"> </span><span id=\"i362mf\">x</span><span data-cke-bookmark=\"1\" id=\"ixrmtk\"> </span><div data-cke-filler-webkit=\"end\" data-cke-temp=\"1\" id=\"iv7pd5\"><span id=\"inuwal\"> </span></div><p></p></td><td id=\"ixkhyu\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"ioqfdn\">تعریف نمونه کار و پروژه</span></td><td><span class=\"tick\">✔</span></td><td id=\"i768wi\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i3lagg\">گالری تصاویر</span></td><td><span class=\"tick\">✔</span></td><td id=\"ipkdhh\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"iv4nv7\">طراحی ریسپانسیو</span></td><td><span class=\"tick\">✔</span></td><td id=\"iezl15\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"iro6i1\"><span id=\"icdg1i\">ثبت اطلاعات کسب و کار در Google Map</span></td><td><span class=\"tick\"><span><span id=\"ip6g1u\"></span></span></span><p id=\"irkg7k\"></p><div data-cke-filler-webkit=\"start\" data-cke-temp=\"1\" id=\"imv2su\"><span id=\"irj7bb\"> </span></div><span data-cke-bookmark=\"1\" id=\"i1kfru\"> </span><span id=\"i5tkpo\">x</span><span data-cke-bookmark=\"1\" id=\"ixi5x6\"> </span><div data-cke-filler-webkit=\"end\" data-cke-temp=\"1\" id=\"iso1sm\"><span id=\"iyt8ln\"> </span></div><p></p></td><td><span class=\"tick\"><span><span id=\"iuhi03\">✔</span></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"ig64wz\"><span id=\"ioyvym\"><span id=\"ijuexu\">Google Webmaster Tools </span><br/>اتصال به </span></td><td id=\"iqcz6j\"><span class=\"tick\"><span><span id=\"i2t58p\"><span id=\"ibm18c\">✔</span></span></span></span></td><td><span class=\"tick\"><span><span id=\"ipc19x\">✔</span></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"ikruaf\"><span id=\"ih8vqh\"><span id=\"iwm6xd\">ثبت سایت در Google Analytics</span></span></td><td><span class=\"tick\"><span><span id=\"i3tgb6\"><br/></span></span></span><p id=\"i31ho4\"></p><div data-cke-filler-webkit=\"start\" data-cke-temp=\"1\" id=\"icemqp\"><span id=\"i3obkc\"> </span></div><span data-cke-bookmark=\"1\" id=\"iqby7h\"> </span><span id=\"ijmocz\">x</span><span data-cke-bookmark=\"1\" id=\"ik9egk\"> </span><div data-cke-filler-webkit=\"end\" data-cke-temp=\"1\" id=\"iu3vjm\"><span id=\"imqzak\"> </span></div><p></p></td><td><span class=\"tick\"><span><span id=\"i4psgn\">✔</span></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i63oxm\">سئو استاندارد</span></td><td><span class=\"tick\">✔</span></td><td id=\"ibqm3h\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"i6fhcp\"><span id=\"i9d1sw\">صفحه ساز گرافیکی</span></td><td><span class=\"tick\"><span id=\"iazg7r\"></span></span><span id=\"is8k4f\" class=\"tick\">✔</span></td><td id=\"ij614h\"><span class=\"tick\"><span id=\"ikutkx\"><span id=\"ivmkej\">✔</span></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"iqq6kk\"><span id=\"if8cbj\">دکمه شناور تماس سریع</span></td><td><span class=\"tick\"><span><span id=\"i66g9v\"><span id=\"ibzlwe\">✔</span></span></span></span></td><td><span class=\"tick\"><span><span id=\"ihklqi\">✔</span></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"ismb6s\">آموزش ویدیویی پنل مدیریت</span></td><td><span class=\"tick\">✔</span></td><td id=\"i8r05f\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"ickc2t\">یکسال پشتیبانی رایگان</span></td><td><span class=\"tick\">✔</span></td><td id=\"i5vnib\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"id5oxt\"><span id=\"i4j4fg\">آمار بازدید کاربران</span></td><td id=\"ibqpt6\"><span class=\"tick\"><span id=\"i3vaeg\"></span></span><p id=\"id6lol\"></p><div data-cke-filler-webkit=\"start\" data-cke-temp=\"1\" id=\"io3vu1\"><span id=\"im5nc9\"> </span></div><span data-cke-bookmark=\"1\" id=\"ii5esz\"> </span><span id=\"ilcg5g\">x</span><span data-cke-bookmark=\"1\" id=\"il59fr\"> </span><div data-cke-filler-webkit=\"end\" data-cke-temp=\"1\" id=\"ix523a\"><span id=\"iwv37i\"> </span></div><p></p></td><td id=\"i6d5ta\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"i1z1qf\"><span id=\"i2x9g5\">معرفی شبکه های اجتماعی</span></td><td><span class=\"tick\"><span id=\"i3ek8o\"></span></span><p id=\"iy4h5r\"></p><div data-cke-filler-webkit=\"start\" data-cke-temp=\"1\" id=\"ijx4ll\"><span id=\"i832yt\"> </span></div><span data-cke-bookmark=\"1\" id=\"ixemhu\"> </span><span id=\"iumldl\">x</span><span data-cke-bookmark=\"1\" id=\"iriciv\"> </span><div data-cke-filler-webkit=\"end\" data-cke-temp=\"1\" id=\"ixvnih\"><span id=\"ialuxu\"> </span></div><p></p></td><td id=\"ice71r\"><span class=\"tick\"><span id=\"i6j8ug\"><span id=\"i56jnx\">✔</span></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"iajbnc\">چت واتساپ</span></td><td><span class=\"tick\"><span id=\"i34lk6\"></span></span><p id=\"iarrva\"></p><div data-cke-filler-webkit=\"start\" data-cke-temp=\"1\" id=\"ihotrc\"><span id=\"inv2jl\"> </span></div><span data-cke-bookmark=\"1\" id=\"if9e95\"> </span><span id=\"ivcdnb\">x</span><span data-cke-bookmark=\"1\" id=\"iy3agc\"> </span><div data-cke-filler-webkit=\"end\" data-cke-temp=\"1\" id=\"itcc1f\"><span id=\"iq2yc4\"> </span></div><p></p></td><td id=\"i1t8wh\"><span class=\"tick\"><span id=\"iohrf3\"></span></span><p id=\"idrnri\"></p><div data-cke-filler-webkit=\"start\" data-cke-temp=\"1\" id=\"i5p78j\"><span id=\"ih77bt\"> </span></div><span data-cke-bookmark=\"1\" id=\"il9obu\"> </span><span id=\"ihsf56\">x</span><span data-cke-bookmark=\"1\" id=\"im073b\"> </span><div data-cke-filler-webkit=\"end\" data-cke-temp=\"1\" id=\"icskiv\"><span id=\"i6i1w6\"> </span></div><p></p></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i5kqkq\">افزایش سرعت و کشینگ</span></td><td><span class=\"tick\"><span id=\"ihwluh\"></span></span><p id=\"i0r5xl\"></p><div data-cke-filler-webkit=\"start\" data-cke-temp=\"1\" id=\"ixzb5z\"><span id=\"ijye1d\"> </span></div><span data-cke-bookmark=\"1\" id=\"i23a4g\"> </span><span id=\"ivcwyw\">x</span><span data-cke-bookmark=\"1\" id=\"ikw3ej\"> </span><div data-cke-filler-webkit=\"end\" data-cke-temp=\"1\" id=\"iy6546\"><span id=\"if0dqa\"> </span></div><p></p></td><td id=\"i66wqj\"><p id=\"itlub2\"></p><div data-cke-filler-webkit=\"start\" data-cke-temp=\"1\" id=\"i0s18n\"><span id=\"iareau\"> </span></div><span data-cke-bookmark=\"1\" id=\"i1j3pa\"> </span><span id=\"icfhnn\">x</span><span data-cke-bookmark=\"1\" id=\"iz9jkc\"> </span><div data-cke-filler-webkit=\"end\" data-cke-temp=\"1\" id=\"i87yb3\"><span id=\"i55kvr\"> </span></div><p></p><span class=\"tick\"><span id=\"icmvyj\"></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"i4abvw\"><span id=\"ivhkte\">بهینه سازی تصاویر</span></td><td><span class=\"tick\"><span id=\"ivvywk\"></span></span><p id=\"ihtusi\"></p><div data-cke-filler-webkit=\"start\" data-cke-temp=\"1\" id=\"i3x2iw\"><span id=\"i8zocn\"> </span></div><span data-cke-bookmark=\"1\" id=\"iuex4z\"> </span><span id=\"ia2n3k\">x</span><span data-cke-bookmark=\"1\" id=\"icngdz\"> </span><div data-cke-filler-webkit=\"end\" data-cke-temp=\"1\" id=\"i44b48\"><span id=\"i315mi\"> </span></div><p></p></td><td id=\"iusito\"><p id=\"ifaebc\"></p><div data-cke-filler-webkit=\"start\" data-cke-temp=\"1\" id=\"iafmhp\"><span id=\"iusark\"> </span></div><span data-cke-bookmark=\"1\" id=\"i2ng33\"> </span><span id=\"ipq3ol\">x</span><span data-cke-bookmark=\"1\" id=\"i8owq5\"> </span><div data-cke-filler-webkit=\"end\" data-cke-temp=\"1\" id=\"ivovk5\"><span id=\"ivq6zn\"> </span></div><p></p><span class=\"tick\"><span id=\"ilxtaq\"></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"ie9yjp\"><span id=\"iqasz1\">2 زبانه</span></td><td id=\"ieccsx\"><span class=\"tick\"><span id=\"inik8h\"></span></span><p id=\"ikhe7h\"></p><div data-cke-filler-webkit=\"start\" data-cke-temp=\"1\" id=\"i2y6t7\"><span id=\"i86yiu\"> </span></div><span data-cke-bookmark=\"1\" id=\"iurgog\"> </span><span id=\"i9mf5e\">x</span><span data-cke-bookmark=\"1\" id=\"ipezcl\"> </span><div data-cke-filler-webkit=\"end\" data-cke-temp=\"1\" id=\"isz9fz\"><span id=\"iad2c8\"> </span></div><p></p></td><td id=\"iytieq\"><p id=\"iyiy29\"></p><div data-cke-filler-webkit=\"start\" data-cke-temp=\"1\" id=\"isow2k\"><span id=\"iik76q\"> </span></div><span data-cke-bookmark=\"1\" id=\"ivrg82\"> </span><span id=\"i2p285\">x</span><span data-cke-bookmark=\"1\" id=\"ivrvmi\"> </span><div data-cke-filler-webkit=\"end\" data-cke-temp=\"1\" id=\"idavab\"><span id=\"ig1t2i\"> </span></div><p></p><span class=\"tick\"><span id=\"il80do\"></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr><td class=\"font-weight-bold\">سفارش پکیج ها</td><td id=\"i7sxxr\"><a href=\"tel:02177200630\" class=\"kw-btn-blue mt-0\">021-77200630</a></td><td><a href=\"tel:02177200630\" class=\"kw-btn-blue mt-0\">021-77200630</a></td><td><a href=\"tel:02177200630\" class=\"kw-btn-blue mt-0\">021-77200630</a></td></tr></tbody></table></div></section></body>','قیمت طراحی سایت شرکتی | هزینه طراحی سایت شرکتی',NULL,'قیمت طراحی سایت شرکتی , تعرفه طراحی سایت شرکتی , هزینه طراحی سایت شرکتی','Article','company-webdesign-price',1,'https://karawebs.com/backend/images/grapesjs/1624038352-dr.png',1,'2020-09-27 09:20:06','2023-11-05 06:37:10',0,'899'),
(8,'تماس با ما','<section><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"></div><div id=\"iu2af\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 230 230\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M44.7906 46.6364V146.418C44.7906 149.812 45.4694 153.036 46.827 156.091C48.1846 159.145 49.9664 161.861 52.1724 164.236C54.5482 166.442 57.2634 168.224 60.3179 169.582C63.5421 170.77 66.9361 171.364 70.4997 171.364H82.9724C84.8391 171.364 85.9421 171.618 86.2815 172.127C86.7906 172.636 87.0452 173.57 87.0452 174.927C87.0452 176.455 86.7906 177.558 86.2815 178.236C85.7724 178.745 84.6694 179 82.9724 179H70.4997C65.9179 179 61.5906 178.152 57.5179 176.455C53.6149 174.758 50.1361 172.467 47.0815 169.582C44.1967 166.527 41.9058 163.048 40.2088 159.145C38.5118 155.073 37.6634 150.745 37.6634 146.164V46.6364H44.7906ZM179.821 171.364C186.948 171.364 192.888 168.988 197.639 164.236C202.56 159.315 205.021 153.291 205.021 146.164C205.021 137.679 202.56 130.891 197.639 125.8C192.718 120.539 186.27 117.145 178.294 115.618C176.088 114.939 173.033 114.261 169.13 113.582C165.397 112.903 161.239 112.139 156.657 111.291C152.076 110.442 147.324 109.594 142.403 108.745C137.482 107.727 132.56 106.709 127.639 105.691C123.227 104.842 118.73 103.994 114.148 103.145C109.736 102.297 105.07 101.448 100.148 100.6C98.9604 100.261 97.7725 100.006 96.5847 99.8364C95.5665 99.6667 94.4634 99.497 93.2756 99.3273V89.4L134.766 56.8182L137.821 60.1273L99.1301 93.4727L106.766 95C112.706 96.1879 118.391 97.2909 123.821 98.3091C129.251 99.3273 134.512 100.261 139.603 101.109C150.124 102.976 158.863 104.588 165.821 105.945C172.948 107.133 177.445 107.982 179.312 108.491H179.566C190.766 110.697 198.912 114.77 204.003 120.709C209.263 126.648 211.894 135.133 211.894 146.164C211.894 150.745 211.045 155.073 209.348 159.145C207.651 163.048 205.36 166.527 202.476 169.582C199.591 172.467 196.197 174.758 192.294 176.455C188.391 178.152 184.233 179 179.821 179H83.0938C81.5665 179 80.5483 178.745 80.0392 178.236C79.3604 177.727 79.021 176.624 79.021 174.927C79.021 173.57 79.2756 172.636 79.7847 172.127C80.2938 171.618 81.3968 171.364 83.0938 171.364H179.821Z\" fill=\"#288ED9\"></path><circle cx=\"115\" cy=\"115\" r=\"111\" stroke=\"#288ED9\" stroke-width=\"8\"></circle></svg></div><div class=\"title-box\"><h3 class=\"title\"> درباره ما</h3><p id=\"i6hkn\"> مختصری از کاراوب</p><div class=\"blue-line\"></div></div></div></div><p id=\"i7gzs\">گروه کاراوب فعالیت خود را از سال 94 شروع کرد و با گذر زمان به یکی از بهترین گروه های طراحی و توسعه وب سایت در ایران تبدیل شد، گروه کاراوب با تیمی متخصص در حوزه های طراحی و توسعه سایت، طراحی cms، طراحی و توسعه اپلیکیشن موبایل فعال میباشد.</p></div><div class=\"col-md-6\"><img src=\"/backend/images/grapesjs/1624092091-support.png\" alt=\"درباره کاراوب\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section><hr/><section><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M39.0434 11.1379C37.2202 9.31691 35.0523 7.87771 32.6664 6.9044C30.2805 5.93109 27.7245 5.44323 25.1479 5.46932C22.5706 5.44981 20.015 5.94058 17.6283 6.91334C15.2416 7.8861 13.071 9.32162 11.2417 11.1371C9.41238 12.9527 7.96047 15.1123 6.96966 17.4916C5.97886 19.8708 5.46875 22.4227 5.46875 25V35.9375C5.46989 36.9731 5.8818 37.966 6.61412 38.6984C7.34644 39.4307 8.33935 39.8426 9.375 39.8437H12.5C13.5357 39.8426 14.5286 39.4307 15.2609 38.6984C15.9932 37.966 16.4051 36.9731 16.4062 35.9375V28.125C16.4051 27.0893 15.9932 26.0964 15.2609 25.3641C14.5286 24.6318 13.5357 24.2199 12.5 24.2187H7.04785C7.25047 19.5672 9.25061 15.1759 12.6269 11.9699C16.0032 8.76386 20.4921 6.99346 25.1479 7.03162C29.8017 6.99646 34.2876 8.76819 37.6614 11.9739C41.0352 15.1796 43.0338 19.5692 43.2363 24.2187H37.7842C36.7485 24.2199 35.7556 24.6318 35.0233 25.3641C34.291 26.0964 33.8791 27.0893 33.8779 28.125V35.9375C33.8791 36.9731 34.291 37.966 35.0233 38.6984C35.7556 39.4307 36.7485 39.8426 37.7842 39.8437H40.9092C41.7555 39.8434 42.5786 39.5665 43.2529 39.0551V40.625C43.2513 42.0749 42.6746 43.465 41.6494 44.4902C40.6242 45.5154 39.2341 46.0921 37.7842 46.0937H26.5625C26.3553 46.0937 26.1566 46.176 26.0101 46.3226C25.8636 46.4691 25.7812 46.6678 25.7812 46.875C25.7812 47.0822 25.8636 47.2809 26.0101 47.4274C26.1566 47.5739 26.3553 47.6562 26.5625 47.6562H37.7844C39.6485 47.6542 41.4358 46.9127 42.7539 45.5945C44.0721 44.2764 44.8136 42.4892 44.8156 40.625V25C44.8231 22.4217 44.3164 19.8679 43.3253 17.4877C42.3342 15.1075 40.8785 12.9489 39.0434 11.1379V11.1379ZM12.5 25.7812C13.1214 25.7819 13.7171 26.0291 14.1565 26.4684C14.5959 26.9078 14.8431 27.5036 14.8438 28.125V35.9375C14.8431 36.5589 14.5959 37.1546 14.1565 37.594C13.7171 38.0334 13.1214 38.2806 12.5 38.2812H9.375C8.75361 38.2806 8.15785 38.0334 7.71846 37.594C7.27907 37.1546 7.03192 36.5589 7.03125 35.9375V25.7812H12.5ZM40.9094 38.2812H37.7844C37.163 38.2806 36.5672 38.0334 36.1278 37.594C35.6884 37.1546 35.4413 36.5589 35.4406 35.9375V28.125C35.4413 27.5036 35.6884 26.9078 36.1278 26.4684C36.5672 26.0291 37.163 25.7819 37.7844 25.7812H43.2531V35.9375C43.2525 36.5589 43.0053 37.1546 42.5659 37.594C42.1265 38.0334 41.5308 38.2806 40.9094 38.2812Z\" fill=\"black\"></path></svg></div><div class=\"title-box\"><h3 class=\"title\">\n                                تماس با ما\n                            </h3><p>راه های ارتباطی با کاراوب</p><div class=\"blue-line\"></div></div></div></div><div class=\"section-head mt-5\"><div class=\"section-title\"><div class=\"title-icon\"><svg width=\"20\" height=\"20\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M24.9994 9.33325C23.4253 9.33325 21.8867 9.8 20.5779 10.6745C19.2692 11.5489 18.2492 12.7919 17.6468 14.2461C17.0445 15.7003 16.8869 17.3004 17.1939 18.8442C17.501 20.3879 18.259 21.806 19.372 22.919C20.485 24.032 21.903 24.7899 23.4468 25.097C24.9905 25.4041 26.5907 25.2465 28.0449 24.6441C29.4991 24.0418 30.742 23.0217 31.6165 21.713C32.4909 20.4043 32.9577 18.8656 32.9577 17.2916C32.9577 15.1809 32.1192 13.1567 30.6267 11.6642C29.1343 10.1717 27.11 9.33325 24.9994 9.33325V9.33325ZM24.9994 22.4721C23.9747 22.4721 22.9731 22.1683 22.1212 21.5991C21.2693 21.0298 20.6052 20.2207 20.2131 19.2741C19.821 18.3275 19.7184 17.2858 19.9183 16.2809C20.1182 15.276 20.6116 14.3529 21.3361 13.6284C22.0607 12.9039 22.9837 12.4105 23.9887 12.2106C24.9936 12.0107 26.0352 12.1133 26.9819 12.5054C27.9285 12.8975 28.7376 13.5615 29.3068 14.4134C29.8761 15.2654 30.1799 16.267 30.1799 17.2916C30.1762 18.6631 29.6288 19.9773 28.6577 20.9458C27.6865 21.9144 26.3709 22.4583 24.9994 22.4583V22.4721Z\" fill=\"#288ED9\"></path><path d=\"M24.9998 2.77783C20.6737 2.78145 16.5248 4.49684 13.4592 7.54935C10.3937 10.6019 8.66069 14.7434 8.63867 19.0695C8.63867 25.5556 12.2776 30.9862 14.9442 34.9445L15.4303 35.6667C18.0835 39.512 20.9297 43.2205 23.9581 46.7778L25.0137 48.0139L26.0692 46.7778C29.0972 43.2202 31.9434 39.5117 34.597 35.6667L35.0831 34.9306C37.7359 30.9723 41.3748 25.5556 41.3748 19.0695C41.3528 14.741 39.6178 10.5974 36.5493 7.54446C33.4808 4.49155 29.3283 2.77778 24.9998 2.77783V2.77783ZM32.7637 33.3334L32.2637 34.0695C29.8748 37.6528 26.7081 41.6667 24.9998 43.6528C23.3609 41.6667 20.1248 37.6528 17.7359 34.0695L17.2498 33.3334C14.7915 29.6667 11.4165 24.6528 11.4165 19.0139C11.4165 17.2302 11.7678 15.4638 12.4504 13.8158C13.133 12.1678 14.1336 10.6704 15.3949 9.40908C16.6562 8.14775 18.1537 7.14721 19.8017 6.46458C21.4497 5.78195 23.216 5.43061 24.9998 5.43061C26.7836 5.43061 28.5499 5.78195 30.1979 6.46458C31.8459 7.14721 33.3433 8.14775 34.6047 9.40908C35.866 10.6704 36.8665 12.1678 37.5491 13.8158C38.2318 15.4638 38.5831 17.2302 38.5831 19.0139C38.5831 24.7084 35.222 29.7223 32.7637 33.3334V33.3334Z\" fill=\"#288ED9\"></path></svg></div><div class=\"title-box\"><h4 class=\"title\">\n                                آدرس\n                            </h4><p>تهرانپارس، اتوبان باقری شمال، خیابان فرجام، خیابان باغدارنیا، پلاک 10، واحد 11</p></div></div></div><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><svg width=\"20\" height=\"20\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M40.6248 45.8333C42.3478 45.8333 43.7498 44.4313 43.7498 42.7083V35.4167C43.7498 33.6938 42.3478 32.2917 40.6248 32.2917C38.1873 32.2917 35.7915 31.9083 33.4998 31.1521C32.952 30.9791 32.3676 30.9581 31.8088 31.0913C31.25 31.2245 30.7378 31.5069 30.3269 31.9083L27.3269 34.9083C22.1417 32.0934 17.8832 27.8363 15.0665 22.6521L18.0415 19.6583C18.8998 18.8625 19.2082 17.6521 18.8415 16.4875C18.0868 14.1923 17.7042 11.7911 17.7082 9.375C17.7082 7.65208 16.3061 6.25 14.5832 6.25H7.2915C5.56859 6.25 4.1665 7.65208 4.1665 9.375C4.1665 29.4792 20.5207 45.8333 40.6248 45.8333ZM7.2915 8.33333H14.5832C14.8594 8.33333 15.1244 8.44308 15.3197 8.63843C15.5151 8.83378 15.6248 9.09873 15.6248 9.375C15.6248 12.0354 16.0415 14.6479 16.8603 17.125C16.9204 17.3048 16.9274 17.498 16.8805 17.6817C16.8336 17.8653 16.7347 18.0316 16.5957 18.1604L12.5207 22.2563C15.9311 28.9813 20.9686 34.0188 27.7248 37.4583L31.7853 33.3958C31.9238 33.2587 32.097 33.1619 32.2864 33.1156C32.4757 33.0694 32.6741 33.0755 32.8603 33.1333C35.3519 33.9583 37.9644 34.375 40.6248 34.375C41.1978 34.375 41.6665 34.8438 41.6665 35.4167V42.7083C41.6665 43.2813 41.1978 43.75 40.6248 43.75C21.6707 43.75 6.24984 28.3292 6.24984 9.375C6.24984 9.09873 6.35958 8.83378 6.55493 8.63843C6.75028 8.44308 7.01524 8.33333 7.2915 8.33333Z\" fill=\"#288ED9\"></path></svg></div><div class=\"title-box\"><h4 class=\"title\">\n                                تلفن\n                            </h4><p id=\"i4ul3\">021-77200630</p></div></div></div><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><svg width=\"20\" height=\"20\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M17.1875 6.25C14.6172 6.25 12.5 8.36719 12.5 10.9375V39.0625C12.5 41.6328 14.6172 43.75 17.1875 43.75H32.8125C35.3828 43.75 37.5 41.6328 37.5 39.0625V10.9375C37.5 8.36719 35.3828 6.25 32.8125 6.25H17.1875ZM17.1875 9.375H32.8125C33.6797 9.375 34.375 10.0703 34.375 10.9375V39.0625C34.375 39.9297 33.6797 40.625 32.8125 40.625H17.1875C16.3203 40.625 15.625 39.9297 15.625 39.0625V10.9375C15.625 10.0703 16.3203 9.375 17.1875 9.375ZM25 35.9375C24.5856 35.9375 24.1882 36.1021 23.8951 36.3951C23.6021 36.6882 23.4375 37.0856 23.4375 37.5C23.4375 37.9144 23.6021 38.3118 23.8951 38.6049C24.1882 38.8979 24.5856 39.0625 25 39.0625C25.4144 39.0625 25.8118 38.8979 26.1049 38.6049C26.3979 38.3118 26.5625 37.9144 26.5625 37.5C26.5625 37.0856 26.3979 36.6882 26.1049 36.3951C25.8118 36.1021 25.4144 35.9375 25 35.9375Z\" fill=\"#288ED9\"></path></svg></div><div class=\"title-box\"><h4 class=\"title\">\n                                تلفن همراه\n                            </h4><p>09125406059</p><p>09058775382</p></div></div></div></div><div class=\"col-md-6\"><iframe frameborder=\"0\" src=\"https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d1293.8233001986305!2d51.52110458214291!3d35.73300479760157!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x1ff72a08a3063b7c!2z2q_YsdmI2Ycg2qnYp9ix2KfZiNio!5e0!3m2!1sen!2s!4v1622704347947!5m2!1sen!2s\" width=\"600\" height=\"450\" allowfullscreen=\"\" loading=\"lazy\" id=\"isn2u\" class=\"w-100 br-20 card-shadow\"></iframe></div></div></div></section>','تماس با ما',NULL,NULL,'Article','contact',1,'https://karawebs.com/backend/images/grapesjs/1624092091-support.png',1,'2020-10-10 08:25:53','2021-11-16 13:36:51',0,'924'),
(9,'قیمت طراحی سایت پزشکی','<body><section id=\"i067\"><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><div id=\"ij0qi\"></div><div id=\"ip7p5v\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 39 39\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M9.75 8.125H30.875C32.1679 8.125 33.4079 8.63861 34.3221 9.55285C35.2364 10.4671 35.75 11.7071 35.75 13V24.375C35.75 25.6679 35.2364 26.9079 34.3221 27.8221C33.4079 28.7364 32.1679 29.25 30.875 29.25H23.5495L24.375 34.125H26V35.75H14.625V34.125H16.25L17.0755 29.25H9.75C8.45707 29.25 7.21709 28.7364 6.30285 27.8221C5.38861 26.9079 4.875 25.6679 4.875 24.375V13C4.875 11.7071 5.38861 10.4671 6.30285 9.55285C7.21709 8.63861 8.45707 8.125 9.75 8.125ZM18.7005 29.25L17.875 34.125H22.75L21.9245 29.25H18.7005ZM9.75 9.75C8.88805 9.75 8.0614 10.0924 7.4519 10.7019C6.84241 11.3114 6.5 12.138 6.5 13V24.375C6.5 25.237 6.84241 26.0636 7.4519 26.6731C8.0614 27.2826 8.88805 27.625 9.75 27.625H30.875C31.737 27.625 32.5636 27.2826 33.1731 26.6731C33.7826 26.0636 34.125 25.237 34.125 24.375V13C34.125 12.138 33.7826 11.3114 33.1731 10.7019C32.5636 10.0924 31.737 9.75 30.875 9.75H9.75ZM1.625 13C1.625 10.8451 2.48102 8.77849 4.00476 7.25476C5.52849 5.73102 7.59512 4.875 9.75 4.875H29.25V6.5H9.75C8.02609 6.5 6.37279 7.18482 5.15381 8.40381C3.93482 9.62279 3.25 11.2761 3.25 13V22.75H1.625V13Z\" fill=\"#4B3DA7\"></path></svg></div></div><div class=\"title-box\"><h2 class=\"title\">تعرفه طراحی سایت پزشکی</h2><p id=\"i7s6l\"> <strong id=\"iwwn8\">هزینه طراحی سایت پزشکی چقدر است؟</strong></p><div class=\"blue-line\"></div></div></div></div><p id=\"ivq9j\">گروه طراحی سایت کاراوب سعی در این دارد تا با ارائه پکیج هایی با امکانات عالی، قیمت خوب هم برای مشتریان در نظر گیرد. شما با توجه به نیازتان میتوانید یکی از 3 پکیج <a id=\"i9og8\" draggable=\"true\" data-highlightable=\"1\" data-cke-saved-href=\"https://karawebs.com/dr-webdesign\" href=\"https://karawebs.com/dr-webdesign\">طراحی سایت پزشکی</a> زیر را سفارش دهید یا اگر امکانات دلخواه را در این پکیج ها پیدا نمیکنید میتوانید با شماره 77200630-021 تماس بگیرید.</p><ul class=\"kw-list1\"><li>پشتیبانی 24 ساعته</li><li id=\"ijvip\">امنیت فوق العاده</li><li id=\"ibx5j\">سئوی استاندارد</li><li id=\"i9yzf\">امکان ارتقاء به سایت چند فروشندگی</li><li id=\"ih8pa\">پنل مدیریت حرفه ای</li></ul></div><div class=\"col-md-6\"><img src=\"/backend/images/grapesjs/1624019759-online-store.png\" alt=\"هزینه طراحی سایت پزشکی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section><section class=\"kw-pricing-table\"><div class=\"container\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M48.4699 1.01253C48.3248 0.651307 48.0461 0.35991 47.6917 0.198957C47.3373 0.0380044 46.9345 0.019888 46.567 0.148377C46.1996 0.276866 45.8958 0.542067 45.719 0.88881C45.5421 1.23555 45.5057 1.63714 45.6174 2.01003C47.9399 8.68503 43.3299 13.67 39.8149 16.34L38.3949 14.305C37.9174 13.6225 36.8499 13.055 36.0199 13.045L28.0499 13.08C27.0763 13.1094 26.1287 13.4014 25.3074 13.925L1.82238 30.3925C1.27611 30.7769 0.904423 31.3621 0.788689 32.02C0.672954 32.6779 0.822605 33.3548 1.20488 33.9025L11.8774 49.1725C12.6774 50.31 13.9549 50.1725 15.0949 49.3775L38.5799 32.9075C39.2549 32.43 40.0349 31.4 40.3099 30.6125L42.8049 22.75C43.0799 21.965 42.9124 20.7675 42.4349 20.085L41.5699 18.845C46.2899 15.2275 51.1899 8.83503 48.4699 1.01253V1.01253ZM37.5424 24.4075C37.1097 24.7104 36.6216 24.925 36.106 25.0392C35.5904 25.1533 35.0573 25.1648 34.5373 25.0728C34.0172 24.9809 33.5204 24.7874 33.0751 24.5033C32.6299 24.2193 32.245 23.8504 31.9424 23.4175C31.3297 22.5417 31.0896 21.4585 31.2747 20.4058C31.4599 19.353 32.0551 18.4168 32.9299 17.8025C33.6156 17.3221 34.4344 17.0679 35.2717 17.0755C36.109 17.0831 36.923 17.3522 37.5999 17.845C36.9199 18.255 36.4524 18.495 36.3649 18.5325C36.055 18.6803 35.8044 18.9289 35.6544 19.2377C35.5043 19.5465 35.4635 19.8971 35.5387 20.2321C35.614 20.5671 35.8008 20.8665 36.0685 21.0815C36.3363 21.2964 36.6691 21.414 37.0124 21.415C37.2274 21.415 37.4474 21.365 37.6549 21.2675C38.1399 21.0375 38.6599 20.765 39.2024 20.4425C39.3272 21.1927 39.2376 21.9628 38.9439 22.6643C38.6502 23.3658 38.1644 23.97 37.5424 24.4075V24.4075Z\" fill=\"#288ED9\"></path></svg></div><div class=\"title-box\"><h3 class=\"title\">هزینه طراحی سایت پزشکی</h3><p>پایینترین هزینه با کیفیت بالا...</p><div class=\"blue-line\"></div></div></div></div><ul><li class=\"active\"><button>پلن پایه</button></li><li><button>پلن حرفه ای</button></li><li><button>پلین ویژه</button></li></ul><table class=\"card-shadow\"><thead class=\"border-bottom\"><tr><th class=\"font-weight-bold\"><span id=\"ivllx\">طراحی سایت پزشکی</span></th><th class=\"font-weight-bold\"><span>پلن پایه</span></th><th class=\"font-weight-bold\"><span>پلن حرفه ای</span></th><th class=\"font-weight-bold\"><span id=\"id0dz\">پلن ویژه</span></th></tr></thead><tbody><tr><td class=\"font-weight-bold\"><span>قیمت</span></td><td id=\"i1ubx\"><span class=\"txt-l\"><span id=\"iva4u\">10.5</span></span><span class=\"txt-top\">میلیون تومان</span></td><td><span class=\"txt-l\"><span id=\"ix8v3\">12.5</span></span><span class=\"txt-top\">میلیون تومان</span></td><td><span class=\"txt-l\"><span id=\"iptz74\">15.5</span></span><span class=\"txt-top\">میلیون تومان</span></td></tr><tr><td colspan=\"5\" class=\"sep\"><span>امکانات وب سایت</span></td></tr><tr><td><span id=\"ir2vd6\">اجرای سایت با وردپرس</span></td><td><span class=\"tick\">✔</span></td><td><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"iwaidi\">هاست یک گیگابایت یکساله</span></td><td><span class=\"tick\">✔</span></td><td id=\"incn2i\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i20txe\">ظاهر دلخواه سایت</span></td><td><span class=\"tick\">✔</span></td><td id=\"i94pu7\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"ir7cxj\"><span id=\"iwgczn\">وبلاگ و مقالات پزشکی</span></td><td><span class=\"tick\">✔</span></td><td id=\"it9d2e\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"io4pxi\">تماس با ما</span></td><td><span class=\"tick\">✔</span></td><td id=\"iecftm\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i1cij3\">درباره ما</span></td><td><span class=\"tick\">✔</span></td><td id=\"i9tlqj\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"iaap4z\">فرم تماس</span></td><td><span class=\"tick\">✔</span></td><td id=\"ijs203\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"ioqfdn\">تعریف منو و زیر منو</span></td><td><span class=\"tick\">✔</span></td><td id=\"i768wi\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i3lagg\">گالری تصاویر</span></td><td><span class=\"tick\">✔</span></td><td id=\"ipkdhh\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"iv4nv7\">طراحی ریسپانسیو</span></td><td><span class=\"tick\">✔</span></td><td id=\"iezl15\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i63oxm\">سئو استاندارد</span></td><td><span class=\"tick\">✔</span></td><td id=\"ibqm3h\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"ismb6s\">آموزش ویدیویی پنل مدیریت</span></td><td><span class=\"tick\">✔</span></td><td id=\"i8r05f\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"ickc2t\">یکسال پشتیبانی رایگان</span></td><td><span class=\"tick\">✔</span></td><td id=\"i5vnib\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"ispfbc\"><span id=\"i069mk\">دامنه ir</span></td><td><span class=\"tick\">✔</span></td><td id=\"iv35v9\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"iv6t3u\"><span id=\"igr59p\">دامنه com</span></td><td><span id=\"il158e\">ندارد</span></td><td id=\"idwc8l\"><span class=\"tick\"><span id=\"inlepk\"><span id=\"in62sc\">✔</span></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"iixe03\"><span id=\"itbnl1\">فید یا خبرخوان</span></td><td id=\"iuhfhw\"><span class=\"tick\"><span id=\"izsfqs\">ندارد</span></span></td><td id=\"ix0cwu\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i4j4fg\">عضویت کاربران</span></td><td><span class=\"tick\"><span id=\"i7oyu6\">ندارد</span></span></td><td id=\"i6d5ta\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"ien5ki\">چت آنلاین</span></td><td><span class=\"tick\"><span id=\"iiby4i\">ندارد</span></span></td><td id=\"ixkhyu\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"i6fhcp\"><span id=\"i9d1sw\">صفحه ساز گرافیکی</span></td><td><span class=\"tick\"><span id=\"iq92gj\">ندارد</span></span></td><td id=\"ij614h\"><span class=\"tick\"><span id=\"i2h6wl\"><span id=\"i8yb8c\">✔</span></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"i0018b\"><span id=\"iajbnc\">چت واتساپ</span></td><td><span class=\"tick\"><span id=\"i022gm\">ندارد</span></span></td><td id=\"i1t8wh\"><span class=\"tick\"><span id=\"i03atd\"><span id=\"iqy6of\">✔</span></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"i920zu\"><span id=\"i2x9g5\">معرفی شبکه های اجتماعی</span></td><td><span class=\"tick\"><span id=\"in1n3k\">ندارد</span></span></td><td id=\"ice71r\"><span class=\"tick\"><span id=\"i8vatl\"><span id=\"i0sjxt\">✔</span></span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"inn5ro\"><span id=\"ivdu7i\">رزرو آنلاین نوبت</span></td><td><span class=\"tick\"><span id=\"iqqvhf\">ندارد</span></span></td><td id=\"it9y46\"><span class=\"tick\"><span id=\"i11v8e\">ندارد</span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i5kqkq\">افزایش سرعت و کشینگ</span></td><td><span class=\"tick\"><span id=\"i0on9j\">ندارد</span></span></td><td id=\"i66wqj\"><span class=\"tick\"><span id=\"iapoea\">ندارد</span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"ivhkte\">بهینه سازی تصاویر</span></td><td><span class=\"tick\"><span id=\"ih3fdl\">ندارد</span></span></td><td id=\"iusito\"><span class=\"tick\"><span id=\"ixeuhn\">ندارد</span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"ie9yjp\"><span id=\"iqasz1\">عضویت در خبرنامه</span></td><td><span class=\"tick\"><span id=\"i6v7mi\">ندارد</span></span></td><td id=\"iytieq\"><span class=\"tick\"><span id=\"ilh6c2\">ندارد</span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr><td class=\"font-weight-bold\">سفارش پکیج ها</td><td id=\"i7sxxr\"><a href=\"tel:02177200630\" class=\"kw-btn-blue mt-0\">021-77200630</a></td><td><a href=\"tel:02177200630\" class=\"kw-btn-blue mt-0\">021-77200630</a></td><td><a href=\"tel:02177200630\" class=\"kw-btn-blue mt-0\">021-77200630</a></td></tr></tbody></table></div></section></body>','قیمت طراحی سایت پزشکی',NULL,'قیمت طراحی سایت پزشکی, تعرفه طراحی سایت پزشکی','Article','dr-webdesign-price',1,'https://karawebs.com/backend/images/grapesjs/1624038352-dr.png',1,'2020-11-29 14:03:14','2023-05-20 10:53:09',0,'910'),
(10,'طراحی سایت شخصی','<section><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><div id=\"ij0qi\"></div><div id=\"ih64iv\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M32.4175 9.2C32.5368 8.89036 32.5283 8.54599 32.3937 8.24265C32.2592 7.93931 32.0096 7.70185 31.7 7.5825C31.3904 7.46315 31.046 7.4717 30.7427 7.60626C30.4393 7.74081 30.2018 7.99036 30.0825 8.3L17.5825 40.8C17.5234 40.9533 17.4951 41.1168 17.4992 41.281C17.5032 41.4453 17.5396 41.6072 17.6063 41.7574C17.6729 41.9076 17.7684 42.0432 17.8875 42.1564C18.0065 42.2697 18.1467 42.3584 18.3 42.4175C18.4533 42.4766 18.6168 42.5049 18.781 42.5008C18.9453 42.4968 19.1072 42.4604 19.2573 42.3937C19.4075 42.3271 19.5432 42.2316 19.6564 42.1125C19.7697 41.9935 19.8584 41.8533 19.9175 41.7L32.4175 9.2V9.2Z\" fill=\"black\"></path><path d=\"M14.5626 15.3C14.6877 15.4067 14.7905 15.5371 14.8652 15.6836C14.9399 15.8302 14.9849 15.99 14.9976 16.154C15.0104 16.3179 14.9907 16.4828 14.9396 16.6391C14.8886 16.7955 14.8072 16.9402 14.7001 17.065L7.89758 25L14.6976 32.9375C14.8985 33.1908 14.9935 33.5122 14.9624 33.8341C14.9314 34.156 14.7769 34.4533 14.5313 34.6636C14.2857 34.874 13.9681 34.981 13.6453 34.9621C13.3225 34.9432 13.0195 34.8 12.8001 34.5625L5.30008 25.8125C5.10642 25.5861 5 25.2979 5 25C5 24.702 5.10642 24.4139 5.30008 24.1875L12.8001 15.4375C13.0159 15.1859 13.3228 15.0303 13.6534 15.005C13.9839 14.9797 14.3109 15.0867 14.5626 15.3025V15.3Z\" fill=\"black\"></path><path d=\"M35.4375 35.95C35.3128 35.8433 35.2102 35.7131 35.1358 35.5668C35.0614 35.4204 35.0165 35.2609 35.0037 35.0972C34.991 34.9336 35.0105 34.769 35.0614 34.6129C35.1122 34.4568 35.1933 34.3123 35.3 34.1875L42.105 26.25L35.3 18.315C35.1932 18.1903 35.1119 18.0457 35.0609 17.8895C35.0099 17.7334 34.9902 17.5687 35.0029 17.4049C35.0155 17.2411 35.0603 17.0815 35.1347 16.935C35.209 16.7885 35.3115 16.6581 35.4363 16.5513C35.561 16.4444 35.7056 16.3631 35.8618 16.3122C36.0179 16.2612 36.1826 16.2414 36.3464 16.2541C36.5101 16.2667 36.6698 16.3115 36.8163 16.3859C36.9628 16.4603 37.0932 16.5628 37.2 16.6875L44.7 25.4375C44.8937 25.6639 45.0001 25.9521 45.0001 26.25C45.0001 26.5479 44.8937 26.8361 44.7 27.0625L37.2 35.8125C37.0933 35.9373 36.9631 36.0398 36.8168 36.1142C36.6705 36.1887 36.5109 36.2335 36.3473 36.2463C36.1836 36.2591 36.019 36.2395 35.8629 36.1886C35.7068 36.1378 35.5623 36.0567 35.4375 35.95V35.95Z\" fill=\"black\"></path></svg></div></div><div class=\"title-box\"><h2 class=\"title\">طراحی سایت شخصی چیست؟</h2><p id=\"i7s6l\"> <strong>بررسی این نوع وب سایت</strong></p><div class=\"blue-line\"></div></div></div></div><p id=\"ivq9j\">طراحی سایت شخصی یکی دیگر از انواع <a data-cke-saved-href=\"https://karawebs.com\" href=\"https://karawebs.com\">طراحی وب سایت</a> است که در گروه کاراوب به انجام میرسدو این نوع وب سایت برای اشخاص، هنرمندان، نمایندگان مجلس، عکاس ها و به طور کل کسانی که میخواهند در یک قالب بسیار شیک نمونه کار های خود را به صورت آنلاین به اشتراک بگذارند مناسب است. <strong>طراحی وب سایت شخصی</strong> در کاراوب مطابق اصول و مبانی طراحی بین المللی انجام میگردد.<br/>​​​​​​​با ما باشید تا به بررسی این موضوع بپردازیم.</p><ul class=\"kw-list1\"><li>پشتیبانی 24 ساعته</li><li id=\"ijvip\">امنیت فوق العاده</li><li id=\"ibx5j\">سئوی استاندارد</li><li id=\"i9yzf\">امکان ارتقاء به سایت فروشگاهی</li><li id=\"i0vnsk\">امکان ارتقاء به سایت شرکتی</li><li id=\"ih8pa\">پنل مدیریت حرفه ای</li></ul><a href=\"#faqs\" class=\"kw-btn-blue\">سوالات متداول</a><a href=\"https://karawebs.com/personal-webdesign-price\" class=\"kw-btn-blue\">تعرفه و امکانات</a></div><div class=\"col-md-6\"><img src=\"/backend/images/grapesjs/1624087299-code (1).png\" alt=\"طراحی سایت شخصی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section><section class=\"kw-p\"><div class=\"container\"><div id=\"iithp4\" class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 28 31\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" id=\"ip30j\"><path d=\"M16.2511 4.875H17.8761V3.25C17.8761 2.81902 17.7049 2.4057 17.4002 2.10095C17.0954 1.79621 16.6821 1.625 16.2511 1.625H11.3761C10.9451 1.625 10.5318 1.79621 10.2271 2.10095C9.92233 2.4057 9.75113 2.81902 9.75113 3.25V4.875H11.3761V8.242L2.08925 24.3262C1.79293 24.8195 1.63286 25.3825 1.62539 25.9578C1.61792 26.5331 1.76333 27.1001 2.04675 27.6009C2.33016 28.1016 2.74143 28.5181 3.23854 28.8079C3.73564 29.0976 4.30075 29.2502 4.87613 29.25H22.7511C23.3265 29.2502 23.8916 29.0976 24.3887 28.8079C24.8858 28.5181 25.2971 28.1016 25.5805 27.6009C25.8639 27.1001 26.0093 26.5331 26.0019 25.9578C25.9944 25.3825 25.8343 24.8195 25.538 24.3262L16.2511 8.242V4.875ZM4.87613 30.875C3.99846 30.8752 3.13702 30.6385 2.38272 30.1898C1.62842 29.7411 1.00924 29.0971 0.590535 28.3257C0.171827 27.5544 -0.0308794 26.6843 0.00381014 25.8073C0.0384997 24.9303 0.309298 24.079 0.787625 23.3431L9.75113 7.81787V6.5C9.32015 6.5 8.90682 6.32879 8.60208 6.02405C8.29733 5.7193 8.12613 5.30598 8.12613 4.875V3.25C8.12613 2.38805 8.46854 1.5614 9.07803 0.951903C9.68752 0.34241 10.5142 0 11.3761 0H16.2511C17.1131 0 17.9397 0.34241 18.5492 0.951903C19.1587 1.5614 19.5011 2.38805 19.5011 3.25V4.875C19.5011 5.30598 19.3299 5.7193 19.0252 6.02405C18.7204 6.32879 18.3071 6.5 17.8761 6.5V7.81787L26.8396 23.3431C27.318 24.079 27.5888 24.9303 27.6234 25.8073C27.6581 26.6843 27.4554 27.5544 27.0367 28.3257C26.618 29.0971 25.9988 29.7411 25.2445 30.1898C24.4902 30.6385 23.6288 30.8752 22.7511 30.875H4.87613ZM15.1039 19.9745L17.7461 17.3323L22.7511 26H4.87613L10.8236 15.6975L15.1039 19.9745ZM15.1039 22.2722L11.173 18.343L7.69062 24.375H19.9366L17.3984 19.9777L15.1039 22.2722ZM14.6261 11.375C15.0571 11.375 15.4704 11.5462 15.7752 11.851C16.0799 12.1557 16.2511 12.569 16.2511 13C16.2511 13.431 16.0799 13.8443 15.7752 14.149C15.4704 14.4538 15.0571 14.625 14.6261 14.625C14.1951 14.625 13.7818 14.4538 13.4771 14.149C13.1723 13.8443 13.0011 13.431 13.0011 13C13.0011 12.569 13.1723 12.1557 13.4771 11.851C13.7818 11.5462 14.1951 11.375 14.6261 11.375V11.375Z\" fill=\"#288ED9\"></path></svg></div></div><div class=\"title-box\"><h3 class=\"title\"> برخی نمونه کار ها</h3><p id=\"i6kfnf\">خلاقیت، کیفیت، زیبایی</p><div class=\"blue-line\"></div></div></div></div><div id=\"i0uqh\" class=\"row\"><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1619518884moshtaqi.jpg\" alt=\"\" id=\"ivo4b\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">داروخانه دکتر مشتاقی</h3><p class=\"subtitle\">طراحی سایت فروشگاهی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/moahtaqi-online\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1611133098screencapture-choobiranshop-2021-01-20-12_27_03.jpg\" alt=\"\" id=\"ive1u\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">فروشگاه چوب ایران</h3><p class=\"subtitle\">طراحی سایت فروشگاهی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/choobiranshop\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1611135044screencapture-elisa-shop-ir-2021-01-20-12_59_30.jpg\" alt=\"\" id=\"iafqy\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">الیسا شاپ</h3><p class=\"subtitle\">طراحی سایت فروشگاهی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/elisa-shop\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1614420323mira.jpg\" alt=\"\" id=\"ig75id\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">فروشگاه میراکالا</h3><p class=\"subtitle\">طراحی سایت فروشگاهی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/mirakala\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div></div></div></section><section id=\"iz6v0x\"><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><img src=\"/backend/images/grapesjs/1624030974-panel.png\" alt=\"طراحی وب سایت شخصی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h2 class=\"title\">پنل مدیریت اختصاصی طراحی سایت شخصی</h2><p id=\"ieficj\">بررسی امکانات</p><div class=\"blue-line\"></div></div></div></div><p id=\"i6qmdu\">گروه کاراوب با استفاده از کد نویسی اختصاصی، پنل مدیریت حرفه ای را برای وب سایت شخصی شما طراحی خواهد کرد و بعد از اتمام کار طراحی سایت فروشگاهی تمام جزئیات آن را در قالب یک ویدیوی آموزشی به شما آموزش خواهد داد.</p><ul class=\"kw-list1\"><li id=\"i25uh8\">هاست حرفه ای</li><li id=\"ia6iuw\">امنیت پنل مدیریت</li><li id=\"ixmdnh\">سهولت کار با پنل</li></ul></div></div></div></section><section class=\"what-we-do pt-5 pb-5\"><div class=\"container\"><div class=\"row\"><div class=\"col-md-12\"><div class=\"section-head justify-content-center\"><div class=\"section-title\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M40.625 45.8333C42.3479 45.8333 43.75 44.4313 43.75 42.7083V35.4167C43.75 33.6938 42.3479 32.2917 40.625 32.2917C38.1875 32.2917 35.7916 31.9083 33.5 31.1521C32.9522 30.9791 32.3677 30.9581 31.8089 31.0913C31.2501 31.2245 30.7379 31.5069 30.327 31.9083L27.327 34.9083C22.1419 32.0934 17.8834 27.8363 15.0666 22.6521L18.0416 19.6583C18.9 18.8625 19.2083 17.6521 18.8416 16.4875C18.0869 14.1923 17.7043 11.7911 17.7083 9.375C17.7083 7.65208 16.3062 6.25 14.5833 6.25H7.29163C5.56871 6.25 4.16663 7.65208 4.16663 9.375C4.16663 29.4792 20.5208 45.8333 40.625 45.8333ZM7.29163 8.33333H14.5833C14.8596 8.33333 15.1245 8.44308 15.3199 8.63843C15.5152 8.83378 15.625 9.09873 15.625 9.375C15.625 12.0354 16.0416 14.6479 16.8604 17.125C16.9205 17.3048 16.9276 17.498 16.8806 17.6817C16.8337 17.8653 16.7348 18.0316 16.5958 18.1604L12.5208 22.2563C15.9312 28.9813 20.9687 34.0188 27.725 37.4583L31.7854 33.3958C31.9239 33.2587 32.0971 33.1619 32.2865 33.1156C32.4759 33.0694 32.6742 33.0755 32.8604 33.1333C35.352 33.9583 37.9645 34.375 40.625 34.375C41.1979 34.375 41.6666 34.8438 41.6666 35.4167V42.7083C41.6666 43.2813 41.1979 43.75 40.625 43.75C21.6708 43.75 6.24996 28.3292 6.24996 9.375C6.24996 9.09873 6.35971 8.83378 6.55506 8.63843C6.75041 8.44308 7.01536 8.33333 7.29163 8.33333Z\" fill=\"#288ED9\"></path></svg></div><div class=\"title-box\"><h2 class=\"title\">\n                                تماس با گروه کاراوب\n                            </h2><p>مشاوره رایگان جهت راه اندازی وب سایت...</p><div class=\"blue-line\"></div></div></div></div></div><div class=\"col-md-12\"><div class=\"d-flex justify-content-center\"><div class=\"contact-us\"><p class=\"contact-phone\">021-77200630</p></div></div></div></div></div></section><section><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div id=\"igrswx\" class=\"row\"><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/undraw_Mobile_app_re_catg%20(1).png\" alt=\"ویژگی سایت شخصی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h2 class=\"title\">ویژگی های طراحی سایت شخصی</h2><p id=\"i19j5a\">طراحی سایت شخصی چه ویژگی هایی دارد؟</p><div class=\"blue-line\"></div></div></div></div><p id=\"iextrd\"><strong>مدیریت حرفه ای طراحی وب سایت شخصی:</strong> یک پنل مدیریت خوب که بتوان صفحات مختلف و منو های وب سایت را به صورت پویا تغییر یا ویرایش کرد.</p><p id=\"i9e2ju\"><strong>طراحی ریسپانسیو وب سایت شخصی:</strong> طراحی سایت شخصی در کاراوب به صورت کاملا ریسپانسیو طراحی شده و این قابلیت را دارد که در تمامی صفحه های نمایش سازگار باشد.</p></div></div></div></section><section id=\"inzibp\"><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div id=\"i5l95y\" class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h3 class=\"title\">امکانات طراحی وب سایت شخصی</h3><p id=\"iv9c94\">معرفی امکانات</p><div class=\"blue-line\"></div></div></div></div><p id=\"iq1y3l\">یک وب سایت شخصی بر اساس دسته بندی مورد نظر شما میتواند شامل امکانات گوناگونی باشد، امکانات پایه به شرح زیر است:</p><ul class=\"kw-list1\"><li id=\"iwth8k\">ااپلیکیشن موبایل برای چت آنلاین</li><li id=\"iep7mr\">دسترسی به گفتگو ها از طریق پنل مدیریت</li><li id=\"i9wgyp\">امکان نمایش کاربران آنلاین در وب سایت شما</li><li id=\"iycznc\">نمونه کارها</li><li id=\"i3g1ok\">تماس با ما</li><li id=\"iyvch4\">اخبار</li><li id=\"i5b7mu\">درباره ما</li><li id=\"ivf095\">مقالات</li><li id=\"ikxxma\">نظر سنجی</li><li id=\"ig7pmj\">چت واتساپ</li><li id=\"i2cdtr\">گالری تصاویر</li><li id=\"i87iki\">آمار بازدید وبسایت</li><li id=\"i0fn5j\">فرم تماس</li></ul><a href=\"https://karawebs.com/portfolios\" title=\"نمونه کارها\" class=\"kw-btn-blue\">نمونه کارها</a></div><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/emkanat%20(1).png\" alt=\"امکانات سایت شخصی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section>','طراحی سایت شخصی | طراحی وب سایت شخصی','طراحی سایت شخصی یکی دیگر از انواع طراحی وب سایت است که در گروه کاراوب به انجام میرسدو این نوع وب سایت برای اشخاص، هنرمندان، نمایندگان مجلس، عکاس ها و به طور کل کسانی که میخواهند در یک قالب بسیار شیک نمونه کار های خود را به صورت آنلاین به اشتراک بگذارند مناسب است.','طراحی سایت شخصی , طراحی وب سایت شخصی','Article','personal-webdesign',1,'https://karawebs.com/backend/images/grapesjs/1624087299-code%20(1).png',1,'2021-01-30 08:03:02','2021-11-16 13:35:17',0,'900'),
(11,'هزینه طراحی سایت شخصی','<section id=\"i067\"><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><div id=\"ij0qi\"></div><div id=\"ip7p5v\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 39 39\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M9.75 8.125H30.875C32.1679 8.125 33.4079 8.63861 34.3221 9.55285C35.2364 10.4671 35.75 11.7071 35.75 13V24.375C35.75 25.6679 35.2364 26.9079 34.3221 27.8221C33.4079 28.7364 32.1679 29.25 30.875 29.25H23.5495L24.375 34.125H26V35.75H14.625V34.125H16.25L17.0755 29.25H9.75C8.45707 29.25 7.21709 28.7364 6.30285 27.8221C5.38861 26.9079 4.875 25.6679 4.875 24.375V13C4.875 11.7071 5.38861 10.4671 6.30285 9.55285C7.21709 8.63861 8.45707 8.125 9.75 8.125ZM18.7005 29.25L17.875 34.125H22.75L21.9245 29.25H18.7005ZM9.75 9.75C8.88805 9.75 8.0614 10.0924 7.4519 10.7019C6.84241 11.3114 6.5 12.138 6.5 13V24.375C6.5 25.237 6.84241 26.0636 7.4519 26.6731C8.0614 27.2826 8.88805 27.625 9.75 27.625H30.875C31.737 27.625 32.5636 27.2826 33.1731 26.6731C33.7826 26.0636 34.125 25.237 34.125 24.375V13C34.125 12.138 33.7826 11.3114 33.1731 10.7019C32.5636 10.0924 31.737 9.75 30.875 9.75H9.75ZM1.625 13C1.625 10.8451 2.48102 8.77849 4.00476 7.25476C5.52849 5.73102 7.59512 4.875 9.75 4.875H29.25V6.5H9.75C8.02609 6.5 6.37279 7.18482 5.15381 8.40381C3.93482 9.62279 3.25 11.2761 3.25 13V22.75H1.625V13Z\" fill=\"#4B3DA7\"></path></svg></div></div><div class=\"title-box\"><h2 class=\"title\">تعرفه طراحی سایت شخصی</h2><p id=\"i7s6l\"> <strong id=\"iwwn8\">هزینه طراحی سایت شخصی چقدر است؟</strong></p><div class=\"blue-line\"></div></div></div></div><p id=\"ivq9j\">گروه <strong id=\"i47xo\" data-gjs-type=\"text\" draggable=\"true\" data-highlightable=\"1\">طراحی سایت </strong>کاراوب سعی در این دارد تا با ارائه پکیج هایی با امکانات عالی، قیمت خوب هم برای مشتریان در نظر گیرد. شما با توجه به نیازتان میتوانید یکی از 3 پکیج&nbsp;<a id=\"i5p2b\" data-gjs-type=\"link\" draggable=\"true\" data-highlightable=\"1\" data-cke-saved-href=\"https://karawebs.com/personal-webdesign\" href=\"https://karawebs.com/personal-webdesign\">طراحی سایت شخصی</a>&nbsp;زیر را سفارش دهید یا اگر امکانات دلخواه را در این پکیج ها پیدا نمیکنید میتوانید با شماره&nbsp;77200630-021&nbsp;تماس بگیرید. هزینه طراحی سایت شرکتی بر اساس امکانات داخل پکیج ها محاسبه شده است.</p><ul class=\"kw-list1\"><li>پشتیبانی 24 ساعته</li><li id=\"ijvip\">امنیت فوق العاده</li><li id=\"ibx5j\">سئوی استاندارد</li><li id=\"i9yzf\">امکان ارتقاء به سایت چند فروشندگی</li><li id=\"ih8pa\">پنل مدیریت حرفه ای</li></ul></div><div class=\"col-md-6\"><img src=\"/backend/images/grapesjs/1624019759-online-store.png\" alt=\"هزینه طراحی سایت شخصی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section><section class=\"kw-pricing-table\"><div class=\"container\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M48.4699 1.01253C48.3248 0.651307 48.0461 0.35991 47.6917 0.198957C47.3373 0.0380044 46.9345 0.019888 46.567 0.148377C46.1996 0.276866 45.8958 0.542067 45.719 0.88881C45.5421 1.23555 45.5057 1.63714 45.6174 2.01003C47.9399 8.68503 43.3299 13.67 39.8149 16.34L38.3949 14.305C37.9174 13.6225 36.8499 13.055 36.0199 13.045L28.0499 13.08C27.0763 13.1094 26.1287 13.4014 25.3074 13.925L1.82238 30.3925C1.27611 30.7769 0.904423 31.3621 0.788689 32.02C0.672954 32.6779 0.822605 33.3548 1.20488 33.9025L11.8774 49.1725C12.6774 50.31 13.9549 50.1725 15.0949 49.3775L38.5799 32.9075C39.2549 32.43 40.0349 31.4 40.3099 30.6125L42.8049 22.75C43.0799 21.965 42.9124 20.7675 42.4349 20.085L41.5699 18.845C46.2899 15.2275 51.1899 8.83503 48.4699 1.01253V1.01253ZM37.5424 24.4075C37.1097 24.7104 36.6216 24.925 36.106 25.0392C35.5904 25.1533 35.0573 25.1648 34.5373 25.0728C34.0172 24.9809 33.5204 24.7874 33.0751 24.5033C32.6299 24.2193 32.245 23.8504 31.9424 23.4175C31.3297 22.5417 31.0896 21.4585 31.2747 20.4058C31.4599 19.353 32.0551 18.4168 32.9299 17.8025C33.6156 17.3221 34.4344 17.0679 35.2717 17.0755C36.109 17.0831 36.923 17.3522 37.5999 17.845C36.9199 18.255 36.4524 18.495 36.3649 18.5325C36.055 18.6803 35.8044 18.9289 35.6544 19.2377C35.5043 19.5465 35.4635 19.8971 35.5387 20.2321C35.614 20.5671 35.8008 20.8665 36.0685 21.0815C36.3363 21.2964 36.6691 21.414 37.0124 21.415C37.2274 21.415 37.4474 21.365 37.6549 21.2675C38.1399 21.0375 38.6599 20.765 39.2024 20.4425C39.3272 21.1927 39.2376 21.9628 38.9439 22.6643C38.6502 23.3658 38.1644 23.97 37.5424 24.4075V24.4075Z\" fill=\"#288ED9\"></path></svg></div><div class=\"title-box\"><h3 class=\"title\">هزینه طراحی سایت شخصی</h3><p>پایینترین هزینه با کیفیت بالا...</p><div class=\"blue-line\"></div></div></div></div><ul><li class=\"active\"><button>پلن پایه</button></li><li><button>پلن حرفه ای</button></li><li><button>پلین ویژه</button></li></ul><table class=\"card-shadow\"><thead class=\"border-bottom\"><tr><th class=\"font-weight-bold\"><span id=\"ivllx\">طراحی سایت شخصی</span></th><th class=\"font-weight-bold\"><span>پلن پایه</span></th><th class=\"font-weight-bold\"><span>پلن حرفه ای</span></th><th class=\"font-weight-bold\"><span>پلن ورژه</span></th></tr></thead><tbody><tr><td class=\"font-weight-bold\"><span>قیمت</span></td><td id=\"i1ubx\"><span class=\"txt-l\"><span id=\"iva4u\">2.2</span></span><span class=\"txt-top\">میلیون تومان</span></td><td><span class=\"txt-l\"><span id=\"ix8v3\">3.2</span></span><span class=\"txt-top\">میلیون تومان</span></td><td><span class=\"txt-l\"><span id=\"iptz74\">4.2</span></span><span class=\"txt-top\">میلیون تومان</span></td></tr><tr><td colspan=\"5\" class=\"sep\"><span>امکانات وب سایت</span></td></tr><tr><td><span>اجرای سایت با وردپرس</span></td><td><span class=\"tick\">✔</span></td><td><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"iwaidi\">هاست یک گیگابایت یکساله</span></td><td><span class=\"tick\">✔</span></td><td id=\"incn2i\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i20txe\">ظاهر دلخواه سایت</span></td><td><span class=\"tick\">✔</span></td><td id=\"i94pu7\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"ir7cxj\"><span id=\"iwgczn\">پنل مدیریت پیشرفته</span></td><td><span class=\"tick\">✔</span></td><td id=\"it9d2e\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"io4pxi\">تماس با ما</span></td><td><span class=\"tick\">✔</span></td><td id=\"iecftm\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i1cij3\">درباره ما</span></td><td><span class=\"tick\">✔</span></td><td id=\"i9tlqj\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"iaap4z\">فرم تماس</span></td><td><span class=\"tick\">✔</span></td><td id=\"ijs203\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"ioqfdn\">تعریف نمونه کار و پروژه</span></td><td><span class=\"tick\">✔</span></td><td id=\"i768wi\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i3lagg\">گالری تصاویر</span></td><td><span class=\"tick\">✔</span></td><td id=\"ipkdhh\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"iv4nv7\">طراحی ریسپانسیو</span></td><td><span class=\"tick\">✔</span></td><td id=\"iezl15\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i63oxm\">سئو استاندارد</span></td><td><span class=\"tick\">✔</span></td><td id=\"ibqm3h\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"ismb6s\">آموزش ویدیویی پنل مدیریت</span></td><td><span class=\"tick\">✔</span></td><td id=\"i8r05f\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"ickc2t\">یکسال پشتیبانی رایگان</span></td><td><span class=\"tick\">✔</span></td><td id=\"i5vnib\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"iixe03\"><span id=\"itbnl1\">فید یا خبرخوان</span></td><td id=\"iuhfhw\"><span class=\"tick\"><span id=\"iseupi\">ندارد</span></span></td><td id=\"ix0cwu\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i4j4fg\">عضویت کاربران</span></td><td><span class=\"tick\"><span id=\"iqi8cx\">ندارد</span></span></td><td id=\"i6d5ta\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"ien5ki\">چت آنلاین</span></td><td><span class=\"tick\"><span id=\"iwr1ab\">ندارد</span></span></td><td id=\"ixkhyu\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i069mk\">دامنه ir</span></td><td><span class=\"tick\">✔</span></td><td id=\"iv35v9\"><span class=\"tick\">✔</span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"iv6t3u\"><span id=\"igr59p\">دامنه com</span></td><td><span id=\"il158e\">ندارد</span></td><td id=\"idwc8l\"><span class=\"tick\"><span id=\"iqks63\">ندارد</span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"i6fhcp\"><span id=\"i9d1sw\">صفحه ساز گرافیکی</span></td><td><span class=\"tick\"><span id=\"iw6i2e\">ندارد</span></span></td><td id=\"ij614h\"><span class=\"tick\"><span id=\"i0x9ap\">ندارد</span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"inn5ro\"><span id=\"ivdu7i\">نقشه گوگل</span></td><td><span class=\"tick\"><span id=\"ilqwej\">ندارد</span></span></td><td id=\"it9y46\"><span class=\"tick\"><span id=\"iuiuxf\">ندارد</span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"iajbnc\">چت واتساپ</span></td><td><span class=\"tick\"><span id=\"i77o8i\">ندارد</span></span></td><td id=\"i1t8wh\"><span class=\"tick\"><span id=\"iv8zm8\">ندارد</span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i5kqkq\">افزایش سرعت و کشینگ</span></td><td><span class=\"tick\"><span id=\"ipb0pr\">ندارد</span></span></td><td id=\"i66wqj\"><span class=\"tick\"><span id=\"i5nyhj\">ندارد</span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"ivhkte\">بهینه سازی تصاویر</span></td><td><span class=\"tick\"><span id=\"isfeq6\">ندارد</span></span></td><td id=\"iusito\"><span class=\"tick\"><span id=\"iqyydi\">ندارد</span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td><span id=\"i2x9g5\">معرفی شبکه های اجتماعی</span></td><td><span class=\"tick\"><span id=\"i2sfwu\">ندارد</span></span></td><td id=\"ice71r\"><span class=\"tick\"><span id=\"ivders\">ندارد</span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr class=\"border-bottom\"><td id=\"ie9yjp\"><span id=\"iqasz1\">عضویت در خبرنامه</span></td><td><span class=\"tick\"><span id=\"irsd97\">ندارد</span></span></td><td id=\"iytieq\"><span class=\"tick\"><span id=\"iy41gk\">ندارد</span></span></td><td class=\"default\"><span class=\"tick\">✔</span></td></tr><tr><td class=\"font-weight-bold\">سفارش پکیج ها</td><td id=\"i7sxxr\"><a href=\"tel:02177200630\" class=\"kw-btn-blue mt-0\">021-77200630</a></td><td><a href=\"tel:02177200630\" class=\"kw-btn-blue mt-0\">021-77200630</a></td><td id=\"ic6n8k\"><a href=\"tel:02177200630\" class=\"kw-btn-blue mt-0\">021-77200630</a></td></tr></tbody></table></div></section>','هزینه طراحی سایت شخصی | قیمت طراحی سایت شخصی','هزینه طراحی سایت شخصی بر اساس امکانات متنوعی محاسبه میشود که میتوانید آنها را در این صفحه مشاهده کنید','هزینه طراحی سایت شخصی , قیمت طراحی سایت شخصی','Article','personal-webdesign-price',1,'https://karawebs.com/backend/images/grapesjs/1624087299-code%20(1).png',1,'2021-01-30 08:47:50','2021-11-16 13:34:52',0,'802'),
(12,'طراحی سایت داروخانه','<section><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><div id=\"ij0qi\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><g clip-path=\"url(#clip0)\"><path d=\"M9.28125 4.21875C9.57465 3.87573 9.93887 3.60035 10.3489 3.41153C10.7588 3.22272 11.2049 3.12497 11.6563 3.125H38.3438C38.7951 3.12497 39.2412 3.22272 39.6511 3.41153C40.0611 3.60035 40.4254 3.87573 40.7187 4.21875L48.8719 13.7313C49.5998 14.5807 50 15.6625 50 16.7812V17.5781C50.0002 19.1249 49.5171 20.6331 48.6182 21.8919C47.7193 23.1508 46.4496 24.0973 44.9865 24.5992C43.5234 25.1011 41.94 25.1334 40.4577 24.6915C38.9754 24.2495 37.6682 23.3555 36.7188 22.1344C36.0254 23.0274 35.137 23.7499 34.1214 24.2466C33.1057 24.7433 31.9899 25.001 30.8594 25C29.7288 25.0013 28.6129 24.7437 27.5972 24.2469C26.5816 23.7502 25.6932 23.0276 25 22.1344C24.3068 23.0276 23.4184 23.7502 22.4028 24.2469C21.3871 24.7437 20.2712 25.0013 19.1406 25C18.01 25.0013 16.8941 24.7437 15.8785 24.2469C14.8628 23.7502 13.9744 23.0276 13.2812 22.1344C12.3318 23.3555 11.0246 24.2495 9.5423 24.6915C8.05998 25.1334 6.47661 25.1011 5.01351 24.5992C3.55041 24.0973 2.2807 23.1508 1.38182 21.8919C0.482943 20.6331 -0.000170621 19.1249 4.52017e-08 17.5781V16.7812C3.93986e-05 15.6625 0.400177 14.5807 1.12813 13.7313L9.28437 4.21562L9.28125 4.21875ZM14.8438 17.5781C14.8438 18.7177 15.2965 19.8107 16.1023 20.6165C16.9081 21.4223 18.001 21.875 19.1406 21.875C20.2802 21.875 21.3732 21.4223 22.179 20.6165C22.9848 19.8107 23.4375 18.7177 23.4375 17.5781C23.4375 17.1637 23.6021 16.7663 23.8951 16.4733C24.1882 16.1802 24.5856 16.0156 25 16.0156C25.4144 16.0156 25.8118 16.1802 26.1049 16.4733C26.3979 16.7663 26.5625 17.1637 26.5625 17.5781C26.5625 18.7177 27.0152 19.8107 27.821 20.6165C28.6268 21.4223 29.7198 21.875 30.8594 21.875C31.999 21.875 33.0919 21.4223 33.8977 20.6165C34.7035 19.8107 35.1562 18.7177 35.1562 17.5781C35.1562 17.1637 35.3209 16.7663 35.6139 16.4733C35.9069 16.1802 36.3043 16.0156 36.7188 16.0156C37.1332 16.0156 37.5306 16.1802 37.8236 16.4733C38.1166 16.7663 38.2812 17.1637 38.2812 17.5781C38.2813 18.7177 38.734 19.8107 39.5398 20.6165C40.3456 21.4223 41.4385 21.875 42.5781 21.875C43.7177 21.875 44.8107 21.4223 45.6165 20.6165C46.4223 19.8107 46.875 18.7177 46.875 17.5781V16.7812C46.875 16.4088 46.742 16.0487 46.5 15.7656L38.3438 6.25H11.6563L3.5 15.7656C3.25796 16.0487 3.12497 16.4088 3.125 16.7812V17.5781C3.125 18.7177 3.57771 19.8107 4.38353 20.6165C5.18935 21.4223 6.28227 21.875 7.42188 21.875C8.56148 21.875 9.6544 21.4223 10.4602 20.6165C11.266 19.8107 11.7188 18.7177 11.7188 17.5781C11.7187 17.1637 11.8834 16.7663 12.1764 16.4733C12.4694 16.1802 12.8668 16.0156 13.2812 16.0156C13.6957 16.0156 14.0931 16.1802 14.3861 16.4733C14.6791 16.7663 14.8438 17.1637 14.8438 17.5781V17.5781ZM4.6875 26.5625C5.1019 26.5625 5.49933 26.7271 5.79235 27.0201C6.08538 27.3132 6.25 27.7106 6.25 28.125V46.875H9.375V31.25C9.375 30.4212 9.70424 29.6263 10.2903 29.0403C10.8763 28.4542 11.6712 28.125 12.5 28.125H21.875C22.7038 28.125 23.4987 28.4542 24.0847 29.0403C24.6708 29.6263 25 30.4212 25 31.25V46.875H43.75V28.125C43.75 27.7106 43.9146 27.3132 44.2076 27.0201C44.5007 26.7271 44.8981 26.5625 45.3125 26.5625C45.7269 26.5625 46.1243 26.7271 46.4174 27.0201C46.7104 27.3132 46.875 27.7106 46.875 28.125V46.875H48.4375C48.8519 46.875 49.2493 47.0396 49.5424 47.3326C49.8354 47.6257 50 48.0231 50 48.4375C50 48.8519 49.8354 49.2493 49.5424 49.5424C49.2493 49.8354 48.8519 50 48.4375 50H1.5625C1.1481 50 0.750671 49.8354 0.457646 49.5424C0.16462 49.2493 4.52017e-08 48.8519 4.52017e-08 48.4375C4.52017e-08 48.0231 0.16462 47.6257 0.457646 47.3326C0.750671 47.0396 1.1481 46.875 1.5625 46.875H3.125V28.125C3.125 27.7106 3.28962 27.3132 3.58265 27.0201C3.87567 26.7271 4.2731 26.5625 4.6875 26.5625V26.5625ZM12.5 46.875H21.875V31.25H12.5V46.875ZM28.125 31.25C28.125 30.4212 28.4542 29.6263 29.0403 29.0403C29.6263 28.4542 30.4212 28.125 31.25 28.125H37.5C38.3288 28.125 39.1237 28.4542 39.7097 29.0403C40.2958 29.6263 40.625 30.4212 40.625 31.25V40.625C40.625 41.4538 40.2958 42.2487 39.7097 42.8347C39.1237 43.4208 38.3288 43.75 37.5 43.75H31.25C30.4212 43.75 29.6263 43.4208 29.0403 42.8347C28.4542 42.2487 28.125 41.4538 28.125 40.625V31.25ZM37.5 31.25H31.25V40.625H37.5V31.25Z\" fill=\"#288ED9\"></path></g><defs><clippath id=\"clip0\"><rect width=\"50\" height=\"50\" fill=\"white\"></rect></clippath></defs></svg></div></div><div class=\"title-box\"><h2 class=\"title\">طراحی سایت داروخانه آنلاین، خرید دارو با چند کلیک</h2><p id=\"i7s6l\"> <strong>بررسی این نوع وب سایت</strong></p><div class=\"blue-line\"></div></div></div></div><p id=\"ivq9j\">امروزه مردم برای تامین نیاز هی خود اکثرا از دنیای اینترنت استفاده میکنند. خرید دارو به صورت آنلاین هم به فعالیت های آنلاین مردم طی سال های اخیر اضافه گردیده است. طراحی سایت داروخانه این امکان را به صاحبان داروخانه میدهد تا به صورت آنلاین و بدون اتلاف وقت نیاز های بیماران و مشتریان خود را برطرف کنند. طراحی وب سایت داروخانه میتواند امکانات گوناگونی داشته باشد. کاراوب این نوع وب سایت را به زیبایی هر چه تمام تر و بر اساس متد های بین المللی برای شما طراحی میکند.</p><ul class=\"kw-list1\"><li>پشتیبانی 24 ساعته</li><li id=\"ijvip\">امنیت فوق العاده</li><li id=\"ibx5j\">سئوی استاندارد</li><li id=\"i9yzf\">امکان ارتقاء به سایت چند فروشندگی</li><li id=\"ih8pa\">پنل مدیریت حرفه ای</li></ul><a href=\"#faqs\" class=\"kw-btn-blue\">سوالات متداول</a><a href=\"https://karawebs.com/online-store-prices\" class=\"kw-btn-blue\">تعرفه و امکانات</a></div><div class=\"col-md-6\"><img src=\"/backend/images/grapesjs/1624085643-pharmacy.png\" alt=\"طراحی سایت داروخانه\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section><section class=\"kw-p\"><div class=\"container\"><div id=\"iithp4\" class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 28 31\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" id=\"ip30j\"><path d=\"M16.2511 4.875H17.8761V3.25C17.8761 2.81902 17.7049 2.4057 17.4002 2.10095C17.0954 1.79621 16.6821 1.625 16.2511 1.625H11.3761C10.9451 1.625 10.5318 1.79621 10.2271 2.10095C9.92233 2.4057 9.75113 2.81902 9.75113 3.25V4.875H11.3761V8.242L2.08925 24.3262C1.79293 24.8195 1.63286 25.3825 1.62539 25.9578C1.61792 26.5331 1.76333 27.1001 2.04675 27.6009C2.33016 28.1016 2.74143 28.5181 3.23854 28.8079C3.73564 29.0976 4.30075 29.2502 4.87613 29.25H22.7511C23.3265 29.2502 23.8916 29.0976 24.3887 28.8079C24.8858 28.5181 25.2971 28.1016 25.5805 27.6009C25.8639 27.1001 26.0093 26.5331 26.0019 25.9578C25.9944 25.3825 25.8343 24.8195 25.538 24.3262L16.2511 8.242V4.875ZM4.87613 30.875C3.99846 30.8752 3.13702 30.6385 2.38272 30.1898C1.62842 29.7411 1.00924 29.0971 0.590535 28.3257C0.171827 27.5544 -0.0308794 26.6843 0.00381014 25.8073C0.0384997 24.9303 0.309298 24.079 0.787625 23.3431L9.75113 7.81787V6.5C9.32015 6.5 8.90682 6.32879 8.60208 6.02405C8.29733 5.7193 8.12613 5.30598 8.12613 4.875V3.25C8.12613 2.38805 8.46854 1.5614 9.07803 0.951903C9.68752 0.34241 10.5142 0 11.3761 0H16.2511C17.1131 0 17.9397 0.34241 18.5492 0.951903C19.1587 1.5614 19.5011 2.38805 19.5011 3.25V4.875C19.5011 5.30598 19.3299 5.7193 19.0252 6.02405C18.7204 6.32879 18.3071 6.5 17.8761 6.5V7.81787L26.8396 23.3431C27.318 24.079 27.5888 24.9303 27.6234 25.8073C27.6581 26.6843 27.4554 27.5544 27.0367 28.3257C26.618 29.0971 25.9988 29.7411 25.2445 30.1898C24.4902 30.6385 23.6288 30.8752 22.7511 30.875H4.87613ZM15.1039 19.9745L17.7461 17.3323L22.7511 26H4.87613L10.8236 15.6975L15.1039 19.9745ZM15.1039 22.2722L11.173 18.343L7.69062 24.375H19.9366L17.3984 19.9777L15.1039 22.2722ZM14.6261 11.375C15.0571 11.375 15.4704 11.5462 15.7752 11.851C16.0799 12.1557 16.2511 12.569 16.2511 13C16.2511 13.431 16.0799 13.8443 15.7752 14.149C15.4704 14.4538 15.0571 14.625 14.6261 14.625C14.1951 14.625 13.7818 14.4538 13.4771 14.149C13.1723 13.8443 13.0011 13.431 13.0011 13C13.0011 12.569 13.1723 12.1557 13.4771 11.851C13.7818 11.5462 14.1951 11.375 14.6261 11.375V11.375Z\" fill=\"#288ED9\"></path></svg></div></div><div class=\"title-box\"><h3 class=\"title\"> برخی نمونه کار ها</h3><p id=\"i6kfnf\">خلاقیت، کیفیت، زیبایی</p><div class=\"blue-line\"></div></div></div></div><div id=\"i0uqh\" class=\"row\"><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1619518884moshtaqi.jpg\" alt=\"\" id=\"ivo4b\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">داروخانه دکتر مشتاقی</h3><p class=\"subtitle\">طراحی سایت فروشگاهی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/moahtaqi-online\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1611133098screencapture-choobiranshop-2021-01-20-12_27_03.jpg\" alt=\"\" id=\"ive1u\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">فروشگاه چوب ایران</h3><p class=\"subtitle\">طراحی سایت فروشگاهی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/choobiranshop\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1611135044screencapture-elisa-shop-ir-2021-01-20-12_59_30.jpg\" alt=\"\" id=\"iafqy\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">الیسا شاپ</h3><p class=\"subtitle\">طراحی سایت فروشگاهی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/elisa-shop\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"https://karawebs.com/images/1614420323mira.jpg\" alt=\"\" id=\"ig75id\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">فروشگاه میراکالا</h3><p class=\"subtitle\">طراحی سایت فروشگاهی</p></div><div class=\"kw-p-btn\"><a href=\"https://karawebs.com/portfolios/mirakala\" class=\"kw-btn-blue\"><svg width=\"10\" height=\"10\" viewBox=\"0 0 10 10\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M4.79176 7.5C6.45385 7.5 7.89927 6.57333 8.63968 5.20833C8.26435 4.51504 7.70861 3.93608 7.03127 3.53268C6.35392 3.12927 5.58014 2.91643 4.79176 2.91667C4.00339 2.91643 3.22961 3.12927 2.55226 3.53268C1.87492 3.93608 1.31918 4.51504 0.943848 5.20833C1.31918 5.90163 1.87492 6.48059 2.55226 6.88399C3.22961 7.28739 4.00339 7.50023 4.79176 7.5ZM4.79176 2.5C5.69318 2.4997 6.57641 2.75367 7.33998 3.23275C8.10356 3.71183 8.71651 4.39657 9.10843 5.20833C8.71651 6.02009 8.10356 6.70484 7.33998 7.18392C6.57641 7.66299 5.69318 7.91697 4.79176 7.91667C3.89034 7.91697 3.00712 7.66299 2.24355 7.18392C1.47997 6.70484 0.86702 6.02009 0.475098 5.20833C0.86702 4.39657 1.47997 3.71183 2.24355 3.23275C3.00712 2.75367 3.89034 2.4997 4.79176 2.5ZM4.79176 3.33333C5.28905 3.33333 5.76596 3.53088 6.11759 3.88251C6.46922 4.23414 6.66676 4.71105 6.66676 5.20833C6.66676 5.70561 6.46922 6.18253 6.11759 6.53416C5.76596 6.88579 5.28905 7.08333 4.79176 7.08333C4.29448 7.08333 3.81757 6.88579 3.46594 6.53416C3.11431 6.18253 2.91676 5.70561 2.91676 5.20833C2.91676 4.71105 3.11431 4.23414 3.46594 3.88251C3.81757 3.53088 4.29448 3.33333 4.79176 3.33333ZM4.79176 3.75C4.40499 3.75 4.03406 3.90365 3.76057 4.17714C3.48708 4.45063 3.33343 4.82156 3.33343 5.20833C3.33343 5.59511 3.48708 5.96604 3.76057 6.23953C4.03406 6.51302 4.40499 6.66667 4.79176 6.66667C5.17854 6.66667 5.54947 6.51302 5.82296 6.23953C6.09645 5.96604 6.2501 5.59511 6.2501 5.20833C6.2501 4.82156 6.09645 4.45063 5.82296 4.17714C5.54947 3.90365 5.17854 3.75 4.79176 3.75Z\" fill=\"#FF5C00\"></path></svg>\n                                    مشاهده\n                                </a></div></div></div></div></div></div></div></section><section id=\"iz6v0x\"><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/drugstore/%D8%B7%D8%B1%D8%A7%D8%AD%DB%8C-%D8%B3%D8%A7%DB%8C%D8%AA-%D8%AF%D8%A7%D8%B1%D9%88%D8%AE%D8%A7%D9%86%D9%87.png\" alt=\"طراحی وب سایت داروخانه\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h2 class=\"title\">چرا نیاز به طراحی سایت داروخانه دارید؟</h2><p id=\"ieficj\">بررسی امکانات</p><div class=\"blue-line\"></div></div></div></div><p id=\"i6qmdu\">داروخانه ها محل رفت و آمد بسیاری از مردم هستند. از آنجایی که اکثر این افراد بیمار هستند میتوانند بیماری را به دیگران انتقال دهند. با <strong>طراحی سایت داروخانه</strong> دیگر نیاز به مراجعه حضوری بیماران نخواهد بود. بیمار میتواند با آپلود نسخه ی خود داروهای مورد نیاز خود را در سبد خرید خود که توسط شما در آن قرار میگیرد داشته باشد. </p><p id=\"i7obii\">همانطور که میدانید، مردم زمان زیادی را برای جستجوی دارو در دنیای اینترنت هم صرف میکنند. مخصوصا دارو های پوست و زیبایی از آن دسته هایی هستند که بسیار زیاد در دنیای اینترنت جستجو میشوند. طراحی وب سایت داروخانه این امکان را به شما میدهد تا با توضیحات تفکیک شده درباری دارو، عوارض آن و پاسخ به سوالات متداول بیماران، فروش دارو های خو را تا چندین برابر افزایش دهید. <a data-cke-saved-href=\"https://karwebs.com\" href=\"https://karwebs.com\">طراحی سایت</a> میتواند به 2 صورت آماده و اختصاصی انجام شود.</p><ul class=\"kw-list1\"><li id=\"i25uh8\">هاست حرفه ای</li><li id=\"ia6iuw\">امنیت پنل مدیریت</li><li id=\"ixmdnh\">سهولت کار با پنل</li></ul></div></div></div></section><section class=\"what-we-do pt-5 pb-5\"><div class=\"container\"><div class=\"row\"><div class=\"col-md-12\"><div class=\"section-head justify-content-center\"><div class=\"section-title\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M40.625 45.8333C42.3479 45.8333 43.75 44.4313 43.75 42.7083V35.4167C43.75 33.6938 42.3479 32.2917 40.625 32.2917C38.1875 32.2917 35.7916 31.9083 33.5 31.1521C32.9522 30.9791 32.3677 30.9581 31.8089 31.0913C31.2501 31.2245 30.7379 31.5069 30.327 31.9083L27.327 34.9083C22.1419 32.0934 17.8834 27.8363 15.0666 22.6521L18.0416 19.6583C18.9 18.8625 19.2083 17.6521 18.8416 16.4875C18.0869 14.1923 17.7043 11.7911 17.7083 9.375C17.7083 7.65208 16.3062 6.25 14.5833 6.25H7.29163C5.56871 6.25 4.16663 7.65208 4.16663 9.375C4.16663 29.4792 20.5208 45.8333 40.625 45.8333ZM7.29163 8.33333H14.5833C14.8596 8.33333 15.1245 8.44308 15.3199 8.63843C15.5152 8.83378 15.625 9.09873 15.625 9.375C15.625 12.0354 16.0416 14.6479 16.8604 17.125C16.9205 17.3048 16.9276 17.498 16.8806 17.6817C16.8337 17.8653 16.7348 18.0316 16.5958 18.1604L12.5208 22.2563C15.9312 28.9813 20.9687 34.0188 27.725 37.4583L31.7854 33.3958C31.9239 33.2587 32.0971 33.1619 32.2865 33.1156C32.4759 33.0694 32.6742 33.0755 32.8604 33.1333C35.352 33.9583 37.9645 34.375 40.625 34.375C41.1979 34.375 41.6666 34.8438 41.6666 35.4167V42.7083C41.6666 43.2813 41.1979 43.75 40.625 43.75C21.6708 43.75 6.24996 28.3292 6.24996 9.375C6.24996 9.09873 6.35971 8.83378 6.55506 8.63843C6.75041 8.44308 7.01536 8.33333 7.29163 8.33333Z\" fill=\"#288ED9\"></path></svg></div><div class=\"title-box\"><h2 class=\"title\">\n                                تماس با گروه کاراوب\n                            </h2><p>مشاوره رایگان جهت راه اندازی وب سایت...</p><div class=\"blue-line\"></div></div></div></div></div><div class=\"col-md-12\"><div class=\"d-flex justify-content-center\"><div class=\"contact-us\"><p class=\"contact-phone\">021-77200630</p></div></div></div></div></div></section><section><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/drugstore/%D8%A7%D9%85%DA%A9%D8%A7%D9%86%D8%A7%D8%AA-%D8%B3%D8%A7%DB%8C-%D8%AF%D8%A7%D8%B1%D9%88%D8%AE%D8%A7%D9%86%D9%87.png\" alt=\"طراحی سایت داروخانه\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h2 class=\"title\">امکانات طراحی سایت داروخانه چیست؟</h2><p id=\"i19j5a\">چرا طراحی سایت فروشگاهی مهم است؟</p><div class=\"blue-line\"></div></div></div></div><p id=\"iextrd\">امکانات متنوعی برای <a data-cke-saved-href=\"https://karawebs.com/online-store-web-design\" href=\"https://karawebs.com/online-store-web-design\">طراحی سایت فروشگاهی</a> در نظر گرفته میشود که به برخی از آن ها اشاره میکنیم:</p><ul class=\"kw-list1\"><li id=\"iy0lmj\">چت آنلاین</li><li id=\"ilmy4m\">معرفی دارو</li><li id=\"ie85tk\">فروش محصولات به صورت آنلاین</li><li id=\"i6ijv6\">امکان آپلود نسخه توسط بیمار</li><li id=\"i6a0nh\">امکان تخفیف حرفه ای</li><li id=\"iokqy9\">سوالات متداول</li><li id=\"im2xpo\">بخش عوارض دارو در صفحه محصول</li><li id=\"ishu9e\">گالری محصول</li><li id=\"ircxyi\">وبلاگ</li><li id=\"i4satn\">نمایش قیمت دارو</li></ul></div></div></div></section><section id=\"inzibp\"><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div id=\"i5l95y\" class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h3 class=\"title\">سئو در طراحی سایت داروخانه</h3><p id=\"iv9c94\">معرفی امکانات</p><div class=\"blue-line\"></div></div></div></div><p id=\"iq1y3l\">همانطور که میدانید گوگل فاکتور های گوناگونی را برای رتبه دهی به سایت شما در صفحه ی نتایج خود در نظر میگیرد. در طراحی سایت داروخانه تمامی نکاتی که برای موتور های جستجو حائز اهمیت هست توسط گروه کاراوب رعایت میشود، قالب شما به صورت کاملا سئو بیس طراحی شده و میتوانید با تولید محتوای درست، آن را به نوک قله ی گوگل برسانید. اگر اطلاعی درباری سئو ندارید میتوانید مقاله ی<a data-cke-saved-href=\"https://karawebs.com/blog/what-is-seo\" href=\"https://karawebs.com/blog/what-is-seo\"> سئو چیست</a> را مطالعه کنید. </p><ul class=\"kw-list1\"><li id=\"iwth8k\">سئو پایه طراحی وب سایت</li><li id=\"iep7mr\">استفاده از اسکیما</li><li id=\"i9wgyp\">متا تگ های بهینه</li><li id=\"igz06w\">شبکه های اجتماعی</li></ul><a href=\"https://karawebs.com/portfolios\" title=\"نمونه کارها\" class=\"kw-btn-blue\">نمونه کارها</a></div><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/drugstore/%D8%B3%D8%A6%D9%88.png\" alt=\"طراحی سایت فروشگاهی\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section><section><div class=\"container\"><div data-aos=\"fade-up\" class=\"contact aos-init aos-animate\"><div class=\"wrapper\"><div class=\"icon\"></div><div class=\"description\"><strong>به مشاوره نیاز دارید؟ همین حالا با ما تماس بگیرید</strong><p>مشاوره رایگان در رابطه با راه اندازی وب سایت شما</p></div></div><div class=\"call-btn\"><a href=\"\" class=\"kw-btn-blue\">تماس با کاراوب</a></div><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#4B3DA7\" fill-opacity=\"0.07\"></path></svg></div></div></section><section id=\"iujubi\"><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/drugstore/%D8%B1%DB%8C%D8%B3%D9%BE%D8%A7%D9%86%D8%B3%DB%8C%D9%88.png\" alt=\"طراحی سایت داروخانه\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h3 class=\"title\">طراحی ریسپانسیو سایت داروخانه و تاثیر آن بر سئو</h3><p id=\"io5agx\">مناسب برای تمامی نمایشگر ها</p><div class=\"blue-line\"></div></div></div></div><p id=\"ieyzrg\">یکی از نکات بسیار مهم از نظر موتور های جستجو طراحی ریسپانسیو میباشد. <a data-cke-saved-href=\"https://karawebs.com\" href=\"https://karawebs.com\">طراحی سایت</a> اصول و قواعد گوناگونی دارد که اگر یک طراح آن ها را رعایت نکند ممکن است گوگل وب سایت شما را نادیده بگید.</p><p id=\"itcdti\">طراحی ریسپانسیو تاثیر بسیار زیادی بر سئوی سایت دارد! برای گوگل و موتور های جستجو بسیار مهم است که سایت شما در صفحه نمایش های مختلف به هم ریحتگی نداشته باشد و به اصطلاح ریسپانسیو باشد.</p><p id=\"idefg3\">طراحی وب سایت داروخانه به صورت کاملا ریسپانسیو طراحی شده و با تمامی صفحه نمایش ها سازگار میباشد.</p></div></div></div></section><section><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h2 class=\"title\">افزایش فروش دارو با طراحی سایت داروخانه</h2><p id=\"iug9mk\">دنیای آنلاین، بازاری متفاوت دارد!</p><div class=\"blue-line\"></div></div></div></div><p id=\"iktdwi\">حتما تا اینجا به اهمیت <strong>طراحی سایت داروخانه</strong> پی برده اید. به راحتی با <a data-cke-saved-href=\"https://karawebs.com/online-store-web-design\" href=\"https://karawebs.com/online-store-web-design\">طراحی سایت فروشگاهی </a>میتوانید فروش محصولات خود را دو چندان کنید. فراموش نکنید که بسیاری از مردم دیگر برای خرید حتی از خانه خارج نمیشوند!<br/>انواع سیستم تخفیف دهی برای افزایش فروش:<br/></p><ul class=\"kw-list1\"><li id=\"ihv4fm\">تخفیف بر اساس محصول</li><li id=\"ianzfm\">تخفیف بر اساس دسته بندی</li><li id=\"i21ae8\">تخفیف بر اساس کاربر یا کاربران</li></ul></div><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/drugstore/%D8%A7%D9%81%D8%B2%D8%A7%DB%8C%D8%B4-%D9%81%D8%B1%D9%88%D8%B4-%D8%A8%D8%A7-%D8%B7%D8%B1%D8%A7%D8%AD%DB%8C-%D8%B3%D8%A7%DB%8C%D8%AA-%D8%AF%D8%A7%D8%B1%D9%88%D8%AE%D8%A7%D9%86%D9%87.png\" alt=\"طراحی وب سایت\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section><section id=\"i8bp4x\"><div class=\"container\"><div data-aos=\"fade-up\" class=\"contact aos-init aos-animate\"><div class=\"wrapper\"><div class=\"icon\"></div><div class=\"description\"><strong>به مشاوره نیاز دارید؟ همین حالا با ما تماس بگیرید</strong><p>مشاوره رایگان در رابطه با راه اندازی وب سایت شما</p></div></div><div class=\"call-btn\"><a href=\"\" class=\"kw-btn-blue\">تماس با کاراوب</a></div><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#4B3DA7\" fill-opacity=\"0.07\"></path></svg></div></div></section><section id=\"ijoi3e\"><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/drugstore/%D9%85%D8%B2%D8%A7%DB%8C%D8%A7%DB%8C-%D8%B7%D8%B1%D8%A7%D8%AD%DB%8C-%D8%B3%D8%A7%DB%8C%D8%AA.png\" alt=\"مزایای طراحی سایت داروخانه\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h3 class=\"title\">مزایای طراحی وب سایت داروخانه چیست؟</h3><p id=\"iuwqmf\">سیستم پرداخت آنلاین در طراحی سایت فروشگاهی</p><div class=\"blue-line\"></div></div></div></div><p id=\"i60pjk\">به طور کلی سیستم فروش آنلاین دارای مزایای بسیار زیادی است، برای مثال دیگر نیاز به پاسخگویی حضوری به تک تک مشتریان و بیماران ندارید. از اتلاف وقت جلوگیری میکنید. طراحی سایت دارو خانه برند حرفه ای از شما میسازد و...</p></div></div></div></section><section><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h3 class=\"title\">سیستم پرداخت آنلاین در طراحی سایت داروخانه وجود دارد؟</h3><p id=\"iv7pao\">پرداخت آنلاین، امن و حرفه ای</p><div class=\"blue-line\"></div></div></div></div><p id=\"i0dy6e\"><a data-cke-saved-href=\"https://karawebs.com/online-store-web-design\" href=\"https://karawebs.com/online-store-web-design\">طراحی سایت فروشگاهی</a> بدون داشتن درگاه پرداخت بانکی اصلا بی استفاده است! پرداخت آنلاین به صورت کاملا امن و حرفه ای برای طراحی وب سایت داروخانه در نظر گرفته میشود. <br/>  سیستم پرداخت کارت به کارت نیز یکی دیگر از راه های پرداخت توسط مشتریان شما میباشد.  <br/> همچنین امکان پرداخت در محل برای <strong>طراحی سایت داروخانه</strong> وجود دارد.</p><ul class=\"kw-list1\"><li id=\"ij03xj\">درگاه پرئاخت مستقیم</li><li id=\"iilqvr\">درگاه پرداخت غیر مستقیم</li><li id=\"isw6jl\">امکان کارت به کارت</li><li id=\"ius42y\">پرداخت در محل</li></ul></div><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/drugstore/%D9%BE%D8%B1%D8%AF%D8%A7%D8%AE%D8%AA-%D8%A2%D9%86%D9%84%D8%A7%DB%8C%D9%86.png\" alt=\"سیستم پرداخت در سایت داروخانه\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section><section><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><img src=\"https://karawebs.com/images/2020/drugstore/%D8%A7%D9%86%D9%88%D8%A7%D8%B9.png\" alt=\"طراحی سایت\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h3 class=\"title\">نمونه های طراحی سایت داروخانه</h3><p id=\"imflgh\">نمونه هایی از طراحان دیگر</p><div class=\"blue-line\"></div></div></div></div><p id=\"idgkph\"> در این بخش چند نمونه از وب سایت های برتر در زمینه ی فروش آنلاین دارو برای شما آماده کرده ایم:<br/><a data-cke-saved-href=\"https://shiderstore.com/\" href=\"https://shiderstore.com/\">داروخانه شیدر<br/></a><a data-cke-saved-href=\"https://mosbatesabz.com/\" href=\"https://mosbatesabz.com/\">مثبت سبز<br/></a><a data-cke-saved-href=\"https://www.darobox.ir/\" href=\"https://www.darobox.ir/\">داروباکس</a><br/></p></div></div></div></section><section class=\"what-we-do pt-5 pb-5\"><div class=\"container\"><div class=\"row\"><div class=\"col-md-12\"><div class=\"section-head justify-content-center\"><div class=\"section-title\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M40.625 45.8333C42.3479 45.8333 43.75 44.4313 43.75 42.7083V35.4167C43.75 33.6938 42.3479 32.2917 40.625 32.2917C38.1875 32.2917 35.7916 31.9083 33.5 31.1521C32.9522 30.9791 32.3677 30.9581 31.8089 31.0913C31.2501 31.2245 30.7379 31.5069 30.327 31.9083L27.327 34.9083C22.1419 32.0934 17.8834 27.8363 15.0666 22.6521L18.0416 19.6583C18.9 18.8625 19.2083 17.6521 18.8416 16.4875C18.0869 14.1923 17.7043 11.7911 17.7083 9.375C17.7083 7.65208 16.3062 6.25 14.5833 6.25H7.29163C5.56871 6.25 4.16663 7.65208 4.16663 9.375C4.16663 29.4792 20.5208 45.8333 40.625 45.8333ZM7.29163 8.33333H14.5833C14.8596 8.33333 15.1245 8.44308 15.3199 8.63843C15.5152 8.83378 15.625 9.09873 15.625 9.375C15.625 12.0354 16.0416 14.6479 16.8604 17.125C16.9205 17.3048 16.9276 17.498 16.8806 17.6817C16.8337 17.8653 16.7348 18.0316 16.5958 18.1604L12.5208 22.2563C15.9312 28.9813 20.9687 34.0188 27.725 37.4583L31.7854 33.3958C31.9239 33.2587 32.0971 33.1619 32.2865 33.1156C32.4759 33.0694 32.6742 33.0755 32.8604 33.1333C35.352 33.9583 37.9645 34.375 40.625 34.375C41.1979 34.375 41.6666 34.8438 41.6666 35.4167V42.7083C41.6666 43.2813 41.1979 43.75 40.625 43.75C21.6708 43.75 6.24996 28.3292 6.24996 9.375C6.24996 9.09873 6.35971 8.83378 6.55506 8.63843C6.75041 8.44308 7.01536 8.33333 7.29163 8.33333Z\" fill=\"#288ED9\"></path></svg></div><div class=\"title-box\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h3 class=\"title\">پشتیبانی طراحی سایت داروخانه در کاراوب</h3><p id=\"i29hju\">پشتیبانی وب سایت یکی از مهمترین خدماتی است که شاید خیلی از گروه ها و شرکت های <a data-cke-saved-href=\"https://karawebs.com\" href=\"https://karawebs.com\">طراحی سایت</a> به آن توجه نداشته باشند. گروه کاراوب به صورت 24 ساعته و  7 روز هفته آماده ی پاسخگویی به سوالات یا مشکلات احتمالی مشتریان است. <strong>طراحی سایت داروخانه</strong> دارای پشتیبانی رایگان یکساله میباشد.</p><div class=\"blue-line\"></div></div></div></div></div></div></div></div><div class=\"col-md-12\"><div class=\"d-flex justify-content-center\"><div class=\"contact-us\"></div></div></div></div></div></section>','طراحی سایت داروخانه | طراحی وب سایت داروخانه','طراحی سایت داروخانه از انواع دیگر کسب و کار آنلاین است که توسط کاراوب راه اندازی میشود. طراحی وب سایت داروخانه میتواند امکانات گوناگونی داشته باشد','طراحی سایت داروخانه , طراحی وب سایت داروخانه','Article','drugstore-webdesign',1,'https://karawebs.com/backend/images/grapesjs/1624085643-pharmacy.png',1,'2021-02-13 07:42:30','2021-11-16 13:33:45',0,'984'),
(13,'طراحی سایت ارزان','<body id=\"iscz\"><section><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><div id=\"ij0qi\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><g clip-path=\"url(#clip0)\"><path d=\"M9.28125 4.21875C9.57465 3.87573 9.93887 3.60035 10.3489 3.41153C10.7588 3.22272 11.2049 3.12497 11.6563 3.125H38.3438C38.7951 3.12497 39.2412 3.22272 39.6511 3.41153C40.0611 3.60035 40.4254 3.87573 40.7187 4.21875L48.8719 13.7313C49.5998 14.5807 50 15.6625 50 16.7812V17.5781C50.0002 19.1249 49.5171 20.6331 48.6182 21.8919C47.7193 23.1508 46.4496 24.0973 44.9865 24.5992C43.5234 25.1011 41.94 25.1334 40.4577 24.6915C38.9754 24.2495 37.6682 23.3555 36.7188 22.1344C36.0254 23.0274 35.137 23.7499 34.1214 24.2466C33.1057 24.7433 31.9899 25.001 30.8594 25C29.7288 25.0013 28.6129 24.7437 27.5972 24.2469C26.5816 23.7502 25.6932 23.0276 25 22.1344C24.3068 23.0276 23.4184 23.7502 22.4028 24.2469C21.3871 24.7437 20.2712 25.0013 19.1406 25C18.01 25.0013 16.8941 24.7437 15.8785 24.2469C14.8628 23.7502 13.9744 23.0276 13.2812 22.1344C12.3318 23.3555 11.0246 24.2495 9.5423 24.6915C8.05998 25.1334 6.47661 25.1011 5.01351 24.5992C3.55041 24.0973 2.2807 23.1508 1.38182 21.8919C0.482943 20.6331 -0.000170621 19.1249 4.52017e-08 17.5781V16.7812C3.93986e-05 15.6625 0.400177 14.5807 1.12813 13.7313L9.28437 4.21562L9.28125 4.21875ZM14.8438 17.5781C14.8438 18.7177 15.2965 19.8107 16.1023 20.6165C16.9081 21.4223 18.001 21.875 19.1406 21.875C20.2802 21.875 21.3732 21.4223 22.179 20.6165C22.9848 19.8107 23.4375 18.7177 23.4375 17.5781C23.4375 17.1637 23.6021 16.7663 23.8951 16.4733C24.1882 16.1802 24.5856 16.0156 25 16.0156C25.4144 16.0156 25.8118 16.1802 26.1049 16.4733C26.3979 16.7663 26.5625 17.1637 26.5625 17.5781C26.5625 18.7177 27.0152 19.8107 27.821 20.6165C28.6268 21.4223 29.7198 21.875 30.8594 21.875C31.999 21.875 33.0919 21.4223 33.8977 20.6165C34.7035 19.8107 35.1562 18.7177 35.1562 17.5781C35.1562 17.1637 35.3209 16.7663 35.6139 16.4733C35.9069 16.1802 36.3043 16.0156 36.7188 16.0156C37.1332 16.0156 37.5306 16.1802 37.8236 16.4733C38.1166 16.7663 38.2812 17.1637 38.2812 17.5781C38.2813 18.7177 38.734 19.8107 39.5398 20.6165C40.3456 21.4223 41.4385 21.875 42.5781 21.875C43.7177 21.875 44.8107 21.4223 45.6165 20.6165C46.4223 19.8107 46.875 18.7177 46.875 17.5781V16.7812C46.875 16.4088 46.742 16.0487 46.5 15.7656L38.3438 6.25H11.6563L3.5 15.7656C3.25796 16.0487 3.12497 16.4088 3.125 16.7812V17.5781C3.125 18.7177 3.57771 19.8107 4.38353 20.6165C5.18935 21.4223 6.28227 21.875 7.42188 21.875C8.56148 21.875 9.6544 21.4223 10.4602 20.6165C11.266 19.8107 11.7188 18.7177 11.7188 17.5781C11.7187 17.1637 11.8834 16.7663 12.1764 16.4733C12.4694 16.1802 12.8668 16.0156 13.2812 16.0156C13.6957 16.0156 14.0931 16.1802 14.3861 16.4733C14.6791 16.7663 14.8438 17.1637 14.8438 17.5781V17.5781ZM4.6875 26.5625C5.1019 26.5625 5.49933 26.7271 5.79235 27.0201C6.08538 27.3132 6.25 27.7106 6.25 28.125V46.875H9.375V31.25C9.375 30.4212 9.70424 29.6263 10.2903 29.0403C10.8763 28.4542 11.6712 28.125 12.5 28.125H21.875C22.7038 28.125 23.4987 28.4542 24.0847 29.0403C24.6708 29.6263 25 30.4212 25 31.25V46.875H43.75V28.125C43.75 27.7106 43.9146 27.3132 44.2076 27.0201C44.5007 26.7271 44.8981 26.5625 45.3125 26.5625C45.7269 26.5625 46.1243 26.7271 46.4174 27.0201C46.7104 27.3132 46.875 27.7106 46.875 28.125V46.875H48.4375C48.8519 46.875 49.2493 47.0396 49.5424 47.3326C49.8354 47.6257 50 48.0231 50 48.4375C50 48.8519 49.8354 49.2493 49.5424 49.5424C49.2493 49.8354 48.8519 50 48.4375 50H1.5625C1.1481 50 0.750671 49.8354 0.457646 49.5424C0.16462 49.2493 4.52017e-08 48.8519 4.52017e-08 48.4375C4.52017e-08 48.0231 0.16462 47.6257 0.457646 47.3326C0.750671 47.0396 1.1481 46.875 1.5625 46.875H3.125V28.125C3.125 27.7106 3.28962 27.3132 3.58265 27.0201C3.87567 26.7271 4.2731 26.5625 4.6875 26.5625V26.5625ZM12.5 46.875H21.875V31.25H12.5V46.875ZM28.125 31.25C28.125 30.4212 28.4542 29.6263 29.0403 29.0403C29.6263 28.4542 30.4212 28.125 31.25 28.125H37.5C38.3288 28.125 39.1237 28.4542 39.7097 29.0403C40.2958 29.6263 40.625 30.4212 40.625 31.25V40.625C40.625 41.4538 40.2958 42.2487 39.7097 42.8347C39.1237 43.4208 38.3288 43.75 37.5 43.75H31.25C30.4212 43.75 29.6263 43.4208 29.0403 42.8347C28.4542 42.2487 28.125 41.4538 28.125 40.625V31.25ZM37.5 31.25H31.25V40.625H37.5V31.25Z\" fill=\"#288ED9\"></path></g><defs><clipPath id=\"clip0\"><rect width=\"50\" height=\"50\" fill=\"white\"></rect></clipPath></defs></svg></div></div><div class=\"title-box\"><h2 class=\"title\">طراحی سایت فقط 599 هزار تومان!</h2><p id=\"i7s6l\"> <strong>بررسی این نوع وب سایت</strong></p><div class=\"blue-line\"></div></div></div></div><p id=\"ivq9j\">برخی از مشتریان به دنبال طراحی وب سایت با قیمت ارزان و کیفیت خوب هستند. پیشنهاد گروه طراحی سایت کاراوب به این دسته از مشتریان خرید قالب های آماده طراحی سایت میباشد. در این نوع سایت دامنه&nbsp; رایگان، هاست 2 گیگابایت یکساله به صورت رایگان در پکیج قرار دارد.</p><ul class=\"kw-list1\"><li id=\"ijvip\">امنیت فوق العاده</li><li id=\"ibx5j\">سئوی استاندارد</li><li id=\"i9yzf\">آموزش آنلاین پنل مدیریت</li><li id=\"ih8pa\">پنل مدیریت حرفه ای</li></ul></div><div class=\"col-md-6\"><img src=\"/backend/images/grapesjs/1624019759-online-store.png\" alt=\"\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section><section class=\"kw-p\"><div class=\"container\"><section class=\"kw-pricing-table\"></section><div id=\"i0uqh\" class=\"row\"></div></div></section><section id=\"iz6v0x\"><svg width=\"188\" height=\"481\" viewBox=\"0 0 188 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-right\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><img src=\"/backend/images/grapesjs/1624030974-panel.png\" alt=\"\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h2 class=\"title\">مراحل سفارش این نوع وب سایت</h2><p id=\"ieficj\">بررسی امکانات</p><div class=\"blue-line\"></div></div></div></div><p id=\"i6qmdu\">کافیه کد نمونه ای که انتخاب کردین رو برای ما ارسال کنین و ثبت سفارش شما انجام میشه. کارشناسان ما بعد از ثبت سفارش با شما تماس میگیرن و شما را در انتخاب دامنه وب سایت راهنمایی میکنند. مرحله ی بعد مرحله ی واریز وجه میباشد.<br>به همین سادگی! بعد از انجام این چند مرحله آموزش پنل مدیریت، اطلاعات ورود به پنل مدیریت و اطلاعات ورود به هاست برای شما ارسال میشه!<br></p><ul class=\"kw-list1\"></ul></div></div></div></section><section class=\"what-we-do pt-5 pb-5\"><div class=\"container\"><div class=\"row\"><div class=\"col-md-12\"><div class=\"section-head justify-content-center\"><div class=\"section-title\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M40.625 45.8333C42.3479 45.8333 43.75 44.4313 43.75 42.7083V35.4167C43.75 33.6938 42.3479 32.2917 40.625 32.2917C38.1875 32.2917 35.7916 31.9083 33.5 31.1521C32.9522 30.9791 32.3677 30.9581 31.8089 31.0913C31.2501 31.2245 30.7379 31.5069 30.327 31.9083L27.327 34.9083C22.1419 32.0934 17.8834 27.8363 15.0666 22.6521L18.0416 19.6583C18.9 18.8625 19.2083 17.6521 18.8416 16.4875C18.0869 14.1923 17.7043 11.7911 17.7083 9.375C17.7083 7.65208 16.3062 6.25 14.5833 6.25H7.29163C5.56871 6.25 4.16663 7.65208 4.16663 9.375C4.16663 29.4792 20.5208 45.8333 40.625 45.8333ZM7.29163 8.33333H14.5833C14.8596 8.33333 15.1245 8.44308 15.3199 8.63843C15.5152 8.83378 15.625 9.09873 15.625 9.375C15.625 12.0354 16.0416 14.6479 16.8604 17.125C16.9205 17.3048 16.9276 17.498 16.8806 17.6817C16.8337 17.8653 16.7348 18.0316 16.5958 18.1604L12.5208 22.2563C15.9312 28.9813 20.9687 34.0188 27.725 37.4583L31.7854 33.3958C31.9239 33.2587 32.0971 33.1619 32.2865 33.1156C32.4759 33.0694 32.6742 33.0755 32.8604 33.1333C35.352 33.9583 37.9645 34.375 40.625 34.375C41.1979 34.375 41.6666 34.8438 41.6666 35.4167V42.7083C41.6666 43.2813 41.1979 43.75 40.625 43.75C21.6708 43.75 6.24996 28.3292 6.24996 9.375C6.24996 9.09873 6.35971 8.83378 6.55506 8.63843C6.75041 8.44308 7.01536 8.33333 7.29163 8.33333Z\" fill=\"#288ED9\"></path></svg></div><div class=\"title-box\"><h2 class=\"title\"> تماس با گروه کاراوب</h2><p>مشاوره رایگان جهت راه اندازی وب سایت...</p><div class=\"blue-line\"></div></div></div></div></div><div class=\"col-md-12\"><div class=\"d-flex justify-content-center\"><div class=\"contact-us\"><p class=\"contact-phone\">021-77200630</p></div></div></div></div></div></section><section><div class=\"container\"></div></section><section id=\"inzibp\"><div class=\"container\"><div id=\"i5l95y\" class=\"row\"></div></div></section><section class=\"kw-p\"><div class=\"container\"><div class=\"container mt-5\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 28 31\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M16.2511 4.875H17.8761V3.25C17.8761 2.81902 17.7049 2.4057 17.4002 2.10095C17.0954 1.79621 16.6821 1.625 16.2511 1.625H11.3761C10.9451 1.625 10.5318 1.79621 10.2271 2.10095C9.92233 2.4057 9.75113 2.81902 9.75113 3.25V4.875H11.3761V8.242L2.08925 24.3262C1.79293 24.8195 1.63286 25.3825 1.62539 25.9578C1.61792 26.5331 1.76333 27.1001 2.04675 27.6009C2.33016 28.1016 2.74143 28.5181 3.23854 28.8079C3.73564 29.0976 4.30075 29.2502 4.87613 29.25H22.7511C23.3265 29.2502 23.8916 29.0976 24.3887 28.8079C24.8858 28.5181 25.2971 28.1016 25.5805 27.6009C25.8639 27.1001 26.0093 26.5331 26.0019 25.9578C25.9944 25.3825 25.8343 24.8195 25.538 24.3262L16.2511 8.242V4.875ZM4.87613 30.875C3.99846 30.8752 3.13702 30.6385 2.38272 30.1898C1.62842 29.7411 1.00924 29.0971 0.590535 28.3257C0.171827 27.5544 -0.0308794 26.6843 0.00381014 25.8073C0.0384997 24.9303 0.309298 24.079 0.787625 23.3431L9.75113 7.81787V6.5C9.32015 6.5 8.90682 6.32879 8.60208 6.02405C8.29733 5.7193 8.12613 5.30598 8.12613 4.875V3.25C8.12613 2.38805 8.46854 1.5614 9.07803 0.951903C9.68752 0.34241 10.5142 0 11.3761 0H16.2511C17.1131 0 17.9397 0.34241 18.5492 0.951903C19.1587 1.5614 19.5011 2.38805 19.5011 3.25V4.875C19.5011 5.30598 19.3299 5.7193 19.0252 6.02405C18.7204 6.32879 18.3071 6.5 17.8761 6.5V7.81787L26.8396 23.3431C27.318 24.079 27.5888 24.9303 27.6234 25.8073C27.6581 26.6843 27.4554 27.5544 27.0367 28.3257C26.618 29.0971 25.9988 29.7411 25.2445 30.1898C24.4902 30.6385 23.6288 30.8752 22.7511 30.875H4.87613ZM15.1039 19.9745L17.7461 17.3323L22.7511 26H4.87613L10.8236 15.6975L15.1039 19.9745ZM15.1039 22.2722L11.173 18.343L7.69062 24.375H19.9366L17.3984 19.9777L15.1039 22.2722ZM14.6261 11.375C15.0571 11.375 15.4704 11.5462 15.7752 11.851C16.0799 12.1557 16.2511 12.569 16.2511 13C16.2511 13.431 16.0799 13.8443 15.7752 14.149C15.4704 14.4538 15.0571 14.625 14.6261 14.625C14.1951 14.625 13.7818 14.4538 13.4771 14.149C13.1723 13.8443 13.0011 13.431 13.0011 13C13.0011 12.569 13.1723 12.1557 13.4771 11.851C13.7818 11.5462 14.1951 11.375 14.6261 11.375V11.375Z\" fill=\"#288ED9\"></path></svg></div><div class=\"title-box\"><h2 class=\"title\">نمونه های آماده</h2><p>کیفیت، زیبایی، پشتیبانی حرفه ای...</p><div class=\"blue-line\"></div></div></div></div></div><div class=\"row\"><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"./assets/images/rose.jpg\" alt=\"\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">وب سایت رز بیوتی</h3><p class=\"subtitle\">طراحی سایت شرکتی</p></div><div class=\"kw-p-btn\"><a href=\"single-portfolio.html\" class=\"kw-btn-blue\">کد: 3403</a></div></div></div></div></div><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"./assets/images/moshfegh.jpg\" alt=\"\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">وب سایت رز بیوتی</h3><p class=\"subtitle\">طراحی سایت شرکتی</p></div><div class=\"kw-p-btn\"><a href=\"single-portfolio.html\" class=\"kw-btn-blue\">کد: 2548</a></div></div></div></div></div><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"./assets/images/rose.jpg\" alt=\"\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">وب سایت رز بیوتی</h3><p class=\"subtitle\">طراحی سایت شرکتی</p></div><div class=\"kw-p-btn\"><a href=\"single-portfolio.html\" class=\"kw-btn-blue\">کد: 4702</a></div></div></div></div></div><div class=\"col-md-4 col-lg-3\"><div class=\"kw-p-items\"><div class=\"kw-p-item kw-wrapper kw-wrapper-br pt-0\"><div class=\"kw-p-image\"><img src=\"./assets/images/rose.jpg\" alt=\"\"/></div><div class=\"kw-p-details\"><div class=\"titles\"><h3 class=\"kw-p-title\">وب سایت رز بیوتی</h3><p class=\"subtitle\">طراحی سایت شرکتی</p></div><div class=\"kw-p-btn\"><a href=\"single-portfolio.html\" class=\"kw-btn-blue\">کد: 8458</a></div></div></div></div></div></div></div></section><section id=\"iujubi\"><div class=\"container\"></div></section><section><div class=\"container\"></div></section><section id=\"i8bp4x\"><div class=\"container\"></div></section><section id=\"ijoi3e\"><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"></div></div></div></section><section id=\"portfolios\" class=\"portfolios\"><div class=\"container mb-4\"></div><div data-aos=\"fade-up\" tabindex=\"0\" class=\"portfolios-items flipster flipster--transform flipster--flat flipster--click flipster--active aos-init\"></div></section><section><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"></div></div></div></section></body>','طراحی سایت ارزان',NULL,NULL,NULL,'website-arzan',0,NULL,1,'2022-09-03 17:33:14','2022-09-03 18:26:12',0,NULL),
(14,'طراحی سایت اختصاصی','<body id=\"i3xg\"><section><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-icon\"><div id=\"ij0qi\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><g clip-path=\"url(#clip0)\"><path d=\"M9.28125 4.21875C9.57465 3.87573 9.93887 3.60035 10.3489 3.41153C10.7588 3.22272 11.2049 3.12497 11.6563 3.125H38.3438C38.7951 3.12497 39.2412 3.22272 39.6511 3.41153C40.0611 3.60035 40.4254 3.87573 40.7187 4.21875L48.8719 13.7313C49.5998 14.5807 50 15.6625 50 16.7812V17.5781C50.0002 19.1249 49.5171 20.6331 48.6182 21.8919C47.7193 23.1508 46.4496 24.0973 44.9865 24.5992C43.5234 25.1011 41.94 25.1334 40.4577 24.6915C38.9754 24.2495 37.6682 23.3555 36.7188 22.1344C36.0254 23.0274 35.137 23.7499 34.1214 24.2466C33.1057 24.7433 31.9899 25.001 30.8594 25C29.7288 25.0013 28.6129 24.7437 27.5972 24.2469C26.5816 23.7502 25.6932 23.0276 25 22.1344C24.3068 23.0276 23.4184 23.7502 22.4028 24.2469C21.3871 24.7437 20.2712 25.0013 19.1406 25C18.01 25.0013 16.8941 24.7437 15.8785 24.2469C14.8628 23.7502 13.9744 23.0276 13.2812 22.1344C12.3318 23.3555 11.0246 24.2495 9.5423 24.6915C8.05998 25.1334 6.47661 25.1011 5.01351 24.5992C3.55041 24.0973 2.2807 23.1508 1.38182 21.8919C0.482943 20.6331 -0.000170621 19.1249 4.52017e-08 17.5781V16.7812C3.93986e-05 15.6625 0.400177 14.5807 1.12813 13.7313L9.28437 4.21562L9.28125 4.21875ZM14.8438 17.5781C14.8438 18.7177 15.2965 19.8107 16.1023 20.6165C16.9081 21.4223 18.001 21.875 19.1406 21.875C20.2802 21.875 21.3732 21.4223 22.179 20.6165C22.9848 19.8107 23.4375 18.7177 23.4375 17.5781C23.4375 17.1637 23.6021 16.7663 23.8951 16.4733C24.1882 16.1802 24.5856 16.0156 25 16.0156C25.4144 16.0156 25.8118 16.1802 26.1049 16.4733C26.3979 16.7663 26.5625 17.1637 26.5625 17.5781C26.5625 18.7177 27.0152 19.8107 27.821 20.6165C28.6268 21.4223 29.7198 21.875 30.8594 21.875C31.999 21.875 33.0919 21.4223 33.8977 20.6165C34.7035 19.8107 35.1562 18.7177 35.1562 17.5781C35.1562 17.1637 35.3209 16.7663 35.6139 16.4733C35.9069 16.1802 36.3043 16.0156 36.7188 16.0156C37.1332 16.0156 37.5306 16.1802 37.8236 16.4733C38.1166 16.7663 38.2812 17.1637 38.2812 17.5781C38.2813 18.7177 38.734 19.8107 39.5398 20.6165C40.3456 21.4223 41.4385 21.875 42.5781 21.875C43.7177 21.875 44.8107 21.4223 45.6165 20.6165C46.4223 19.8107 46.875 18.7177 46.875 17.5781V16.7812C46.875 16.4088 46.742 16.0487 46.5 15.7656L38.3438 6.25H11.6563L3.5 15.7656C3.25796 16.0487 3.12497 16.4088 3.125 16.7812V17.5781C3.125 18.7177 3.57771 19.8107 4.38353 20.6165C5.18935 21.4223 6.28227 21.875 7.42188 21.875C8.56148 21.875 9.6544 21.4223 10.4602 20.6165C11.266 19.8107 11.7188 18.7177 11.7188 17.5781C11.7187 17.1637 11.8834 16.7663 12.1764 16.4733C12.4694 16.1802 12.8668 16.0156 13.2812 16.0156C13.6957 16.0156 14.0931 16.1802 14.3861 16.4733C14.6791 16.7663 14.8438 17.1637 14.8438 17.5781V17.5781ZM4.6875 26.5625C5.1019 26.5625 5.49933 26.7271 5.79235 27.0201C6.08538 27.3132 6.25 27.7106 6.25 28.125V46.875H9.375V31.25C9.375 30.4212 9.70424 29.6263 10.2903 29.0403C10.8763 28.4542 11.6712 28.125 12.5 28.125H21.875C22.7038 28.125 23.4987 28.4542 24.0847 29.0403C24.6708 29.6263 25 30.4212 25 31.25V46.875H43.75V28.125C43.75 27.7106 43.9146 27.3132 44.2076 27.0201C44.5007 26.7271 44.8981 26.5625 45.3125 26.5625C45.7269 26.5625 46.1243 26.7271 46.4174 27.0201C46.7104 27.3132 46.875 27.7106 46.875 28.125V46.875H48.4375C48.8519 46.875 49.2493 47.0396 49.5424 47.3326C49.8354 47.6257 50 48.0231 50 48.4375C50 48.8519 49.8354 49.2493 49.5424 49.5424C49.2493 49.8354 48.8519 50 48.4375 50H1.5625C1.1481 50 0.750671 49.8354 0.457646 49.5424C0.16462 49.2493 4.52017e-08 48.8519 4.52017e-08 48.4375C4.52017e-08 48.0231 0.16462 47.6257 0.457646 47.3326C0.750671 47.0396 1.1481 46.875 1.5625 46.875H3.125V28.125C3.125 27.7106 3.28962 27.3132 3.58265 27.0201C3.87567 26.7271 4.2731 26.5625 4.6875 26.5625V26.5625ZM12.5 46.875H21.875V31.25H12.5V46.875ZM28.125 31.25C28.125 30.4212 28.4542 29.6263 29.0403 29.0403C29.6263 28.4542 30.4212 28.125 31.25 28.125H37.5C38.3288 28.125 39.1237 28.4542 39.7097 29.0403C40.2958 29.6263 40.625 30.4212 40.625 31.25V40.625C40.625 41.4538 40.2958 42.2487 39.7097 42.8347C39.1237 43.4208 38.3288 43.75 37.5 43.75H31.25C30.4212 43.75 29.6263 43.4208 29.0403 42.8347C28.4542 42.2487 28.125 41.4538 28.125 40.625V31.25ZM37.5 31.25H31.25V40.625H37.5V31.25Z\" fill=\"#288ED9\"></path></g><defs><clipPath id=\"clip0\"><rect width=\"50\" height=\"50\" fill=\"white\"></rect></clipPath></defs></svg></div></div><div class=\"title-box\"><h2 class=\"title\">طراحی وب سایت اختصاصی</h2><p id=\"i7s6l\"> <strong>بررسی این نوع وب سایت</strong></p><div class=\"blue-line\"></div></div></div></div><p id=\"ivq9j\">طراحی سایت اختصاصی چیست؟ این نوع طراحی وب سایت به صورت کامل و از 0 تا 100 به صورت اختصاصی و بدون استفاده از قالب های آماده انجام میشود. <br/>در این نوع طراحی سایت، رابط کاربری (ظاهر سایت) ، برنامه نویسی سمت سرور، همه و همه به صورت اختصاصی برای کارفرما انجام میشود.<br/>طبیعتا هزینه ی طراحی این نوع وب سایت ها نسبت به وب سایت های وردپرسی بالاتر است، در صورتی که نیاز به طراحی سایت اختصاصی داشتید، کافیست برای دریافت اطلاعات بیشتر با مشاوران و کارشناسان ما در کاراوب تماس بگیرید<br/></p><ul class=\"kw-list1\"><li id=\"izxd9\">طراحی پنل مدیریت اختصاصی</li><li id=\"ijvip\">رابط کاربری اختصاصی</li><li id=\"ibx5j\">قالب اختصاصی</li><li id=\"ih8pa\">پنل مدیریت حرفه ای</li></ul><a href=\"https://karawebs.com/portfolios\" class=\"kw-btn-blue\">نمونه کار ها</a><a href=\"https://karawebs.com/online-store-prices\" class=\"kw-btn-blue\">تعرفه و امکانات</a></div><div class=\"col-md-6\"><img src=\"/backend/images/grapesjs/1624019759-online-store.png\" alt=\"\" data-aos=\"fade-up\" class=\"aos-init aos-animate\"/></div></div></div></section><section class=\"kw-p\"></section><section id=\"iz6v0x\"><div class=\"container\"><div class=\"row\"></div></div></section><section class=\"what-we-do pt-5 pb-5\"><div class=\"container\"><div class=\"row\"><div class=\"col-md-12\"><div class=\"section-head justify-content-center\"><div class=\"section-title\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M40.625 45.8333C42.3479 45.8333 43.75 44.4313 43.75 42.7083V35.4167C43.75 33.6938 42.3479 32.2917 40.625 32.2917C38.1875 32.2917 35.7916 31.9083 33.5 31.1521C32.9522 30.9791 32.3677 30.9581 31.8089 31.0913C31.2501 31.2245 30.7379 31.5069 30.327 31.9083L27.327 34.9083C22.1419 32.0934 17.8834 27.8363 15.0666 22.6521L18.0416 19.6583C18.9 18.8625 19.2083 17.6521 18.8416 16.4875C18.0869 14.1923 17.7043 11.7911 17.7083 9.375C17.7083 7.65208 16.3062 6.25 14.5833 6.25H7.29163C5.56871 6.25 4.16663 7.65208 4.16663 9.375C4.16663 29.4792 20.5208 45.8333 40.625 45.8333ZM7.29163 8.33333H14.5833C14.8596 8.33333 15.1245 8.44308 15.3199 8.63843C15.5152 8.83378 15.625 9.09873 15.625 9.375C15.625 12.0354 16.0416 14.6479 16.8604 17.125C16.9205 17.3048 16.9276 17.498 16.8806 17.6817C16.8337 17.8653 16.7348 18.0316 16.5958 18.1604L12.5208 22.2563C15.9312 28.9813 20.9687 34.0188 27.725 37.4583L31.7854 33.3958C31.9239 33.2587 32.0971 33.1619 32.2865 33.1156C32.4759 33.0694 32.6742 33.0755 32.8604 33.1333C35.352 33.9583 37.9645 34.375 40.625 34.375C41.1979 34.375 41.6666 34.8438 41.6666 35.4167V42.7083C41.6666 43.2813 41.1979 43.75 40.625 43.75C21.6708 43.75 6.24996 28.3292 6.24996 9.375C6.24996 9.09873 6.35971 8.83378 6.55506 8.63843C6.75041 8.44308 7.01536 8.33333 7.29163 8.33333Z\" fill=\"#288ED9\"></path></svg></div><div class=\"title-box\"><h2 class=\"title\">برای دریافت مشاوره با ما تماس بگیرید</h2><p>مشاوره رایگان جهت راه اندازی وب سایت...</p><div class=\"blue-line\"></div></div></div></div></div><div class=\"col-md-12\"><div class=\"d-flex justify-content-center\"><div class=\"contact-us\"><p class=\"contact-phone\">021-77200630</p></div></div></div></div></div></section><section class=\"kw-pricing-table\"></section><section><div class=\"container\"><div class=\"row\"></div></div></section><section id=\"inzibp\"><div class=\"container\"><div id=\"i5l95y\" class=\"row\"><div class=\"col-md-6\"></div></div></div></section><section id=\"iujubi\"><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"></div></div></div></section><section><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"></div></div></div></section><section id=\"i8bp4x\"><div class=\"container\"></div></section><section id=\"ijoi3e\"><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"></div></div></div></section><section><div class=\"container\"><div class=\"row\"><div class=\"col-md-6\"></div></div></div></section></body>','طراحی سایت اختصاصی',NULL,NULL,NULL,'exclusive-website-design',0,NULL,1,'2022-09-14 18:27:54','2022-09-19 18:03:26',0,NULL),
(15,'قوانین و مقررات','<body><p id=\"igu5b\"><span dir=\"LTR\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">.</span></span><br><span style=\"font-size:11pt\"><span style=\"text-justify:inter-ideograph\"><span style=\"line-height:107%\"><span style=\"font-family:Calibri\"><b><span dir=\"RTL\" style=\"font-size:11.5000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\"><span style=\"font-weight:bold\">تعهدات مجری</span></span></span></b></span></span></span></span><br> <span style=\"font-size:11pt\"><span style=\"text-justify:inter-ideograph\"><span style=\"line-height:107%\"><span style=\"font-family:Calibri\"><span dir=\"RTL\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">مجری متعهد میگردد در صورت دریافت کلیه داده ها و موارد مورد نیاز در طراحی ، موضوع قرارداد را حداکثر در مدت زمان ذکر شده در بند 4 &nbsp;قرارداد به کارفرما تحویل نماید.</span></span></span></span></span></span> <span style=\"font-size:11pt\"><span style=\"text-justify:inter-ideograph\"><span style=\"line-height:107%\"><span style=\"font-family:Calibri\"><span dir=\"RTL\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">مجری متعهد میگردد سایت</span></span><span dir=\"RTL\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">&nbsp;<font face=\"Yekan Bakh Light\">و اپلیکیشن</font></span></span><span dir=\"RTL\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">&nbsp;مذکور را در تاریخ ذکر شده در ماده ی 4 قرارداد &nbsp;به طور کامل تحویل دهد. در غیر این صورت روزانه </span></span><span dir=\"LTR\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">5 </span></span><span dir=\"RTL\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">% از مبلغ کل قرار داد کسر خواهد شد.</span></span></span></span></span></span> <span style=\"font-size:11pt\"><span style=\"text-justify:inter-ideograph\"><span style=\"line-height:107%\"><span style=\"font-family:Calibri\"><span dir=\"RTL\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">مجری متعهد میگردد نام کاربری ، رمز عبور و را پس از تسویه کامل مبلغ قرارداد در اختیار نماینده کارفرما قراردهد</span></span><span dir=\"LTR\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">.</span></span></span></span></span></span> <span style=\"font-size:11pt\"><span style=\"text-justify:inter-ideograph\"><span style=\"line-height:107%\"><span style=\"font-family:Calibri\"><span dir=\"RTL\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\"><font face=\"Yekan Bakh Light\">مجری متعهد میگردد فایل های (</font></span></span><span dir=\"LTR\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">apk</span></span><span dir=\"RTL\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\"><font face=\"Yekan Bakh Light\">) اپلیکیشن </font></span></span><span dir=\"LTR\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">android </span></span><span dir=\"RTL\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">&nbsp;&nbsp;<font face=\"Yekan Bakh Light\">را در اختیار کارفرما قرار دهد.</font></span></span></span></span></span></span> <span style=\"font-size:11pt\"><span style=\"text-justify:inter-ideograph\"><span style=\"line-height:107%\"><span style=\"font-family:Calibri\"><span dir=\"RTL\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">مجری متعهد میگردد پنل مدیریتی وبسایت</span></span><span dir=\"RTL\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">&nbsp;<font face=\"Yekan Bakh Light\">و اپلیکیشن</font></span></span><span dir=\"RTL\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">&nbsp;را به کارفرما یک کلیپ آموزشی آموزش دهد.</span></span></span></span></span></span> <span style=\"font-size:11pt\"><span style=\"text-justify:inter-ideograph\"><span style=\"line-height:107%\"><span style=\"font-family:Calibri\"><span dir=\"RTL\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">مجري مي بايست كليه اطلاعات ارائه شده را محرمانه تلقي نموده و از قراردادن اطلاعات مذكور در اختيار اشخاص ثالث خودداري نمايد.</span></span></span></span></span></span> <span style=\"text-justify:inter-ideograph\"><span dir=\"RTL\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\"><font face=\"Yekan Bakh Light\">خرید هاست یک گیگابایت یکساله به عهده مجری میباشد</font></span></span><span dir=\"RTL\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\"><font face=\"Yekan Bakh Light\">. <br>​​​​​​​​​​​​​​</font></span></span></span><span style=\"font-size:11pt\"><span style=\"text-justify:inter-ideograph\"><span style=\"line-height:107%\"><span style=\"font-family:Calibri\"><b><span dir=\"RTL\" style=\"font-size:11.5000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\"><span style=\"font-weight:bold\">تعهدات کارفرما</span></span></span></b></span></span></span></span><br> <span style=\"font-size:11pt\"><span style=\"text-justify:inter-ideograph\"><span style=\"line-height:107%\"><span style=\"font-family:Calibri\"><span dir=\"RTL\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">کارفرما متعهد میگردد کلیه اطلاعات مورد نیاز طراحی را در اختیار مجري قراردهد. بدیهی است در صورت عدم تحویل اطلاعات و تصاویر صحیح مورد نیاز در طراحی به مجري ، مجري هیچگونه مسئولیتی در خصوص تحویل به موقع موضوع قرارداد در مدت زمان ذکر شده در بند 4 بر عهده نخواهد داشت</span></span><span dir=\"LTR\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">.</span></span></span></span></span></span> <span style=\"text-justify:inter-ideograph\"><span dir=\"RTL\" style=\"font-size:10.5000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">تسلیم مدارك مورد نیاز برای طراحی وب سایت به طراح، و پرداخت مبلغ قرارداد.</span></span></span> <span style=\"text-justify:inter-ideograph\"><span dir=\"RTL\" style=\"font-size:10.5000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">کارفرما حق واگذاری امتیاز طراحی سایت در زمان اجرا و پشتیبانی</span></span>&nbsp;<span dir=\"RTL\" style=\"font-size:10.5000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\"><font face=\"Yekan Bakh Light\">یکساله </font></span></span><span dir=\"RTL\" style=\"font-size:10.5000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">، به غیر ندارد.</span></span></span> <span style=\"text-justify:inter-ideograph\"><span dir=\"RTL\" style=\"font-size:10.5000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">تمامی محتوای وب سایت، مسائل حقوقی و مالیاتی در خصوص فروش اجناس سایت، کاملا به عهده کارفرما می باشد.</span></span></span> <span style=\"text-justify:inter-ideograph\"><span dir=\"RTL\" style=\"font-size:10.5000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">کارفرما </span></span><span dir=\"RTL\" style=\"font-size:10.5000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">متعهد میگردد </span></span><span dir=\"RTL\" style=\"font-size:10.5000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\"><span style=\"color:#333333\">الباقی مبلغ قرارداد را بلافاصله بعد از تحویل گرفتن سایت در زمان &nbsp;مقرر پرداخت نماید</span></span></span><span dir=\"RTL\" style=\"font-size:10.5000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">&nbsp;در غیر این صورت روزانه </span></span><span dir=\"LTR\" style=\"font-size:10.5000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">5 </span></span><span dir=\"RTL\" style=\"font-size:10.5000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">% به مبلغ کل قرار داد اضافه خواهد شد.</span></span></span> <span style=\"text-justify:inter-ideograph\"><span dir=\"RTL\" style=\"font-size:10.5000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\"><font face=\"Yekan Bakh Light\">دریافت کد رهگیری مالیاتی جهت ثبت درگاه بانکی به عهده کارفرما میباشد.</font></span></span></span> <span style=\"text-justify:inter-ideograph\"><span dir=\"RTL\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">هزینه تمدید هاست و دامین بعد از یکسال به عهده کارفرما میباشد</span></span><span dir=\"RTL\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\">.</span></span></span></p><section><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" class=\"svg-header-left\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#288ed929\" fill-opacity=\"0.6\"></path></svg></section><section class=\"what-we-do pt-5 pb-5\"><div class=\"container\"><div class=\"row\"><div class=\"col-md-12\"><div class=\"section-head justify-content-center\"><div class=\"section-title\"><div class=\"title-icon\"><svg width=\"50\" height=\"50\" viewBox=\"0 0 50 50\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M40.625 45.8333C42.3479 45.8333 43.75 44.4313 43.75 42.7083V35.4167C43.75 33.6938 42.3479 32.2917 40.625 32.2917C38.1875 32.2917 35.7916 31.9083 33.5 31.1521C32.9522 30.9791 32.3677 30.9581 31.8089 31.0913C31.2501 31.2245 30.7379 31.5069 30.327 31.9083L27.327 34.9083C22.1419 32.0934 17.8834 27.8363 15.0666 22.6521L18.0416 19.6583C18.9 18.8625 19.2083 17.6521 18.8416 16.4875C18.0869 14.1923 17.7043 11.7911 17.7083 9.375C17.7083 7.65208 16.3062 6.25 14.5833 6.25H7.29163C5.56871 6.25 4.16663 7.65208 4.16663 9.375C4.16663 29.4792 20.5208 45.8333 40.625 45.8333ZM7.29163 8.33333H14.5833C14.8596 8.33333 15.1245 8.44308 15.3199 8.63843C15.5152 8.83378 15.625 9.09873 15.625 9.375C15.625 12.0354 16.0416 14.6479 16.8604 17.125C16.9205 17.3048 16.9276 17.498 16.8806 17.6817C16.8337 17.8653 16.7348 18.0316 16.5958 18.1604L12.5208 22.2563C15.9312 28.9813 20.9687 34.0188 27.725 37.4583L31.7854 33.3958C31.9239 33.2587 32.0971 33.1619 32.2865 33.1156C32.4759 33.0694 32.6742 33.0755 32.8604 33.1333C35.352 33.9583 37.9645 34.375 40.625 34.375C41.1979 34.375 41.6666 34.8438 41.6666 35.4167V42.7083C41.6666 43.2813 41.1979 43.75 40.625 43.75C21.6708 43.75 6.24996 28.3292 6.24996 9.375C6.24996 9.09873 6.35971 8.83378 6.55506 8.63843C6.75041 8.44308 7.01536 8.33333 7.29163 8.33333Z\" fill=\"#288ED9\"></path></svg></div><div class=\"title-box\"><h2 class=\"title\"> تماس با گروه کاراوب</h2><p>مشاوره رایگان جهت راه اندازی وب سایت...</p><div class=\"blue-line\"></div></div></div></div></div><div class=\"col-md-12\"><div class=\"d-flex justify-content-center\"><div class=\"contact-us\"><p class=\"contact-phone\">021-77200630</p></div></div></div></div></div></section></body>','قوانین و مقررات',NULL,NULL,NULL,'rules',0,NULL,1,'2023-05-01 14:34:41','2023-05-01 14:41:06',0,NULL),
(16,'نمونه قرارداد','<body id=\"itxm\"><section id=\"i8bp4x\"><div class=\"container\"><div class=\"section-head\"><div class=\"section-title\"><div class=\"title-box\"><h2 class=\"title\">نمونه قرار داد طراحی سایت</h2><p id=\"ikipf\">نمونه قرارداد</p><div class=\"blue-line\"></div></div></div></div><p id=\"ian1tc\"><span style=\"color:#000000;\"><strong>۱ . موضوع قرارداد<br>قرارداد طراحی سایت</strong>  <strong>۲<br> . طرفین قرارداد</strong><br>ايــن قــرارداد فــی مابيــن …………. کــه از ایــن پــس در ایــن قــرارداد پیمانــکار نامیـده مـی شـود و از یـک طـرف …………………………… کـه از ایـن پـس در ایـن قــرارداد کارفرمــا نامیــده مــی شــود، بــه شــرح ذیــل منعقــد و طرفیــن قــرارداد متعهــد بــه اجــرای مفــاد آن مــی باشــند.  <strong>۲-۱ مشخصات طرفین</strong>  <strong>۲-۱-۱ مشخصات پیمانکار</strong><br>…………………………… آدرس پسـت الکترونیک …………………………… به نشـانی  تهران، میدان رسالت، خیابان هنگام، چهار راه آزادگان، کوچه حسینی<br>  <strong>۲-۱-۲ مشخصات کارفرما-حقوقی</strong><br>شــرکت …………………………… بــه شناســه ملــی …………………………… نــام و نــام خانوادگــی نماینــده …………………………… ســمت …………………………… کـد ملـی …………………………… آدرس پسـت الکترونیـک …………………………… نشــانی …………………………… تلفــن ……………………………  <strong>مشخصات کارفرما -حقیقی</strong><br>نــام و نــام خانوادگــی …………………………… کــد ملــی ………………………….. &nbsp;آدرس پســت الکترونیــک …………………………… نشــانی …………………………… تلفــن ……………………………<br>کلیــه اعالنــات صــورت گرفتــه از طــرف مشــخصات منــدرج در مــاده ۱-۲ بــرای طرفیــن بــه منزلــه درخواســت رســمی و قطعــی طرفیــن قــرارداد مــی باشــد .  <strong>۳ .مبلغ قرارداد</strong><br><strong>۳-۱</strong><br>مبلــغ انجــام موضــوع قــرارداد بــا توجــه بــه مشــخصات آمــده در مــاده ۱ ایــن قــرارداد، بــه مبلــغ …………………………… مــی باشــد.  <strong>۴ . شرایط پرداخت</strong><br><strong>۴-۱</strong><br>مرحلــه ۱ :پرداخــت ۵۰ %مبلــغ کل قــرارداد بــه عنــوان پیــش پرداخــت از طــرف کارفرمــا.<br>  <strong>۴-۱-۱ نحوه پرداخت<br></strong><span style=\"font-size:16px;\"><span style=\"word-break:break-all\"><span dir=\"RTL\"><span style=\"font-family:\'Yekan Bakh Light\'\"></span></span></span></span></span><span style=\"word-break:break-all\"><span style=\"color:#000000;\"><span style=\"font-size:16px;\"><span dir=\"RTL\"><span style=\"font-family:\'Yekan Bakh Light\'\">ضمنا</span></span>&nbsp;<span dir=\"RTL\"><span style=\"font-family:\'Yekan Bakh Light\'\">كليه پرداخت ها به </span></span><span dir=\"RTL\"><span style=\"font-family:\'Yekan Bakh Light\'\">شماره کارت </span></span><b><span dir=\"RTL\"><span style=\"font-family:\'Yekan Bakh Light\'\"><span style=\"font-weight:bold\"><font face=\"Yekan Bakh Light\">0541 0030 8619 6219</font></span></span></span></b><b>&nbsp;</b>&nbsp;&nbsp;<span dir=\"RTL\"><span style=\"font-family:\'Yekan Bakh Light\'\">نزد بانک </span></span><b><span dir=\"RTL\"><span style=\"font-family:\'Yekan Bakh Light\'\"><span style=\"font-weight:bold\"><font face=\"Yekan Bakh Light\">سامان </font></span></span></span></b><span dir=\"RTL\"><span style=\"font-family:\'Yekan Bakh Light\'\">به نام </span></span><b><span dir=\"RTL\"><span style=\"font-family:\'Yekan Bakh Light\'\"><span style=\"font-weight:bold\">فرشاد رجب زاده نودهی</span></span></span></b><span dir=\"RTL\"><span style=\"font-family:\'Yekan Bakh Light\'\">، واریز </span></span><span dir=\"RTL\"><span style=\"font-family:\'Yekan Bakh Light\'\"><font face=\"Yekan Bakh Light\">میگردد</font></span></span></span></span><span dir=\"RTL\" style=\"font-size:10.0000pt\"><span style=\"font-family:\'Yekan Bakh Light\'\"><span style=\"color:#000000;\"><span style=\"font-size:16px;\">.<br></span></span></span></span></span><span style=\"color:#000000;\"><span style=\"font-size:16px;\"></span><strong>۴-۲</strong><br>مرحلـه ۲ :پرداخـت ۵۰ درصـد مبلـغ کل قـرارداد پـس از تحویل وب سایت و تأییـد کارفرما.<br>  <strong>۴-۳</strong><br>مــدت زمــان تأییــد طــرح و پرداخــت وجــه از ســوی کارفرمــا از زمــان ارائــه بــه نماینـده کارفرمـا در مرحلـه ۲ مندرج در بنـد ۴-۲ حداکثر ۴ روز کاری می باشـد،  در صـورت گذشـت بیـش از ۴ روز کاری از زمـان ارائـه طـرح و عـدم پاسـخگوییکارفرمـا مبـی بـر تأییـد و یـا عـدم تأییـد طـرح، روزانـه مبلـغ ۰۰۰,۱۰۰ ریـال بـه عنـوان<br>خسـارت تأخیـر مـی بایسـت بـه پیمانـکار پرداخـت گـردد.<br>در صــورت گذشــت بیــش از ۴ روز کاری و عــدم دریافــت پاســخ کارفرمــا در صورتــی کــه پیمــان کار اطــاع رســانی الزم را انجــام داده باشــد، بدیهــی اســت زمــان تحویــل نهایــی موضــوع قــرارداد از زمــان مشــخص شــده فراتــر خواهــد رفـت و پیمانـکار زمـان تحویـل نهایـی را طبـق صـاح دیـد مشـخص مـی نمایـد.<br>  <strong>۴-۴</strong><br>وجــه تســویه مرحلــه ۲ مــی توانــد بــه صــورت نقــدی و یــا بــه هــر نــوع حســاب بانکــی کــه توســط پیمــان کار معرفــی مــی شــود واریــز گــردد.<br>  <strong>۴-۵</strong><br>درصورتـی کـه طـرح مرحلـه ۲ بـه تأییـد کلـی کارفرمـا برسـد و تغییـرات جزئـی نیــاز باشــد، تســویه ایــن مرحلــه مــی بایســت حداکثــر طــی ۴ روز کاری انجــام گردد. در مقابـل پیمانـکار متعهـد مـی شـود بـا توجـه بـه میـزان تغییـرات در<br>اسـرع وقـت نسـبت بـه اعمـال تغییـرات اقـدام نمایـد.<br><strong>۴-۵-۱</strong><br>    منظور از تأیید کلی در بند ۴-۵ رضایت کلی کارفرما از طرح می باشد.<br><br>  <strong>۴-۶</strong><br>درصورتـی کـه کارفرمـا طـرح مرحلـه ۲ را تأییـد نکنـد، مـی توانـد تسـویه ایـن مراحــل را تــا انجــام تغییــرات مــورد انتظــار بــه تعویــق بیانــدازد. بدیهــی اســت مـدت زمـان الزم بـرای انجـام تغییـرات کـه از سـوی پیمانـکار تعیین مـی گردد، بـه مـدت زمـان تحویـل موضـوع قـرارداد اضافـه میگـردد.<br>  <strong>۵ .شروع قرارداد</strong><br>قــرارداد از تاریــخ امضــاء و تبــادل آن توســط طرفیــن و پرداخــت مبلــغ پیــش پرداخــت، نافــذ، معتبــر و الزم االجــرا اســت.<br>  <strong>۵-۱</strong><br>در صـورت امضـاء قـرارداد و عـدم پرداخـت وجـه پیـش پرداخـت در تاریـخ عقـد قـرارداد، مـدت زمـان الزم جهـت انجـام موضـوع قـرارداد کـه درمـاده ۶ همیـن قــرارداد درج شــده اســت، متناســب بــا اختــاف تاریــخ امضــاء قــرارداد و تاریــخ پرداخــت وجــه پیــش پرداخــت، افزایــش خواهــد یافــت.<br>  <strong>۶.مدت زمان لازم جهت انجام موضوع قرارداد<br></strong>  <strong>۶-۱</strong> <br> مــدت زمــان الزم جهــت انجــام موضــوع قــرارداد و تحویــل طــرح نهایــی طبــق مذاکــرات انجــام شــده و توافــق طرفیــن ………. روز کاری مــی باشــد.<br>مبنـای تعییـن مـدت زمـان الزم بـرای انجـام موضـوع قـرارداد، ارائـه اطلاعـات و توضیحــات اولیــه بــه پیمانــکار همزمــان بــا پرداخــت وجــه پیــش پرداخــت و امضـاء قـرارداد و همچنیـن تأییـد اولیـن طـرح هـای ارائـه شـده بـه کارفرمـا در<br>مرحلــه ۲ منــدرج در بنــد ۴ -۲ مــی باشــد.  بدیهـی اسـت در صـورت عـدم ارائـه اطالعـات در زمـان پرداخـت پیـش پرداخـت و امضـاء قـرارداد و همچنیـن عـدم تأییـد طـرح هـای اولیـه و درخواسـت تغییـرات و یـا طراحـی و پیـاده سـازی مجـدد طـرح هـا، زمان سـپری شـده از تاریـخ پرداخت پیـش پرداخـت و امضـاء قـرارداد تـا زمـان ارائـه اطالعـات اولیـه از سـوی کارفرما و همچنیـن مـدت زمـان الزم بـرای انجـام تغییـرات کـه از سـوی پیمانـکار تعییـن مـی شـود، بـه مـدت زمـان الزم بـرای تحویـل موضـوع قـرارداد اضافـه مـی شـود.  <strong>۷.خدمات پشتیبانی</strong><br>خدمـات پشـتیبانی بـه مـدت یـک سـال شـمیس و شـروع آن از تاریـخ پرداخـت وجــه تســویه مرحلــه ۲ قــرارداد، منــدرج در بنــد ۴-۲ اســت کــه در ســال هــای آتـی بـا پرداخـت ۲۰ درصـد مبلـغ کل قـرارداد، بـه مـدت یـک سـال شـمیس قابـل<br>تمدیـد مـی باشـد.<br>  <strong>۷-۱</strong><br>خدمــات پشــتیبانی طراحــی ســایت شــامل رفــع هرگونــه نقــص در عملکــرد صحیـح مـوارد منـدرج در مـاده ۱ همیـن قـرارداد و یـا آمـوزش نحـوه کار بـا بخش های مختلـف وب سـایت اسـت.<br>  <strong>۷-۱-۱</strong><br>آمـوزش اولیـه نحـوه مدیریـت سـایت بـه صـورت یـک فایـل ویدیویـی رایـگان بـه کارفرمـا تحویـل مـی گـردد. بدیهـی اسـت در صـورت درخواسـت کارفرمـا و نیـاز بـه جلسـه آمـوزیش نحـوه مدیریـت سـایت، کارفرمـا مـی بایسـت هزینـه مشـخص شـده از طـرف پیمانـکار را بپـردازد.<br>  <strong>۷-۱-۲</strong><br>در صـورت درخواسـت تغییـرات از سـوی کارفرمـا پـس از تأییـد طرح هـا در مرحله منـدرج در بنـد ۴-۲ ، کارفرمـا مـی بایسـت هزینـه انجـام تغییـرات کـه توسـط پیمانـکار تعییـن مـی گـردد را از قبـل بپـردازد.<br>  <strong>۷-۲</strong><br>در صــورت عــدم واریــز هزینــه خدمــات پشــتیبانی ســاالنه، وظیفــه پشــتیبانی و رفـع اشـکال از پیمانـکار سـاقط مـی گـردد.<br>  <strong>۸ .تعهدات طرفین</strong>  <strong>۸-۱ تعهدات پیمانکار<br></strong>  <strong>۸-۱-۱</strong><br>کلیــه اطلاعاتــى كــه توســط كارفرمــا در اختيــار پیمانــکار قــرار میگیــرد از ســوی پیمانـکار محرمانـه تلقـی میگـردد و پیمانـکار موظـف بـه حفـظ و نگهـدارى اطلاعـات داده شـده بـوده و حـق در اختیـار دادن ایـن اطالعـات را بـه سـایر ندارد.<br>  <strong>۸-۱-۲</strong><br>پیمانــکار متعهــد مــی شــود کلیــه خدمــات ذکــر شــده در موضــوع قــرارداد را پـس از تسـویه کامـل قـرارداد، بـه کارفرمـا ارائـه دهـد.  <strong>۸-۱-۳</strong><br>پیمانـکار متعهـد مـی شـود، در طـول قـرارداد کلیـه مشـکالت فـی مربـوط بـه وب سـایت را برطـرف نمایـد.<br><strong>۸-۱-۴</strong><br>پیمانــکار متعهــد مــی شــود در صــورت عــدم تحویــل طــرح نهایــی در زمــان محاســبه شــده،روزانه مبلــغ ۱۰۰/۰۰۰ ریــال بــه عنــوان خســارت تأخیــر بــه کارفرمــا پرداخــت نمایــد.<br>  <strong>۸-۱-۵</strong><br>در صــورت تســویه مرحلــه ۲ منــدرج در بنــد ۴-۲ ،پیمانــکار مــی بایســت فایــل آمـوزیش را در اختیـار کارفرمـا قـرار دهـد و اطلاعـات الزم را در اختیار وی قـرار دهد.<br>  <strong>۸-۲ <br>تعهدات کارفرما</strong>  <strong>۸-۲-۱</strong><br>درج نـام پیمانـکار در وبسـایت کارفرمـا الزامـی اسـت و پیمانـکار حـق دارد طرح تحویـل داده شـده را در محـل مناسـب بـه نحـوی کـه بـه اصـل طـرح آسـيب وارد نگــردد امضــاء نمایــد، مگــر در صورتــی کــه طرفیــن در ایــن مــورد بــه توافــق<br>برسـند.<br>  <strong>۸-۲-۲</strong><br>در صورتــی کــه کارفرمــا درخواســت عــدم امضــای طــرح نمایــد، مــی بایســت مبلـغ ۵۰۰ هـزار تومـان بـه پیمانـکار بـه عنـوان عـدم درج اسـم پیمانـکار در طـرح را پرداخـت نمایـد.<br>  <strong>۸-۲-۳</strong><br>چنانچــه چنــد طــرح اولیــه توســط پیمانــکار جهــت بررســى بــه كارفرمــا ارائــه گــردد، كارفرمــا پــس از انتخــاب طــرح اولیــه مناســب، ملــزم بــه بازگردانــدن تمـام طـرح هـای دیگـر بـه پیمانـکار بـوده و هیچگونـه حـق مالكيتـى نسـبت<br>بــه ســاير طــرح هــا نخواهــد داشــت.<br>  <strong>۸-۲-۴</strong><br>پرداخـت کلیـه کسـورات قانونـی مبلـغ قـرارداد بـر عهـده کارفرمـا میباشـد و مبلـغ قـرارداد بـه صـورت خالـص بـه پیمانـکار پرداخـت میگـردد.<br>  <strong>۸-۲-۵</strong><br>پیمانــکار پــس از تحویــل کار اطالعــات امنیــی آن را در اختیــار کارفرمــا قــرار میدهــد. بدیهــی اســت پیمانــکار هیــچ گونــه مســئولییت در قبــال در اختیــار قـرار گرفتـن اطالعـات امنیـی وب سـایت بـه افـراد غیـر بـه هـر نحـوی از سـوی کارفرمــا را نــدارد.<br>  <strong>۸-۲-۶</strong><br>در صــورت ثبــت نشــانی)دامنه( و تهیــه هاســت)فضای میزبانــی( وب ســایت از طریــق پیمانــکار، کارفرمــا متعهــد مــی شــود کــه هزینــه ســاالنه مربــوط بــه تمدیــد نشــانی )دامنــه( یــا هاســت را طبــق تعرفــه روز بــه پیمانــکار پرداخــت نمایــد. زمــان تمدیــد دامنــه و هاســت توســط ســرور اصلــی بــه ایمیــل یــا پنــل کاربــری کارفرمــا ارســال میشــود و قابــل پیگیــری اســت.<br>  <strong>۸-۲-۷</strong><br>کارفرمـا متعهـد مـی شـود کـه پـس از عقـد قـرارداد، در قبـال درخواسـت اضافه کـردن ویژگـی هـای جدیـد بـه وب سـایت، هزینـه آن را بـه پیمانـکار پرداخـت نماید .<br><strong>۸-۲-۸</strong><br>کارفرمــا متعهــد مــی شــود در صــورت نیــاز بــه ارائــه اطالعــات اولیــه ماننــد نشــانه)دامنه( ، تصاویــر، کاتالــوگ و …. آن هــا را قبــل از ارائــه طــرح اولیــه در اختیــار پیمانــکار قراردهــد. بدیهــی اســت در صــورت عــدم همــکاری کارفرمــا، پیمانــکار مــی توانــد طــرح اولیـه منـدرج در بنـد ۴-۲ را ارائـه ندهـد و هزینـه ایـن مرحلـه را دریافـت نمایـد.<br>  <strong>۸-۲-۹</strong><br>کارفرمــا متعهــد مــی شــود پــس از تأییــد طــرح مرحلــه ۲ منــدرج در بنــد ۴-۲ ، هرگونــه درخواســت تغییــر کــه منجــر بــه طراحــی مجــدد و یــا تغییــرات در بخــی از طــرح شــود، هزینــه آن را طبــق تعرفــه روز محاســبه شــده توســط پیمانــکار پرداخــت نمایــد.<br>  <strong>۹ .حل اختلاف</strong><br>در صـورت بــروز اختـلاف فـی مـا بیـن طرفیـن قـرارداد، در صورتــی کـه توافقـی در مذاکـرات حاصـل نشـد، اختـلاف از طریـق مراجـع ذیصـاح مـورد بـرریس قـرار مـی گیـرد.<br>  <strong>۱۰.فسخ قرارداد</strong><br>قــرار داد از نــوع الزم االجــرا تلقــی شــده و تنهــا در صــورت وقــوع شــرایط فســخ اشــاره شــده در متــن قــراداد و یــا توافــق طرفیــن قابــل فســخ مــی باشــد.<br>  <strong>۱۱ .اقامت گاه قانونی طرفین</strong><br>اقامتـگاه قانونـی طرفیـن، همـان نشـاني منـدرج در قـرارداد بـوده و در مـوارد لـزوم و بـه منظـور ابـاغ مكاتبـات، مـورد اسـتناد خواهـد بـود و در صورتيكـه در طـول مـدت قـرارداد نشـاني متعاقديـن تغييـر يابـد، طرفيـن بايـد رسـماً و كتبـاً مراتـب را بـه يكديگـر ابـاغ نماينـد و تـا قبـل از ابالغ رسـمي، نشـاني قبلـي معتبر خواهـد بـود.<br>  <strong>۱۲ .فورس ماژور</strong><br>در صـورت بـروز هرگونـه اشـکال بـه علـت وجـود فـورس مـاژور طبـق تعاریـف سـازمان برنامـه و بودجـه )از قبیـل سـیل، زلزلـه، جنـگ، اعتصـاب و غیـره( طبـق قوانیـن حاکـم بـر جامعـه عمـل خواهـد شـد.<br>  <strong>۱۳ .نسخ قرارداد</strong><br>ایــن قــرارداد در تاریــخ ……………………… در ۱۳ مــاده در دو نســخه کــه اعتبــار یکســان دارنــد تنظیــم و بــه امضــاء طرفیــن قــرارداد رســید.<br>​​​​​​​  <strong>۱۳-۱</strong><br>نسخ قرارداد فاقد هرگونه قلم خوردگی میباشند.</span></p><div data-aos=\"fade-up\" class=\"contact aos-init aos-animate\"><div class=\"wrapper\"><div class=\"icon\"></div><div class=\"description\"><strong>به مشاوره نیاز دارید؟ همین حالا با ما تماس بگیرید</strong><p id=\"iyfq3\">مشاوره رایگان در رابطه با راه اندازی وب سایت شما</p></div></div><div class=\"call-btn\"><a href=\"\" class=\"kw-btn-blue\">تماس با کاراوب</a></div><svg width=\"174\" height=\"481\" viewBox=\"0 0 174 481\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z\" fill=\"#4B3DA7\" fill-opacity=\"0.07\"></path></svg></div></div></section></body>','نمونه قرار داد طراحی سایت',NULL,NULL,NULL,'sample-contract',0,NULL,1,'2023-06-13 18:24:59','2023-06-13 18:42:58',0,NULL);
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_resets`
--

DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_resets` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_resets`
--

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `res_number` varchar(255) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payments_order_id_foreign` (`order_id`),
  CONSTRAINT `payments_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `permission_role`
--

DROP TABLE IF EXISTS `permission_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `permission_role` (
  `role_id` bigint(20) unsigned NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`permission_id`),
  KEY `permission_role_permission_id_foreign` (`permission_id`),
  CONSTRAINT `permission_role_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `permission_role_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `permission_role`
--

LOCK TABLES `permission_role` WRITE;
/*!40000 ALTER TABLE `permission_role` DISABLE KEYS */;
INSERT INTO `permission_role` (`role_id`, `permission_id`) VALUES (1,2),
(1,3),
(1,4),
(1,5),
(1,6),
(1,7),
(1,8),
(1,9),
(1,10),
(1,11),
(1,15),
(5,10);
/*!40000 ALTER TABLE `permission_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `permission_user`
--

DROP TABLE IF EXISTS `permission_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `permission_user` (
  `user_id` bigint(20) unsigned NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`user_id`,`permission_id`),
  KEY `permission_user_permission_id_foreign` (`permission_id`),
  CONSTRAINT `permission_user_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `permission_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `permission_user`
--

LOCK TABLES `permission_user` WRITE;
/*!40000 ALTER TABLE `permission_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `permission_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `permissions`
--

DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `permissions`
--

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` (`id`, `name`, `label`, `created_at`, `updated_at`) VALUES (2,'manage-plugins','مدیریت پلاگین ها',NULL,NULL),
(3,'manage-users','مدیریت کاربران',NULL,NULL),
(4,'manage-portfolios','مدیریت نمونه کارها',NULL,NULL),
(5,'manage-pages','مدیریت برگه ها',NULL,NULL),
(6,'manage-menu','مدیریت منوها',NULL,NULL),
(7,'manage-comments','مدیریت نظرات',NULL,NULL),
(8,'manage-courses','مدیریت دوره ها',NULL,NULL),
(9,'manage-discounts','مدیریت تخفیف ها',NULL,NULL),
(10,'edit-profile','مدیریت پروفایل',NULL,NULL),
(11,'manage-all','مدیریت همه جیز',NULL,NULL),
(12,'send-ticket','ارسال تیکت',NULL,NULL),
(13,'see-ticket','مشاهده تیکت',NULL,NULL),
(15,'manage-posts','مدیریت پست ها','2021-06-14 03:28:53','2021-06-14 03:28:53');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `portfolios`
--

DROP TABLE IF EXISTS `portfolios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `portfolios` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `desc` longtext NOT NULL,
  `slug` text NOT NULL,
  `keywords` text DEFAULT NULL,
  `meta_disc` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `meta_title` varchar(255) DEFAULT NULL,
  `link` varchar(255) DEFAULT NULL,
  `order_id` int(20) DEFAULT NULL,
  `logo` text DEFAULT NULL,
  `techs` text NOT NULL,
  `project_progress` text DEFAULT NULL,
  `project_running_date` text DEFAULT NULL,
  `colors` text NOT NULL,
  `meta_type` varchar(255) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_persian_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `portfolios`
--

LOCK TABLES `portfolios` WRITE;
/*!40000 ALTER TABLE `portfolios` DISABLE KEYS */;
INSERT INTO `portfolios` (`id`, `title`, `desc`, `slug`, `keywords`, `meta_disc`, `created_at`, `updated_at`, `meta_title`, `link`, `order_id`, `logo`, `techs`, `project_progress`, `project_running_date`, `colors`, `meta_type`, `image`, `status`) VALUES (14,'فروشگاه آنلاین الیسا','<p>فروشگاه آنلاین الیسا فعال در زمینه فروش لوازم و اغذیه کودکان میباشد و از نمونه کار های موفق کاراوب در زمینه <a href=\"../../../online-store-web-design\">طراحی سایت فروشگاهی</a> میباشد.</p>\r\n<p>این وب سایت دارای امکانات کامل فروشگاهی میباشد، امکاناتی مانند:</p>\r\n<p>سیستم مدیریت سفارش</p>\r\n<p>سیستم مدیریت محصول</p>\r\n<p>سیستم پیامکی</p>\r\n<p>سیستم امتیاز دهی بر اساس خرید</p>\r\n<p>سیستم تخفیف دهی حرفه ای</p>\r\n<p>و...</p>\r\n<p><img style=\"display: block; margin-left: auto; margin-right: auto;\" src=\"../../../images/portfolios/elisa.jpg\" alt=\"\" width=\"700\" height=\"351\" /></p>','elisa-shop','الیسا شاپ , elisa shop','فروشگاه آنلاین الیسا فعال در زمینه فروش لوازم و اغذیه کودکان میباشد و از نمونه کار های موفق کاراوب در زمینه طراحی سایت فروشگاهی میباشد.','2020-08-06 04:59:20','2022-08-28 17:22:28','فروشگاه آنلاین الیسا | نمونه کار کاراوب','https://elisa-shop.ir/',15,'/images/portfolios/elisa-logo.png','a:5:{i:0;s:4:\"html\";i:1;s:3:\"css\";i:2;s:10:\"javascript\";i:3;s:9:\"wordpress\";i:4;s:11:\"woocommerce\";}','100','1399/3/16','#ff4646 , #7ab2fa',NULL,'/images/1611135044screencapture-elisa-shop-ir-2021-01-20-12_59_30.jpg',0),
(15,'فروشگاه برند چلارس','<p>برند چلارس فعال در حوزه تولید ادکلن و عطر میباشد. وب سایت این برند بر اساس درخواست های کارفرما طراحی و اجرا شده است.</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">این وب سایت دارای امکانات کامل فروشگاهی میباشد، امکاناتی مانند:</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">سیستم مدیریت سفارش</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">سیستم مدیریت محصول</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">سیستم پیامکی</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">سیستم امتیاز دهی بر اساس خرید</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">سیستم تخفیف دهی حرفه ای</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; background-color: #ffffff;\"><img style=\"display: block; margin-left: auto; margin-right: auto;\" src=\"../../../images/portfolios/chelarce.jpg\" alt=\"\" width=\"700\" height=\"351\" /></p>','chelarce','چلارس','برند چلارس فعال در حوزه تولید ادکلن و عطر میباشد. وب سایت این برند بر اساس درخواست های کارفرما طراحی و اجرا شده است.','2020-08-06 05:14:27','2022-08-28 17:22:30','فروشگاه برند چلارس | نمونه کار','http://chelarce.com/',23,NULL,'a:6:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";i:3;s:10:\"javascript\";i:4;s:9:\"wordpress\";i:5;s:11:\"woocommerce\";}','100','1397/8/30','#0c0c0c',NULL,'/images/1611134944screencapture-chelarce-2021-01-20-12_58_21.jpg',0),
(20,'فروشگاه تاپ اسپرت','<p>فروشگاه تاپ اسپرت فعال در حوزه لوازم جانبی، دزدگیر و روکش خودرو میباشد و&nbsp;از نمونه کار های موفق کاراوب در زمینه&nbsp;<a href=\"https://karawebs.com/online-store-web-design\">طراحی سایت فروشگاهی</a>&nbsp;میباشد.</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">این وب سایت دارای امکانات کامل فروشگاهی میباشد، امکاناتی مانند:</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">سیستم مدیریت سفارش</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">سیستم مدیریت محصول</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">سیستم پیامکی</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">سیستم امتیاز دهی بر اساس خرید</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">سیستم تخفیف دهی حرفه ای</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">و...</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; background-color: #ffffff;\"><img style=\"display: block; margin-left: auto; margin-right: auto;\" src=\"../../../images/portfolios/top-sport.jpg\" alt=\"\" width=\"700\" height=\"351\" /></p>','topsportpunak','فروشگاه تاپ اسپرت','فروشگاه تاپ اسپرت فعال در حوزه لوازم جانبی، دزدگیر و روکش خودرو میباشد و از نمونه کار های موفق کاراوب در زمینه طراحی سایت فروشگاهی میباشد.','2020-08-06 05:26:55','2021-06-20 02:31:52','فروشگاه تاپ اسپرت','https://topsportpunak.com/',17,'/images/portfolios/top-sport-logo.jpg','a:5:{i:0;s:4:\"html\";i:1;s:3:\"css\";i:2;s:10:\"javascript\";i:3;s:9:\"wordpress\";i:4;s:11:\"woocommerce\";}','100','1399/3/31','#800000 , #2d2a2a',NULL,'/images/1611134703screencapture-topsportpunak-2021-01-20-12_54_06.jpg',1),
(24,'فروشگاه تاپ پلاست','<p>شرکت تاپ پلاست یکی از شرکت های موفق در تولید محصولات پلاستیکی و بهداشتی میباشد. این وب سایت دارای امکانات کامل وب سایت فروشگاهی میباشد.&nbsp;</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">این وب سایت دارای امکانات کامل فروشگاهی میباشد، امکاناتی مانند:</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">سیستم مدیریت سفارش</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">سیستم مدیریت محصول</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">سیستم پیامکی</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">سیستم امتیاز دهی بر اساس خرید</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">سیستم تخفیف دهی حرفه ای</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">و.</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; background-color: #ffffff;\"><img style=\"display: block; margin-left: auto; margin-right: auto;\" src=\"../../../images/portfolios/top-plast.jpg\" alt=\"\" width=\"700\" height=\"351\" /></p>','top-plast','فروشگاه تاپ پلاست , تاپ پلاست , top plast','شرکت تاپ پلاست یکی از شرکت های موفق در تولید محصولات پلاستیکی و بهداشتی میباشد. این وب سایت دارای امکانات کامل وب سایت فروشگاهی میباشد.','2020-08-06 05:32:40','2021-06-20 02:49:20','فروشگاه تاپ پلاست','http://top-plast.ir/',20,'/images/portfolios/top-plast-logo.png','a:5:{i:0;s:4:\"html\";i:1;s:3:\"css\";i:2;s:10:\"javascript\";i:3;s:9:\"wordpress\";i:4;s:11:\"woocommerce\";}','100','1398/11/30','#2d2a2a , #d14245',NULL,'/images/1611134147screencapture-top-plast-ir-2021-01-20-12_40_04.jpg',1),
(26,'فروشگاه آسیا مخزن','<div>\r\n<div>\r\n<h2>طراحی سایت آسیا مخزن</h2>\r\n</div>\r\n</div>\r\n<div>\r\n<p>یک طراحی بسیار زیبا و شیک توسط گروه طراحی سایت کاراوب برای شرکت آسیا مخزن<br />این وب سایت با استفاده از وردپرس پیاده سازی شده است.<br /><br /></p>\r\n</div>','asia-makhzan','آسیا مخزن','یک طراحی بسیار زیبا و شیک توسط گروه طراحی سایت کاراوب برای شرکت آسیا مخزن\r\nاین وب سایت با استفاده از وردپرس پیاده سازی شده است.','2020-08-06 05:35:15','2023-01-17 09:45:16','آسیا مخزن','http://asiamakhzan.com/',14,'/images/portfolios/asia-logo.png','a:5:{i:0;s:4:\"html\";i:1;s:3:\"css\";i:2;s:10:\"javascript\";i:3;s:9:\"wordpress\";i:4;s:11:\"woocommerce\";}','100','1398/5/16','#474747 , #fcce00',NULL,'/images/portfolios/asia.jpg',1),
(27,'وب سایت 2 زبانه شرکت ژاواندیش','<p>شرکت ژاو اندیش فعال در حوزه بارگیری کاتالیست میباشد و از شرکت های نام آشنا در این زمینه نیز میباشد. افتخار انجام این پروژه به کاراوب رسید و ما تمام تلاش خود را جهت ارائه یک پروژه کامل و خوب ارائه دادیم.</p>\r\n<p>این وب سایت به دلیل داشتن مخاطبان انگلیسی زبان&nbsp; به صورت 2 زبانه طراحی شده است.</p>\r\n<p><img style=\"display: block; margin-left: auto; margin-right: auto;\" src=\"../../../images/portfolios/zhavandish.jpg\" alt=\"\" width=\"700\" height=\"351\" /></p>','zhavandish','شرکت ژاو اندیش','شرکت ژاو اندیش فعال در حوزه بارگیری کاتالیست میباشد و از شرکت های نام آشنا در این زمینه نیز میباشد. افتخار انجام این پروژه به کاراوب رسید و ما تمام تلاش خود را جهت ارائه یک پروژه کامل و خوب ارائه دادیم.','2020-08-06 05:37:49','2023-05-02 13:53:20','وب سایت 2 زبانه شرکت ژاواندیش','http://www.zhavandish.com/',5,'/images/portfolios/logo-ZAV1s.png','a:4:{i:0;s:4:\"html\";i:1;s:3:\"css\";i:2;s:10:\"javascript\";i:3;s:9:\"wordpress\";}','100','1398/12/28','#f91515 , #34495e',NULL,'/images/1611133658screencapture-zhavandish-2021-01-20-12_36_42.jpg',1),
(28,'سالن زیبایی Rose Beauty','<p>این وب سایت یکی از نمونه کار های موفق ما در حوزه طراحی سایت میباشد. سالن زیبایی رز بیوتی واقع در شهر پاریس میباشد و این سایت هم با توجه به موقعیت مکانی ای که دارد طراحی ظاهری متفاوتی نیز دارد.</p>\r\n<p>زبان اصلی این وبسایت فرانسه است، با توجه به مخاطبان وب سایت که اغلب فرانسوی هستند.</p>\r\n<p>برخی خدمات انجام شده در این <a href=\"https://karawebs.com/\">طراحی سایت</a>:</p>\r\n<p>طراحی رابط کاربری با استفاده از Figma</p>\r\n<p>پیاده سازی قالب با HTML و CSS</p>\r\n<p>کد نویسی بخش وردپرس</p>\r\n<p>سیستم رزرو آنلاین وقت</p>\r\n<p><img style=\"display: block; margin-left: auto; margin-right: auto;\" src=\"../../../images/portfolios/rose.jpg\" alt=\"\" width=\"700\" height=\"351\" /></p>','rose-beauty','نمونه کار طراحی سایت زیبایی , سایت سالن زیبایی','این وب سایت یکی از نمونه کار های موفق ما در حوزه طراحی سایت میباشد. سالن زیبایی رز بیوتی واقع در شهر پاریس میباشد و این سایت هم با توجه به موقعیت مکانی ای که دارد طراحی ظاهری متفاوتی نیز دارد','2020-10-31 07:17:04','2021-06-20 01:55:18','سالن زیبایی رز بیوتی | نمونه کار طراحی سایت','http://rosebeauty.fr/',10,'/images/portfolios/rose-logo.png','a:6:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";i:3;s:10:\"javascript\";i:4;s:5:\"figma\";i:5;s:9:\"wordpress\";}','100','1399/09/28','#f06491 ,  #3e3e3e',NULL,'/images/1611133550screencapture-rosebeauty-fr-2021-01-20-12_35_01.jpg',1),
(30,'رزرو آنلاین نوبت دکتر خشایار احمدی','<p>این <a title=\"طراحی سایت\" href=\"../../../web-design\">طراحی سایت</a> به صورت اختصاصی برای یکی از بهترین دکتر های عمل زیبایی در ایران طراحی شده است، این وب سایت دارای سیستم پیشرفته رزرو آنلاین نوبت میباشد. اگر شما هم قصد طراحی یک سیستم رزرو آنلاین را دارید میتوانید برای اطلاعات بیشتر به صفحه&nbsp; <a href=\"../../dr-webdesign\">طراحی سایت پزشکی</a> مراجعه کنید.</p>\r\n<p>از امکانات مهم این وب سایت میتوان به سیستم پیشرفته رزرو آنلاین نوبت، مدیریت ظرفیت ها، نمایش جزئیات رزروی ها و پنل مدیریت پیشرفته اشاره کرد.</p>\r\n<p><img style=\"display: block; margin-left: auto; margin-right: auto;\" src=\"../../../images/portfolios/zibajooyan.jpg\" alt=\"\" width=\"700\" height=\"351\" /></p>','dr-ahmadi','طراحی سایت پزشکی , زیباجویان , دکتر خشایار احمدی','این طراحی سایت به صورت اختصاصی برای یکی از بهترین دکتر های عمل زیبایی در ایران طراحی شده است، این وب سایت دارای سیستم پیشرفته رزرو آنلاین نوبت میباشد. اگر شما هم قصد طراحی یک سیستم رزرو آنلاین را دارید میتوانید برای اطلاعات بیشتر به صفحه  طراحی سایت پزشکی مراجعه کنید.','2020-11-28 07:58:32','2022-09-03 16:03:00','نمونه کار طراحی سایت شرکتی','https://zibajooyan.com/',3,NULL,'a:5:{i:0;s:3:\"php\";i:1;s:7:\"laravel\";i:2;s:4:\"html\";i:3;s:3:\"css\";i:4;s:10:\"javascript\";}','100','1399/07/20','#6441a5',NULL,'/images/portfolios/ziba.jpg',1),
(31,'وب سایت 2 زبانه شرکت فاران','<p>این وب سایت به صورت دو زبانه برای شرکت نام آشنای فاران طراحی شده است و از امکانات بسیار خوبی برخوردار است. با استفاده از پنل مدیریت پیشرفته، امکان ویرایش صفحات و اضافه کردن صفحات جدید در هر زبان وجود دارد.</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">برخی خدمات انجام شده در این طراحی سایت:</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">طراحی ظاهر وب سایت و رابط کاربری</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">طراحی بنر</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">پیاده سازی سیستم 2 زبانه در سایت</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">پنل مدیریت پیشرفته</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; background-color: #ffffff;\"><img style=\"display: block; margin-left: auto; margin-right: auto;\" src=\"../../../images/portfolios/faran.jpg\" alt=\"\" width=\"700\" height=\"351\" /></p>','faran','طراحی سایت 2 زبانه','این وب سایت به صورت دو زبانه برای شرکت نام آشنای فاران طراحی شده است و از امکانات بسیار خوبی برخوردار است. با استفاده از پنل مدیریت پیشرفته، امکان ویرایش صفحات و اضافه کردن صفحات جدید در هر زبان وجود دارد.','2020-11-28 08:01:28','2023-05-02 13:53:50','وب سایت 2 زبانه شرکت فاران','#',7,'/images/portfolios/faran-logo.png','a:4:{i:0;s:4:\"html\";i:1;s:3:\"css\";i:2;s:10:\"javascript\";i:3;s:9:\"wordpress\";}','100','1399/08/17','#294e95',NULL,'/images/1611133274screencapture-faraneng-2021-01-20-12_30_01.jpg',1),
(32,'فروشگاه آنلاین چوب ایران','<p>فروشگاه آنلاین چوب ایران از نمونه های دیگر <a href=\"../../online-store-web-design\">طراحی سایت فروشگاهی</a> در کاراوب میباشد. این وب سایت دارای امکانات متعددی است که به تعدادی از آنها اشاره خواهیم کرد:</p>\r\n<ul>\r\n<li>طراحی سایت با وردپرس و ووکامرس</li>\r\n<li>ظاهر دلخواه</li>\r\n<li>صفحه ساز گرافیکی</li>\r\n<li>پنل مدیریت پیشرفته</li>\r\n<li>تعریف انواع صفحات</li>\r\n<li>تعریف منو و زیر منو دلخواه</li>\r\n<li>دامنه ir</li>\r\n<li>هاست یک گیگابایت یکساله رایگان</li>\r\n<li>وبلاگ</li>\r\n<li>نظردهی کاربران</li>\r\n<li>معرفی شبکه های اجتماعی</li>\r\n<li>تعریف انواع محصول</li>\r\n<li>جستجو پیشرفته</li>\r\n<li>دسته بندی ها</li>\r\n<li>پروفایل کاربری پیشرفته</li>\r\n<li>اتصال به درگاه بانکی</li>\r\n<li>روش های حمل و نقل</li>\r\n<li>کوپن تخفیف</li>\r\n<li>ریسپانسیو</li>\r\n<li>سئو استاندارد</li>\r\n<li>سپر امنیتی</li>\r\n<li>افزایش سرعت و کش</li>\r\n<li>آموزش ویدیویی پنل مدیر</li>\r\n<li>6ماه پشتیبانی رایگان</li>\r\n<li>ورود 10 محصول اولیه</li>\r\n</ul>\r\n<p><img style=\"display: block; margin-left: auto; margin-right: auto;\" src=\"../../../images/portfolios/choobiran.jpg\" alt=\"\" width=\"700\" height=\"351\" /></p>','choobiranshop','فروشگاه آنلاین چوب ایران','فروشگاه آنلاین چوب ایران از نمونه های دیگر طراحی سایت فروشگاهی در کاراوب میباشد. این وب سایت دارای امکانات متعددی است که به تعدادی از آنها اشاره خواهیم کرد:','2020-12-19 10:27:10','2022-09-09 06:46:06','فروشگاه آنلاین چوب ایران','http://choobiranshop.com/',11,'/images/portfolios/choobiran-logo.png','a:4:{i:0;s:4:\"html\";i:1;s:3:\"css\";i:2;s:10:\"javascript\";i:3;s:9:\"wordpress\";}','100','1399/9/29','#353535 , #036371',NULL,'/images/1611133098screencapture-choobiranshop-2021-01-20-12_27_03.jpg',1),
(33,'وب سایت 2 زبانه خرمای جلایر','<p>شرکت نخلستان جلایر در سال 1385 فعالیت خود را آغاز کرده است. بنیان گذار این شرکت، افتخار طراحی و توسعه ی وب سایت خود را بر عهده ی گروه کاراوب گذاشت و ما نهایت تلاش خود را در عالی تر اجرا شدن این پروژه انجام دادیم.</p>\r\n<p>این وب سایت به صورت دو زبانه برای شرکت خرمای جلایر طراحی شده است و از امکانات بسیار خوبی برخوردار است. با استفاده از پنل مدیریت پیشرفته، امکان ویرایش صفحات و اضافه کردن صفحات جدید در هر زبان وجود دارد.</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">برخی خدمات انجام شده در این طراحی سایت:</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">طراحی ظاهر وب سایت و رابط کاربری</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">طراحی بنر</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">پیاده سازی سیستم 2 زبانه در سایت</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">پنل مدیریت پیشرفته</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; background-color: #ffffff;\"><img style=\"display: block; margin-left: auto; margin-right: auto;\" src=\"../../../images/portfolios/jalayer.jpg\" alt=\"\" width=\"700\" height=\"354\" /></p>','jalayer','طراحی سایت 2 زبانه','این وب سایت به صورت دو زبانه برای شرکت خرمای جلایر طراحی شده است و از امکانات بسیار خوبی برخوردار است. با استفاده از پنل مدیریت پیشرفته، امکان ویرایش صفحات و اضافه کردن صفحات جدید در هر زبان وجود دارد.','2021-01-06 14:16:28','2023-05-02 13:53:56','وب سایت 2 زبانه خرمای جلایر','#',6,'/images/portfolios/jalayer-logo.png','a:4:{i:0;s:4:\"html\";i:1;s:3:\"css\";i:2;s:10:\"javascript\";i:3;s:9:\"wordpress\";}','100','1399/09/24','#f2ba66 , #211e1b',NULL,'/images/1611132983screencapture-jalayerdate-2021-01-20-12_22_36.jpg',1),
(34,'فروشگاه مشفق بی','<h3><span style=\"font-size: 14pt;\">شرح پروژه</span></h3>\r\n<p>فروشگاه مشفق بی فعال در زمینه ی فروش آنلاین آموزش و همچنین فروش آنلاین کالا های فیزیکی میباشد. این وب سایت دارای قابلیت چند فروشندگی (مارکت پلیس) است و با امکانات بسیار عالی پنل را در اختیار فروشندگان خود قرار میدهد.</p>\r\n<p>امکانات وب سایت مشفق بی:</p>\r\n<ul>\r\n<li>اجرای سایت با وردپرس</li>\r\n<li>سیستم چند فروشندگی</li>\r\n<li>ظاهر دلخواه</li>\r\n<li>صفحه ساز گرافیکی</li>\r\n<li>پنل مدیریت پیشرفته</li>\r\n<li>تعریف انواع صفحات</li>\r\n<li>تعریف منو و زیر منو دلخواه</li>\r\n<li>دامنه ir</li>\r\n<li>هاست یک گیگابایت یکساله رایگان</li>\r\n<li>وبلاگ</li>\r\n<li>نظردهی کاربران</li>\r\n<li>معرفی شبکه های اجتماعی</li>\r\n<li>تعریف انواع محصول</li>\r\n<li>جستجو پیشرفته</li>\r\n<li>دسته بندی ها</li>\r\n<li>پروفایل کاربری پیشرفته</li>\r\n<li>اتصال به درگاه بانکی</li>\r\n<li>روش های حمل و نقل</li>\r\n<li>کوپن تخفیف</li>\r\n<li>ریسپانسیو</li>\r\n<li>سئو استاندارد</li>\r\n<li>سپر امنیتی</li>\r\n<li>افزایش سرعت و کش</li>\r\n<li>آموزش ویدیویی پنل مدیر</li>\r\n<li>یکسال پشتیبانی رایگان</li>\r\n<li>ورود 10 محصول اولیه</li>\r\n<li>پنل پیامکی</li>\r\n<li>پاپ آپ</li>\r\n<li>پشتیبانی و چت آنلاین</li>\r\n<li>مقایسه محصولات</li>\r\n<li>دامنه&nbsp; com</li>\r\n<li>پشتیبانی و تیکتینگ محصول</li>\r\n<li>تعریف برند محصول</li>\r\n<li>نمایش وضعیت سفارش (مانند دیجیکالا)</li>\r\n</ul>\r\n<p>برای مشاهده دیگر نمونه کار های <a href=\"../../online-store-web-design\">طراحی سایت فروشگاهی</a> میتوانید به صفحه نمونه کار طراحی سایت مراجعه نمایید.</p>\r\n<p><img style=\"display: block; margin-left: auto; margin-right: auto;\" src=\"../../../images/portfolios/moshfegh.jpg\" alt=\"\" width=\"700\" height=\"351\" /></p>','moshfeghb','نمونه کار طراحی سایت فروشگاهی','فروشگاه مشفق بی فعال در زمینه ی فروش آنلاین آموزش و همچنین فروش آنلاین کالا های فیزیکی میباشد. این وب سایت دارای قابلیت چند فروشندگی (مارکت پلیس) است و با امکانات بسیار عالی پنل را در اختیار فروشندگان خود قرار میدهد.','2021-02-27 10:01:06','2021-06-20 01:55:44','فروشگاه مشفق بی | نمونه کار طراحی سایت فروشگاهی','http://moshfeghb.com',8,'/images/portfolios/moshfegh-logo.png','a:5:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";i:3;s:10:\"javascript\";i:4;s:9:\"wordpress\";}','100','1399/11/26','#004cd1 , #50d4ff',NULL,'/images/1614420066moshfegh.jpg',1),
(35,'فروشگاه میراکالا','<p>فروشگاه میراکالا فعال در زمینه ی فروش موبایل و لوازم جانبی موبایل، تبلت و... میباشد. طراحی ظاهری این فروشگاه به صورت کاملا اختصاصی انجام شده است. این وب سایت با استفاده از cms وردپرس طراحی شده است.&nbsp;</p>\r\n<p>خدمات انجام شده در این پروژه:</p>\r\n<p>طراحی رابط کاربری با استفاده از نرم افزار Figma</p>\r\n<p>پیاده سازی قالب با HTML و CSS</p>\r\n<p>تبدیل قالب HTML به قالب وردپرسی</p>\r\n<p>کد نویسی های مربوط به وردپرس</p>\r\n<p>&nbsp;</p>\r\n<p>برای مشاهده دیگر نمونه کار های&nbsp;<a href=\"../../online-store-web-design\">طراحی سایت فروشگاهی</a>&nbsp;میتوانید به صفحه نمونه کار طراحی سایت مراجعه نمایید.</p>\r\n<p><img style=\"display: block; margin-left: auto; margin-right: auto;\" src=\"../../../images/portfolios/mira.jpg\" alt=\"\" width=\"700\" height=\"354\" /></p>','mirakala','نمونه کار طراحی سایت فروشگاهی','فروشگاه میراکالا فعال در زمینه ی فروش موبایل و لوازم جانبی موبایل، تبلت و... میباشد. طراحی ظاهری این فروشگاه به صورت کاملا اختصاصی حتی با آیکون های اختصاصی طراحی شده است.','2021-02-27 10:05:23','2022-08-28 17:23:16','فروشگاه میراکالا | نمونه کار طراحی سایت فروشگاهی','https://mirakala.com',1,'/images/portfolios/logo-orange.png','a:7:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";i:3;s:10:\"javascript\";i:4;s:5:\"figma\";i:5;s:9:\"wordpress\";i:6;s:11:\"woocommerce\";}','100','1399/11/30','#ff7502 , #333',NULL,'/images/portfolios/1614420323mira.jpg',0),
(36,'وب سایت کلینیک دکتر عسگری','<p>کلینیک دکتر عسگری یک وب سایت سبک و کاآمد است که قابلیت های کامل&nbsp; یک وب سایت پزشکی را دارد</p>\r\n<p>برخی از امکانات این دسترسی را به شما میدهند تا به صورت آنلاین وقت رزرو کنید ، بر اساس روز، ساعت و دسته بندی دلخواه خودتون.</p>\r\n<p>برخی خدمات انجام شده در این پروژه:</p>\r\n<p>طراحی ظاهری قالب</p>\r\n<p>پیاده سازی با وردپرس</p>\r\n<p>طراحی سیستم رزرو آنلاین نوبت</p>\r\n<p>و...</p>\r\n<p><img style=\"display: block; margin-left: auto; margin-right: auto;\" src=\"../../../images/portfolios/drasgari.jpg\" alt=\"\" width=\"700\" height=\"351\" /></p>','drasgari','نمونه کار طراحی سایت پزشکی','وب سایت کلینیک دکتر عسگری در دسته بندی طراحی سایت پزشکی از نمونه های موفق کاراوب در این زمینه میباشد','2021-03-11 07:44:05','2021-06-20 01:56:15','وب سایت کلینیک دکتر عسگری | طراحی سایت پزشکی','http://www.drasgari4clinic.com',4,'/images/portfolios/drasgari-logo.png','a:5:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";i:3;s:9:\"wordpress\";i:4;s:11:\"woocommerce\";}','100','1399/12/20','#88b325 , #002d67 , #ff7b07',NULL,'/images/1615448645screencapture-drasgari4clinic-2021-03-11-10_55_45.jpg',1),
(37,'وب سایت 2 زبانه شرکت GPI','<p>شرکت گوهر پالایه ایرانیان با بیش از ۵۰ سال تجربه در زمینه تولید انواع فیلترهای صنعتی فعالیت دارد . گروه <a href=\"../../../\">طراحی سایت</a> کاراوب تمام تلاش خود را برای راه اندازی هرچه بهتر این پروژه انجام داده است. وب سایت gpi جزو وب سایت های شرکتی 2 زبانه طراحی شده در گروه کاراوب میباشند که با cms وردپرس پیاده سازی شده است.&nbsp;</p>\r\n<p>برخی خدمات انجام شده در این طراحی سایت:</p>\r\n<p>طراحی ظاهر وب سایت و رابط کاربری</p>\r\n<p>طراحی بنر</p>\r\n<p>پیاده سازی سیستم 2 زبانه در سایت</p>\r\n<p>پنل مدیریت پیشرفته</p>\r\n<p><img style=\"display: block; margin-left: auto; margin-right: auto;\" src=\"../../../images/portfolios/gpi.jpg\" alt=\"\" width=\"700\" height=\"351\" /></p>','gpi','وب سایت 2 زبانه شرکت GPI','شرکت گوهر پالایه ایرانیان با بیش از ۵۰ سال تجربه در زمینه تولید انواع فیلترهای صنعتی فعالیت دارد . گروه طراحی سایت کاراوب تمام تلاش خود را برای راه اندازی هرچه بهتر این پروژه انجام داده است. وب سایت gpi جزو وب سایت های شرکتی 2 زبانه طراحی شده در گروه کاراوب میباشند که با cms وردپرس پیاده سازی شده است.','2021-04-12 11:14:54','2023-05-03 13:29:11','وب سایت 2 زبانه شرکت GPI','http://gpi-filter.com/',5,'/images/portfolios/gpi-logo.png','a:4:{i:0;s:4:\"html\";i:1;s:3:\"css\";i:2;s:10:\"javascript\";i:3;s:9:\"wordpress\";}','100','1399/12/28','#044089 , #353535',NULL,'/images/1618226094screencapture-gpi-filter-2021-04-12-15_37_39.jpg',0),
(38,'وب سایت Nema Partners','<p>وب سایت Nema Advisoryیکی دیگر از فعالیت های بین المللی گروه طراحی سایت کاراوب میباشد. به دلیل مخاطبان این وب سایت، زبان اصلی آن انگلیسی میباشد.</p>\r\n<p>یک وب سایت ساده و شیک برای معرفی خدمات شرکت Nema Advisory طراحی شده تا به بهترین شکل ممکن خدمات را به کاربران ارائه دهد.</p>\r\n<p><img style=\"display: block; margin-left: auto; margin-right: auto;\" src=\"../../../images/portfolios/nema-advisory.jpg\" alt=\"\" width=\"700\" height=\"351\" /></p>','nema','وب سایت Nema Partners','وب سایت Nema Advisoryیکی دیگر از فعالیت های بین المللی گروه طراحی سایت کاراوب میباشد. به دلیل مخاطبان این وب سایت، زبان اصلی آن انگلیسی میباشد.','2021-04-12 11:16:20','2021-06-20 02:04:45','وب سایت Nema Partners','https://nema-advisory.com/',12,'/images/portfolios/NEMA-Advisory-logo-2.png','a:3:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";}','100','1400/1/23','#0065c9 , #00070d',NULL,'/images/1618226180screencapture-nema-partners-2021-04-12-15_34_50.jpg',1),
(39,'داروخانه آنلاین دکتر مشتاقی','<p>داروخانه دکتر مشتاقی واقع در تهران، تهرانپارس فعالیت آنلاین خود را از فروردین ماه 1400 آغاز کرد، این وب به صورت فروشگاهی طراحی شده و امکانات کامل یک وب ساتی فروشگاهی را دارد.&nbsp;</p>\r\n<p>برخی خدمات انجام شده در این پروژه:</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">طراحی رابط کاربری با استفاده از نرم افزار Figma</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">پیاده سازی قالب با HTML و CSS</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">تبدیل قالب HTML به قالب وردپرسی</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">کد نویسی های مربوط به وردپرس</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">برای مشاهده دیگر نمونه کار های&nbsp;<a style=\"box-sizing: border-box; color: #007bff; text-decoration-line: none; background-color: transparent; margin: 0px; padding: 0px; border: 0px; font: inherit; vertical-align: baseline;\" href=\"../../../online-store-web-design\">طراحی سایت فروشگاهی</a>&nbsp;میتوانید به صفحه نمونه کار طراحی سایت مراجعه نمایید.</p>\r\n<p><img style=\"display: block; margin-left: auto; margin-right: auto;\" src=\"../../../images/portfolios/moshtaqi.jpg\" alt=\"\" width=\"700\" height=\"354\" /></p>','moahtaqi-online','داروخانه آنلاین دکتر مشتاقی','داروخانه دکتر مشتاقی واقع در تهران، تهرانپارس فعالیت آنلاین خود را از فروردین ماه 1400 آغاز کرد، این وب به صورت فروشگاهی طراحی شده و امکانات کامل یک وب ساتی فروشگاهی را دارد.','2021-04-27 10:21:24','2022-08-28 17:22:00','داروخانه آنلاین دکتر مشتاقی','https://moshtaqionline.com/',2,'/images/portfolios/logo-moshtaqi.png','a:7:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";i:3;s:10:\"javascript\";i:4;s:5:\"figma\";i:5;s:9:\"wordpress\";i:6;s:11:\"woocommerce\";}','100','1400/02/25','#1a3f6f , #ff7f00',NULL,'/images/1619518884moshtaqi.jpg',0),
(41,'شرکت کارگو پارس','<p style=\"text-align: justify;\">شرکت کارگوپارس فعالیت خود را در زمینه حمل و نقل کالا از سال 1396 آغاز نمود. این شرکت با استفاده از امکانات فراوان در زمینه حمل و نقل و کارکنان با تجربه سرویس های مطمئن و سریعی را در زمینه های مختلف به مشتریان خود ارائه میدهد.. شرکت در طول مدت فعالیت خود توانسته است خدمات شایانی را به تجار، &nbsp;صادرکنندگان و واردکنندگان عرضه نماید.</p>\r\n<p style=\"text-align: justify;\">گروه طراحی سایت کاراوب افتخار طراحی سایت این مجموعه ی بزرگ را داشته و نهایت تلاش خود را در اجرای هر چه بهتر این پروژه انجام داده.</p>\r\n<p style=\"text-align: justify;\">این وب سایت به علت داشتن بازدید های بین المللی به صورت 2 زبانه فارسی و انگلیسی طراحی شده است.</p>\r\n<p style=\"text-align: justify;\">برخی امکانات سایت کارگو پارس:&nbsp;</p>\r\n<p style=\"text-align: justify;\">پنل مدیریت پیشرفته</p>\r\n<p style=\"text-align: justify;\">سیستم 2 زبانه</p>\r\n<p style=\"text-align: justify;\">سیستم فرم تماس</p>\r\n<p style=\"text-align: justify;\">بخش نمونه کار ها</p>\r\n<p style=\"text-align: justify;\">وبلاگ</p>\r\n<p style=\"text-align: justify;\">صفحه ساز گرافیکی</p>\r\n<p style=\"text-align: justify;\">ایجاد سیستم دسترسی</p>\r\n<p style=\"text-align: justify;\">و...</p>\r\n<p style=\"text-align: justify;\"><img src=\"../../images/portfolios/cargo-content.jpg\" alt=\"\" width=\"700\" height=\"354\" /></p>','cargopars','کارگو پارس , شرکت کارگو پارس','گروه طراحی سایت کاراوب افتخار طراحی سایت این مجموعه ی بزرگ را داشته و نهایت تلاش خود را در اجرای هر چه بهتر این پروژه انجام داده.','2021-06-23 06:59:53','2023-01-17 09:05:17','شرکت کارگو پارس | نمونه کار طراحی سایت','http://www.cargopars.com/',2,'https://karawebs.com/images/portfolios/cargo-logo.png','a:5:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";i:3;s:10:\"javascript\";i:4;s:9:\"wordpress\";}','100','1400/02/25','#023954 , #bf1e2d',NULL,'https://karawebs.com/images/portfolios/cargo.jpg',1),
(42,'کلینیک زیبایی دکتر عسگری','<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">کلینیک زیبایی دکتر عسگری یک وب سایت سبک و کارآمد است که قابلیت های کامل&nbsp; یک وب سایت پزشکی را دارد</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">برخی از امکانات این دسترسی را به شما میدهند تا به صورت آنلاین وقت رزرو کنید ، بر اساس روز، ساعت و دسته بندی دلخواه خودتون.</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">برخی خدمات انجام شده در این پروژه:</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">طراحی ظاهری قالب</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">پیاده سازی با وردپرس</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">طراحی سیستم رزرو آنلاین نوبت</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">و...</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\"><img src=\"../../images/portfolios/ideal-content.jpg\" alt=\"\" width=\"700\" height=\"354\" /></p>','idealskin','دکتر عسگری  , کلینیک زیبایی','کلینیک زیبایی دکتر عسگری یک وب سایت سبک و کارآمد است که قابلیت های کامل  یک وب سایت پزشکی را دارد','2021-06-23 07:05:25','2023-01-17 09:05:56','کلینیک زیبایی دکتر عسگری | نمونه کار طراحی سایت','https://idealskin.ir/',3,'https://karawebs.com/images/portfolios/ideal-logo.png','a:5:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";i:3;s:10:\"javascript\";i:4;s:9:\"wordpress\";}','100','1400/02/31','#629cff',NULL,'/images/portfolios/idealskin.jpg',1),
(43,'فروشگاه بوردِکس','<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">فروشگاه آنلاین بوردِکس فعالیت آنلاین خود را از فروردین ماه 1400 آغاز کرد، این وب به صورت فروشگاهی طراحی شده و امکانات کامل یک وب ساتی فروشگاهی را دارد.&nbsp;</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">برخی خدمات انجام شده در این پروژه:</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">طراحی رابط کاربری با استفاده از نرم افزار Figma</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">پیاده سازی قالب با HTML و CSS</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">تبدیل قالب HTML به قالب وردپرسی</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">کد نویسی های مربوط به وردپرس</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: \'Yekan Bakh\'; vertical-align: baseline; color: #8e939b; text-align: justify; background-color: #ffffff;\">برای مشاهده دیگر نمونه کار های&nbsp;<a style=\"box-sizing: border-box; color: #007bff; text-decoration-line: none; background-color: transparent; margin: 0px; padding: 0px; border: 0px; font: inherit; vertical-align: baseline;\" href=\"../../online-store-web-design\">طراحی سایت فروشگاهی</a> میتوانید به صفحه نمونه کار طراحی سایت مراجعه نمایید.</p>','boardex','بوردِکس , بوردکس ایران','فروشگاه آنلاین بوردِکس فعالیت آنلاین خود را از فروردین ماه 1400 آغاز کرد، این وب به صورت فروشگاهی طراحی شده و امکانات کامل یک وب ساتی فروشگاهی را دارد.','2021-07-13 12:27:54','2023-05-20 10:56:39','فروشگاه بوردِکس | نمونه کار','#',0,'https://karawebs.com/images/portfolios/boardex_logo.png','a:6:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";i:3;s:5:\"figma\";i:4;s:9:\"wordpress\";i:5;s:11:\"woocommerce\";}','100','1400/04/05','#e1962f , #333333',NULL,'https://karawebs.com/images/portfolios/boardex.jpg',0),
(44,'کلینیک زیبایی ideal skin','<p>طراحی و اجرای لندینگ پیج برای کلینیک ideal skin</p>','ideal2','کلینیک زیبایی ideal skin','طراحی و اجرای لندینگ پیج برای کلینیک ideal skin. گروه طراحی سایت کاراوب طراح و مجری این پروژه میباشد','2022-09-03 16:12:13','2023-01-17 09:06:02','کلینیک زیبایی ideal skin','https://idealskinbeauty.com/',4,NULL,'a:4:{i:0;s:4:\"html\";i:1;s:3:\"css\";i:2;s:5:\"figma\";i:3;s:9:\"wordpress\";}',NULL,NULL,'#7ab2fa',NULL,'/images/portfolios/idealskin2.jpg',1),
(45,'شرکت پترو پالایش بهراد','<p>طراحی و اجرای پروژه طراحی سایت شرکتی لاراول به صورت اختصاصی و با زبان php و فریمورک لاراول انجام شده است. صفر تا صد پروژه از طراحی رابط کاربری تا اجرای بک اند توسط تیم مجرب گروه طراحی سایت کاراوب انجام شده است</p>','ppb','شرکت پترو پالایش بهراد','طراحی و اجرای پروژه طراحی سایت شرکتی لاراول به صورت اختصاصی و با زبان php و فریمورک لاراول انجام شده است. صفر تا صد پروژه از طراحی رابط کاربری تا اجرای بک اند توسط تیم مجرب گروه طراحی سایت کاراوب انجام شده است','2022-09-03 16:20:15','2023-05-20 11:08:10','شرکت پترو پالایش بهراد','#',1,'/images/portfolios/ppb.png','a:6:{i:0;s:3:\"php\";i:1;s:7:\"laravel\";i:2;s:4:\"html\";i:3;s:3:\"css\";i:4;s:10:\"javascript\";i:5;s:5:\"figma\";}',NULL,NULL,'#ff9c00',NULL,'/images/portfolios/petrobehrad.jpg',1),
(46,'فروشگاه دنیای آی سی','<p>طراحی و اجرای پروژه طراحی سایت فروشگاهی لاراول به صورت اختصاصی و با زبان php و فریمورک لاراول انجام شده است. صفر تا صد پروژه از طراحی رابط کاربری تا اجرای بک اند توسط تیم مجرب گروه طراحی سایت کاراوب انجام شده است</p>','icworld','وب سایت فروشگاهی دنیای آی سی','طراحی و اجرای پروژه طراحی سایت فروشگاهی لاراول به صورت اختصاصی و با زبان php و فریمورک لاراول انجام شده است. صفر تا صد پروژه از طراحی رابط کاربری تا اجرای بک اند توسط تیم مجرب گروه طراحی سایت کاراوب انجام شده است','2022-09-03 16:24:02','2022-09-03 16:24:20','وب سایت فروشگاهی دنیای آی سی','http://icworldco.com',0,NULL,'a:6:{i:0;s:3:\"php\";i:1;s:7:\"laravel\";i:2;s:4:\"html\";i:3;s:3:\"css\";i:4;s:10:\"javascript\";i:5;s:5:\"figma\";}',NULL,NULL,'#ff0052',NULL,'/images/portfolios/ic.jpg',1),
(47,'فروشگاه امیر پلاسکو','<p>فروشگاه امیر پلاسکو فعال در فروش ظروف یکبار مصرف به صورت آنلاین میباشد، طراحی صفر تا 100 این فروشگاه توسط تیم متخصص کاراوب انجام شده است</p>','amirplasco','نمونه کار طراحی سایت','فروشگاه امیر پلاسکو فعال در فروش ظروف یکبار مصرف به صورت آنلاین میباشد، طراحی صفر تا 100 این فروشگاه توسط تیم متخصص کاراوب انجام شده است','2023-01-17 09:04:15','2023-01-17 09:28:36','سایت فروشگاهی امیر پلاسکو','https://amirplasco.com/',3,'/images/portfolios/amir-plasco-logo.png','a:5:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:10:\"javascript\";i:3;s:9:\"wordpress\";i:4;s:11:\"woocommerce\";}','100','1401/08/01','#cf2e2e',NULL,'/images/portfolios/amirplasco.jpg',1),
(48,'آژانس گردشگری جهانجا','<p>آژانس گردشگری جهانجا</p>','jahanja',NULL,'آژانس گردشگری جهانجا','2023-01-17 09:21:33','2023-02-05 17:20:55','آژانس گردشگری جهانجا | نمونه کار طراحی سایت','https://jahanja.com',2,'/images/portfolios/logo-jahanja.png','a:4:{i:0;s:4:\"html\";i:1;s:3:\"css\";i:2;s:9:\"wordpress\";i:3;s:11:\"woocommerce\";}','100','1401/09/01','#7ab2fa',NULL,'/images/jahanja.jpg',0),
(49,'شرکت TKA','<p>وب سایت این شرکت به صورت زبان انگلیسی و چپ چین میباشد، این وب سایت از صفر تا صد به دست گروه کاراوب انجام شده است</p>','tka',NULL,'وب سایت این شرکت به صورت زبان انگلیسی و چپ چین میباشد، این وب سایت از صفر تا صد به دست گروه کاراوب انجام شده است','2023-01-17 09:27:47','2023-01-17 09:27:47','شرکت TKA','https://tkainspection.com/',1,'/images/portfolios/logo-tka.jpg','a:5:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";i:3;s:10:\"javascript\";i:4;s:9:\"wordpress\";}','100','1401/09/18','#2874a6',NULL,'/images/portfolios/tka.jpg',1),
(50,'پت شاپ وکو پت','<p>این وب سایت فروشگاهی برای یک فروشگاه ملزومات حیوانات خانگی طراحی شده. روند طراحی این وب سایت فروشگاهی بسیار حرفه ای بوده است. طرح ابتدا روی فیگما پیاده سازی شده، بعد این طرح به کد در آمده و در وردپرس پیاده سازی شده است</p>','vokopet','نمونه کار طراحی سایت','این وب سایت فروشگاهی برای یک فروشگاه ملزومات حیوانات خانگی طراحی شده. روند طراحی این وب سایت فروشگاهی بسیار حرفه ای بوده است. طرح ابتدا روی فیگما پیاده سازی شده، بعد این طرح به کد در آمده و در وردپرس پیاده سازی شده است','2023-02-06 08:24:52','2023-05-02 13:41:12','پت شاپ وکو پت | نمونه کار طراحی سایت فروشگاهی','https://vokopet.com/',2,'/images/portfolios/logovoko.png','a:7:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";i:3;s:10:\"javascript\";i:4;s:5:\"figma\";i:5;s:9:\"wordpress\";i:6;s:11:\"woocommerce\";}','100','1401/11/15','#FEBF00',NULL,'/images/portfolios/voko.jpg',1),
(51,'وب سایت دکتر نجم آبادی','<p>وب سایت شخصی دکتر نجم آبادی</p>','drnajmabadi','نمونه کار طراحی سایت','وب سایت شخصی دکتر نجم آبادی','2023-02-06 09:05:41','2023-02-06 09:05:41','وب سایت دکتر نجم آبادی','http://drnajmabadi.ir/',1,'/images/portfolios/logo-t.png','a:5:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";i:3;s:10:\"javascript\";i:4;s:9:\"wordpress\";}','100','1401/11/10','#0F406E',NULL,'/images/portfolios/drnajmabadi.jpg',1),
(52,'وب سایت شرکتی کیهان کانتین','<p>این وب سایت با استفاده از وردپرس طراحی شده و یکی از نمونه کار های خوب در این زمینه میباشد</p>','ob-sayt-shrkty-kyhan-kantyn','نمونه کار طراحی سایت','این وب سایت با استفاده از وردپرس طراحی شده و یکی از نمونه کار های خوب در این زمینه میباشد','2023-05-02 13:39:31','2023-05-02 13:41:30','وب سایت شرکتی کیهان کانتین','http://keyhancontain.com/',0,'/images/keyhan-logo.png','a:6:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";i:3;s:10:\"javascript\";i:4;s:5:\"figma\";i:5;s:11:\"woocommerce\";}','100','1401/12/08','#7ab2fa',NULL,'/images/keyhan.jpg',1),
(53,'سایت فروشگاه آیزل مارکت','<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: KalamehWebFaNum; font-optical-sizing: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; vertical-align: baseline; color: #8e939b; background-color: #ffffff;\">فروشگاه آیزل مارکت فعال در زمینه ی پوشاک میباشد. طراحی ظاهری این فروشگاه به صورت کاملا اختصاصی انجام شده است. این وب سایت با استفاده از cms وردپرس طراحی شده است. </p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: KalamehWebFaNum; font-optical-sizing: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; vertical-align: baseline; color: #8e939b; background-color: #ffffff;\">خدمات انجام شده در این پروژه:</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: KalamehWebFaNum; font-optical-sizing: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; vertical-align: baseline; color: #8e939b; background-color: #ffffff;\">طراحی رابط کاربری با استفاده از نرم افزار Figma</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: KalamehWebFaNum; font-optical-sizing: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; vertical-align: baseline; color: #8e939b; background-color: #ffffff;\">پیاده سازی قالب با HTML و CSS</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: KalamehWebFaNum; font-optical-sizing: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; vertical-align: baseline; color: #8e939b; background-color: #ffffff;\">تبدیل قالب HTML به قالب وردپرسی</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: KalamehWebFaNum; font-optical-sizing: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; vertical-align: baseline; color: #8e939b; background-color: #ffffff;\">کد نویسی های مربوط به وردپرس</p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: KalamehWebFaNum; font-optical-sizing: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; vertical-align: baseline; color: #8e939b; background-color: #ffffff;\"> </p>\r\n<p style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-stretch: inherit; font-size: 1.2rem; line-height: 2; font-family: KalamehWebFaNum; font-optical-sizing: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; vertical-align: baseline; color: #8e939b; background-color: #ffffff;\">برای مشاهده دیگر نمونه کار های <a style=\"box-sizing: border-box; color: #007bff; text-decoration-line: none; background-color: transparent; margin: 0px; padding: 0px; border: 0px; font: inherit; vertical-align: baseline;\" href=\"../../online-store-web-design\">طراحی سایت فروشگاهی</a> میتوانید به صفحه نمونه کار طراحی سایت مراجعه نمایید.</p>','sayt-froshgah-ayzl-markt','نمونه کار طراحی سایت','فروشگاه آیزل مارکت فعال در زمینه ی پوشاک میباشد. طراحی ظاهری این فروشگاه به صورت کاملا اختصاصی انجام شده است. این وب سایت با استفاده از cms وردپرس طراحی شده است.','2023-05-02 13:47:25','2023-11-27 09:44:10','سایت فروشگاه آیزل مارکت','https://izelmarket.ir/',0,'/images/izel-logo.png','a:5:{i:0;s:4:\"html\";i:1;s:3:\"css\";i:2;s:5:\"figma\";i:3;s:9:\"wordpress\";i:4;s:11:\"woocommerce\";}','100','1401/12/24','#7ab2fa',NULL,'/images/izel.jpg',0),
(54,'وب سایت پزشکی دکتر مینا نجم آبادی','<p><span style=\"color: #8e939b; font-size: 19.2px; background-color: #ffffff;\">این وب سایت با استفاده از وردپرس طراحی شده و یکی از نمونه کار های خوب در این زمینه میباشد</span></p>','ob-sayt-bzshky-dktr-myna-ngm-abady','نمونه کار طراحی سایت','این وب سایت با استفاده از وردپرس طراحی شده و یکی از نمونه کار های خوب در این زمینه میباشد','2023-05-20 11:02:19','2023-05-20 11:02:19','وب سایت پزشکی دکتر مینا نجم آبادی','https://drminanajmabadi.com/',2,'/images/portfolios/mina-logo.png','a:6:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";i:3;s:10:\"javascript\";i:4;s:5:\"figma\";i:5;s:9:\"wordpress\";}','100','1401/09/18','#7ab2fa',NULL,'/images/portfolios/minanajmabadi.jpg',1),
(55,'وب سایت شرکت PNS Pouya','<p><span style=\"color: #8e939b; font-size: 19.2px; background-color: #ffffff;\">این وب سایت با استفاده از وردپرس طراحی شده و یکی از نمونه کار های خوب در این زمینه میباشد</span></p>','ob-sayt-shrkt-pns-pouya','نمونه کار طراحی سایت','این وب سایت با استفاده از وردپرس طراحی شده و یکی از نمونه کار های خوب در این زمینه میباشد','2023-05-20 11:05:16','2023-05-20 11:05:16','وب سایت شرکت PNS Pouya','https://pnspouya.com/',1,'/images/portfolios/pns-logo.png','a:5:{i:0;s:4:\"html\";i:1;s:3:\"css\";i:2;s:10:\"javascript\";i:3;s:9:\"wordpress\";i:4;s:11:\"woocommerce\";}','100','1401/09/18','#7ab2fa',NULL,'/images/portfolios/pns-pouya.jpg',1),
(56,'وب سایت Smart Gamers','<p>این وب سایت با استفاده از وردپرس طراحی شده و یکی از نمونه کار های خوب در این زمینه میباشد</p>','ob-sayt-smart-gamers','نمونه کار طراحی سایت','این وب سایت با استفاده از وردپرس طراحی شده و یکی از نمونه کار های خوب در این زمینه میباشد','2023-05-20 11:12:10','2023-05-20 11:12:10','وب سایت Smart Gamers','https://smartgamers.net/',1,'/images/portfolios/smartgamers.jpg','a:6:{i:0;s:4:\"html\";i:1;s:3:\"css\";i:2;s:10:\"javascript\";i:3;s:5:\"figma\";i:4;s:9:\"wordpress\";i:5;s:11:\"woocommerce\";}','100','1402/02/18','#7ab2fa',NULL,'/images/portfolios/smartgamers.jpg',1),
(57,'وب سایت 2 زبانه شرکت جلوه نما','<p>این وب سایت با استفاده از وردپرس طراحی شده و یکی از نمونه کار های خوب در این زمینه میباشد</p>','ob-sayt-2-zbanh-shrkt-gloh-nma','نمونه کار طراحی سایت','این وب سایت با استفاده از وردپرس طراحی شده و یکی از نمونه کار های خوب در این زمینه میباشد','2023-05-20 11:41:05','2023-05-20 11:41:05','وب سایت 2 زبانه شرکت جلوه نما','https://jelvehnamaaria.com/',1,'/images/portfolios/jelve-logo.png','a:5:{i:0;s:4:\"html\";i:1;s:3:\"css\";i:2;s:10:\"javascript\";i:3;s:5:\"figma\";i:4;s:9:\"wordpress\";}','100','1401/02/18','#7ab2fa',NULL,'/images/portfolios/jelve.jpg',1),
(58,'وب سایت آپکو سنتر','<p>این وب سایت با استفاده از وردپرس طراحی شده و یکی از نمونه کار های خوب در این زمینه میباشد</p>','ob-sayt-abko-sntr','نمونه کار طراحی سایت','این وب سایت با استفاده از وردپرس طراحی شده و یکی از نمونه کار های خوب در این زمینه میباشد','2023-05-20 11:43:54','2023-05-20 11:43:54','وب سایت آپکو سنتر','https://apcocenter.com/',1,'/','a:6:{i:0;s:4:\"html\";i:1;s:3:\"css\";i:2;s:10:\"javascript\";i:3;s:5:\"figma\";i:4;s:9:\"wordpress\";i:5;s:11:\"woocommerce\";}','100','1401/11/18','#23272d',NULL,'/images/portfolios/apco.jpg',1),
(59,'سایت شرکتی همراه ماکان','<p>وب سایت همراه ماکان از صفر تا صد به صورت اختصاصی و با استفاده از وردپرس طراحی شده است، این وب سایت به 2 بخش شرکتی و فروشگاهی تقسیم میشود</p>','sayt-shrkty-hmrah-makan','نمونه کار طراحی سایت','وب سایت همراه ماکان از صفر تا صد به صورت اختصاصی و با استفاده از وردپرس طراحی شده است، این وب سایت به 2 بخش شرکتی و فروشگاهی تقسیم میشود','2023-06-14 07:45:34','2023-06-14 07:45:34','سایت شرکتی همراه ماکان','http://hamrahmacan.com/',0,NULL,'a:7:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";i:3;s:10:\"javascript\";i:4;s:5:\"figma\";i:5;s:9:\"wordpress\";i:6;s:11:\"woocommerce\";}','100','1402/02/18','#484a4d',NULL,'/images/portfolios/screencapture-hamrahmacan-2023-06-14-11_07_05.jpg',1),
(60,'سایت فروشگاهی همراه ماکان','<p>وب سایت همراه ماکان از صفر تا صد به صورت اختصاصی و با استفاده از وردپرس طراحی شده است، این وب سایت به 2 بخش شرکتی و فروشگاهی تقسیم میشود</p>','sayt-froshgahy-hmrah-makan','نمونه کار طراحی سایت','وب سایت همراه ماکان از صفر تا صد به صورت اختصاصی و با استفاده از وردپرس طراحی شده است، این وب سایت به 2 بخش شرکتی و فروشگاهی تقسیم میشود','2023-06-14 07:48:32','2023-06-14 07:48:32','سایت فروشگاهی همراه ماکان','https://hamrahmacan.com/',0,NULL,'a:7:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";i:3;s:10:\"javascript\";i:4;s:5:\"figma\";i:5;s:9:\"wordpress\";i:6;s:11:\"woocommerce\";}','100','1402/02/18','#7ab2fa',NULL,'/images/portfolios/screencapture-hamrahmacan-wp-admin-post-php-2023-06-14-11_12_05.jpg',1),
(61,'فروشگاه حجاب ایران','<p>این فروشگاه به صورت اختصاصی از صفر تا 100 توسط کاراوبز طراحی شده</p>','froshgah-hgab-ayran','نمونه کار طراحی سایت','این فروشگاه به صورت اختصاصی از صفر تا 100 توسط کاراوبز طراحی شده','2023-06-14 07:52:38','2023-06-14 07:52:38','فروشگاه حجاب ایران','https://hejabirshop.com/',0,NULL,'a:7:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";i:3;s:10:\"javascript\";i:4;s:5:\"figma\";i:5;s:9:\"wordpress\";i:6;s:11:\"woocommerce\";}','100','1401/012/18','#7ab2fa',NULL,'/images/portfolios/screencapture-hejabirshop-2023-06-14-11_19_17.jpg',1),
(62,'سفارش آنلاین غذا - Topolie','<p>این وب سایت برای یک رستوران واقع در فرانسه طراحی شده که یک منوی آنلاین غذای رستوران میباشد.</p>','sfarsh-anlayn-ghtha-topolie','نمونه کار طراحی سایت','این وب سایت برای یک رستوران واقع در فرانسه طراحی شده که یک منوی آنلاین غذای رستوران میباشد.','2023-06-14 07:55:53','2023-06-14 07:55:53','سفارش آنلاین غذا - Topolie','https://topolie.fr/',0,NULL,'a:7:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";i:3;s:10:\"javascript\";i:4;s:5:\"figma\";i:5;s:9:\"wordpress\";i:6;s:11:\"woocommerce\";}','100','1402/03/18','#7ab2fa',NULL,'/images/portfolios/screencapture-topolie-fr-2023-06-14-11_23_36.png',1),
(63,'سالن زیبایی مهتاب براتی','<p>وب سایت سالن زیبایی مهتاب براتی</p>','saln-zybayy-mhtab-braty','نمونه کار طراحی سایت','وب سایت سالن زیبایی مهتاب براتی','2023-12-23 09:26:12','2023-12-23 09:26:12','طراحی سایت سالن زیبایی مهتاب براتی','https://mahtabbarati.com/',0,'/images/screencapture-mahtabbarati-2023-12-23-12_50_15.jpg','a:7:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";i:3;s:10:\"javascript\";i:4;s:5:\"figma\";i:5;s:9:\"wordpress\";i:6;s:11:\"woocommerce\";}','100','1402/08/20','#7ab2fa','Article','/images/screencapture-mahtabbarati-2023-12-23-12_50_15.jpg',1),
(64,'فروشگاه آوا وینا','<p>فروشگاه آوا وینا</p>','froshgah-aoa-oyna','نمونه کار طراحی سایت','فروشگاه آوا وینا','2023-12-23 09:27:55','2023-12-23 09:27:55','سایت فروشگاه آوا وینا','https://avavina.com/',-5,'/images/screencapture-avavina-2023-12-23-12_49_36.jpg','a:7:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";i:3;s:10:\"javascript\";i:4;s:5:\"figma\";i:5;s:9:\"wordpress\";i:6;s:11:\"woocommerce\";}','100','1402/09/21','#7ab2fa','Article','/images/screencapture-avavina-2023-12-23-12_49_36.jpg',1),
(65,'فروشگاه آقای یدک','<p>فروشگاه آقای یدک</p>','froshgah-akay-ydk','نمونه کار طراحی سایت','فروشگاه آقای یدک','2023-12-23 09:29:24','2023-12-23 09:29:24','سایت فروشگاه آقای یدک','https://aqayeyadak.com/',-4,'/images/screencapture-aqayeyadak-2023-12-23-12_50_05.jpg','a:6:{i:0;s:3:\"php\";i:1;s:4:\"html\";i:2;s:3:\"css\";i:3;s:10:\"javascript\";i:4;s:9:\"wordpress\";i:5;s:11:\"woocommerce\";}','100','1402/09/20','#7ab2fa','Article','/images/screencapture-aqayeyadak-2023-12-23-12_50_05.jpg',1);
/*!40000 ALTER TABLE `portfolios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `body` longtext NOT NULL,
  `meta_title` varchar(255) DEFAULT NULL,
  `meta_description` text DEFAULT NULL,
  `meta_keywords` varchar(255) DEFAULT NULL,
  `meta_type` varchar(255) DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `rating_count` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `posts_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` (`id`, `title`, `body`, `meta_title`, `meta_description`, `meta_keywords`, `meta_type`, `status`, `created_at`, `updated_at`, `image`, `slug`, `rating_count`) VALUES (19,'بازاریابی لحظه‌ای','<h2 style=\"text-align: justify;\">مقدمه</h2>\r\n<p style=\"text-align: justify;\">در عصر دیجیتال، تغییرات در رفتار و انتظارات مشتریان به&zwnj;طور پیوسته و لحظه&zwnj;ای رخ می&zwnj;دهد. این تحولات سریع، برندها را به سمت استفاده از روش&zwnj;های نوینی در بازاریابی سوق داده است تا بتوانند به سرعت و در زمان مناسب به نیازها و خواسته&zwnj;های مشتریان پاسخ دهند. یکی از این روش&zwnj;ها، بازاریابی لحظه&zwnj;ای است که با بهره&zwnj;گیری از داده&zwnj;ها و اطلاعات بلادرنگ، پیام&zwnj;های تبلیغاتی را دقیقاً در لحظاتی که مخاطب به آن&zwnj;ها نیاز دارد یا آماده دریافت است، ارسال می&zwnj;کند. این مقاله به بررسی بازاریابی لحظه&zwnj;ای، تفاوت&zwnj;های آن با بازاریابی سنتی، نقش داده&zwnj;های بلادرنگ، مراحل اجرایی، نمونه&zwnj;های موفق، مزایا و معایب و همچنین استراتژی&zwnj;های خلاقانه در این حوزه می&zwnj;پردازیم و اهمیت این رویکرد در تعاملات مشتری&zwnj;محور را مورد توجه قرار می&zwnj;دهد.</p>\r\n<p style=\"text-align: justify;\"><strong>&nbsp;</strong></p>\r\n<h2 style=\"text-align: justify;\"><strong>تعریف</strong><strong>&nbsp;و اهمیت آن در عصر دیجیتال</strong></h2>\r\n<p style=\"text-align: justify;\"><span style=\"background-color: #bfedd2;\">بازاریابی لحظه&zwnj;ای به معنای استفاده از فرصت&zwnj;های آنی برای برقراری ارتباط موثر با مشتریان است.</span> این رویکرد بر اساس نیازهای فوری و آنی مشتریان عمل می&zwnj;کند و از تکنولوژی&zwnj;های دیجیتال برای ایجاد ارتباطات بلادرنگ و تعاملات پویا بهره می&zwnj;گیرد. در این روش، برندها قادرند به سرعت و در زمان مناسب به مخاطبان خود پاسخ دهند، که به ایجاد تجربه کاربری بهتر و افزایش وفاداری مشتریان کمک می&zwnj;کند.</p>\r\n<p style=\"text-align: justify;\">با افزایش رقابت در بازارهای دیجیتال، بازاریابی لحظه&zwnj;ای به یک نیاز اساسی برای برندها تبدیل شده است. این نوع بازاریابی، برندها را قادر می&zwnj;سازد تا به&zwnj;جای برنامه&zwnj;ریزی&zwnj;های طولانی&zwnj;مدت، با انعطاف&zwnj;پذیری به تغییرات سریع رفتار مصرف&zwnj;کننده پاسخ دهند. مشتریان امروز توقع دارند که نیازها و خواسته&zwnj;هایشان به&zwnj;سرعت شناسایی شده و پاسخ داده شود، و برندهایی که این انتظارات را برآورده کنند، به&zwnj;سرعت محبوبیت و وفاداری مشتریان را به&zwnj;دست می&zwnj;آورند.</p>\r\n<p style=\"text-align: justify;\">همچنین، بازاریابی لحظه&zwnj;ای در ارتقای تجربه مشتری نقش مهمی دارد. از آنجا که این رویکرد به&zwnj;طور مستقیم به نیازها و تمایلات فردی پاسخ می&zwnj;دهد، به مشتریان حس ارزشمندی می&zwnj;بخشد و تجربه&zwnj;ای منحصر&zwnj;به&zwnj;فرد و شخصی&zwnj;سازی&zwnj;شده ایجاد می&zwnj;کند. این تجربه شخصی&zwnj;سازی&zwnj;شده به بهبود رضایت و حفظ مشتریان کمک کرده و به برندها امکان می&zwnj;دهد تا ارتباط عمیق&zwnj;تر و پایدارتری با مشتریان برقرار کنند.</p>\r\n<p>&nbsp;</p>\r\n<h2 style=\"text-align: justify;\"><strong>تفاوت بازاریابی لحظه&zwnj;ای با بازاریابی سنتی</strong></h2>\r\n<p style=\"text-align: justify;\">در بازاریابی سنتی، اغلب کمپین&zwnj;ها از قبل برنامه&zwnj;ریزی می&zwnj;شوند و هدف آن&zwnj;ها ایجاد یک تعامل پایدار و بلندمدت با مخاطبان است. این در حالی است که بازاریابی لحظه&zwnj;ای انعطاف&zwnj;پذیری بیشتری دارد و به تغییرات آنی رفتار و نیازهای مخاطبان واکنش نشان می&zwnj;دهد. در واقع، بازاریابی لحظه&zwnj;ای به داده&zwnj;های بلادرنگ وابسته است و به برندها این امکان را می&zwnj;دهد که در زمان مناسب و با محتوای مرتبط به مخاطب خود دسترسی پیدا کنند.</p>\r\n<p style=\"text-align: justify;\">بازاریابی سنتی بر اساس الگوهای ثابت و برنامه&zwnj;ریزی&zwnj;های از پیش تعیین&zwnj;شده عمل می&zwnj;کند، که ممکن است برای نیازهای فوری مشتریان مناسب نباشد. به عبارت دیگر، بازاریابی سنتی نمی&zwnj;تواند به سرعت به تغییرات ناگهانی در رفتار مخاطب پاسخ دهد. در مقابل، بازاریابی لحظه&zwnj;ای با جمع&zwnj;آوری و تحلیل سریع داده&zwnj;ها از کانال&zwnj;های مختلف به برندها اجازه می&zwnj;دهد که به سرعت محتوای متناسب با نیازها و شرایط لحظه&zwnj;ای مشتری را به او ارائه کنند.</p>\r\n<p style=\"text-align: justify;\">همچنین، بازاریابی لحظه&zwnj;ای برای ارتباطات کوتاه&zwnj;مدت و جلب توجه سریع طراحی شده است، در حالی که بازاریابی سنتی برای تقویت آگاهی بلندمدت و اعتبار برند به&zwnj;کار می&zwnj;رود. هرچند این دو رویکرد در اهداف و رویکردها تفاوت دارند، اما می&zwnj;توانند مکمل یکدیگر باشند. ترکیب بازاریابی لحظه&zwnj;ای و سنتی، به برندها این امکان را می&zwnj;دهد که در کوتاه&zwnj;مدت توجه مخاطب را جلب کرده و در بلندمدت ارتباط پایدارتری با او ایجاد کنند.</p>\r\n<p>&nbsp;</p>\r\n<h2 style=\"text-align: justify;\"><strong>نقش داده&zwnj;های بلادرنگ در بازاریابی لحظه&zwnj;ای</strong></h2>\r\n<p style=\"text-align: justify;\">داده&zwnj;های بلادرنگ، هسته اصلی بازاریابی لحظه&zwnj;ای را تشکیل می&zwnj;دهند و به برندها اجازه می&zwnj;دهند تا رفتار و الگوهای مشتریان را به&zwnj;طور دقیق و آنی تحلیل کنند. این داده&zwnj;ها از منابع مختلفی مانند شبکه&zwnj;های اجتماعی، وب&zwnj;سایت&zwnj;ها، دستگاه&zwnj;های موبایل و حتی اینترنت اشیا جمع&zwnj;آوری می&zwnj;شوند. تحلیل داده&zwnj;های بلادرنگ به برندها این امکان را می&zwnj;دهد تا به سرعت به نیازها و تغییرات بازار پاسخ دهند و کمپین&zwnj;های خود را به&zwnj;صورت پیوسته بهینه&zwnj;سازی کنند.</p>\r\n<p style=\"text-align: justify;\">داده&zwnj;های بلادرنگ نه تنها به شناسایی رفتار مشتریان کمک می&zwnj;کنند، بلکه می&zwnj;توانند به پیش&zwnj;بینی نیازهای آینده آن&zwnj;ها نیز یاری رسانند. با تحلیل دقیق این داده&zwnj;ها، برندها می&zwnj;توانند لحظات مهم برای مشتریان را شناسایی کرده و پیام&zwnj;ها و محتوای متناسب را در آن لحظات ارائه دهند. این نوع تحلیل لحظه&zwnj;ای به برندها کمک می&zwnj;کند تا در زمان مناسب و با محتواهای مرتبط، تجربه&zwnj;ای شخصی و منحصر&zwnj;به&zwnj;فرد برای مشتری ایجاد کنند.</p>\r\n<p style=\"text-align: justify;\">علاوه بر این، استفاده از داده&zwnj;های بلادرنگ باعث افزایش کارایی و اثربخشی کمپین&zwnj;های بازاریابی می&zwnj;شود. چراکه با به&zwnj;کارگیری این داده&zwnj;ها، برندها می&zwnj;توانند از اتلاف منابع در ارائه محتوای نامرتبط و بی&zwnj;تأثیر جلوگیری کرده و پیام&zwnj;های خود را دقیقاً به مخاطبان هدف خود ارسال کنند. این سطح از دقت و هماهنگی باعث می&zwnj;شود که بازاریابی لحظه&zwnj;ای نسبت به روش&zwnj;های سنتی موثرتر و کارآمدتر باشد.</p>\r\n<p>&nbsp;</p>\r\n<h2 style=\"text-align: justify;\"><strong>مراحل اصلی در اجرای بازاریابی لحظه&zwnj;ای</strong></h2>\r\n<p style=\"text-align: justify;\">اجرای بازاریابی لحظه&zwnj;ای شامل چند مرحله مهم است که به موفقیت کمپین&zwnj;ها کمک می&zwnj;کند. نخستین گام، جمع&zwnj;آوری و تحلیل داده&zwnj;ها و شناسایی دقیق مخاطبان هدف است. در مرحله بعد، برنامه&zwnj;ریزی و تولید محتوای مناسب برای هر لحظه و شرایط خاص مخاطبان صورت می&zwnj;گیرد. برای مرحله اجرا، از ابزارهای اتوماسیون بازاریابی و سیستم&zwnj;های بلادرنگ برای ارسال پیام&zwnj;ها و تبلیغات در زمان مناسب استفاده می&zwnj;شود. در نهایت، <span style=\"background-color: #fbeeb8;\">ارزیابی و بهینه&zwnj;سازی کمپین&zwnj;ها با استفاده از داده&zwnj;های به&zwnj;دست&zwnj;آمده، برای بهبود مداوم و افزایش اثربخشی بازاریابی لحظه&zwnj;ای بسیار حیاتی است.</span></p>\r\n<p style=\"text-align: justify;\">مرحله جمع&zwnj;آوری داده&zwnj;ها باید به دقت انجام شود تا اطلاعات واقعی و بلادرنگ از منابع مختلف به دست آید. این داده&zwnj;ها شامل اطلاعات رفتار مشتریان در شبکه&zwnj;های اجتماعی، تحلیل بازدیدهای وب&zwnj;سایت، مکان&zwnj;های جغرافیایی و تعاملات کاربران در اپلیکیشن&zwnj;هاست. جمع&zwnj;آوری این اطلاعات به برندها امکان می&zwnj;دهد که شناخت عمیقی از الگوهای رفتاری و علایق مخاطبان خود پیدا کنند و در نتیجه، پیام&zwnj;های مناسب&zwnj;تری برای آن&zwnj;ها ارسال کنند.</p>\r\n<p style=\"text-align: justify;\">در مرحله تولید محتوا و برنامه&zwnj;ریزی کمپین، استفاده از محتوای متناسب با موقعیت مخاطب و لحظات خاص زندگی او اهمیت دارد. محتوای ارائه&zwnj;شده باید با نیازها و احساسات لحظه&zwnj;ای مخاطب هماهنگ باشد تا تعامل بیشتری ایجاد کند. علاوه بر این، استفاده از ابزارهای اتوماسیون بازاریابی به برندها این امکان را می&zwnj;دهد که در لحظه&zwnj;های کلیدی، پیام&zwnj;های خود را به صورت خودکار به مخاطبان هدف ارسال کنند و از واکنش&zwnj;های سریع بهره&zwnj;مند شوند.</p>\r\n<p>&nbsp;</p>\r\n<h2 style=\"text-align: justify;\"><strong>نمونه&zwnj;های موفق این نوع بازاریابی در ایران و جهان</strong></h2>\r\n<p style=\"text-align: justify;\">در سطح بین&zwnj;المللی، شرکت&zwnj;های بزرگی مانند نایکی&nbsp; با استفاده از بازاریابی لحظه&zwnj;ای توانسته&zwnj;اند تعاملات فوری و موثری با مشتریان خود برقرار کنند. این شرکت&zwnj;ها با استفاده از تبلیغات لحظه&zwnj;ای در شبکه&zwnj;های اجتماعی و استفاده از داده&zwnj;های بلادرنگ، به ایجاد تجربه&zwnj;ای متمایز برای مشتریان پرداخته&zwnj;اند. در ایران نیز برندهایی مانند دیجی&zwnj;کالا و اسنپ با استفاده از تخفیف&zwnj;های لحظه&zwnj;ای و تبلیغات بلادرنگ توانسته&zwnj;اند مخاطبان خود را جذب کنند و وفاداری بیشتری در مشتریان ایجاد کنند. این نمونه&zwnj;ها نشان&zwnj;دهنده قدرت و تاثیرگذاری بازاریابی لحظه&zwnj;ای در جلب توجه و حفظ مشتریان هستند.</p>\r\n<p style=\"text-align: justify;\">بازاریابی لحظه&zwnj;ای در کمپین&zwnj;های برندها نیز موفقیت&zwnj;آمیز بوده است. برخی برندها &nbsp;با ارائه پیشنهادهای ویژه در ساعات خاص و یا در فصول مختلف سال، تجربه&zwnj;ای منحصر&zwnj;به&zwnj;فرد برای مشتریان خود خلق کرده است. &nbsp;آنها با ارسال پیام&zwnj;های شخصی&zwnj;سازی&zwnj;شده به اعضای باشگاه مشتریان خود، موفق به ایجاد تعاملات قوی&zwnj;تری می&zwnj;شوند و وفاداری مشتریانش را به شکل محسوسی افزایش داده اند. در ایران، برندهایی مانند کافه بازار و فیلیمو از تکنیک&zwnj;های بازاریابی لحظه&zwnj;ای برای جذب و حفظ کاربران بهره می&zwnj;گیرند. برای مثال، فیلیمو با پیشنهاد تماشای فیلم&zwnj;های پرطرفدار و یا تخفیف&zwnj;های ویژه در زمان&zwnj;های خاص، کاربران را به استفاده از خدمات خود ترغیب می&zwnj;کند. این استراتژی&zwnj;ها نه تنها باعث جذب مخاطبان جدید می&zwnj;شود، بلکه کاربران فعلی را نیز به استفاده مداوم از خدمات تشویق کرده است.</p>\r\n<p>&nbsp;</p>\r\n<h2 style=\"text-align: justify;\"><strong>مزایا و معایب بازاریابی لحظه&zwnj;ای</strong></h2>\r\n<p style=\"text-align: justify;\">از مزایای بازاریابی لحظه&zwnj;ای می&zwnj;توان به افزایش تعاملات آنی با مشتریان، بهبود تجربه کاربری و افزایش فروش اشاره کرد. این روش با پاسخ&zwnj;دهی سریع به نیازهای مخاطبان، می&zwnj;تواند رضایت مشتریان را افزایش دهد. با این حال، بازاریابی لحظه&zwnj;ای نیز چالش&zwnj;هایی دارد، از جمله نیاز به زیرساخت&zwnj;های فناوری پیشرفته و هزینه&zwnj;های بالای اجرای لحظه&zwnj;ای تبلیغات. علاوه بر این، ارسال بیش&zwnj;ازحد پیام&zwnj;های لحظه&zwnj;ای ممکن است باعث خستگی و نارضایتی مخاطبان شود. بنابراین، مدیریت مناسب پیام&zwnj;ها و تعیین محدودیت&zwnj;ها بسیار ضروری است.</p>\r\n<p style=\"text-align: justify;\">یکی دیگر از مزایای مهم بازاریابی لحظه&zwnj;ای، افزایش وفاداری مشتریان است. این روش با ارائه تجربیات شخصی&zwnj;سازی&zwnj;شده و منحصر&zwnj;به&zwnj;فرد، مشتریان را در لحظات حساس به خود جذب کرده و احساس ارزشمندی به آن&zwnj;ها می&zwnj;بخشد. برندهایی که بتوانند به سرعت به نیازهای مشتریان پاسخ دهند و لحظات مهم زندگی آن&zwnj;ها را شناسایی کنند، می&zwnj;توانند جایگاه ویژه&zwnj;ای در ذهن و قلب مشتریان پیدا کنند.</p>\r\n<p style=\"text-align: justify;\">با این حال، اجرای بازاریابی لحظه&zwnj;ای نیازمند یک تیم متخصص و دسترسی به تکنولوژی&zwnj;های پیشرفته&zwnj;ای مانند سیستم&zwnj;های اتوماسیون بازاریابی، تحلیل داده&zwnj;ها و هوش مصنوعی است. برای بسیاری از برندها، این نیازها می&zwnj;تواند هزینه&zwnj;های زیادی در پی داشته باشد و نیاز به سرمایه&zwnj;گذاری قابل توجهی برای زیرساخت&zwnj;های فنی و تیم&zwnj;های تخصصی ایجاد کند.</p>\r\n<p style=\"text-align: justify;\">&nbsp;</p>\r\n<h2 style=\"text-align: justify;\">استراتژی&zwnj;های <strong>خلاقانه</strong> در بازاریابی لحظه&zwnj;ای</h2>\r\n<p style=\"text-align: justify;\">در بازاریابی لحظه&zwnj;ای، خلاقیت به عنوان یک عامل کلیدی برای جذب مخاطب و افزایش تاثیرگذاری کمپین&zwnj;ها نقش&zwnj;آفرینی می&zwnj;کند. استفاده از هوش مصنوعی و شخصی&zwnj;سازی پیام&zwnj;ها به کمک داده&zwnj;های لحظه&zwnj;ای، می&zwnj;تواند تعاملات را بسیار جذاب&zwnj;تر و پویا&zwnj;تر سازد. برندها همچنین می&zwnj;توانند از روندهای روزمره در شبکه&zwnj;های اجتماعی و لحظات مهم رویدادهای خاص برای جلب توجه سریع مخاطبان استفاده کنند. برگزاری نظرسنجی&zwnj;ها، مسابقات و تعاملات زنده در شبکه&zwnj;های اجتماعی از دیگر روش&zwnj;های خلاقانه در این نوع بازاریابی است.</p>\r\n<p style=\"text-align: justify;\">یکی از استراتژی&zwnj;های خلاقانه می&zwnj;تواند بهره&zwnj;گیری از فناوری <span style=\"background-color: #f8cac6;\">واقعیت افزوده (AR)</span> باشد که به برندها امکان می&zwnj;دهد تا تجربه&zwnj;ای منحصر&zwnj;به&zwnj;فرد و تعاملی برای کاربران خلق کنند. برای مثال، برندهایی که از واقعیت افزوده در تبلیغات لحظه&zwnj;ای خود استفاده می&zwnj;کنند، می&zwnj;توانند به مشتریان این امکان را بدهند که محصولات را در محیط&zwnj;های واقعی مشاهده کنند. این روش نه&zwnj;تنها تجربه جالبی برای کاربر ایجاد می&zwnj;کند، بلکه به تصمیم&zwnj;گیری او در خرید نیز کمک شایانی می&zwnj;کند.</p>\r\n<p style=\"text-align: justify;\">از دیگر استراتژی&zwnj;های خلاقانه در بازاریابی لحظه&zwnj;ای، استفاده از محتوای تولید&zwnj;شده توسط کاربران (UGC) است. برندها می&zwnj;توانند مشتریان را ترغیب کنند تا تجربیات خود را به اشتراک بگذارند و از این محتوای ایجاد&zwnj;شده توسط کاربران برای تبلیغ برند استفاده کنند. این نوع محتوا به&zwnj;دلیل اینکه توسط خود کاربران تولید می&zwnj;شود، بیشتر به دل مخاطبان می&zwnj;نشیند و به افزایش اعتبار برند کمک می&zwnj;کند.</p>\r\n<p>&nbsp;</p>\r\n<h2 style=\"text-align: justify;\">بازاریابی لحظه&zwnj;ای در شبکه&zwnj;های اجتماعی</h2>\r\n<p style=\"text-align: justify;\">شبکه&zwnj;های اجتماعی به دلیل سرعت انتشار بالا و دسترسی آسان، ابزار بسیار مناسبی برای بازاریابی لحظه&zwnj;ای به شمار می&zwnj;آیند. برندها از طریق امکاناتی چون استوری&zwnj;های اینستاگرام، پست&zwnj;های زنده در فیس&zwnj;بوک و توییتر، به سرعت به سوالات و نیازهای مخاطبان پاسخ می&zwnj;دهند و ارتباطی مستقیم و موثر با آن&zwnj;ها برقرار می&zwnj;کنند. استفاده از تبلیغات لحظه&zwnj;ای و نظرسنجی&zwnj;های فوری در شبکه&zwnj;های اجتماعی می&zwnj;تواند به جذب بیشتر مخاطبان و افزایش تعاملات منجر شود.</p>\r\n<p style=\"text-align: justify;\">استفاده از امکانات استوری&zwnj;های زنده و زمان&zwnj;مند، برندها را قادر می&zwnj;سازد که پیشنهادات ویژه، تخفیفات لحظه&zwnj;ای و رویدادهای خاص را به&zwnj;سرعت با مخاطبان به اشتراک بگذارند. از آنجا که استوری&zwnj;ها معمولاً کوتاه و فوری هستند، توانایی جلب توجه سریع و تعامل کاربران را دارند. برندهایی که به&zwnj;صورت منظم از این ابزارها بهره می&zwnj;گیرند، می&zwnj;توانند به&zwnj;سرعت توجه مخاطبان را جلب کرده و تعاملات بیشتری ایجاد کنند.</p>\r\n<p style=\"text-align: justify;\">علاوه بر این، شبکه&zwnj;های اجتماعی امکان تعامل مستقیم با مشتریان را نیز فراهم می&zwnj;کنند. برندها می&zwnj;توانند به سوالات و نظرات مخاطبان در لحظه پاسخ دهند و ارتباطی نزدیک و شخصی با آن&zwnj;ها برقرار کنند. این ارتباط مستقیم و پاسخگویی سریع به افزایش رضایت مشتریان کمک کرده و تصویری مثبت از برند در ذهن مخاطب ایجاد می&zwnj;کند.</p>\r\n<p>&nbsp;</p>\r\n<h2 style=\"text-align: justify;\">پتانسیل بازاریابی لحظه&zwnj;ای برای کسب&zwnj;وکارهای کوچک و استارتاپ&zwnj;ها</h2>\r\n<p style=\"text-align: justify;\">بازاریابی لحظه&zwnj;ای برای کسب&zwnj;وکارهای کوچک و استارتاپ&zwnj;ها می&zwnj;تواند فرصتی برای دیده&zwnj;شدن و رشد سریع فراهم کند. با استفاده از این نوع بازاریابی، استارتاپ&zwnj;ها می&zwnj;توانند با هزینه&zwnj;های کمتری، به مخاطبان هدف خود دسترسی یابند و توجه آن&zwnj;ها را به خود جلب کنند. ایجاد کمپین&zwnj;های هدفمند و مناسب در لحظات حساس، می&zwnj;تواند این کسب&zwnj;وکارها را به موفقیت&zwnj;های بزرگ&zwnj;تر برساند و برندهای نوپا را به شکلی سریع و موثر معرفی کند.</p>\r\n<p style=\"text-align: justify;\">استارتاپ&zwnj;ها معمولاً بودجه محدودی برای تبلیغات دارند، بنابراین بازاریابی لحظه&zwnj;ای برای آن&zwnj;ها راهکاری اقتصادی و کارآمد است. این روش به آن&zwnj;ها امکان می&zwnj;دهد که به&zwnj;جای اجرای کمپین&zwnj;های گسترده و پرهزینه، بر روی لحظات حساس و مناسب تمرکز کرده و با بهره&zwnj;گیری از ابزارهای دیجیتال، با مخاطبان خود در لحظه ارتباط برقرار کنند. این ارتباطات شخصی&zwnj;سازی&zwnj;شده باعث جلب توجه بیشتر مشتریان و ایجاد حس نزدیکی به برند می&zwnj;شود.</p>\r\n<p style=\"text-align: justify;\">علاوه بر این، کسب&zwnj;وکارهای کوچک و استارتاپ&zwnj;ها با استفاده از بازاریابی لحظه&zwnj;ای می&zwnj;توانند نوآوری و خلاقیت بیشتری در کمپین&zwnj;های خود نشان دهند. به دلیل اندازه کوچکتر و انعطاف&zwnj;پذیری بیشتر، آن&zwnj;ها می&zwnj;توانند سریع&zwnj;تر از برندهای بزرگ به تغییرات بازار پاسخ دهند و از فرصت&zwnj;های لحظه&zwnj;ای برای رشد و موفقیت خود بهره&zwnj;برداری کنند. این رویکرد به آن&zwnj;ها امکان می&zwnj;دهد که در بازارهای رقابتی، سهم قابل توجهی کسب کنند و جایگاه خود را به&zwnj;عنوان برندی متمایز و خلاق تثبیت کنند.</p>\r\n<p>&nbsp;</p>\r\n<h2 style=\"text-align: justify;\">نکات مهم در طراحی کمپین&zwnj;ها</h2>\r\n<p style=\"text-align: justify;\">شناخت دقیق نیازها و علایق مخاطبان اولین قدم در طراحی کمپین&zwnj;های بازاریابی لحظه&zwnj;ای است. تیم&zwnj;ها باید همواره آماده باشند تا در مواجهه با تغییرات ناگهانی بازار واکنش نشان دهند و از ابزارهای اتوماسیون برای بهینه&zwnj;سازی عملکرد کمپین&zwnj;ها استفاده کنند. همچنین، ارزیابی و بهینه&zwnj;سازی نتایج به&zwnj;دست&zwnj;آمده برای بهبود مداوم و افزایش اثربخشی کمپین&zwnj;ها ضروری است.</p>\r\n<p style=\"text-align: justify;\">یکی از نکات مهم در طراحی این نوع کمپین&zwnj;ها، توجه به زمان&zwnj;بندی و هماهنگی دقیق با نیازهای آنی مخاطبان است. برندها باید با استفاده از داده&zwnj;های بلادرنگ، لحظات مناسب برای ارسال پیام&zwnj;ها را شناسایی کنند و پیام&zwnj;ها را دقیقاً در زمان و موقعیت درست به مخاطبان برسانند. این زمان&zwnj;بندی دقیق باعث افزایش اثربخشی کمپین&zwnj;ها و جلب توجه بیشتر مشتریان می&zwnj;شود.</p>\r\n<p style=\"text-align: justify;\">علاوه بر این، طراحی محتوای شخصی&zwnj;سازی&zwnj;شده و مرتبط با نیازهای مخاطبان می&zwnj;تواند به موفقیت کمپین&zwnj;های لحظه&zwnj;ای کمک زیادی کند. محتوای ارائه&zwnj;شده باید ارزشمند و جذاب باشد تا به ایجاد تعامل و جذب مخاطبان کمک کند. استفاده از تصاویر، ویدیوها و محتوای خلاقانه و جذاب می&zwnj;تواند توجه بیشتری را به برند جلب کرده و تجربه کاربری بهتری برای مخاطبان فراهم آورد.</p>\r\n<p>&nbsp;</p>\r\n<h2 style=\"text-align: justify;\">آینده بازاریابی لحظه&zwnj;ای و تاثیر هوش مصنوعی بر آن</h2>\r\n<p style=\"text-align: justify;\">ورود هوش مصنوعی به بازاریابی لحظه&zwnj;ای می&zwnj;تواند این رویکرد را به یکی از ارکان اصلی بازاریابی دیجیتال تبدیل کند. هوش مصنوعی با تحلیل داده&zwnj;های زنده و پیش&zwnj;بینی رفتارهای مشتریان، می&zwnj;تواند به برندها کمک کند تا تعاملات خود را هوشمندانه&zwnj;تر و سریع&zwnj;تر اجرا کنند. استفاده از این فناوری نه تنها امکان خودکارسازی بیشتر کمپین&zwnj;ها را فراهم می&zwnj;کند، بلکه به ایجاد تجربه&zwnj;ای شخصی&zwnj;سازی&zwnj;شده و پویا برای مشتریان نیز کمک می&zwnj;کند.</p>\r\n<p style=\"text-align: justify;\">هوش مصنوعی با تحلیل داده&zwnj;های رفتاری مخاطبان به برندها کمک می&zwnj;کند. تا زمان&zwnj;های حساس برای ارسال پیام&zwnj;های تبلیغاتی را شناسایی کرده و محتوای مناسب&zwnj;تری ارائه دهند. این تحلیل&zwnj;های پیشرفته می&zwnj;توانند رفتار آینده مشتریان را پیش&zwnj;بینی کرده و کمپین&zwnj;هایی با دقت بالا و کارایی بیشتر ایجاد کنند. این باعث می&zwnj;شود که بازاریابی لحظه&zwnj;ای به یک ابزار قدرتمند در ارتقای تجربه مشتری و جلب وفاداری او تبدیل شود.</p>\r\n<p style=\"text-align: justify;\">همچنین، هوش مصنوعی می&zwnj;تواند در کاهش هزینه&zwnj;ها و بهینه&zwnj;سازی منابع برندها مؤثر باشد. با خودکارسازی فرآیندهای بازاریابی لحظه&zwnj;ای و به حداقل رساندن نیاز به مداخلات انسانی، برندها می&zwnj;توانند با سرعت بیشتری به نیازهای مشتریان پاسخ دهند و هزینه&zwnj;های اجرای کمپین&zwnj;ها را کاهش دهند. این ویژگی&zwnj;ها هوش مصنوعی را به ابزاری کلیدی برای موفقیت کمپین&zwnj;های لحظه&zwnj;ای تبدیل می&zwnj;کند.</p>\r\n<p style=\"text-align: justify;\">&nbsp;</p>\r\n<h2 style=\"text-align: justify;\">نتیجه&zwnj;گیری</h2>\r\n<p style=\"text-align: justify;\">بازاریابی لحظه&zwnj;ای به عنوان یک رویکرد نوآورانه در دنیای دیجیتال، فرصتی بی&zwnj;نظیر برای برندها فراهم می&zwnj;کند. تا به سرعت با مشتریان خود تعامل برقرار کرده و تجربه&zwnj;ای شخصی&zwnj;سازی&zwnj;شده و متمایز برای آن&zwnj;ها خلق کنند. این روش، با بهره&zwnj;گیری از داده&zwnj;های بلادرنگ و ابزارهای تکنولوژیکی، به برندها کمک می&zwnj;کند تا نیازهای فوری و تمایلات لحظه&zwnj;ای مخاطبان را درک کرده و به آن&zwnj;ها پاسخ دهند. با وجود چالش&zwnj;هایی مانند هزینه&zwnj;های بالا و نیاز به زیرساخت&zwnj;های فنی مناسب، مزایای بازاریابی لحظه&zwnj;ای از جمله افزایش رضایت و وفاداری مشتریان، ارزش سرمایه&zwnj;گذاری در این حوزه را اثبات می&zwnj;کند. در نهایت، بازاریابی لحظه&zwnj;ای با ایجاد تعاملات آنی و خلاقانه، به برندها امکان می&zwnj;دهد تا جایگاه خود را در بازار تثبیت کنند و به طور فعالانه&zwnj;ای به تغییرات سریع رفتار مشتریان پاسخ دهند.</p>\r\n<p style=\"text-align: justify;\">&nbsp;</p>\r\n<p style=\"text-align: justify;\">&nbsp;</p>','بازاریابی لحظه‌ای عرصه ای تازه برای دیده شدن','بازاریابی لحظه‌ای یک رویکرد نوآورانه است که به برندها کمک می‌کند تا با استفاده از داده‌های بلادرنگ، به نیازهای فوری مشتریان پاسخ دهند.','بازاریابی لحظه‌ای','Article',1,'2024-10-31 07:56:36','2024-10-31 07:56:36','/uploads/Snapinsta.app_244305676_192819126294646_2069526424703811142_n_1080.jpg','micro-moment-marketing',NULL);
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `status` enum('canceled','preparation','done') NOT NULL,
  `tracking_id` int(11) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `renew_date` timestamp NOT NULL DEFAULT current_timestamp(),
  `edit_level1` longtext DEFAULT NULL,
  `edit_level2` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `start_date` timestamp NOT NULL DEFAULT '2021-06-09 19:30:00',
  `domain` varchar(255) NOT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `course_file` varchar(255) DEFAULT NULL,
  `price` bigint(20) NOT NULL,
  `login_info` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `projects_user_id_foreign` (`user_id`),
  CONSTRAINT `projects_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_user`
--

DROP TABLE IF EXISTS `role_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_user` (
  `role_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`user_id`),
  KEY `role_user_user_id_foreign` (`user_id`),
  CONSTRAINT `role_user_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_user`
--

LOCK TABLES `role_user` WRITE;
/*!40000 ALTER TABLE `role_user` DISABLE KEYS */;
INSERT INTO `role_user` (`role_id`, `user_id`) VALUES (1,1),
(1,208);
/*!40000 ALTER TABLE `role_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` (`id`, `name`, `label`, `created_at`, `updated_at`) VALUES (1,'Admin','مدیر کل',NULL,NULL),
(2,'Author','نویسنده',NULL,NULL),
(5,'User','کاربر عادی',NULL,NULL);
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ticket_replies`
--

DROP TABLE IF EXISTS `ticket_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ticket_replies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext NOT NULL,
  `ticket_id` bigint(20) unsigned NOT NULL,
  `for` enum('user','admin') NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_replies_ticket_id_foreign` (`ticket_id`),
  CONSTRAINT `ticket_replies_ticket_id_foreign` FOREIGN KEY (`ticket_id`) REFERENCES `tickets` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ticket_replies`
--

LOCK TABLES `ticket_replies` WRITE;
/*!40000 ALTER TABLE `ticket_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `ticket_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tickets`
--

DROP TABLE IF EXISTS `tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tickets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `section` enum('technical','financial','consulting') NOT NULL,
  `priority` enum('high','medium','low') NOT NULL,
  `status` enum('answered','waiting','closed') NOT NULL,
  `message` longtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `ticketable_type` varchar(255) DEFAULT NULL,
  `ticketable_id` bigint(20) unsigned DEFAULT NULL,
  `tracking_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tickets_user_id_foreign` (`user_id`),
  KEY `tickets_ticketable_type_ticketable_id_index` (`ticketable_type`,`ticketable_id`),
  CONSTRAINT `tickets_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tickets`
--

LOCK TABLES `tickets` WRITE;
/*!40000 ALTER TABLE `tickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `tickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `avatar` varchar(255) DEFAULT NULL,
  `phone` varchar(255) NOT NULL,
  `identity_number` varchar(255) DEFAULT NULL,
  `birthday` timestamp NULL DEFAULT NULL,
  `h_phone` varchar(255) DEFAULT NULL,
  `address` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_mobile_unique` (`phone`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_identity_number_unique` (`identity_number`)
) ENGINE=InnoDB AUTO_INCREMENT=209 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` (`id`, `name`, `email`, `remember_token`, `created_at`, `updated_at`, `avatar`, `phone`, `identity_number`, `birthday`, `h_phone`, `address`) VALUES (1,'فرشاد رجب زاده','farshad.rajabzade@yahoo.com',NULL,'2021-01-19 05:20:40','2023-10-08 12:04:30','https://karawebs.com/images/users/1624298381user.png','09058775382','0019023421','2023-10-08 11:10:47','+19394002017','ش'),
(208,'حسین حسین زاده',NULL,NULL,NULL,NULL,NULL,'09376688753',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping events for database 'yektamentor_karawebs'
--

--
-- Dumping routines for database 'yektamentor_karawebs'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-12-30  2:11:32
