import fa from '/locale/fa.js';

const editor = grapesjs.init({
    storageManager:false,
    canvas: {
        styles: [
            'https://cdnjs.cloudflare.com/ajax/libs/jquery.flipster/1.1.5/jquery.flipster.css',
            '/vendor/bootstrap/css/bootstrap.min.css',
            '/vendor/fontawesome-free/css/all.min.css',
            '/vendor/animate/animate.min.css',
            '/vendor/simple-line-icons/css/simple-line-icons.min.css',
            '/vendor/owl.carousel/assets/owl.carousel.min.css',
            '/vendor/owl.carousel/assets/owl.theme.default.min.css',
            '/vendor/magnific-popup/magnific-popup.min.css',
            '/css/theme.css',
            '/css/theme-elements.css',
            '/css/theme-blog.css',
            '/css/theme-shop.css',
            '/vendor/rs-plugin/css/settings.css',
            '/vendor/rs-plugin/css/layers.css',
            '/vendor/rs-plugin/css/navigation.css',
            '/vendor/circle-flip-slideshow/css/component.css',
            '/css/skins/default.css',
            '/css/custom.css',
            '/vendor/modernizr/modernizr.min.js',
        ],
        scripts : [
            '/vendor/jquery/jquery.min.js',
            '/vendor/jquery.appear/jquery.appear.min.js',
            '/vendor/jquery.easing/jquery.easing.min.js',
            '/vendor/jquery.cookie/jquery.cookie.min.js',
            '/vendor/popper/umd/popper.min.js',
            '/vendor/bootstrap/js/bootstrap.min.js',
            '/vendor/common/common.min.js',
            '/vendor/jquery.validation/jquery.validate.min.js',
            '/vendor/jquery.easy-pie-chart/jquery.easypiechart.min.js',
            '/vendor/jquery.gmap/jquery.gmap.min.js',
            '/vendor/jquery.lazyload/jquery.lazyload.min.js',
            '/vendor/isotope/jquery.isotope.min.js',
            '/vendor/owl.carousel/owl.carousel.min.js',
            '/vendor/magnific-popup/jquery.magnific-popup.min.js',
            '/vendor/vide/jquery.vide.min.js',
            '/vendor/vivus/vivus.min.js',
            '/vendor/rs-plugin/js/jquery.themepunch.tools.min.js',
            '/vendor/rs-plugin/js/jquery.themepunch.revolution.min.js',
            '/vendor/circle-flip-slideshow/js/jquery.flipshow.min.js',
            '/js/views/view.home.js',
            '/js/theme.init.js',
        ]
    },
    container : '#gjs',
    fromElement: true,

    plugins: ['gjs-plugin-ckeditor' ,
        'gjs-blocks-flexbox' ,
        'grapesjs-typed' ,
        'grapesjs-parser-postcss',
        'grapesjs-touch',
        'grapesjs-custom-code',
        'grapesjs-tooltip',
        'grapesjs-tabs',
        'grapesjs-lory-slider',
        'gjs-preset-webpage',
        'gjs-plugin-ckeditor'
    ],
    pluginsOpts: {
        'gjs-plugin-ckeditor': {
            position: 'center',
            options: {
                startupFocus: true,
                language: 'fa',
                extraAllowedContent: '*(*);*{*}', // Allows any class and any inline style
                allowedContent: true, // Disable auto-formatting, class removing, etc.
                enterMode: CKEDITOR.ENTER_BR,
                extraPlugins: 'sharedspace,justify,colorbutton,panelbutton,font,format,list,tabletools,table,tableselection',
                toolbar: [
                    { name: 'clipboard', items: [ 'Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo' ] },
                    { name: 'editing', items: [ 'Find', 'Replace', '-', 'SelectAll', '-', 'Scayt' ] },
                    { name: 'forms', items: [ 'Form', 'Checkbox', 'Radio', 'TextField', 'Textarea', 'Select', 'Button', 'ImageButton', 'HiddenField' ] },
                    '/',
                    { name: 'basicstyles', items: [ 'Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript', '-', 'CopyFormatting', 'RemoveFormat' ] },
                    { name: 'paragraph', items: [ 'NumberedList', 'BulletedList', '-', 'Outdent', 'Indent', '-', 'Blockquote', 'CreateDiv', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock', '-', 'BidiLtr', 'BidiRtl', 'Language' ] },
                    { name: 'links', items: [ 'Link', 'Unlink', 'Anchor' ] },
                    { name: 'insert', items: [ 'Image', 'Flash', 'Table', 'HorizontalRule', 'Smiley', 'SpecialChar', 'PageBreak', 'Iframe' ] },
                    '/',
                    { name: 'styles', items: [ 'Styles', 'Format', 'Font', 'FontSize' ] },
                    { name: 'colors', items: [ 'TextColor', 'BGColor' ] },
                    { name: 'tools', items: [ 'Maximize', 'ShowBlocks' ] },
                ],
                i18n: {
                    // locale: 'fa', // default locale
                    // detectLocale: false, // by default, the editor will detect the language
                    // localeFallback: 'fa', // default fallback
                    messages: {fa},
                }
            }
        }
    },
    assetManager: {
        storageType  	: 'local',
        storeOnChange  : true,
        storeAfterUpload  : true,
        upload: 'backend/images/grapesjs',        //for temporary storage
        assets    	: [ ],
        uploadFile: function(e) {
            var files = e.dataTransfer ? e.dataTransfer.files : e.target.files;
            var formData = new FormData();
            for(var i in files){
                formData.append('file-'+i, files[i]) //containing all the selected images from local
            }
            $.ajax({
                url: '/uploader',
                type: 'POST',
                data: formData,
                contentType:false,
                crossDomain: true,
                dataType: 'json',
                mimeType: "multipart/form-data",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                processData:false,
                success: function(result){
                    var myJSON = [];
                    $.each( result['data'], function( key, value ) {
                        myJSON[key] = value;
                    });
                    var images = myJSON;
                    editor.AssetManager.add(images); //adding images to asset manager of GrapesJS
                }
            });
        },
    },
});

var blockManager = editor.BlockManager;
editor.Panels.addButton
('options',
    [{
        id: 'save-db',
        className: 'fa fa-floppy-o',
        command: 'save-db',
        attributes: {title: 'Save DB'}
    }]
);
editor.Panels.addButton
('options',
    [{
        id: 'back',
        className: 'fa fa-arrow-left',
        command: 'back',
        attributes: {title: 'بازگشت'}
    }]
);
// Add the command
editor.Commands.add
('save-db',
    {
        run: function(editor, sender)
        {
            sender && sender.set('active', 0); // turn off the button
            editor.store();

            var htmldata = editor.getHtml();
            var cssdata = editor.getCss();
            var page_id = document.getElementById('page-id');
            axios.post(`/kara-lux/pages/${page_id.value}/update` , {
                body: htmldata
            })
                .then(res => success())
            function success() {
                Swal.fire({
                    icon: 'success',
                    title: 'به روز رسانی موفق',
                    text: 'به روز رسانی با موفقیت انجام شد',
                    confirmButtonText: 'باشه'
                })
            }
        }
    });
// Add the command
editor.Commands.add
('back',
    {
        run: function(editor, sender)
        {
            var page_id = document.getElementById('page-id');
            sender && sender.set('active', 0); // turn off the button
            window.location.replace(`/kara-lux/pages/${page_id.value}/edit`);
        }
    });
blockManager.add('2-column-block-left-pic', {
    label: 'بلاک 2 ستونه تصویر چپ',
    content: '<section class=" ">\n' +
        '    <svg width="174" height="481" viewBox="0 0 174 481" fill="none" xmlns="http://www.w3.org/2000/svg" class="svg-header-left">\n' +
        '        <path fill-rule="evenodd" clip-rule="evenodd" d="M-72.1475 5.43998C-20.7162 -6.35171 37.9761 0.315034 79.8891 32.4416C121.47 64.3139 129.182 121.486 144.651 171.618C159.871 220.94 184.832 271.67 168.856 320.751C152.887 369.811 107.482 403.416 61.5928 426.795C20.5364 447.711 -26.5476 437.071 -72.1475 443.533C-128.415 451.507 -191.767 504.174 -236.5 469.037C-281.74 433.501 -234.659 355.759 -253.288 301.25C-272.464 245.138 -363.721 209.613 -344.307 153.584C-324.737 97.1054 -233.271 120.752 -180.861 92.2241C-139.131 69.5092 -118.437 16.0527 -72.1475 5.43998Z" fill="#288ed929" fill-opacity="0.6"></path>\n' +
        '    </svg>\n' +
        '    <div class="container">\n' +
        '        <div class="row">\n' +
        '            <div class="col-md-6">\n' +
        '                <div class="section-head">\n' +
        '                    <div class="section-title">\n' +
        '                        <div class="title-icon">\n' +
        '                            <svg width="50" height="50" viewBox="0 0 50 50" fill="none" xmlns="http://www.w3.org/2000/svg">\n' +
        '                                <path d="M0.215576 23.7705C0.215576 30.2596 2.64014 35.8094 7.48928 40.4201C12.3384 45.0307 18.1753 47.3361 25.0001 47.3361C31.8248 47.3361 37.6617 45.0307 42.5108 40.4201C47.36 35.8094 49.7845 30.2596 49.7845 23.7705C49.7845 17.2814 47.36 11.7316 42.5108 7.1209C37.6617 2.51025 31.8248 0.204918 25.0001 0.204918C18.1753 0.204918 12.3384 2.51025 7.48928 7.1209C2.64014 11.7316 0.215576 17.2814 0.215576 23.7705ZM2.04747 23.7705C2.04747 20.765 2.72994 17.7937 4.09489 14.8566L14.9785 43.3402C11.0992 41.5642 7.9742 38.9174 5.60351 35.3996C3.23282 31.8818 2.04747 28.0055 2.04747 23.7705ZM25.0001 45.5943C22.7012 45.5943 20.546 45.2869 18.5345 44.6721L25.4311 25.7172L32.4354 44.0574C32.5072 44.0574 32.5432 44.0915 32.5432 44.1598C32.5432 44.2281 32.5791 44.2964 32.6509 44.3648C29.921 45.1844 27.3707 45.5943 25.0001 45.5943ZM43.5345 23.3607C44.684 20.6284 45.2587 18.0328 45.2587 15.5738C45.2587 14.5492 45.2228 13.7978 45.1509 13.3197C47.0187 16.6667 47.9526 20.1503 47.9526 23.7705C47.9526 27.6639 46.911 31.3012 44.8276 34.6824C42.7443 38.0635 39.9785 40.7104 36.5302 42.623L43.5345 23.3607ZM38.5776 16.7008C39.8707 18.8866 40.5173 20.8675 40.5173 22.6434C40.5173 24.4194 39.9067 26.776 38.6854 29.7131L36.4225 36.9877L28.1251 13.5246L30.819 13.3197C31.1782 13.3197 31.4297 13.166 31.5733 12.8586C31.717 12.5512 31.6991 12.2609 31.5195 11.9877C31.3399 11.7145 31.0345 11.5779 30.6035 11.5779C28.161 11.7145 26.1495 11.7828 24.569 11.7828L18.5345 11.5779C18.1035 11.5779 17.7982 11.7145 17.6186 11.9877C17.439 12.2609 17.421 12.5512 17.5647 12.8586C17.7084 13.166 17.9598 13.3197 18.319 13.3197C19.1093 13.4563 19.9354 13.5246 20.7975 13.5246L24.3535 22.8484L19.2889 37.1926L10.9914 13.5246L13.5776 13.3197C14.0087 13.3197 14.2781 13.166 14.3858 12.8586C14.4936 12.5512 14.4577 12.2609 14.2781 11.9877C14.0985 11.7145 13.8291 11.5779 13.4699 11.5779C10.9555 11.7145 8.9081 11.7828 7.32764 11.7828H5.81902C7.90236 8.77732 10.6322 6.38661 14.0087 4.61066C17.3851 2.8347 21.0489 1.94672 25.0001 1.94672C30.819 1.94672 35.9914 3.85929 40.5173 7.68443H40.194C39.1164 7.68443 38.2005 8.07719 37.4462 8.86271C36.6919 9.64822 36.3147 10.5533 36.3147 11.5779C36.3147 12.6708 37.069 14.3784 38.5776 16.7008Z" fill="black"></path>\n' +
        '                            </svg>\n' +
        '\n' +
        '                        </div>\n' +
        '                        <div class="title-box">\n' +
        '                            <h3 class="title">\n' +
        '                                طراحی سایت با وردپرس\n' +
        '                            </h3>\n' +
        '                            <p>طراحی حرفه ای سایت با وردپرس</p>\n' +
        '                            <div class="blue-line"></div>\n' +
        '                        </div>\n' +
        '                    </div>\n' +
        '                </div>\n' +
        '                <p>\n' +
        '                    این روز ها اگر یک جستجوی ساده درباره ی توسعه وب سایت در اینترنت انجام دهید، به احتمال زیاد با طراحی سایت با وردپرس هم روبرو میشوید. اگر میخواهید کمتر هزینه کنید و امکانات خوبی هم داشته باشید، طراحی سایت با وردپرس انتخاب خوبی برای شما خواهد بود! کاراوب دارای نمونه کار های بسیار زیادی در این زمینه میباشد. طراحی سایت با وردپرس بر خلاف نظر عموم مردم، بسیار کاربردی است، امروزه بیش از 80.000.000 وب سایت از سیستم وردپرس برای وب سیت خود استفاده میکنند.\n' +
        '                </p>\n' +
        '            </div>\n' +
        '            <div class="col-md-6">\n' +
        '                <img src="./assets/images/wordpress.png" alt="" data-aos="fade-up" class="aos-init aos-animate">\n' +
        '            </div>\n' +
        '        </div>\n' +
        '    </div>\n' +
        '</section>',
});
blockManager.add('2-column-block-right-pic', {
    label: 'بلاک 2 ستونه تصویر راست',
    content: '<section class=" ">\n' +
        '    <svg width="188" height="481" viewBox="0 0 188 481" fill="none" xmlns="http://www.w3.org/2000/svg" class="svg-header-right">\n' +
        '        <path fill-rule="evenodd" clip-rule="evenodd" d="M246.148 5.43998C194.716 -6.35171 136.024 0.315034 94.1109 32.4416C52.5296 64.3139 44.8184 121.486 29.3485 171.618C14.1287 220.94 -10.8316 271.67 5.14396 320.751C21.1128 369.811 66.5184 403.416 112.407 426.795C153.464 447.711 200.548 437.071 246.148 443.533C302.415 451.507 365.767 504.174 410.5 469.037C455.74 433.501 408.659 355.759 427.288 301.25C446.464 245.138 537.721 209.613 518.307 153.584C498.737 97.1054 407.271 120.752 354.861 92.2241C313.131 69.5092 292.437 16.0527 246.148 5.43998Z" fill="#288ed929" fill-opacity="0.6"></path>\n' +
        '    </svg>\n' +
        '    <div class="container">\n' +
        '        <div class="row">\n' +
        '            <div class="col-md-6">\n' +
        '                <img src="./assets/images/support.png" alt="" data-aos="fade-up" class="aos-init aos-animate">\n' +
        '            </div>\n' +
        '            <div class="col-md-6">\n' +
        '                <div class="section-head">\n' +
        '                    <div class="section-title">\n' +
        '                        <div class="title-icon">\n' +
        '                            <svg width="50" height="50" viewBox="0 0 50 50" fill="none" xmlns="http://www.w3.org/2000/svg">\n' +
        '                                <path d="M39.0434 11.1379C37.2202 9.31691 35.0523 7.87771 32.6664 6.9044C30.2805 5.93109 27.7245 5.44323 25.1479 5.46932C22.5706 5.44981 20.015 5.94058 17.6283 6.91334C15.2416 7.8861 13.071 9.32162 11.2417 11.1371C9.41238 12.9527 7.96047 15.1123 6.96966 17.4916C5.97886 19.8708 5.46875 22.4227 5.46875 25V35.9375C5.46989 36.9731 5.8818 37.966 6.61412 38.6984C7.34644 39.4307 8.33935 39.8426 9.375 39.8437H12.5C13.5357 39.8426 14.5286 39.4307 15.2609 38.6984C15.9932 37.966 16.4051 36.9731 16.4062 35.9375V28.125C16.4051 27.0893 15.9932 26.0964 15.2609 25.3641C14.5286 24.6318 13.5357 24.2199 12.5 24.2187H7.04785C7.25047 19.5672 9.25061 15.1759 12.6269 11.9699C16.0032 8.76386 20.4921 6.99346 25.1479 7.03162C29.8017 6.99646 34.2876 8.76819 37.6614 11.9739C41.0352 15.1796 43.0338 19.5692 43.2363 24.2187H37.7842C36.7485 24.2199 35.7556 24.6318 35.0233 25.3641C34.291 26.0964 33.8791 27.0893 33.8779 28.125V35.9375C33.8791 36.9731 34.291 37.966 35.0233 38.6984C35.7556 39.4307 36.7485 39.8426 37.7842 39.8437H40.9092C41.7555 39.8434 42.5786 39.5665 43.2529 39.0551V40.625C43.2513 42.0749 42.6746 43.465 41.6494 44.4902C40.6242 45.5154 39.2341 46.0921 37.7842 46.0937H26.5625C26.3553 46.0937 26.1566 46.176 26.0101 46.3226C25.8636 46.4691 25.7812 46.6678 25.7812 46.875C25.7812 47.0822 25.8636 47.2809 26.0101 47.4274C26.1566 47.5739 26.3553 47.6562 26.5625 47.6562H37.7844C39.6485 47.6542 41.4358 46.9127 42.7539 45.5945C44.0721 44.2764 44.8136 42.4892 44.8156 40.625V25C44.8231 22.4217 44.3164 19.8679 43.3253 17.4877C42.3342 15.1075 40.8785 12.9489 39.0434 11.1379V11.1379ZM12.5 25.7812C13.1214 25.7819 13.7171 26.0291 14.1565 26.4684C14.5959 26.9078 14.8431 27.5036 14.8438 28.125V35.9375C14.8431 36.5589 14.5959 37.1546 14.1565 37.594C13.7171 38.0334 13.1214 38.2806 12.5 38.2812H9.375C8.75361 38.2806 8.15785 38.0334 7.71846 37.594C7.27907 37.1546 7.03192 36.5589 7.03125 35.9375V25.7812H12.5ZM40.9094 38.2812H37.7844C37.163 38.2806 36.5672 38.0334 36.1278 37.594C35.6884 37.1546 35.4413 36.5589 35.4406 35.9375V28.125C35.4413 27.5036 35.6884 26.9078 36.1278 26.4684C36.5672 26.0291 37.163 25.7819 37.7844 25.7812H43.2531V35.9375C43.2525 36.5589 43.0053 37.1546 42.5659 37.594C42.1265 38.0334 41.5308 38.2806 40.9094 38.2812Z" fill="black"></path>\n' +
        '                            </svg>\n' +
        '                        </div>\n' +
        '                        <div class="title-box">\n' +
        '                            <h3 class="title">\n' +
        '                                پشتیبانی حرفه ای طراحی سایت\n' +
        '                            </h3>\n' +
        '                            <p>پشتیبانی مهمترین مرحله ی هر پروژه ای!</p>\n' +
        '                            <div class="blue-line"></div>\n' +
        '                        </div>\n' +
        '                    </div>\n' +
        '                </div>\n' +
        '                <p>تمامی وب سایت های طراحی شده در کاراوب تا یکسال به صورت رایگان پشتیبانی میشوند و بعد از آن با پرداخت مبلغ اندکی این پشتیبانی تمدید میشود. پشتیبانی در کاراوب به صورت 24 ساعته و 7 روز هفته میباشد که از طریق سیستم چت آنلاین و سیستم تیکتینگ میتوانید به راحتی با ما در ارتباط باشید.</p>\n' +
        '                <p>به طور کلی یک وب سایت نیاز به پشتیبانی مداوم در طول زمان خواهد داشت، برای هر وب سایت ممکن از مشکلاتی پیش بیاید که کاراوب با پشتیبانی 24 ساعته همیشه آماده ی حل مشکلات احتمالی شما در زمینه طراحی وب سایت خواهد بود.</p>\n' +
        '                <ul class="kw-list1">\n' +
        '                    <li>پشتیبانی 24 ساعته</li>\n' +
        '                    <li>پشتیبانه 7 روز هفته</li>\n' +
        '                    <li>پشتیبانی حتی روز های تعطیل</li>\n' +
        '                </ul>\n' +
        '            </div>\n' +
        '        </div>\n' +
        '    </div>\n' +
        '</section>',
});

