<?php $__env->startComponent('backend.layouts.components.main',['title' => 'مدیریت نمونه کار ها', 'titleBar'=>true , 'button' => 'افزودن نمونه کار' , 'route' => 'admin.portfolios.create']); ?>

    <?php $__env->slot('breadcrumb'); ?>
        <li class="breadcrumb-item active">
            <a href="<?php echo e(route('admin.index')); ?>">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">نمونه کار ها</li>


    <?php $__env->endSlot(); ?>

    
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست نمونه کار ها</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>لوگو</th>
                            <th>نام</th>
                            <th>دسته بندی</th>
                            <th>تاریخ ثبت</th>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-portfolios')): ?>
                                <th>عملیات</th>
                            <?php endif; ?>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $portfolios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $portfolio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <img src="<?php echo e($portfolio->logo); ?>" alt="" style="width: 55px; height: auto;">
                                </td>
                                <td><?php echo e($portfolio->title); ?></td>
                                <td>
                                    <?php $__currentLoopData = $portfolio->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(count($portfolio->categories)>1): ?>
                                            <?php echo e($category->name . ','); ?>

                                        <?php else: ?>
                                            <?php echo e($category->name); ?>

                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                                <td><?php echo e(\Hekmatinasser\Verta\Verta::instance($portfolio->created_at)->formatJalaliDate()); ?></td>

                                <td>
                                    <form action="<?php echo e(route('admin.portfolios.destroy', $portfolio->id)); ?>" method="post"
                                          id="delete-<?php echo e($portfolio->id); ?>">
                                        <?php echo method_field('delete'); ?>
                                        <?php echo csrf_field(); ?>
                                    </form>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-users')): ?>
                                        <a href="<?php echo e(route('admin.portfolios.edit', $portfolio->id)); ?>" role="button"
                                           class="btn btn-success light sharp" title="ویرایش">
                                            <i class="fa fa-pencil"
                                               onclick="document.getElementById('edit-<?php echo e($portfolio->id); ?>').submit()"></i>
                                        </a>
                                        <button onclick="document.getElementById('delete-<?php echo e($portfolio->id); ?>').submit()"
                                                role="button" class="btn btn-danger light sharp" title="حذف">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    <?php endif; ?>
                                    <a href="<?php echo e(asset('portfolios/'.$portfolio->slug)); ?>" role="button"
                                       class="btn btn-primary light sharp" title="نمایش" target="_blank">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                </td>

                            </tr>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </div>
                <?php echo e($portfolios->links()); ?>

            </div>
        </div>
    </div>
    
<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('/backend/js/search.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/yektamentor/public_html/core/Modules/Portfolio/Resources/views/backend/all.blade.php ENDPATH**/ ?>