<?php $__env->startComponent('backend.layouts.components.page',['title' => 'مدیریت برگه ها', 'titleBar'=>true , 'button' => 'افزودن برگه' , 'route' => 'admin.page.new']); ?>

    <?php $__env->slot('breadcrumb'); ?>
        <li class="breadcrumb-item active">
            <a href="<?php echo e(route('admin.index')); ?>">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">برگه ها</li>
    <?php $__env->endSlot(); ?>

    
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست برگه ها</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>نام</th>
                            <th>تاریخ ایجاد</th>
                            <th>آخرین به روز رسانی</th>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-pages')): ?>
                                <th>عملیات</th>
                            <?php endif; ?>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <tr>
                                <td><?php echo e($page->title); ?></td>
                                <td><?php echo e(\Hekmatinasser\Verta\Verta::instance($page->created_at)->formatJalaliDate()); ?></td>
                                <td><?php echo e(\Hekmatinasser\Verta\Verta::instance($page->updated_at)->format('%d %B, %Y')); ?></td>
                                <td>
                                    <form action="<?php echo e(route('admin.pages.destroy', $page->id)); ?>" method="post"
                                          id="delete-<?php echo e($page->id); ?>">
                                        <?php echo method_field('delete'); ?>
                                        <?php echo csrf_field(); ?>
                                    </form>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-users')): ?>
                                        <a href="<?php echo e(route('admin.pages.edit', $page->id)); ?>" role="button"
                                           class="btn btn-success light sharp" title="ویرایش">
                                            <i class="fa fa-pencil"
                                               onclick="document.getElementById('edit-<?php echo e($page->id); ?>').submit()"></i>
                                        </a>
                                        <button onclick="document.getElementById('delete-<?php echo e($page->id); ?>').submit()"
                                                role="button" class="btn btn-danger light sharp" title="حذف">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    <?php endif; ?>
                                    <a href="<?php echo e(asset($page->slug)); ?>" class="btn btn-primary light sharp" title="نمایش" target="_blank">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                </td>

                            </tr>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </div>
                <?php echo e($pages->links()); ?>

            </div>
        </div>
    </div>
    
<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('/backend/js/search.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/yektamentor/public_html/core/Modules/Page/Resources/views/backend/all.blade.php ENDPATH**/ ?>