@extends('user::frontend.layout')
@section('profile-active-page')
    <div class="container">
        <div class="row justify-content-between align-items-center p-4">
            <div class="section-head">
                <div id="nav-icon3">
                    <span></span>
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
                <div class="section-title">
                    <div class="title-icon">
                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M1.75 14.5128L4.88775 11.375H13.125C13.5891 11.375 14.0342 11.1906 14.3624 10.8624C14.6906 10.5342 14.875 10.0891 14.875 9.625V5.25C14.875 4.78587 14.6906 4.34075 14.3624 4.01256C14.0342 3.68437 13.5891 3.5 13.125 3.5H3.5C3.03587 3.5 2.59075 3.68437 2.26256 4.01256C1.93437 4.34075 1.75 4.78587 1.75 5.25V14.5128ZM1.75 15.75H0.875V5.25C0.875 4.55381 1.15156 3.88613 1.64384 3.39384C2.13613 2.90156 2.80381 2.625 3.5 2.625H13.125C13.8212 2.625 14.4889 2.90156 14.9812 3.39384C15.4734 3.88613 15.75 4.55381 15.75 5.25V9.625C15.75 10.3212 15.4734 10.9889 14.9812 11.4812C14.4889 11.9734 13.8212 12.25 13.125 12.25H5.25L1.75 15.75ZM18.375 18.0128V8.75C18.375 8.28587 18.1906 7.84075 17.8624 7.51256C17.5342 7.18437 17.0891 7 16.625 7V6.125C17.3212 6.125 17.9889 6.40156 18.4812 6.89384C18.9734 7.38613 19.25 8.05381 19.25 8.75V19.25H18.375L14.875 15.75H7C6.48508 15.7501 5.98149 15.5988 5.55193 15.3148C5.12237 15.0309 4.7858 14.6269 4.58412 14.1531L5.2815 13.4558C5.35837 13.8552 5.57198 14.2153 5.88559 14.4743C6.19921 14.7333 6.59326 14.875 7 14.875H15.2372L18.375 18.0128Z" fill="black"></path>
                        </svg>
                    </div>
                    <div class="title-box">
                        <h3 class="title">
                            پشتیبانی
                        </h3>
                    </div>
                </div>
            </div>
            <div>
                <a href="{{route('profile.tickets.create')}}" class="kw-btn-green">ارسال تیکت جدید</a>
            </div>
        </div>
        <div>
            <table class="table table-hover">
                <thead>
                <tr>
                    <th scope="col">شماره</th>
                    <th scope="col">موضوع</th>
                    <th scope="col">وضعیت</th>
                    <th scope="col">تاریخ ایجاد</th>
                    <th scope="col">عملیات</th>
                </tr>
                </thead>
                <tbody>
                @foreach(auth()->user()->tickets()->latest()->get() as $ticket)
                    <tr>
                        <th scope="row">{{$ticket->tracking_id}}</th>
                        <td>
                            {{$ticket->title}}
                        </td>
                        <td>
                            @switch($ticket->status)
                                @case('answered')
                                <span class="badge badge-success badge-pill">پاسخ داده شده</span>
                                @break
                                @case('waiting')
                                <span class="badge badge-info badge-pill">در حال بررسی</span>
                                @break
                                @case('closed')
                                <span class="badge badge-danger badge-pill">بسته شده</span>
                                @break
                            @endswitch
                        </td>
                        <td>
                            {{\Hekmatinasser\Verta\Verta::instance($ticket->created_at)->formatJalaliDatetime()}}
                        </td>
                        <td>
                            <a href="{{route('profile.tickets.show' , $ticket)}}" class="kw-btn-blue mt-0">مشاهده تیکت</a>
                        </td>
                    </tr>

                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@stop
