@extends('user::frontend.layout')
@section('profile-active-page')
    <div class="container">
        <div class="row justify-content-between align-items-center p-4">
            <div class="section-head">
                <div id="nav-icon3">
                    <span></span>
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
                <div class="section-title">
                    <div class="title-icon">
                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M10.0625 12.25C13.6867 12.25 16.625 13.6211 16.625 15.3125V17.5H3.5V15.3125C3.5 13.6211 6.43825 12.25 10.0625 12.25ZM15.75 15.3125C15.75 14.105 13.2037 13.125 10.0625 13.125C6.92125 13.125 4.375 14.105 4.375 15.3125V16.625H15.75V15.3125ZM10.0625 4.375C10.8747 4.375 11.6537 4.69766 12.228 5.27199C12.8023 5.84632 13.125 6.62527 13.125 7.4375C13.125 8.24973 12.8023 9.02868 12.228 9.60301C11.6537 10.1773 10.8747 10.5 10.0625 10.5C9.25027 10.5 8.47131 10.1773 7.89699 9.60301C7.32265 9.02868 7 8.24973 7 7.4375C7 6.62527 7.32265 5.84632 7.89699 5.27199C8.47131 4.69766 9.25027 4.375 10.0625 4.375ZM10.0625 5.25C9.48234 5.25 8.92594 5.48047 8.5157 5.8907C8.10547 6.30094 7.875 6.85734 7.875 7.4375C7.875 8.01766 8.10547 8.57406 8.5157 8.9843C8.92594 9.39453 9.48234 9.625 10.0625 9.625C10.6427 9.625 11.1991 9.39453 11.6093 8.9843C12.0195 8.57406 12.25 8.01766 12.25 7.4375C12.25 6.85734 12.0195 6.30094 11.6093 5.8907C11.1991 5.48047 10.6427 5.25 10.0625 5.25Z"
                                fill="black"></path>
                        </svg>
                    </div>
                    <div class="title-box">
                        <h3 class="title">
                            اطلاعات کاربری
                        </h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="pb-3">
            <form action="{{route('profile.update' , auth()->user()->id)}}" method="post" class="pb-5"
                  enctype="multipart/form-data">
                @csrf
                @method('patch')
                <div class="avatar-upload">
                    <div class="avatar-edit">

                        <input type="file" name="avatar" id="imageUpload" accept=".png, .jpg, .jpeg">
                        <label for="imageUpload"></label>

                    </div>
                    <div class="avatar-preview">
                        @if(auth()->user()->avatar)
                            <img class="profile-user-img img-responsive img-circle" id="imagePreview"
                                 src="{{asset(auth()->user()->avatar)}}">
                        @else
                            <img class="profile-user-img img-responsive img-circle" id="imagePreview"
                                 src="{{asset('/images/avatar.png')}}">
                        @endif
                    </div>
                    <p class="subtitle">تصویر پروفایل</p>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <label for="name">نام و نام خانوادگی</label>
                        <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror"
                               placeholder="لطفا نام و نام خانوادگی خود را وارد کنید"
                               value="{{old('name') ? old('name') : auth()->user()->name}}">
                        @error('name')
                        <span class="invalid-feedback">
                        <strong>
                            {{$message}}
                        </strong>
                    </span>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label for="phone">تلفن همراه</label>
                        <input type="text" name="phone" id="phone" class="form-control @error('phone') is-invalid @enderror" disabled
                               value="{{old('phone') ? old('phone') : auth()->user()->phone}}"
                               placeholder="لطفا تلفن همراه خود را وارد کنید">
                        @error('phone')
                        <span class="invalid-feedback">
                        <strong>
                            {{$message}}
                        </strong>
                    </span>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label for="h_phone">تلفن ثابت</label>
                        <input type="text" name="h_phone" id="h_phone" class="form-control @error('birthday') is-invalid @enderror"
                               value="{{old('h_phone') ? old('h_phone') : auth()->user()->h_phone}}"
                               placeholder="لطفا تلفن ثابت خود را وارد کنید">
                        @error('h_phone')
                        <span class="invalid-feedback">
                        <strong>
                            {{$message}}
                        </strong>
                    </span>
                        @enderror
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <label for="id_number">کد ملی</label>
                        <input type="text" name="identity_number" id="identity_number" class="form-control @error('identity_number') is-invalid @enderror"
                               value="{{old('identity_number') ? old('identity_number') : auth()->user()->identity_number}}"
                               placeholder="لطفا کد ملی خود را وارد کنید">
                        @error('identity_number')
                        <span class="invalid-feedback">
                        <strong>
                            {{$message}}
                        </strong>
                    </span>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label for="birthday">تاریخ تولد</label>
                        <span class="kw-btn-orange-sm">
                            {{auth()->user()->birthday ? Verta::instance(auth()->user()->birthday)->formatJalaliDate() : 'وارد نشده'}}
                        </span>
                        <input autocomplete="off" type="text" class="form-control @error('birthday') is-invalid @enderror" name="birthday"
                               id="birthday"
                               placeholder="لطفا تاریخ تولد خود را وارد کنید"
                        />
                        <script type="text/javascript">
                            $('#birthday').persianDatepicker({
                                format: 'L',
                                initialValue: false
                            });
                        </script>
                        @error('birthday')
                        <span class="invalid-feedback">
                        <strong>
                            {{$message}}
                        </strong>
                    </span>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label for="address">آدرس</label>
                        <textarea name="address" id="address" cols="30" rows="5"
                                  class="form-control
                        @error('address') is-invalid @enderror">{!! old('address') ? old('address') : auth()->user()->address !!}</textarea>
                        @error('address')
                        <span class="invalid-feedback">
                        <strong>
                            {{$message}}
                        </strong>
                    </span>
                        @enderror
                    </div>
                </div>
                <button type="submit" class="kw-btn-green">ثبت تغییرات</button>
            </form>

        </div>
    </div>
@stop
@section('head')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
            integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <link rel="stylesheet" href="https://unpkg.com/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.js"
            integrity="sha256-H+K7U5CnXl1h5ywQfKtSj8PCmoN9aaq30gDh27Xc0jk=" crossorigin="anonymous"></script>
    <script src="https://unpkg.com/persian-date@1.1.0/dist/persian-date.min.js"></script>
    <script src="https://unpkg.com/persian-datepicker@1.2.0/dist/js/persian-datepicker.min.js"></script>
@stop

