@extends('user::frontend.layout')
@section('profile-active-page')
    <div class="container">
        <div class="row justify-content-between align-items-center p-4">
            <div class="section-head">
                <div id="nav-icon3">
                    <span></span>
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
                <div class="section-title">
                    <div class="title-icon">
                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M14 7.36225L10.0625 3.42475L3.86225 9.625H5.25V16.625H7.875V11.375H12.25V16.625H14.875V9.625H16.2628L14.875 8.23725V5.25H14V7.36225ZM1.75 10.5L10.0625 2.1875L13.125 5.25V4.375H15.75V7.875L18.375 10.5H15.75V17.4982H11.375V12.2483H8.75V17.4982H4.375V10.5H1.75Z" fill="black"></path>
                        </svg>
                    </div>

                    <div class="title-box">
                        <h3 class="title">
                            پیشخوان
                        </h3>
                    </div>
                </div>
            </div>
            <a href="{{route('main')}}" class="kw-btn-blue">بازگشت به وب سایت</a>
        </div>
        <div class="row pt-2 mr-2 ml-2 p-2">
            <div class="col-lg-12 col-xl-4">
                <a href="{{route('profile.tickets')}}">
                    <div class="profile-details-card">
                        <div class="icon">
                            <svg width="113" height="113" viewBox="0 0 113 113" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M88.238 25.1717C84.1176 21.0563 79.2182 17.8037 73.8261 15.6041C68.4339 13.4044 62.6574 12.3018 56.8341 12.3608C51.0096 12.3167 45.2339 13.4258 39.8399 15.6243C34.446 17.8227 29.5405 21.067 25.4062 25.1701C21.272 29.2731 17.9907 34.1539 15.7514 39.5311C13.5122 44.9082 12.3594 50.6753 12.3594 56.5001V81.2188C12.3619 83.5594 13.2929 85.8034 14.9479 87.4584C16.6029 89.1134 18.8469 90.0444 21.1875 90.0469H28.25C30.5906 90.0444 32.8346 89.1134 34.4896 87.4584C36.1446 85.8034 37.0756 83.5594 37.0781 81.2188V63.5626C37.0756 61.222 36.1446 58.978 34.4896 57.323C32.8346 55.6679 30.5906 54.737 28.25 54.7344H15.9281C16.3861 44.222 20.9064 34.2976 28.5368 27.052C36.1672 19.8064 46.3121 15.8053 56.8341 15.8916C67.3518 15.8121 77.49 19.8162 85.1148 27.0611C92.7397 34.306 97.2563 44.2265 97.7141 54.7344H85.3922C83.0517 54.737 80.8077 55.6679 79.1527 57.323C77.4976 58.978 76.5667 61.222 76.5641 63.5626V81.2188C76.5667 83.5594 77.4976 85.8034 79.1527 87.4584C80.8077 89.1134 83.0517 90.0444 85.3922 90.0469H92.4547C94.3675 90.0463 96.2276 89.4204 97.7516 88.2645V91.8126C97.748 95.0894 96.4447 98.2309 94.1276 100.548C91.8106 102.865 88.669 104.168 85.3922 104.172H60.0312C59.563 104.172 59.1139 104.358 58.7828 104.689C58.4516 105.02 58.2656 105.469 58.2656 105.938C58.2656 106.406 58.4516 106.855 58.7828 107.186C59.1139 107.517 59.563 107.703 60.0312 107.703H85.3927C89.6057 107.699 93.6448 106.023 96.6239 103.044C99.603 100.065 101.279 96.0256 101.283 91.8126V56.5001C101.3 50.6732 100.155 44.9015 97.9152 39.5223C95.6753 34.1432 92.3854 29.2645 88.238 25.1717V25.1717ZM28.25 58.2657C29.6544 58.2672 31.0008 58.8258 31.9938 59.8188C32.9868 60.8118 33.5454 62.1582 33.5469 63.5626V81.2188C33.5454 82.6232 32.9868 83.9696 31.9938 84.9626C31.0008 85.9556 29.6544 86.5142 28.25 86.5157H21.1875C19.7831 86.5142 18.4367 85.9556 17.4437 84.9626C16.4507 83.9696 15.8921 82.6232 15.8906 81.2188V58.2657H28.25ZM92.4552 86.5157H85.3927C83.9883 86.5142 82.6419 85.9556 81.6489 84.9626C80.6559 83.9696 80.0973 82.6232 80.0958 81.2188V63.5626C80.0973 62.1582 80.6559 60.8118 81.6489 59.8188C82.6419 58.8258 83.9883 58.2672 85.3927 58.2657H97.7521V81.2188C97.7505 82.6232 97.192 83.9696 96.199 84.9626C95.2059 85.9556 93.8595 86.5142 92.4552 86.5157Z" fill="#288ED9"></path>
                            </svg>

                        </div>
                        <div class="details">
                            <strong>تیکت ها</strong>
                            <p>{{auth()->user()->tickets->count()}} تیکت</p>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-lg-12 col-xl-4">
                <a href="{{route('profile.projects')}}">
                <div class="profile-details-card">
                    <div class="icon">
                        <svg width="113" height="113" viewBox="0 0 113 113" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M23.5415 32.9583H37.6665V23.5417L47.0832 14.125H61.2082L70.6248 23.5417V32.9583H84.7498C88.496 32.9583 92.0888 34.4465 94.7377 37.0955C97.3867 39.7444 98.8748 43.3372 98.8748 47.0833V84.75C98.8748 88.4962 97.3867 92.0889 94.7377 94.7379C92.0888 97.3868 88.496 98.875 84.7498 98.875H23.5415C19.7953 98.875 16.2026 97.3868 13.5536 94.7379C10.9047 92.0889 9.4165 88.4962 9.4165 84.75V47.0833C9.4165 43.3372 10.9047 39.7444 13.5536 37.0955C16.2026 34.4465 19.7953 32.9583 23.5415 32.9583V32.9583ZM49.0324 18.8333L42.3748 25.4909V32.9583H65.9165V25.4909L59.2589 18.8333H49.0324ZM23.5415 37.6667C21.044 37.6667 18.6489 38.6588 16.8829 40.4247C15.1169 42.1907 14.1248 44.5859 14.1248 47.0833V84.75C14.1248 87.2475 15.1169 89.6426 16.8829 91.4086C18.6489 93.1746 21.044 94.1667 23.5415 94.1667H84.7498C87.2473 94.1667 89.6425 93.1746 91.4084 91.4086C93.1744 89.6426 94.1665 87.2475 94.1665 84.75V47.0833C94.1665 44.5859 93.1744 42.1907 91.4084 40.4247C89.6425 38.6588 87.2473 37.6667 84.7498 37.6667H23.5415Z" fill="#288ED9"></path>
                        </svg>
                    </div>
                    <div class="details">
                        <strong>پروژه ها</strong>
                        <p>{{auth()->user()->projects->count()}} پروژه</p>
                    </div>
                </div>
                </a>
            </div>
            <div class="col-lg-12 col-xl-4">
                <a href="{{route('profile.courses')}}">
                <div class="profile-details-card">
                    <div class="icon">
                        <svg width="113" height="113" viewBox="0 0 50 50" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M35.9375 34.2424L25 40.3948L14.0625 34.2424V27.7422L10.9375 26.0061V36.07L25 43.9801L39.0625 36.07V26.0061L35.9375 27.7422V34.2424V34.2424Z" fill="#288ED9"></path>
                            <path d="M25 4.48987L3.125 15.8324V18.5408L25 30.6933L43.75 20.277V28.9062H46.875V15.8324L25 4.48987ZM40.625 18.4382L37.5 20.1742L25 27.1191L12.5 20.1742L9.375 18.4382L7.20908 17.2349L25 8.00999L42.7909 17.2349L40.625 18.4382Z" fill="#288ED9"></path>
                        </svg>
                    </div>
                    <div class="details">
                        <strong>دوره های آموزشی شما</strong>
                        <p>{{auth()->user()->courses->count()}} دوره</p>
                    </div>
                </div>
                </a>
            </div>
        </div>
        <div class="row p-4">
            <div class="col-md-6">
                <div class="section-head">
                    <div class="section-title">
                        <div class="title-box">
                            <h3 class="title">
                                پیام های شما
                            </h3>
                            <div class="blue-line mt-1"></div>
                        </div>
                    </div>
                </div>
                <p class="subtitle">هیچ پیامی ندارید</p>
            </div>
            <div class="col-md-6">
                <div class="section-head">
                    <div class="section-title">
                        <div class="title-box">
                            <h3 class="title">
                                آخرین دوره های آموزشی
                            </h3>
                            <div class="blue-line mt-1"></div>
                        </div>
                    </div>
                </div>
                <div id="carouselExampleIndicators" class="carousel slide" data-ride="carousel">
                    <div class="carousel-inner">
                        @foreach($courses as $course)
                            <div class="carousel-item @if($loop->first) active @endif">
                                <a href="{{asset('series/' . $course->slug)}}">
                                    <img src="{{asset($course->video_cover)}}" class="d-block w-100 br-20" alt="{{$course->title}}">
                                </a>
                            </div>
                        @endforeach
                    </div>
                    <a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-slide="prev">
                        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                        <span class="sr-only">قبلی</span>
                    </a>
                    <a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-slide="next">
                        <span class="carousel-control-next-icon" aria-hidden="true"></span>
                        <span class="sr-only">بعدی</span>
                    </a>
                </div>
            </div>

        </div>
    </div>
@stop
