<?php

namespace Modules\User\Entities;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Modules\ACL\Entities\Permission;
use Modules\ACL\Entities\Role;
use Modules\Comment\Entities\Comment;
use Modules\Course\Entities\Course;
use Modules\Discount\Entities\Discount;
use Modules\LoginWithCode\Entities\Code;
use Modules\Order\Entities\Order;
use Modules\Project\Entities\Project;
use Modules\Ticket\Entities\Ticket;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'phone','h_phone' , 'identity_number' , 'birthday' , 'address'  ,'avatar'
    ];


    public function roles()
    {
        return $this->belongsToMany(Role::class);
    }

    public function permissions()
    {
        return $this->belongsToMany(Permission::class);
    }

    public function hasRole($roles)
    {
        return !! $roles->intersect($this->roles)->all();
    }

    public function hasPermission($permission)
    {
        return $this->permissions->contains('name' , $permission->name) || $this->hasRole($permission->roles);
    }

    public function isAdmin()
    {
        foreach (auth()->user()->roles as $role){
            if ($role->id == 5){
                return false;
            }
            return true;
        }
    }

    public function whatsUserRole()
    {
        foreach ($this->roles as $role){
            if ($role->id == 5){
                return false;
            }
            return true;
        }
    }

    public function getRole()
    {
        foreach ($this->roles as $role){
            return $role->label;
        }
    }

    public function comments()
    {
        return $this->hasMany(Comment::class);
    }

    public function activeCode()
    {
        return $this->hasMany(Code::class);
    }

    public function courses()
    {
        return $this->belongsToMany(Course::class );
    }

    public function discounts()
    {
        return $this->hasMany(Discount::class);
    }

    public function orders()
    {
        return $this->hasMany(Order::class);
    }

    public function tickets()
    {
        return $this->hasMany(Ticket::class);
    }

    public function projects()
    {
        return $this->hasMany(Project::class);
    }
}

