@component('backend.layouts.components.main',['title' => 'ویرایش تیکت','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">ویرایش تیکت</li>
    @endslot
    {{-- Section Start --}}

    <div class="col-md-8">
        <div class="sidebar-admin">
            <div class="card">
                <div class="card-header">{{$ticket->title}}</div>
                <div class="card-body height3">
                    <ul class="chat-list">
                        <li class="in">
                            <div class="chat-img">
                                @if($ticket->user->avatar)
                                    <img alt="Avtar" src="{{$ticket->user->avatar}}">
                                @else
                                    <img src="/images/avatar.png" alt="">
                                @endif
                            </div>
                            <div class="chat-body">
                                <div class="chat-message">
                                    <h5>{{$ticket->user->name}}</h5>
                                    <p>{!! $ticket->message !!}</p>
                                </div>
                            </div>
                        </li>

                        @foreach($ticket->replies as $reply)
                            <li class="{{$reply->for == 'user' ? 'in' : 'out'}}">
                                <div class="chat-img">
                                    @if($reply->for == 'user')
                                        <img alt="Avtar"
                                             src="{{$ticket->user->avatar ? $ticket->user->avatar : '/images/avatar.png'}}">
                                    @else
                                        <img src="/images/avatar.png" alt="">
                                    @endif
                                </div>
                                <div class="chat-body">
                                    <div class="chat-message">
                                        @if($reply->for == 'user')
                                            <h5>{{$ticket->user->name}}</h5>
                                        @else
                                            <h5>پشتیبانی</h5>
                                        @endif
                                        <p>{!! $reply->message !!}</p>
                                    </div>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
            <div class="card-body">
                <form action="{{route('admin.tickets.reply' , $ticket)}}" method="post" id="store">
                    @csrf
                    @method('post')
                </form>
                <textarea class="@error('message') is-invalid @enderror"
                          name="message" id="editor1" form="store" required>{{old('message')}}</textarea>
                @error('message')
                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                @enderror
            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}

    <div class="col-md-4">
        @if($errors->any())
            <div class="alert alert-danger left-icon-big alert-dismissible fade show">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span><i
                            class="mdi mdi-close"></i></span>
                </button>
                <div class="media">
                    <div class="alert-left-icon-big">
                        <span><i class="mdi mdi-alert"></i></span>
                    </div>
                    <div class="media-body">
                        <h5 class="mt-1 mb-2">خطا!</h5>
                        @foreach($errors->all() as $error)
                            <p class="mb-0">{{$error}}</p>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif
        <div class="sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.tickets.index')}}" role="button" class="btn btn-xs btn-info light"
                   title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای اعمال ویرایش ها، روی دکمه "به روز رسانی" کلیک کنید.
                </p>
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    در صورتی که میخواهید تیکت منتشر شده اما در سایت نمایش داده نشود وضعیت را در حالت خاموش قرار دهید.
                </p>

                <div class="row">
                    <div class="col-md-6">
                        <button class="btn btn-success btn-sm btn-block light"
                                onclick="document.getElementById('store').submit()">
                            <i class="fa fa-send"></i>
                            ارسال پاسخ
                        </button>
                    </div>
                    <div class="col-md-6">
                        <form action="{{route('admin.tickets.close'  , $ticket)}}" id="close-ticket" method="post">
                            @csrf
                            @method('patch')
                        </form>
                        @switch($ticket->status)
                            @case('closed')
                            <button class="btn btn-primary btn-sm btn-block light"
                                    onclick="document.getElementById('close-ticket').submit()">
                                <i class="fa fa-check"></i>
                                باز کردن
                            </button>
                            @break
                            @case('waiting')
                            <button class="btn btn-danger btn-sm btn-block light"
                                    onclick="document.getElementById('close-ticket').submit()">
                                <i class="fa fa-close"></i>
                                بستن
                            </button>
                            @break
                            @case('answered')
                            <button class="btn btn-danger btn-sm btn-block light"
                                    onclick="document.getElementById('close-ticket').submit()">
                                <i class="fa fa-close"></i>
                                بستن
                            </button>
                            @break
                        @endswitch
                    </div>
                </div>

            </div>
        </div>

    </div>

    {{-- Sidebar End --}}

    {{-- Scripts --}}
@section('script')
    <script src="{{ asset('/vendor/file-manager/js/file-manager.js') }}"></script>
    <script src="{{asset('/backend/js/file-editor.js')}}"></script>
    <script src="{{asset('/backend/js/file-button.js')}}"></script>
    <script>
        let meta_title = document.getElementById('meta-title');
        let meta_desc = document.getElementById('meta-desc');
        let g_link = document.getElementById('g-link');
        let g_desc = document.getElementById('g-desc');
        meta_title.addEventListener('change', function () {
            g_link.innerText = meta_title.value;
        })
        meta_desc.addEventListener('change', function () {
            g_desc.innerText = meta_desc.value;
        })
    </script>

@stop

@section('head')
    <script src="https://cdn.tiny.cloud/1/piqrm2bib3zv8de8a26kklh89gvqb0bhm9a14mjb88jwos8r/tinymce/5/tinymce.min.js"
            referrerpolicy="origin"></script>
    <link rel="stylesheet" href="{{ asset('/backend/css/tickets.css') }}">
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.0/css/all.css">
    <link rel="stylesheet" href="{{ asset('/vendor/file-manager/css/file-manager.css') }}">
@stop
@endcomponent
